/*
 *	Installs a MIME Type
 */

#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include <glib.h>
#include <endeavour2.h>

int main(int argc, char *argv[])
{
	edv_context_struct *ctx = EDVContextNew();
	EDVContextLoadConfigurationFile(ctx, NULL);

	if(argc > 1)
	{
	    gint i;
	    edv_mimetype_struct *m = EDVMimeTypeNew(
		(edv_mimetype_class)atoi(argv[1]),
		(argc > 3) ? argv[3] : NULL,
		(argc > 2) ? argv[2] : NULL,
		(argc > 4) ? argv[4] : NULL
	    );
	    m->handler = (edv_mimetype_handler)((argc > 5) ?
		atoi(argv[5]) : EDV_MIMETYPE_HANDLER_COMMAND
	    );

	    if(argc > 6)
		m->small_icon_file[
		    EDV_MIMETYPE_ICON_STATE_STANDARD
		] = g_strdup(argv[6]);
            if(argc > 7)
                m->small_icon_file[
                    EDV_MIMETYPE_ICON_STATE_SELECTED
                ] = g_strdup(argv[7]);
            if(argc > 8)
                m->small_icon_file[
                    EDV_MIMETYPE_ICON_STATE_EXTENDED
                ] = g_strdup(argv[8]);
            if(argc > 9)
                m->medium_icon_file[
                    EDV_MIMETYPE_ICON_STATE_STANDARD
                ] = g_strdup(argv[9]);
            if(argc > 10)
                m->medium_icon_file[
                    EDV_MIMETYPE_ICON_STATE_SELECTED
                ] = g_strdup(argv[10]);
            if(argc > 11)
                m->medium_icon_file[
                    EDV_MIMETYPE_ICON_STATE_EXTENDED
                ] = g_strdup(argv[11]);
            if(argc > 12)
                m->large_icon_file[
                    EDV_MIMETYPE_ICON_STATE_STANDARD
                ] = g_strdup(argv[12]);
            if(argc > 13)
                m->large_icon_file[
                    EDV_MIMETYPE_ICON_STATE_SELECTED
                ] = g_strdup(argv[13]);
            if(argc > 14)
                m->large_icon_file[
                    EDV_MIMETYPE_ICON_STATE_EXTENDED
                ] = g_strdup(argv[14]);

	    i = 15;
	    while(argc > i)
	    {
		gint n = m->total_commands;
		m->total_commands = n + 1;
		m->command_name = (gchar **)g_realloc(
		    m->command_name,
		    m->total_commands * sizeof(gchar *)
		);
		m->command_name[n] = (argc > i) ? g_strdup(argv[i]) : NULL;
		i++;
		m->command = (gchar **)g_realloc(
                    m->command,
                    m->total_commands * sizeof(gchar *)
                );
                m->command[n] = (argc > i) ? g_strdup(argv[i]) : NULL;
		i++;
	    }

	    /* Need to map the MIME Types Window to ensure that 
	     * Endeavour is running
	     */
	    EDVWindowMIMETypesWindowMap(ctx);
	    EDVContextSync(ctx);

	    /* Install the MIME Type */
	    EDVMimeTypeInstall(ctx, m);

	    EDVMimeTypeDelete(m);
	}
	else
	{
	    g_print(
"Usage: %s <class> [type] [value] [desc] [handler] \
[icon_small_std] [icon_small_sel] [icon_small_ext] \
[icon_medium_std] [icon_medium_sel] [icon_medium_ext] \
[icon_large_std] [icon_large_sel] [icon_large_ext] \
[command_name] [command] [...]\n",
		argv[0]
	    );
	}

	EDVContextSync(ctx);
	EDVContextDelete(ctx);

	return(0);
}
