/*
		 Endeavour Image Browser Thumbs List
 */

#ifndef IMBRTLIST_H
#define IMBRTLIST_H

#include <gtk/gtk.h>
#include "imbr.h"
#include "endeavour.h"


extern gint EDVImbrTListFindThumbByPath(
	edv_imbr_struct *imbr, const gchar *path
);

extern guint8 *EDVImbrTListLoadImageRGBA(
	tlist_struct *tlist, const gchar *path,
	gint *width, gint *height, gint *bpl,
	gboolean resize_for_thumb,		/* Resize for tlist thumb */
        gboolean no_enlarge,			/* No enlarge if smaller
                                                 * than req size */
        GdkWindow *window			/* Reference window */
);

extern void EDVImbrTListResetThumbs(edv_imbr_struct *imbr);
extern void EDVImbrTListDoUpdate(
	edv_imbr_struct *imbr, const gchar *path,
	gboolean update_status_bar
);

extern gint EDVImbrTListLoadIterate(
	edv_imbr_struct *imbr, gboolean update_status_bar,
	gboolean no_enlarge
);

extern void EDVImbrTListDoOpenObject(
	edv_imbr_struct *imbr, gint thumb_num, guint state
);
extern void EDVImbrTListDoOpenWithObject(
	edv_imbr_struct *imbr, gint thumb_num
);

extern void EDVImbrTListDoFPromptRename(
	edv_imbr_struct *imbr, gint thumb_num
);

extern void EDVImbrTListObjectAddedNotify(
	edv_imbr_struct *imbr, const gchar *path,
	const struct stat *lstat_buf
);
extern void EDVImbrTListObjectModifiedNotify(
	edv_imbr_struct *imbr, const gchar *path,
	const gchar *new_path,
	const struct stat *lstat_buf
);
extern void EDVImbrTListObjectRemovedNotify(
	edv_imbr_struct *imbr, const gchar *path
);

extern void EDVImbrTListMountNotify(
	edv_imbr_struct *imbr, edv_device_struct *dev_ptr,
	gboolean is_mounted
);


#endif	/* IMBRTLIST_H */
