/*
	                   Endeavour Image Browser
 */

#ifndef IMBR_H
#define IMBR_H


#include <gtk/gtk.h>

#include "edvtypes.h"
#include "edvstatusbar.h"
#include "toolbar.h"
#include "mountbar.h"
#include "findbar.h"
#include "fopdlg.h"
#include "tlist.h"
#include "imgview.h"


/*
 *	Image Browser Operations:
 */
typedef enum {

	EDV_IMBR_OP_NONE			= 0,
	EDV_IMBR_OP_SEPARATOR			= 10,

	EDV_IMBR_OP_CLOSE			= 20,
	EDV_IMBR_OP_EXIT			= 21,

	EDV_IMBR_OP_SYNC_DISKS			= 30,
	EDV_IMBR_OP_RUN				= 31,
	EDV_IMBR_OP_RUN_TERMINAL		= 32,
	EDV_IMBR_OP_WRITE_PROTECT		= 35,

	EDV_IMBR_OP_NEW				= 40,
	EDV_IMBR_OP_NEW_FILE			= 41,
	EDV_IMBR_OP_NEW_DIRECTORY		= 42,
	EDV_IMBR_OP_NEW_LINK			= 43,
	EDV_IMBR_OP_NEW_FIFO			= 44,
	EDV_IMBR_OP_NEW_DEVICE_BLOCK		= 45,
	EDV_IMBR_OP_NEW_DEVICE_CHARACTER	= 46,
	EDV_IMBR_OP_NEW_SOCKET			= 47,

	EDV_IMBR_OP_OPEN			= 50,
	EDV_IMBR_OP_OPEN_WITH			= 51,

	EDV_IMBR_OP_GOTO_PARENT			= 60,
	EDV_IMBR_OP_GOTO_HOME			= 61,
	EDV_IMBR_OP_MOUNT			= 62,	/* Mount/unmount */
	EDV_IMBR_OP_EJECT			= 63,

	EDV_IMBR_OP_MOVE			= 65,
	EDV_IMBR_OP_COPY			= 66,
	EDV_IMBR_OP_LINK			= 67,
	EDV_IMBR_OP_RENAME			= 68,
	EDV_IMBR_OP_CHMOD			= 69,
	EDV_IMBR_OP_CHOWN			= 70,
	EDV_IMBR_OP_DELETE			= 71,
	EDV_IMBR_OP_SELECT_ALL			= 72,
	EDV_IMBR_OP_UNSELECT_ALL		= 73,
	EDV_IMBR_OP_INVERT_SELECTION		= 74,
	EDV_IMBR_OP_PROPERTIES			= 75,

	EDV_IMBR_OP_FIND			= 76,

	EDV_IMBR_OP_HISTORY			= 77,
	EDV_IMBR_OP_COPY_PATH			= 78,
	EDV_IMBR_OP_COPY_URL			= 79,

	EDV_IMBR_OP_REFRESH			= 80,
	EDV_IMBR_OP_REFRESH_ALL			= 81,
	EDV_IMBR_OP_STOP			= 82,
	EDV_IMBR_OP_CONTINUE			= 83,

	EDV_IMBR_OP_DOWNLOAD			= 85,

	EDV_IMBR_OP_SHOW_TOOL_BAR		= 90,
	EDV_IMBR_OP_SHOW_LOCATION_BAR		= 91,
	EDV_IMBR_OP_SHOW_MOUNT_BAR		= 92,
	EDV_IMBR_OP_SHOW_FIND_BAR		= 93,
	EDV_IMBR_OP_SHOW_STATUS_BAR		= 94,
	EDV_IMBR_OP_MIME_TYPES			= 100,
	EDV_IMBR_OP_DEVICES			= 101,

	EDV_IMBR_OP_NEW_BROWSER			= 110,
	EDV_IMBR_OP_NEW_IMBR			= 111,
	EDV_IMBR_OP_NEW_ARCHIVER		= 112,
	EDV_IMBR_OP_RECYCLE_BIN			= 113,

	EDV_IMBR_OP_OPTIONS			= 150,
	EDV_IMBR_OP_CUSTOMIZE			= 151,

	EDV_IMBR_OP_DEVICE_CHECK		= 180,
	EDV_IMBR_OP_DEVICE_TOOLS		= 181,
	EDV_IMBR_OP_DEVICE_FORMAT		= 182,

	EDV_IMBR_OP_HELP_ABOUT			= 1000,
	EDV_IMBR_OP_HELP_CONTENTS		= 1001,
	EDV_IMBR_OP_HELP_FILE_BROWSER	 	= 1002,
	EDV_IMBR_OP_HELP_IMAGE_BROWSER		= 1003,
	EDV_IMBR_OP_HELP_ARCHIVER		= 1004,
	EDV_IMBR_OP_HELP_RECYCLE_BIN		= 1005,
	EDV_IMBR_OP_HELP_KEYS_LIST		= 1006,
	EDV_IMBR_OP_HELP_MIME_TYPES		= 1007,
	EDV_IMBR_OP_HELP_DEVICES		= 1008,
	EDV_IMBR_OP_HELP_COMMON_OPERATIONS	= 1009
} edv_imbr_op;


/*
 *	Image Browser Operation ID:
 */
typedef struct {

	gpointer	imbr;
	edv_imbr_op	op;
	gboolean	allow_multiple;		/* Allow multiple instances
						 * of this operation in
						 * lists */

	toolbar_item_type tb_item_type;		/* Type of item when placed
						 * on the Tool Bar */

	/* Operation callback */
	void	(*func_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* OPID */
	);

	/* Enter and leave notify callbacks */
	void	(*enter_func_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* OPID */
	);
	void	(*leave_func_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* OPID */
	);

	gchar		*button_name,	/* Name on a button */
			*menu_name,	/* Name on a menu item */
			*tooltip;	/* Tool tip or description (one line) */

	guint		accel_key,	/* Accelerator key */
			accel_mods;	/* Accelerator key modifiers */ 

	guint8		**button_icon_data,	/* Shared */
			**menu_icon_data;	/* Shared */

} edv_imbr_opid_struct;
#define EDV_IMBR_OPID(p)	((edv_imbr_opid_struct *)(p))

/*
 *	Image Browser:
 */
typedef struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	processing;
	gint		busy_count,
			freeze_count;
	gpointer	core_ptr;

	edv_imbr_opid_struct	**opid;
	gint			total_opids;

	gint		stop_count;
	guint		loading_tocb;

	gboolean	tool_bar_map_state,
			location_bar_map_state,
			mount_bar_map_state,
			find_bar_map_state,
			status_bar_map_state;

	GtkWidget	*main_vbox,
			*menu_bar,
			*bars_vbox,		/* Toolbars GtkVBox */

			*menu_bar_handle,
			*tool_bar_handle,
			*location_bar_handle,
			*mount_bar_handle,
			*find_bar_handle,

			*location_bar_hbox,	/* GtkHBox parent for location bar */
			*location_icon_fixed,
			*location_icon_pm,
			*location_combo,

			*main_paned;		/* GtkHPaned */

	/* General tool bar */
	toolbar_struct	*toolbar;

	/* Mount bar */
	edv_mountbar_struct	*mountbar;

	/* Find bar */
	edv_findbar_struct	*findbar;

	/* Important menu items */
	GtkWidget	*open_mi,
			*openwith_mi,
			*new_object_submi,
			*new_object_submenu,
			*new_file_mi,
			*new_directory_mi,
			*new_link_mi,
			*new_fifo_mi,
			*new_device_block_mi,
			*new_device_character_mi,
			*new_socket_mi,
			*sync_disks_mi,
			*history_mi,
			*run_mi,
			*close_mi,

			*move_mi,
			*copy_mi,
			*link_mi,
			*rename_mi,
			*chmod_mi,
			*chown_mi,
			*delete_mi,
			*select_all_mi,
			*unselect_all_mi,
			*invert_selection_mi,
			*find_mi,
			*properties_mi,

			*mount_mi,
			*eject_mi,
			*device_check_mi,
			*device_tools_mi,
			*device_format_mi,
			*devices_mi,

			*stop_mi,
			*continue_mi,
			*refresh_mi,
			*refresh_all_mi,
			*show_tool_bar_micheck,
			*show_location_bar_micheck,
			*show_mount_bar_micheck,
			*show_find_bar_micheck,
			*show_status_bar_micheck,
			*mime_types_mi,

			*write_protect_mi,
			*options_mi,
			*customize_mi,

			*window_new_browser_mi,
			*window_new_imbr_mi,
			*window_new_archiver_mi,
			*window_recycle_bin_mi,

			*help_contents_mi,
			*help_image_browser_mi,
			*help_keys_list_mi,
			*help_mime_types_mi,
			*help_devices_mi,
			*help_common_operations_mi,
			*help_about_mi;

	/* Thumbs list */
	tlist_struct	*tlist;

	/* Image viewer */
	imgview_struct	*imgview;


	/* Right-click menu */
	GtkWidget	*tlist_menu,
			*tlist_open_mi,
			*tlist_openwith_mi,
			*tlist_mount_mi,
			*tlist_eject_mi,
			*tlist_mount_misep,
			*tlist_move_mi,
			*tlist_copy_mi,
			*tlist_link_mi,
			*tlist_rename_mi,
			*tlist_chmod_mi,
			*tlist_chown_mi,
			*tlist_delete_mi,
			*tlist_properties_mi;

	/* Icons used in the thumbs list */
	GdkPixmap	*folder_home_pixmap;
	GdkBitmap	*folder_home_mask;
	GdkPixmap	*folder_parent_pixmap;
	GdkBitmap	*folder_parent_mask;
	GdkPixmap	*folder_noaccess_pixmap;
	GdkBitmap	*folder_noaccess_mask;
	GdkPixmap	*file_badimage_pixmap;
	GdkBitmap	*file_badimage_mask;

	/* Last selected thumb (can be -1 for none)
	 *
	 * Note that this does not reflect other selected rows since
	 * multiple selections are allowed
	 */
	gint	tlist_selected_thumb;

	/* Selected device, reflects the device of the disk object of
	 * the selected thumb
	 *
	 * The device number corresponds with a device on the core's
	 * list of devices
	 */
	gint	selected_dev_num;


	/* Last known items in recycle bin, this is used as a quick
	 * access value to check if the recycle bin has contents or
	 * not
	 *
	 * Can be -1 to indicate undefined
	 */
	gint	last_recbin_items;

	/* Last known write protect state (can be -1 to indicate
	 * undefined)
	 */
	gint	last_write_protect_state;



	/* Status bar */
	edv_status_bar_struct	*status_bar;


	/* File operation dialog */
	edv_fopdlg_struct	*fopdlg;

} edv_imbr_struct;
#define EDV_IMBR(p)	((edv_imbr_struct *)(p))


extern void EDVImbrSetTitle(edv_imbr_struct *imbr, const gchar *path);

extern gchar *EDVImbrCurrentLocation(edv_imbr_struct *imbr);
extern void EDVImbrSetLocation(
	edv_imbr_struct *imbr,
	const gchar *path, gboolean record_history
);
extern void EDVImbrUpdateLocationIcon(
	edv_imbr_struct *imbr, const gchar *path
);

extern void EDVImbrToolbarRegenerate(edv_imbr_struct *imbr);
extern void EDVImbrTListMenuRegenerate(edv_imbr_struct *imbr);

extern void EDVImbrSyncConfiguration(edv_imbr_struct *imbr);

extern void EDVImbrQueueLoadingProcess(edv_imbr_struct *imbr);

extern void EDVImbrSelectPath(
	edv_imbr_struct *imbr, const gchar *path
);

extern edv_imbr_opid_struct **EDVImbrOPIDListNew(
	edv_imbr_struct *imbr,		/* Can be NULL */
	gint *total
);
extern void EDVImbrOPIDListDelete(
	edv_imbr_opid_struct **list, gint total
);

extern void EDVImbrNewObjectMenuRegenerate(edv_imbr_struct *imbr);

extern edv_imbr_struct *EDVImbrNew(gpointer core_ptr);
extern void EDVImbrReset(edv_imbr_struct *imbr, gboolean need_unmap);
extern void EDVImbrSyncData(edv_imbr_struct *imbr);
extern void EDVImbrUpdateMenus(edv_imbr_struct *imbr);
extern void EDVImbrSetBusy(edv_imbr_struct *imbr, gboolean is_busy);
extern gboolean EDVImbrIsMapped(edv_imbr_struct *imbr);
extern void EDVImbrMap(edv_imbr_struct *imbr);
extern void EDVImbrUnmap(edv_imbr_struct *imbr);
extern void EDVImbrDelete(edv_imbr_struct *imbr);


#endif	/* IMBR_H */
