#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "../include/string.h"
#include "../include/disk.h"

#include "guiutils.h"
#include "toolbar.h"

#include "cfg.h"
#include "edvtypes.h"
#include "edvlistcb.h"
#include "edvobj.h"
#include "edvdevices.h"
#include "edvstatusbar.h"
#include "fopdlg.h"
#include "imbr.h"
#include "imbrcb.h"
#include "imbropcb.h"
#include "imbrtlist.h"
#include "imbrdnd.h"
#include "endeavour.h"
#include "edvcb.h"
#include "edvutils.h"
#include "edvutilsgtk.h"
#include "edvcfglist.h"
#include "config.h"

#include "images/icon_hsep_20x20.xpm"
#include "images/icon_copy_20x20.xpm"
#include "images/icon_new_20x20.xpm"
#include "images/icon_save_20x20.xpm"
#include "images/icon_trace_20x20.xpm"
#include "images/icon_run_20x20.xpm"
#include "images/icon_terminal_20x20.xpm"
#include "images/icon_close_20x20.xpm"
#include "images/icon_exit_20x20.xpm"
#include "images/icon_mount_20x20.xpm"
#include "images/icon_unmount_20x20.xpm"
#include "images/icon_eject_20x20.xpm"
#include "images/icon_move_file_20x20.xpm"
#include "images/icon_copy_file_20x20.xpm"
#include "images/icon_rename_20x20.xpm"
#include "images/icon_cancel_20x20.xpm"
#include "images/icon_chmod_20x20.xpm"
#include "images/icon_owned_20x20.xpm"
#include "images/icon_select_20x20.xpm"
#include "images/icon_properties2_20x20.xpm"
#include "images/icon_stop_20x20.xpm"
#include "images/icon_reload_20x20.xpm"
#include "images/icon_planet_20x20.xpm"
#include "images/icon_search_20x20.xpm"
#include "images/icon_device_misc_20x20.xpm"
#include "images/icon_mimetypes_20x20.xpm"
#include "images/icon_tool_bar_20x20.xpm"
#include "images/icon_status_bar_20x20.xpm"
#include "images/icon_options2_20x20.xpm"
#include "images/icon_customize_20x20.xpm"
#include "images/icon_insecure_20x20.xpm"
#include "images/icon_secure_20x20.xpm"
#include "images/icon_fsck_20x20.xpm"
#include "images/icon_tools_20x20.xpm"
#include "images/icon_floppy_20x20.xpm"

#include "images/icon_open_20x20.xpm"
#include "images/icon_file_20x20.xpm"
#include "images/icon_folder_closed_20x20.xpm"
#include "images/icon_folder_home_20x20.xpm"
#include "images/icon_folder_parent_20x20.xpm"
#include "images/icon_link2_20x20.xpm"
#include "images/icon_pipe_20x20.xpm"
#include "images/icon_device_block_20x20.xpm"
#include "images/icon_device_character_20x20.xpm"
#include "images/icon_socket_20x20.xpm"

#include "images/icon_folder_home_32x32.xpm"
#include "images/icon_folder_parent_32x32.xpm"
#include "images/icon_folder_noaccess_32x32.xpm"
#include "images/icon_file_badimage_32x32.xpm"

#include "images/icon_trash_empty_20x20.xpm"
#include "images/icon_trash_20x20.xpm"
#include "images/icon_help_20x20.xpm"
#include "images/icon_about_20x20.xpm"

#include "images/endeavour_20x20.xpm"
#include "images/image_browser_20x20.xpm"
#include "images/archiver_20x20.xpm"
#include "images/image_browser_48x48.xpm"


static edv_imbr_opid_struct *EDVImbrMatchOPID(
	edv_imbr_struct *imbr, edv_imbr_op op
);

void EDVImbrSetTitle(edv_imbr_struct *imbr, const gchar *path);

gchar *EDVImbrCurrentLocation(edv_imbr_struct *imbr);
void EDVImbrSetLocation(
	edv_imbr_struct *imbr,
	const gchar *path, gboolean record_history
);
void EDVImbrUpdateLocationIcon(
	edv_imbr_struct *imbr, const gchar *path
);

void EDVImbrToolbarRegenerate(edv_imbr_struct *imbr);
void EDVImbrTListMenuRegenerate(edv_imbr_struct *imbr);

void EDVImbrSyncConfiguration(edv_imbr_struct *imbr);

void EDVImbrQueueLoadingProcess(edv_imbr_struct *imbr);

void EDVImbrSelectPath(
	edv_imbr_struct *imbr, const gchar *path
);

edv_imbr_opid_struct **EDVImbrOPIDListNew(
	edv_imbr_struct *imbr,		/* Can be NULL */
	gint *total
);
void EDVImbrOPIDListDelete(
	edv_imbr_opid_struct **list, gint total
);

void EDVImbrNewObjectMenuRegenerate(edv_imbr_struct *imbr);

static void EDVImbrCreateMenuBar(
	edv_imbr_struct *imbr, GtkWidget *parent
);
edv_imbr_struct *EDVImbrNew(gpointer core_ptr);
void EDVImbrReset(edv_imbr_struct *imbr, gboolean need_unmap);
void EDVImbrSyncData(edv_imbr_struct *imbr);
void EDVImbrUpdateMenus(edv_imbr_struct *imbr);
void EDVImbrSetBusy(edv_imbr_struct *imbr, gboolean is_busy);
gboolean EDVImbrIsMapped(edv_imbr_struct *imbr);
void EDVImbrMap(edv_imbr_struct *imbr);
void EDVImbrUnmap(edv_imbr_struct *imbr);
void EDVImbrDelete(edv_imbr_struct *imbr);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Returns the Image Browser Operation ID that matches the given
 *	operation.
 */
static edv_imbr_opid_struct *EDVImbrMatchOPID(
	edv_imbr_struct *imbr, edv_imbr_op op
)
{
	gint i;
	edv_imbr_opid_struct *opid;

	if(imbr == NULL)
	    return(NULL);

	for(i = 0; i < imbr->total_opids; i++)
	{
	    opid = imbr->opid[i];
	    if((opid != NULL) ? (opid->op == op) : FALSE)
		return(opid);
	}

	return(NULL);
}


/*
 *	Sets the Image Browser's title.
 *
 *	The given path is optional, it can be either the current
 *	selected location or the last selected object.
 */
void EDVImbrSetTitle(edv_imbr_struct *imbr, const gchar *path)
{
	gboolean include_user_name, include_location;
	const gchar *prog_name = "Image Browser";
	gchar *title;
	GtkWidget *w;
	const cfg_item_struct *cfg_list;
	edv_core_struct *core_ptr;

	if(imbr == NULL)
	    return;

	w = imbr->toplevel;
	core_ptr = EDV_CORE(imbr->core_ptr);
	if((w == NULL) || (core_ptr == NULL))
	    return;

	if(!STRISEMPTY(core_ptr->title))
	    prog_name = core_ptr->title;

	cfg_list = core_ptr->cfg_list;

	include_user_name = EDV_GET_B(EDV_CFG_PARM_IMBR_TITLE_WITH_USER);
	include_location = EDV_GET_B(EDV_CFG_PARM_IMBR_TITLE_WITH_LOCATION);

	/* Generate new title string */
	if(include_user_name && include_location &&
	   (path != NULL)
	)
	    title = g_strdup_printf(
		"%s: %s %s",
		prog_name, core_ptr->effective_user_id_host_str,
		path
	    );
	else if(include_location && (path != NULL))
	    title = g_strdup_printf(
		"%s: %s",
		prog_name, path
	    );
	else if(include_user_name)
	    title = g_strdup_printf(
		"%s: %s",
		prog_name, core_ptr->effective_user_id_host_str
	    );
	else
	    title = STRDUP(prog_name);

	/* Set new title */
	gtk_window_set_title(GTK_WINDOW(w), title);

	g_free(title);
}

/*
 *	Returns the Image Browser's current location.
 */
gchar *EDVImbrCurrentLocation(edv_imbr_struct *imbr)
{
	GtkCombo *combo = (GtkCombo *)((imbr != NULL) ?
	    imbr->location_combo : NULL
	);
	return((combo != NULL) ?
	    gtk_entry_get_text(GTK_ENTRY(combo->entry)) : NULL
	);
}

/*
 *	Sets the Image Browser's location.
 *
 *	If record_history is TRUE then the new location will be
 *	recorded on the location history.
 */
void EDVImbrSetLocation(
	edv_imbr_struct *imbr,
	const gchar *path, gboolean record_history
)
{
	const gchar *s;
	gchar *new_path;
	GtkEntry *entry;
	GtkCombo *combo = (GtkCombo *)((imbr != NULL) ?
	    imbr->location_combo : NULL
	);
	if((combo == NULL) || STRISEMPTY(path))
	    return;

	entry = GTK_ENTRY(combo->entry);

	/* Get new path */
	new_path = STRDUP(path);

	/* Simplify new path */
	SimplifyPath(new_path);

	/* No change? */
	s = gtk_entry_get_text(entry);
	if((s != NULL) ? !strcmp(s, new_path) : FALSE)
	{
	    g_free(new_path);
	    return;
	}

	/* Record new location on the location history? */
	if(record_history)
	    GUIComboAddItem(GTK_WIDGET(combo), new_path);

	/* Set new location */
	gtk_entry_set_text(entry, new_path);
	gtk_entry_set_position(entry, -1);

	g_free(new_path);
}

/*
 *	Updates the Image Browser Location Bar's icon.
 *
 *	If the given path is NULL then the icon will be set as unknown.
 */
void EDVImbrUpdateLocationIcon(
	edv_imbr_struct *imbr, const gchar *path
)
{
	gint width, height;
	edv_object_type type;
	edv_permission_flags permissions;
	GdkPixmap *pixmap_closed, *pixmap_opened;
	GdkBitmap *mask_closed, *mask_opened;
	GtkWidget *parent, *w;
	edv_core_struct *core_ptr;

	if(imbr == NULL)
	    return;

	parent = imbr->location_icon_fixed;
	core_ptr = EDV_CORE(imbr->core_ptr);
	if((parent == NULL) || (core_ptr == NULL))
	    return;

	/* Get type and permissions of the object specified by path */
	type = EDV_OBJECT_TYPE_DIRECTORY;
	permissions = 0x00000000;
	if(!STRISEMPTY(path))
	{
	    struct stat lstat_buf;
	    if(!lstat(path, &lstat_buf))
	    {
		mode_t m = lstat_buf.st_mode;
		type = EDVObjectGetTypeFromStatMode(m);
		permissions = EDVObjectGetPermissionsFromStatMode(m);
	    }
	}

	/* Get pixmap and mask for icon */
	EDVMatchObjectIcon(
	    core_ptr->device, core_ptr->total_devices,
	    core_ptr->mimetype, core_ptr->total_mimetypes,
	    type,
	    path,
	    TRUE,
	    permissions,
	    0,			/* Small icons */
	    &pixmap_closed, &mask_closed,
	    &pixmap_opened, &mask_opened,
	    NULL, NULL
	);
	/* If the opened pixmap is not available then rever to the
	 * closed pixmap
	 */
	if(pixmap_opened == NULL)
	{
	    pixmap_opened = pixmap_closed;
	    mask_opened = mask_closed;
	}
	if(pixmap_opened == NULL)
	    return;

	/* Create new icon pixmap widget as needed */
	w = imbr->location_icon_pm;
	if(w == NULL)
	{
	    imbr->location_icon_pm = w = gtk_pixmap_new(
		pixmap_opened, mask_opened
	    );
	    gtk_fixed_put(GTK_FIXED(parent), w, 0, 0);
	    gtk_widget_show(w);
	}
	else
	{
	    gtk_pixmap_set(GTK_PIXMAP(w), pixmap_opened, mask_opened);
	}

	gdk_window_get_size(pixmap_opened, &width, &height);
}


/*
 *	Recreates the Image Browser's Tool Bar.
 */
void EDVImbrToolbarRegenerate(edv_imbr_struct *imbr)
{
	gint i, total_items;
	toolbar_display tb_display;
	toolbar_relief tb_relief;
	GtkWidget *w, *parent;
	const cfg_intlist_struct *intlist;
	const cfg_item_struct *cfg_list;
	edv_imbr_opid_struct *opid;
	toolbar_item_struct **item, *item_ptr;
	toolbar_struct *toolbar;
	edv_core_struct *core_ptr;

	if(imbr == NULL)
	    return;

	parent = imbr->tool_bar_handle;
	core_ptr = EDV_CORE(imbr->core_ptr);
	if((parent == NULL) || (core_ptr == NULL))
	    return;

	cfg_list = core_ptr->cfg_list;

	/* Get Tool Bar configuration */
	tb_display = (toolbar_display)EDV_GET_I(
	    EDV_CFG_PARM_IMBR_TOOL_BAR_DISPLAY
	);
	tb_relief = (toolbar_relief)EDV_GET_I(
	    EDV_CFG_PARM_IMBR_TOOL_BAR_RELIEF
	);
	intlist = EDV_GET_INTLIST(EDV_CFG_PARM_IMBR_TOOL_BAR);
	if(intlist == NULL)
	    return;

	/* Delete existing Tool Bar if any */
	ToolBarDelete(imbr->toolbar);
	imbr->toolbar = NULL;

	/* Create Tool Bar items list */
	total_items = intlist->total;
	if(total_items > 0)
	{
	    item = (toolbar_item_struct **)g_malloc0(
		total_items * sizeof(toolbar_item_struct *)
	    );
	    if(item == NULL)
		total_items = 0;
	}
	else
	{
	    item = NULL;
	}
	for(i = 0; i < total_items; i++)
	{
	    /* Get Operation ID */
	    opid = EDVImbrMatchOPID(imbr, intlist->i[i]);
	    if(opid == NULL)
		continue;

	    switch(opid->op)
	    {
	      case EDV_IMBR_OP_NONE:
		item[i] = item_ptr = NULL;
		break;

	      default:
		item[i] = item_ptr = ToolBarItemNew(
		    opid->tb_item_type,
		    opid->button_name,
		    opid->button_icon_data,
		    opid->tooltip,
		    opid->op,
		    EDVImbrOPCB, opid,
		    EDVImbrOPEnterCB, opid,                    
		    EDVImbrOPLeaveCB, opid
		);
		break;
	    }

	}

	/* Create new Tool Bar */
	imbr->toolbar = toolbar = ToolBarNew(
	    item, total_items, parent,
	    tb_display, tb_relief, FALSE
	);
	ToolBarMap(toolbar);

	/* Delete Tool Bar items list */
	ToolBarItemListDeleteAll(&item, &total_items);

	/* Need to queue resize of toplevel since Tool Bar size
	 * mave have changed
	 */
	w = imbr->toplevel;
	if(w != NULL)
	    gtk_widget_queue_resize(w);
}

/*
 *	Recreates the Image Browser Thumbs List right click menu.
 */
void EDVImbrTListMenuRegenerate(edv_imbr_struct *imbr)
{
	if(imbr == NULL)
	    return;

	GTK_WIDGET_DESTROY(imbr->tlist_menu);
	imbr->tlist_menu = NULL;

	/* Create new menu */
	if(TRUE)
	{
	    edv_imbr_op op;
	    guint8 **icon_data = NULL;
	    GtkAccelGroup *accelgrp = NULL;
	    GtkWidget *menu, *w, **w_record, **fw_record;

#define DO_ADD_MENU_ITEM_LABEL		{	\
 edv_imbr_opid_struct *opid =			\
  EDVImbrMatchOPID(imbr, op);			\
 if(opid != NULL) {				\
  w = GUIMenuItemCreate(			\
   menu, GUI_MENU_ITEM_TYPE_LABEL, accelgrp,	\
   (guint8 **)((icon_data != NULL) ?		\
    icon_data : opid->menu_icon_data),		\
   opid->menu_name,				\
   opid->accel_key, opid->accel_mods,		\
   (gpointer *)fw_record,			\
   (gpointer)opid, EDVImbrMenuItemCB		\
  );						\
  GUISetMenuItemCrossingCB(			\
   w,						\
   (gpointer)EDVImbrMenuItemEnterCB, opid,	\
   (gpointer)EDVImbrMenuItemLeaveCB, opid	\
  );						\
  if(w_record != NULL)				\
   *w_record = w;				\
 }						\
}

#define DO_ADD_MENU_SEP		{		\
 w = GUIMenuItemCreate(				\
  menu, GUI_MENU_ITEM_TYPE_SEPARATOR, NULL,	\
  NULL, NULL, 0, 0, NULL,			\
  NULL, NULL					\
 );						\
}

	    /* Create menu */
	    imbr->tlist_menu = menu = GUIMenuCreate();

	    op = EDV_IMBR_OP_OPEN;
	    w_record = &imbr->tlist_open_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_OPEN_WITH;
	    w_record = &imbr->tlist_openwith_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_IMBR_OP_MOUNT;
	    w_record = &imbr->tlist_mount_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_EJECT;
	    w_record = &imbr->tlist_eject_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP
	    imbr->tlist_mount_misep = w;

	    op = EDV_IMBR_OP_MOVE;
	    w_record = &imbr->tlist_move_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_COPY;
	    w_record = &imbr->tlist_copy_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_LINK;
	    w_record = &imbr->tlist_link_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_RENAME;
	    w_record = &imbr->tlist_rename_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_CHMOD;
	    w_record = &imbr->tlist_chmod_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_CHOWN;
	    w_record = &imbr->tlist_chown_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_DELETE;
	    w_record = &imbr->tlist_delete_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_IMBR_OP_PROPERTIES;
	    w_record = &imbr->tlist_properties_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

#undef DO_ADD_MENU_ITEM_LABEL
#undef DO_ADD_MENU_SEP
	}
}


/*
 *	Sets the Image Browser's values to the configuration.
 */
void EDVImbrSyncConfiguration(edv_imbr_struct *imbr)
{
	GtkWidget *w;
	edv_core_struct *core_ptr;
	cfg_item_struct *cfg_list;

	if(imbr == NULL)
	    return;

	core_ptr = EDV_CORE(imbr->core_ptr);
	if(core_ptr == NULL)
	    return;

	cfg_list = core_ptr->cfg_list;

	/* Location history */
	w = imbr->location_combo;
	if(core_ptr != NULL)
	{
	    GList *glist = GUIComboGetList(w);
	    const gchar *path = EDV_GET_S(
		EDV_CFG_PARM_FILE_IMBR_LOCATION_HISTORY
	    );
	    EDVSaveFileGList(path, glist);
	}

	/* Toplevel geometry */
	w = imbr->toplevel;
	if(w != NULL)
	{
	    GdkWindow *window = w->window;
	    gint x = 0, y = 0;

	    if(window != NULL)
		gdk_window_get_root_origin(window, &x, &y);

	    EDV_SET_I(EDV_CFG_PARM_IMBR_X, x);
	    EDV_SET_I(EDV_CFG_PARM_IMBR_Y, y);
	    EDV_SET_I(EDV_CFG_PARM_IMBR_WIDTH, w->allocation.width);
	    EDV_SET_I(EDV_CFG_PARM_IMBR_HEIGHT, w->allocation.height);
	}

	/* Get position of main paned */
	w = imbr->main_paned;
	if(w != NULL)
	{
	    EDV_SET_I(
		EDV_CFG_PARM_IMBR_PANED_POSITION,
		GTK_PANED(w)->child1_size
	    );
	}

	/* Set new startup directory as the last directory of this
	 * window's location
	 */
	if(EDV_GET_B(EDV_CFG_PARM_RECORD_START_UP_DIR))
	{
	    EDV_SET_S(
		EDV_CFG_PARM_DIR_START_UP,
		EDVImbrCurrentLocation(imbr)
	    );
	}
}

/*
 *	Resets the Image Browser's loading process timeout callback
 *	and initializes loading values.
 */
void EDVImbrQueueLoadingProcess(edv_imbr_struct *imbr)
{
	if(imbr == NULL)
	    return;

	/* Remove previous loading timeout callback as needed */
	if(imbr->loading_tocb > 0)
	{
	    gtk_timeout_remove(imbr->loading_tocb);
	    imbr->loading_tocb = 0;
	}

	/* Reset stop count */
	imbr->stop_count = 0;

	/* Set new loading timeout */
	imbr->loading_tocb = gtk_timeout_add(
	    100,
	    (GtkFunction)EDVImbrLoadingTOCB,
	    imbr
	);
}


/*
 *	Clears the Image Browser's Thumbs List and resets all loading
 *	procedure values, then loads the listing for the new directory
 *	specified by path.
 */
void EDVImbrSelectPath(edv_imbr_struct *imbr, const gchar *path)
{
	gchar *dpath;

	if((imbr == NULL) || STRISEMPTY(path))
	    return;

	dpath = STRDUP(path);
	if(dpath == NULL)
	    return;

	/* Remove previous loading timeout callback as needed */
	if(imbr->loading_tocb > 0)
	{
	    gtk_timeout_remove(imbr->loading_tocb);
	    imbr->loading_tocb = 0;
	}

	/* Update title and location bar */
	EDVImbrSetTitle(imbr, dpath);
	EDVImbrSetLocation(imbr, dpath, FALSE);
	EDVImbrUpdateLocationIcon(imbr, dpath);

	/* Clear thumbs list and get new listing */
	EDVImbrTListDoUpdate(imbr, dpath, TRUE);

	/* Set loading progress timeout callback and reset loading
	 * progress values
	 */
	EDVImbrQueueLoadingProcess(imbr);

	g_free(dpath);
}


/*
 *	Creates a new Image Browser Operation IDs list.
 */
edv_imbr_opid_struct **EDVImbrOPIDListNew(
	edv_imbr_struct *imbr,		/* Can be NULL */
	gint *total
)
{
	edv_imbr_op op;
	gboolean allow_multiple;
	toolbar_item_type tb_item_type;
	const gchar *button_name, *menu_name, *tooltip;
	guint accel_key, accel_mods;
	guint8 **button_icon_data, **menu_icon_data;
	edv_imbr_opid_struct **list, *opid;
	void (*func_cb)(toolbar_item_struct *, gint, gpointer);
	void (*enter_func_cb)(toolbar_item_struct *, gint, gpointer);

	if(total == NULL)
	    return(NULL);

	*total = 0;
	list = NULL;

#define DO_APPEND_OPID	{			\
 gint i = MAX(*total, 0);			\
 *total = i + 1;				\
 list = (edv_imbr_opid_struct **)g_realloc(	\
  list,						\
  (*total) * sizeof(edv_imbr_opid_struct *)	\
 );						\
 if(list == NULL) {				\
  *total = 0;					\
  return(list);					\
 } else {					\
  list[i] = opid = EDV_IMBR_OPID(		\
   g_malloc0(sizeof(edv_imbr_opid_struct))	\
  );						\
  if(opid != NULL) {				\
   opid->imbr = imbr;				\
   opid->op = op;				\
   opid->tb_item_type = tb_item_type;	\
   opid->allow_multiple = allow_multiple;	\
   opid->func_cb = func_cb;			\
   opid->enter_func_cb = enter_func_cb;		\
   opid->button_name = STRDUP(button_name);	\
   opid->menu_name = STRDUP(menu_name);		\
   opid->tooltip = STRDUP(tooltip);		\
   opid->accel_key = accel_key;			\
   opid->accel_mods = accel_mods;		\
   opid->button_icon_data = button_icon_data;	\
   opid->menu_icon_data = menu_icon_data;	\
  }						\
 }						\
}

	func_cb = EDVImbrOPCB;
	enter_func_cb = EDVImbrOPEnterCB;


	op = EDV_IMBR_OP_SEPARATOR;
	tb_item_type = TOOLBAR_ITEM_SEPARATOR;
	allow_multiple = TRUE;
	button_icon_data = (guint8 **)icon_hsep_20x20_xpm;
	menu_icon_data = button_icon_data;
#if defined(PROG_LANGUAGE_SPANISH)
	button_name = "Separador";
	menu_name = "Separador";
	tooltip = "Separador";
#elif defined(PROG_LANGUAGE_FRENCH)
	button_name = "Sparateur";
	menu_name = "Sparateur";
	tooltip = "Sparateur";
#elif defined(PROG_LANGUAGE_GERMAN)
	button_name = "Separator";
	menu_name = "Separator";
	tooltip = "Separator";
#elif defined(PROG_LANGUAGE_ITALIAN)
	button_name = "Separatore";
	menu_name = "Separatore";
	tooltip = "Separatore";
#elif defined(PROG_LANGUAGE_DUTCH)
	button_name = "Separator";
	menu_name = "Separator";
	tooltip = "Separator";
#elif defined(PROG_LANGUAGE_PORTUGUESE)
	button_name = "Separador";
	menu_name = "Separador";
	tooltip = "Separador";
#elif defined(PROG_LANGUAGE_NORWEGIAN)
	button_name = "Separator";
	menu_name = "Separator";
	tooltip = "Separator";
#else
	button_name = "Separator";
	menu_name = "Separator";
	tooltip = "Separator";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_IMBR_OP_CLOSE;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_close_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Close";
	menu_name = "Close";
	tooltip = "Close this window";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Cierre";
	menu_name = "Cierre";
	tooltip = "Cierre esta ventana";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Proche";
	menu_name = "Proche";
	tooltip = "Fermer cette fentre";
#endif
	accel_key = 'w';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_EXIT;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_exit_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Exit";
	menu_name = "Exit";
	tooltip = "Close all windows in the application and exit";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "La Salida";
	menu_name = "La Salida";
	tooltip = "Cierra todas ventanas en la aplicacin y la";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Sortie";
	menu_name = "Sortie";
	tooltip = "Ferme toutes fentres dans l'application et sortie";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_IMBR_OP_WRITE_PROTECT;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_secure_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Protect";
	menu_name = "Write Protect";
	tooltip = "Enable/disable write protect";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Proteja";
	menu_name = "Escriba Proteja";
	tooltip = "Habilite/incapacita escribe protege";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Protge";
	menu_name = "Protge En criture";
	tooltip = "Rend capable/rend infirme protge en criture";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_SYNC_DISKS;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_save_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Sync Disks";
	menu_name = "Sync Disks";
	tooltip = "Flush any pending data transfers to disk";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Discos Sincro";
	menu_name = "Discos Sincro";
	tooltip = "Limpan cualquiera transferencias pendientes de datos al disco";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Disq Syn";
	menu_name = "Les Disques De Syn";
	tooltip = "Rincer des transferts de donnes en attente au disque";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_RUN;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_run_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Run";
	menu_name = "Run...";
	tooltip = "Run a program";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Corra";
	menu_name = "Corra...";
	tooltip = "Corra un programa";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Courir";
	menu_name = "Courir...";
	tooltip = "Excute un programme";
#endif
	accel_key = 'r';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_RUN_TERMINAL;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_terminal_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Terminal";
	menu_name = "Terminal";
	tooltip = "Run a terminal";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "La Terminal";
	menu_name = "La Terminal";
	tooltip = "Corre una terminal";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Le Terminal";
	menu_name = "Le Terminal";
	tooltip = "Courir un terminal";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_IMBR_OP_NEW;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_new_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "New";
	menu_name = "New";
	tooltip = "Create a new object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Nuevo";
	menu_name = "Nuevo";
	tooltip = "Crea un objeto nuevo";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Nouveau";
	menu_name = "Nouveau";
	tooltip = "Crer un nouvel objet";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_NEW_FILE;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_file_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "New File";
	menu_name = "File";
	tooltip = "Create a new file object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Archivo";
	menu_name = "El Archivo";
	tooltip = "Crea un objeto nuevo del archivo";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Fichier";
	menu_name = "Fichier";
	tooltip = "Crer un nouvel objet de fichier";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_NEW_DIRECTORY;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_folder_closed_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "New Dir";
	menu_name = "Directory";
	tooltip = "Create a new directory object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "La Gua";
	menu_name = "La Gua";
	tooltip = "Crea un objeto nuevo de gua";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Annuaire";
	menu_name = "Annuaire";
	tooltip = "Crer un nouvel objet d'annuaire";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_NEW_LINK;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_link2_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "New Lnk";
	menu_name = "Link";
	tooltip = "Create a new symbolic link object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Eslabn";
	menu_name = "El Eslabn";
	tooltip = "Crea un objeto simblico nuevo del eslabn";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Lien";
	menu_name = "Lien";
	tooltip = "Cre un nouveau symbolique lien";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_NEW_FIFO;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_pipe_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "New FIFO";
	menu_name = "FIFO Pipe";
	tooltip = "Create a new FIFO pipe object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "FIFO";
	menu_name = "FIFO Tubo";
	tooltip = "Crea un objeto nuevo de tubo de FIFO";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "FIFO";
	menu_name = "FIFO Tuyau";
	tooltip = "Crer un nouvel objet de tuyau de FIFO";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_NEW_DEVICE_BLOCK;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_device_block_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "New BDev";
	menu_name = "Block Device";
	tooltip = "Create a new block (buffered) device node object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "BArtefacto";
	menu_name = "El Artefacto Del Bloque";
	tooltip = "Crea un objeto nuevo de nodo de artefacto de bloque (buffered)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "BL'Appareil";
	menu_name = "Le Priphrique  Blocs";
	tooltip = "Crer un nouveau bloc (buffered) l'objet de noeu";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_NEW_DEVICE_CHARACTER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_device_character_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "New CDev";
	menu_name = "Character Device";
	tooltip = "Create a new character (unbuffered) device node object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "CArtefacto";
	menu_name = "El Artefacto Del Carcter";
	tooltip = "Crea un objeto nuevo de nodo de artefacto de carcter (unbuffered)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "CL'Appareil";
	menu_name = "Le Priphrique  Caractres";
	tooltip = "Crer un nouveau caractre (unbuffered) l'objet de noeud d'appareil";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_NEW_SOCKET;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_socket_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "New Sock";
	menu_name = "Socket";
	tooltip = "Create a new socket object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Enchufe";
	menu_name = "El Enchufe";
	tooltip = "Crea un objeto nuevo del enchufe";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Douille";
	menu_name = "La Douille";
	tooltip = "Crer un nouvel objet de douille";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_IMBR_OP_OPEN;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_open_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Open";
	menu_name = "Open";
	tooltip = "Open selected object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Abierto";
	menu_name = "Abierto";
	tooltip = "Abre escogido se opone";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Ouvert";
	menu_name = "Ouvert";
	tooltip = "Ouvrir l'objet choisi";
#endif
	accel_key = GDK_Return;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_OPEN_WITH;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_open_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Open With";
	menu_name = "Open With...";
	tooltip = "Open selected object using a specific method";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Abra Con";
	menu_name = "Abra Con...";
	tooltip = "Abre escogido se opone usar un mtodo especfico";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Ouvrir Avec";
	menu_name = "Ouvrir Avec...";
	tooltip = "Ouvrir l'objet choisi pour utiliser une mthode spcifique";
#endif
	accel_key = GDK_Return;
	accel_mods = GDK_SHIFT_MASK;
	DO_APPEND_OPID


	op = EDV_IMBR_OP_GOTO_PARENT;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_folder_parent_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Parent";
	menu_name = "Go To Parent";
	tooltip = "Go to the parent directory";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "El Padre";
	menu_name = "Va A Actuar Como Padre";
	tooltip = "Para Ir a la gua del padre";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Parent";
	menu_name = "Aller Au Parent";
	tooltip = "Aller  l'annuaire de parent";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_GOTO_HOME;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_folder_home_20x20_xpm;
	menu_icon_data = button_icon_data;
	button_name = "Home";
	menu_name = "Go To Home";
	tooltip = "Go to the home directory";
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_MOUNT;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = NULL;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Mount";
	menu_name = "Mount";
	tooltip = "Mount/unmount selected mount point directory";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Monte";
	menu_name = "El Monte";
	tooltip = "El Monte/unmount escogi gua de punto de monte";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Le Mont";
	menu_name = "Le Mont";
	tooltip = "Le Mont/unmount a choisi l'annuaire de point de mont";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_EJECT;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_eject_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Eject";
	menu_name = "Eject";
	tooltip = "Eject media from device";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Expulse";
	menu_name = "Expulse";
	tooltip = "Expulse medios del artefacto";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Ejecter";
	menu_name = "Ejecter";
	tooltip = "Ejecter le presse de l'appareil";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_IMBR_OP_MOVE;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_move_file_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Move";
	menu_name = "Move...";
	tooltip = "Move selected object(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Mueva";
	menu_name = "Mueva...";
	tooltip = "Mueva escogido se opone(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Mouvement";
	menu_name = "Le mouvement...";
	tooltip = "Le Mouvement a choisi l'objet(s)";
#endif
	accel_key = GDK_F7;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_COPY;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_copy_file_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Copy";
	menu_name = "Copy...";
	tooltip = "Copy selected object(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Copia";
	menu_name = "La Copia...";
	tooltip = "La Copia escogi se opone(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Copia";
	menu_name = "La Copie...";
	tooltip = "La Copie a choisi l'objet(s)";
#endif
	accel_key = GDK_F8;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_LINK;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_link2_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Link";
	menu_name = "Link...";
	tooltip = "Link selected object(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Eslabn";
	menu_name = "El Eslabn...";
	tooltip = "El Eslabn escogi se opone(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Le Lien";
	menu_name = "Le Lien...";
	tooltip = "Le Lien a choisi l'objet(s)";
#endif
	accel_key = GDK_F6;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_RENAME;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_rename_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Rename";
	menu_name = "Rename";
	tooltip = "Rename selected object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Reagrupe";
	menu_name = "Reagrupe";
	tooltip = "Reagrupe escogido se opone";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Renommer";
	menu_name = "Renommer";
	tooltip = "Renomme l'objet choisi";
#endif
	accel_key = GDK_F2;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_CHMOD;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_chmod_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "ChMod";
	menu_name = "Change Permissions...";
	tooltip = "Change permissions of the selected object(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "ChMod";
	menu_name = "Cambie El Modo...";
	tooltip = "El Cambio escogi los permisos de objetos";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "ChMod";
	menu_name = "Changer Le Mode...";
	tooltip = "Le Changement a choisi des permissions des objets";
#endif
	accel_key = GDK_F9;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_CHOWN;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_owned_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Chown";
	menu_name = "Change Ownership...";
	tooltip = "Change ownership of the selected object(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Chown";
	menu_name = "Change Ownership...";
	tooltip = "Chown escogi se opone(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Chown";
	menu_name = "Change Ownership...";
	tooltip = "Chown a choisi l'objet(s)";
#endif
	accel_key = GDK_F10;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_DELETE;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_cancel_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Delete";
	menu_name = "Delete";
	tooltip = "Delete selected object(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Borre";
	menu_name = "Borre";
	tooltip = "Borre escogido se opone(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Effacer";
	menu_name = "Effacer";
	tooltip = "Efface l'objet choisi(s)";
#endif
	accel_key = GDK_Delete;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_SELECT_ALL;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_select_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "SelAll";
	menu_name = "Select All";
	tooltip = "Select all objects";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "SelAll";
	menu_name = "Escoja Todo";
	tooltip = "Escoge todo se opone";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "SelAll";
	menu_name = "Choisir Tout";
	tooltip = "Choisir tous objets";
#endif
	accel_key = 'a';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_UNSELECT_ALL;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_select_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "UnSelAll";
	menu_name = "Unselect All";
	tooltip = "Unselect all objects";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "UnSelAll";
	menu_name = "Unescoja Todo";
	tooltip = "Unescoge todo se opone";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "UnSelAll";
	menu_name = "Unchoisir Tout";
	tooltip = "Unchoisir tous objets";
#endif
	accel_key = 'u';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_INVERT_SELECTION;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_select_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "InvSel";
	menu_name = "Invert Selection";
	tooltip =
 "Select all unselected objects and unselect all selected objects";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "InvSel";
	menu_name = "Invierta Seleccin";
	tooltip =
 "Selectos todos objetos y unselect no seleccionados todos objetos escogidos";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "InvSel";
	menu_name = "Inverser Slection";
	tooltip =
 "Choisir tous objets dslections et deslectionner tous objets choisis";
#endif
	accel_key = 'i';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_PROPERTIES;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_properties2_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Properties";
	menu_name = "Properties...";
	tooltip = "Modify selected object's properties";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Props";
	menu_name = "Las Propiedades";
	tooltip = "Modifican escogi las propiedades de objeto";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Props";
	menu_name = "Les Proprits";
	tooltip = "Modifier a choisi les proprits de l'objet";
#endif
	accel_key = GDK_Return;
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_FIND;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_search_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Find";
	menu_name = "Find...";
	tooltip = "Find object(s) by specific attributes";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Hallazgo";
	menu_name = "El Hallazgo";
	tooltip = "El Hallazgo se opone (s) por atributos especificados";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Dcouverte";
	menu_name = "La Dcouverte";
	tooltip = "L'objet de Dcouverte (s) par les attributs spcifis ";
#endif
	accel_key = 'f';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_HISTORY;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_trace_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "History";
	menu_name = "History...";
	tooltip = "History of commands processed by this application";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Historia";
	menu_name = "La Historia...";
	tooltip = "La Historia de rdenes procesadas por esta aplicacin";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "L'Histoire";
	menu_name = "L'Histoire...";
	tooltip = "L'Histoire d'ordres traits par cette application";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_COPY_PATH;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_copy_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "CopyPath";
	menu_name = "Copy Path";
	tooltip = "Copy the location of the selected object(s) as path(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "CopiSende";
	menu_name = "Copie Sendero";
	tooltip = "Copia la ubicacin del objeto(s) escogido como sendero(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "CopiSenti";
	menu_name = "Copier Le Sentier";
	tooltip = "Copier l'emplacement de l'objet choisi(s) comme le sentier(s)";
#endif
	accel_key = 'c';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_COPY_URL;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_copy_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "CopyURL";
	menu_name = "Copy URL";
	tooltip = "Copy the location of the selected object(s) as url(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "CopiURL";
	menu_name = "Copie URL";
	tooltip = "Copie la ubicacin del objeto(s) escogido como url(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "CopiURL";
	menu_name = "Copier URL";
	tooltip = "Copier l'emplacement de l'objet choisi(s) comme url(s)";
#endif
	accel_key = 'c';
	accel_mods = GDK_CONTROL_MASK | GDK_SHIFT_MASK;
	DO_APPEND_OPID


	op = EDV_IMBR_OP_REFRESH;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_reload_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Refresh";
	menu_name = "Refresh";
	tooltip = "Refresh the thumbs list";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Refresque";
	menu_name = "Refresque";
	tooltip = "Refresque gua escogida es listar";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Rafrachir";
	menu_name = "Rafrachir";
	tooltip = "Rafrachit a choisi l'numrer de l'annuaire";
#endif
	accel_key = GDK_F5;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_REFRESH_ALL;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_reload_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Refresh All";
	menu_name = "Refresh All";
	tooltip = "Refresh all listings";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Refresque Todo";
	menu_name = "Refresque Todo";
	tooltip = "Refresca todas listas";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Rafrachir Tout";
	menu_name = "Rafrachir Tout";
	tooltip = "Rafrachir toutes listes";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_STOP;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_stop_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Stop";
	menu_name = "Stop Loading";
	tooltip = "Stop the loading process";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Parada";
	menu_name = "La Parada Cargando";
	tooltip = "Para el proceso que carga";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "L'arrt";
	menu_name = "L'Arrt Pour Charger";
	tooltip = "Arrte le procd qui chargeant";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_CONTINUE;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_run_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Continue";
	menu_name = "Continue Loading";
	tooltip = "Continue the loading process";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Contine";
	menu_name = "Siga Carga";
	tooltip = "Contine el proceso que carga";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Continuer";
	menu_name = "Continue le Chargement";
	tooltip = "Continuer le procd qui chargeant";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_IMBR_OP_DOWNLOAD;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_planet_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Download";
	menu_name = "Download";
	tooltip = "Download an object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Download";
	menu_name = "Download";
	tooltip = "Download del objeto";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Download";
	menu_name = "Download";
	tooltip = "Download de l'objet";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_IMBR_OP_SHOW_TOOL_BAR;
	tb_item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_tool_bar_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "ToolBar";
	menu_name = "Tool Bar";
	tooltip = "Show/hide tool bar";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "ToolBar";
	menu_name = "Tool Bar";
	tooltip = "La Exposicin/la barra de herramienta de cuero";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "ToolBar";
	menu_name = "Tool Bar";
	tooltip = "La barre d'outil de montre/peau";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_SHOW_LOCATION_BAR;
	tb_item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_tool_bar_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "LocBar";
	menu_name = "Location Bar";
	tooltip = "Show/hide location bar";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "LocBar";
	menu_name = "Location Bar";
	tooltip = "La exposicin/la barra de la ubicacin del cuero";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "LocBar";
	menu_name = "Location Bar";
	tooltip = "La barre d'emplacement de montre/peau";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_SHOW_MOUNT_BAR;
	tb_item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_tool_bar_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "MountBar";
	menu_name = "Mount Bar";
	tooltip = "Show/hide mount bar";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "MountBar";
	menu_name = "Mount Bar";
	tooltip = "La Exposicin/la barra del monte del cuero";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "MountBar";
	menu_name = "Mount Bar";
	tooltip = "La barre de mont de Show/Peau";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_SHOW_FIND_BAR;
	tb_item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_tool_bar_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "FindBar";
	menu_name = "Find Bar";
	tooltip = "Show/hide find bar";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "FindBar";
	menu_name = "Find Bar";
	tooltip = "La exposicin/la barra del hallazgo del cuero";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "FindBar";
	menu_name = "Find Bar";
	tooltip = "La barre de dcouverte de montre/peau";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_SHOW_STATUS_BAR;
	tb_item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_status_bar_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "StatusBar";
	menu_name = "Status Bar";
	tooltip = "Show/hide status bar";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "StatusBar";
	menu_name = "Status Bar";
	tooltip = "La exposicin/la barra de la posicin del cuero";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "StatusBar";
	menu_name = "Status Bar";
	tooltip = "La barre de statut de montre/peau";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_MIME_TYPES;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_mimetypes_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "MIMETypes";
	menu_name = "MIME Types...";
	tooltip = "View/modify MIME Types";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "MIMETypes";
	menu_name = "MIME Types...";
	tooltip = "El panorama/modifica MIME Types";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "MIMETypes";
	menu_name = "MIME Types...";
	tooltip = "Vue/modifie MIME Types";
#endif
	accel_key = 'm';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_DEVICES;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_device_misc_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Devices";
	menu_name = "Devices...";
	tooltip = "View/modify file system device references";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Artefactos";
	menu_name = "Los Artefactos...";
	tooltip = "El Panorama/modifica las referencias de artefacto de sistema de archivo";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Appareils";
	menu_name = "Les Appareils...";
	tooltip = "Les rfrences de priphrique-systme de fichier de Vue/Modifie ";
#endif
	accel_key = 'd';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID


	op = EDV_IMBR_OP_NEW_BROWSER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)endeavour_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "FBrowser";
	menu_name = "New File Browser";
	tooltip = "Create a new file browser";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "FBrowser";
	menu_name = "El Examinador Nuevo Del Archivo";
	tooltip = "Crea a un examinador nuevo del archivo";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "FBrowser";
	menu_name = "Nouveau Browser de Fichier";
	tooltip = "Crer un nouveau browser de fichier";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_NEW_IMBR;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)image_browser_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "IBrowser";
	menu_name = "New Image Browser";
	tooltip = "Create a new image browser";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "IBrowser";
	menu_name = "El Examinador Nuevo De La Imagen";
	tooltip = "Crea a un examinador nuevo de la imagen";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "IBrowser";
	menu_name = "Nouveau Browser D'Image";
	tooltip = "Crer un nouveau browser d'image";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_NEW_ARCHIVER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)archiver_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Archiver";
	menu_name = "New Archiver";
	tooltip = "Create a new archiver";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Archiver";
	menu_name = "Archiver Nuevo";
	tooltip = "Crea un archiver nuevo";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Archiver";
	menu_name = "Nouveau Archiver";
	tooltip = "Crer un nouveau archiver";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_RECYCLE_BIN;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_trash_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "RecBin";
	menu_name = "Recycle Bin";
	tooltip = "Open Recycle Bin";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "RecBin";
	menu_name = "El Cajn De La Recirculacin";
	tooltip = "Cajn de Recirculacin (basura puede)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "RecBin";
	menu_name = "Recycler L'Huche";
	tooltip = "Recycler l'huche (la poubelle)";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_IMBR_OP_OPTIONS;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_options2_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Options";
	menu_name = "Options...";
	tooltip = "Modify this application's options";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Las Opciones";
	menu_name = "Las Opciones...";
	tooltip = "Modifican estas opciones de la aplicacin";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Les Options";
	menu_name = "Les Options";
	tooltip = "Modifier ces options de l'application";
#endif
	accel_key = 'o';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_CUSTOMIZE;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_customize_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Custom";
	menu_name = "Customize...";
	tooltip = "Customize the look and feel of this application";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Personal";
	menu_name = "Personaliza...";
	tooltip = "Personaliza la mirada y se siente de esta aplicacin";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Personnal";
	menu_name = "Personnalise...";
	tooltip = "Personnalise le regard et sens de cette application";
#endif
	accel_key = 't';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID


	op = EDV_IMBR_OP_DEVICE_CHECK;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_fsck_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "FSCK";
	menu_name = "File System Check...";
	tooltip = "Check the device's file system";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "FSCK";
	menu_name = "Archive Cheque De Sistema...";
	tooltip = "Verifique el sistema del archivo de artefacto";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "FSCK";
	menu_name = "Classer Le Chque De Systme...";
	tooltip = "Vrifier le systme de fichier de l'appareil";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_DEVICE_TOOLS;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_tools_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "DevTool";
	menu_name = "Device Tools...";
	tooltip = "Run the device's tools program";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "DevTool";
	menu_name = "Artefacto Equipar Herramienta...";
	tooltip = "Corra el programa de herramientas de artefacto";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "DevTool";
	menu_name = "Outils D'Appareil...";
	tooltip = "Courir le programme d'outils de l'appareil";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_DEVICE_FORMAT;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_floppy_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Format";
	menu_name = "Format Media...";
	tooltip = "Format the media in the device";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Format";
	menu_name = "Formatear Medios...";
	tooltip = "Formatear los medios en el artefacto";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Format";
	menu_name = "Met Format Presse...";
	tooltip = "Met en format le presse dans l'appareil";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_IMBR_OP_HELP_CONTENTS;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Help";
	menu_name = "Contents";
	tooltip = "Index of all help pages";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "La Ayuda";
	menu_name = "El Contenido";
	tooltip = "El Indice de toda ayuda pagina";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "L'Aide";
	menu_name = "Les Contenus";
	tooltip = "L'Index de toutes pages d'aide";
#endif
	accel_key = GDK_F1;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_HELP_FILE_BROWSER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
	button_name = "Help";
	menu_name = "File Browser";
	tooltip = "Help on using the file browser";
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_HELP_IMAGE_BROWSER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
	button_name = "Help";
	menu_name = "Image Browser";
	tooltip = "Help on using the image browser";
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_HELP_ARCHIVER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
	button_name = "Help";
	menu_name = "Archiver";
	tooltip = "Help on using the archiver";
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_HELP_RECYCLE_BIN;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
	button_name = "Help";
	menu_name = "Recycle Bin";
	tooltip = "Help on using the recycle bin";
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_HELP_KEYS_LIST;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "HelpKeys";
	menu_name = "Keys List";
	tooltip = "List of all keyboard key operations";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "HelpKeys";
	menu_name = "La Lista De Llaves";
	tooltip = "La Lista de todo teclado las operaciones claves";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "HelpKeys";
	menu_name = "La Liste De Clefs";
	tooltip = "La Liste de tout clavier toutes oprations principales";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_HELP_MIME_TYPES;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "HelpMIME";
	menu_name = "Mime Types";
	tooltip = "Help on setting up MIME Types";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "HelpMIME";
	menu_name = "Mime Types";
	tooltip = "Ayude a establecer MIME Types";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "HelpMIME";
	menu_name = "Mime Types";
	tooltip = "Aider sur montant MIME Types";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_HELP_DEVICES;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "HelpDev";
	menu_name = "Devices";
	tooltip = "Help on setting up devices";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "HelpDev";
	menu_name = "Los Artefactos";
	tooltip = "La Ayuda a establecer artefactos";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "HelpDev";
	menu_name = "Les Appareils";
	tooltip = "L'Aide sur montant des appareils";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_HELP_COMMON_OPERATIONS;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "HelpOp";
	menu_name = "Common Operations";
	tooltip = "Help on the most common operations";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "HelpOp";
	menu_name = "Las Operaciones Comunes";
	tooltip = "La Ayuda en las operaciones ms comunes";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "HelpOp";
	menu_name = "Les Oprations Communes";
	tooltip = "L'Aide sur montant des appareils";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_IMBR_OP_HELP_ABOUT;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_about_20x20_xpm;
	menu_icon_data = (guint8 **)icon_about_20x20_xpm;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "About";
	menu_name = "About";
	tooltip = "About this application";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Acerca";
	menu_name = "Acerca De";
	tooltip = "Acerca de esta aplicacin";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "De";
	menu_name = "De";
	tooltip = "De cette application";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


#undef DO_APPEND_OPID

	return(list);
}

/*
 *	Deletes the Image Browser Opeartoin IDs list.
 */
void EDVImbrOPIDListDelete(
	edv_imbr_opid_struct **list, gint total
)
{
	gint i;
	edv_imbr_opid_struct *opid;

	if(list == NULL)
	    return;

	for(i = 0; i < total; i++)
	{
	    opid = list[i];
	    if(opid == NULL)
		continue;

	    g_free(opid->button_name);
	    g_free(opid->menu_name);
	    g_free(opid->tooltip);

	    g_free(opid);
	}
	g_free(list);
}


/*
 *	Recreates the Image Browser's new objects submenu.
 */
void EDVImbrNewObjectMenuRegenerate(edv_imbr_struct *imbr)
{
	edv_imbr_op op;
	guint8 **icon_data = NULL;
	GtkAccelGroup *accelgrp;
	GtkWidget *w, *menu, **w_record, **fw_record;

	if(imbr == NULL)
	    return;

	accelgrp = imbr->accelgrp;

#define DO_ADD_MENU_ITEM_LABEL	{		\
 edv_imbr_opid_struct *opid =			\
  EDVImbrMatchOPID(imbr, op);			\
 if(opid != NULL) {				\
  w = GUIMenuItemCreate(			\
   menu, GUI_MENU_ITEM_TYPE_LABEL, accelgrp,	\
   (guint8 **)((icon_data != NULL) ?		\
    icon_data : opid->menu_icon_data),		\
   opid->menu_name,				\
   opid->accel_key, opid->accel_mods,		\
   (gpointer *)fw_record,			\
   (gpointer)opid, EDVImbrMenuItemCB		\
  );						\
  GUISetMenuItemCrossingCB(			\
   w,						\
   (gpointer)EDVImbrMenuItemEnterCB, opid,	\
   (gpointer)EDVImbrMenuItemLeaveCB, opid	\
  );						\
  if(w_record != NULL)				\
   *w_record = w;				\
 }						\
}

#define DO_ADD_MENU_SEP {                       \
 w = GUIMenuItemCreate(                         \
  menu, GUI_MENU_ITEM_TYPE_SEPARATOR, NULL,     \
  NULL, NULL, 0, 0, NULL,                       \
  NULL, NULL                                    \
 );                                             \
}

	/* Destroy existing new object submenu */
	GTK_WIDGET_DESTROY(imbr->new_object_submenu);
	imbr->new_object_submenu = NULL;

	/* Create new object submenu */
	menu = GUIMenuCreate();
	if(menu != NULL)
	{
	    op = EDV_IMBR_OP_NEW_FILE;
	    w_record = &imbr->new_file_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_NEW_DIRECTORY;
	    w_record = &imbr->new_directory_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_NEW_LINK;
	    w_record = &imbr->new_link_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_NEW_FIFO;
	    w_record = &imbr->new_fifo_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_NEW_DEVICE_BLOCK;
	    w_record = &imbr->new_device_block_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_NEW_DEVICE_CHARACTER;
	    w_record = &imbr->new_device_character_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_NEW_SOCKET;
	    w_record = &imbr->new_socket_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL
	}
	imbr->new_object_submenu = menu;

	/* Attach submenu to new object menu item */
	w = imbr->new_object_submi;
	GUIMenuItemSetSubMenu(w, menu);

#undef DO_ADD_MENU_SEP
#undef DO_ADD_MENU_ITEM_LABEL
}


/*
 *	Creates the Image Browser's menu bar.
 *
 *	This function should be called by EDVImbrNew().
 */
static void EDVImbrCreateMenuBar(
	edv_imbr_struct *imbr, GtkWidget *parent
)
{
	edv_imbr_op op;
	guint8 **icon_data = NULL;
	GtkAccelGroup *accelgrp = imbr->accelgrp;
	GtkWidget *menu_bar, *menu, *w, **w_record, **fw_record;


	/* Get keyboard accelerator group */
	accelgrp = imbr->accelgrp;

	/* Create menu bar */
	menu_bar = GUIMenuBarCreate(NULL);
	imbr->menu_bar = menu_bar;
	gtk_container_add(GTK_CONTAINER(parent), menu_bar);
	gtk_widget_show(menu_bar);

#define DO_ADD_MENU_ITEM_LABEL	{		\
 edv_imbr_opid_struct *opid =			\
  EDVImbrMatchOPID(imbr, op);			\
 if(opid != NULL) {				\
  w = GUIMenuItemCreate(			\
   menu, GUI_MENU_ITEM_TYPE_LABEL, accelgrp,	\
   (guint8 **)((icon_data != NULL) ?		\
    icon_data : opid->menu_icon_data),		\
   opid->menu_name,				\
   opid->accel_key, opid->accel_mods,		\
   (gpointer *)fw_record,			\
   (gpointer)opid, EDVImbrMenuItemCB		\
  );						\
  GUISetMenuItemCrossingCB(			\
   w,						\
   (gpointer)EDVImbrMenuItemEnterCB, opid,	\
   (gpointer)EDVImbrMenuItemLeaveCB, opid	\
  );						\
  if(w_record != NULL)				\
   *w_record = w;				\
 }						\
}

#define DO_ADD_MENU_ITEM_CHECK	{		\
 edv_imbr_opid_struct *opid =			\
  EDVImbrMatchOPID(imbr, op);			\
 if(opid != NULL) {				\
  w = GUIMenuItemCreate(			\
   menu, GUI_MENU_ITEM_TYPE_CHECK, accelgrp,	\
   (guint8 **)((icon_data != NULL) ?		\
    icon_data : opid->menu_icon_data),		\
   opid->menu_name,				\
   opid->accel_key, opid->accel_mods,		\
   (void **)fw_record,				\
   (gpointer)opid, EDVImbrMenuItemCB		\
  );						\
  GUISetMenuItemCrossingCB(			\
   w,						\
   (gpointer)EDVImbrMenuItemEnterCB, opid,	\
   (gpointer)EDVImbrMenuItemLeaveCB, opid	\
  );						\
  if(w_record != NULL)				\
   *w_record = w;				\
 }						\
}

#define DO_ADD_MENU_SEP	{			\
 w = GUIMenuItemCreate(				\
  menu, GUI_MENU_ITEM_TYPE_SEPARATOR, NULL,	\
  NULL, NULL, 0, 0, NULL,			\
  NULL, NULL					\
 );						\
}

	/* Create file menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_IMBR_OP_OPEN;
	    w_record = &imbr->open_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_OPEN_WITH;
	    w_record = &imbr->openwith_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_IMBR_OP_NEW;
	    w_record = &imbr->new_object_submi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_IMBR_OP_SYNC_DISKS;
	    w_record = &imbr->sync_disks_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_IMBR_OP_HISTORY;
	    w_record = &imbr->history_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_IMBR_OP_RUN;
	    w_record = &imbr->run_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_IMBR_OP_CLOSE;
	    w_record = &imbr->close_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Archivo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Fichier"
#elif defined(PROG_LANGUAGE_GERMAN)
"Akte"
#elif defined(PROG_LANGUAGE_ITALIAN)
"File"
#elif defined(PROG_LANGUAGE_DUTCH)
"Dossier"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Arquivo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arkiv"
#else
"File"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);


	/* Create edit menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_IMBR_OP_MOVE;
	    w_record = &imbr->move_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_COPY;
	    w_record = &imbr->copy_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_LINK;
	    w_record = &imbr->link_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_RENAME;
	    w_record = &imbr->rename_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_CHMOD;
	    w_record = &imbr->chmod_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_CHOWN;
	    w_record = &imbr->chown_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_DELETE;
	    w_record = &imbr->delete_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_IMBR_OP_SELECT_ALL;
	    w_record = &imbr->select_all_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_UNSELECT_ALL;
	    w_record = &imbr->unselect_all_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_INVERT_SELECTION;
	    w_record = &imbr->invert_selection_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_FIND;
	    w_record = &imbr->find_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_IMBR_OP_PROPERTIES;
	    w_record = &imbr->properties_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Redacte"
#elif defined(PROG_LANGUAGE_FRENCH)
"Editer"
#elif defined(PROG_LANGUAGE_GERMAN)
"Redigieren"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Redigere"
#elif defined(PROG_LANGUAGE_DUTCH)
"Bewerking"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Edite"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Rediger"
#else
"Edit"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);


	/* Create view menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_IMBR_OP_STOP;
	    w_record = &imbr->stop_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_CONTINUE;
	    w_record = &imbr->continue_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_IMBR_OP_REFRESH;
	    w_record = &imbr->refresh_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_REFRESH_ALL;
	    w_record = &imbr->refresh_all_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_IMBR_OP_SHOW_TOOL_BAR;
	    w_record = &imbr->show_tool_bar_micheck;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_CHECK

	    op = EDV_IMBR_OP_SHOW_LOCATION_BAR;
	    w_record = &imbr->show_location_bar_micheck;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_CHECK

	    op = EDV_IMBR_OP_SHOW_MOUNT_BAR;
	    w_record = &imbr->show_mount_bar_micheck;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_CHECK

	    op = EDV_IMBR_OP_SHOW_FIND_BAR;
	    w_record = &imbr->show_find_bar_micheck;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_CHECK

	    op = EDV_IMBR_OP_SHOW_STATUS_BAR;
	    w_record = &imbr->show_status_bar_micheck;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_CHECK

	    DO_ADD_MENU_SEP

	    op = EDV_IMBR_OP_MIME_TYPES;
	    w_record = &imbr->mime_types_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Vista"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vue"
#elif defined(PROG_LANGUAGE_GERMAN)
"Blick"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Veduta"
#elif defined(PROG_LANGUAGE_DUTCH)
"Overzicht"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Vista"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sikt"
#else
"View"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);


	/* Create device menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_IMBR_OP_MOUNT;
	    w_record = &imbr->mount_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_EJECT;
	    w_record = &imbr->eject_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_IMBR_OP_DEVICE_CHECK;
	    w_record = &imbr->device_check_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_DEVICE_TOOLS;
	    w_record = &imbr->device_tools_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_DEVICE_FORMAT;
	    w_record = &imbr->device_format_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_IMBR_OP_DEVICES;
	    w_record = &imbr->devices_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Dispositivo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Appareil"
#elif defined(PROG_LANGUAGE_GERMAN)
"Vorrichtung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Congegno"
#elif defined(PROG_LANGUAGE_DUTCH)
"Apparaat"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Artifcio"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Innretning"
#else
"Device"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);


	/* Create settings menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_IMBR_OP_WRITE_PROTECT;
	    w_record = &imbr->write_protect_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_IMBR_OP_OPTIONS;
	    w_record = &imbr->options_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_CUSTOMIZE;
	    w_record = &imbr->customize_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Escenarios"
#elif defined(PROG_LANGUAGE_FRENCH)
"Montages"
#elif defined(PROG_LANGUAGE_GERMAN)
"Setzen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Montaggi"
#elif defined(PROG_LANGUAGE_DUTCH)
"Zetten"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Por"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Innstillinger"
#else
"Settings"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);


	/* Create windows menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_IMBR_OP_NEW_BROWSER;
	    w_record = &imbr->window_new_browser_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_NEW_IMBR;
	    w_record = &imbr->window_new_imbr_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_NEW_ARCHIVER;
	    w_record = &imbr->window_new_archiver_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_IMBR_OP_RECYCLE_BIN;
	    w_record = &imbr->window_recycle_bin_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Ventanas"
#elif defined(PROG_LANGUAGE_FRENCH)
"Windows"
#elif defined(PROG_LANGUAGE_GERMAN)
"Fenster"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Finestre"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ramen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Janelas"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Vinduer"
#else
"Windows"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);


	/* Create help menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_IMBR_OP_HELP_CONTENTS;
	    w_record = &imbr->help_contents_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_IMBR_OP_HELP_IMAGE_BROWSER;
	    w_record = &imbr->help_image_browser_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_HELP_KEYS_LIST;
	    w_record = &imbr->help_keys_list_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_HELP_MIME_TYPES;
	    w_record = &imbr->help_mime_types_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_HELP_DEVICES;
	    w_record = &imbr->help_devices_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_IMBR_OP_HELP_COMMON_OPERATIONS;
	    w_record = &imbr->help_common_operations_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_IMBR_OP_HELP_ABOUT;
	    w_record = &imbr->help_about_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Ayuda"
#elif defined(PROG_LANGUAGE_FRENCH)
"Aide"
#elif defined(PROG_LANGUAGE_GERMAN)
"Hilfe"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Aiuto"
#elif defined(PROG_LANGUAGE_DUTCH)
"Hulp"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Ajuda"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Hjelp"
#else
"Help"
#endif
	    , GUI_MENU_BAR_ALIGN_RIGHT
	);


	/* Create new objects submenu */
	EDVImbrNewObjectMenuRegenerate(imbr);


#undef DO_ADD_MENU_ITEM_LABEL
#undef DO_ADD_MENU_ITEM_CHECK
#undef DO_ADD_MENU_SEP
}

/*
 *	Creates a new Image Browser.
 */
edv_imbr_struct *EDVImbrNew(gpointer core_ptr)
{
	const gchar *location_history_file = NULL;
	gint	toplevel_x = 0,
		toplevel_y = 0,
		toplevel_width = EDV_DEF_IMBR_WIDTH,
		toplevel_height = EDV_DEF_IMBR_HEIGHT,
		paned_position = EDV_DEF_IMBR_PANED_POSITION;
	gboolean	tool_bar_map_state = TRUE,
			location_bar_map_state = TRUE,
			mount_bar_map_state = TRUE,
			find_bar_map_state = TRUE,
			status_bar_map_state = TRUE;
	edv_status_bar_struct *status_bar;
	const gchar	*wm_name = NULL,
			*wm_class = NULL;
	const cfg_item_struct *cfg_list = (core_ptr != NULL) ?
	    EDV_CORE(core_ptr)->cfg_list : NULL;
	GdkColormap *colormap = NULL;
	GdkCursor *cursor;
	GList *glist;
	GtkRcStyle	*standard_rcstyle = NULL,
			*lists_rcstyle = NULL;
	GtkStyle *style;
	GtkWidget *w, *parent, *parent2, *parent3, *parent4;
	gpointer combo_rtn;
	GtkCombo *combo;
	GdkWindow *window;
	GtkAccelGroup *accelgrp;
	tlist_struct *tlist;
	imgview_struct *iv;
	const GtkTargetEntry dnd_tar_types[] = {
{"text/plain",				0,	EDV_DND_TYPE_INFO_TEXT_PLAIN},
{"text/uri-list",			0,	EDV_DND_TYPE_INFO_TEXT_URI_LIST},
{"STRING",				0,	EDV_DND_TYPE_INFO_STRING},
{EDV_DND_TYPE_STRING_RECYCLED_OBJECT,	0,	EDV_DND_TYPE_INFO_RECYCLED_OBJECT},
{EDV_DND_TYPE_STRING_ARCHIVE_OBJECT,	0,	EDV_DND_TYPE_INFO_ARCHIVE_OBJECT}
	};
	const GtkTargetEntry dnd_src_types[] = {
{"text/plain",				0,	EDV_DND_TYPE_INFO_TEXT_PLAIN},
{"text/uri-list",			0,	EDV_DND_TYPE_INFO_TEXT_URI_LIST},
{"STRING",				0,	EDV_DND_TYPE_INFO_STRING}
	};
	edv_imbr_struct *imbr = EDV_IMBR(g_malloc0(
	    sizeof(edv_imbr_struct)
	));
	if(imbr == NULL)
	    return(imbr);


	/* Get configuration */
	if(cfg_list != NULL)
	{
	    edv_core_struct *c_ptr = EDV_CORE(core_ptr);

	    standard_rcstyle = c_ptr->standard_rcstyle;
	    lists_rcstyle = c_ptr->lists_rcstyle;

	    wm_name = c_ptr->wm_name;
	    wm_class = c_ptr->wm_class;

	    location_history_file = EDV_GET_S(EDV_CFG_PARM_FILE_IMBR_LOCATION_HISTORY);

	    if(c_ptr->geometry_set)
	    {
		GdkRectangle *rect = &c_ptr->geometry;
		toplevel_x = rect->x;
		toplevel_y = rect->y;
		toplevel_width = rect->width;
		toplevel_height = rect->height;
	    }
	    else
	    {
		toplevel_x = EDV_GET_I(EDV_CFG_PARM_IMBR_X);
		toplevel_y = EDV_GET_I(EDV_CFG_PARM_IMBR_Y);
		toplevel_width = EDV_GET_I(EDV_CFG_PARM_IMBR_WIDTH);
		toplevel_height = EDV_GET_I(EDV_CFG_PARM_IMBR_HEIGHT);
	    }
	    paned_position = EDV_GET_I(EDV_CFG_PARM_IMBR_PANED_POSITION);

	    tool_bar_map_state = EDV_GET_B(EDV_CFG_PARM_IMBR_SHOW_TOOL_BAR);
	    location_bar_map_state = EDV_GET_B(EDV_CFG_PARM_IMBR_SHOW_LOCATION_BAR);
	    mount_bar_map_state = EDV_GET_B(EDV_CFG_PARM_IMBR_SHOW_MOUNT_BAR);
	    find_bar_map_state = EDV_GET_B(EDV_CFG_PARM_IMBR_SHOW_FIND_BAR);
	    status_bar_map_state = EDV_GET_B(EDV_CFG_PARM_IMBR_SHOW_STATUS_BAR);
	}

	imbr->accelgrp = accelgrp = gtk_accel_group_new();
	imbr->processing = FALSE;
	imbr->busy_count = 0;
	imbr->freeze_count = 0;
	imbr->core_ptr = core_ptr;

	imbr->opid = EDVImbrOPIDListNew(
	    imbr, &imbr->total_opids
	);

	imbr->stop_count = 0;
	imbr->loading_tocb = 0;
	imbr->tool_bar_map_state = tool_bar_map_state;
	imbr->location_bar_map_state = location_bar_map_state;
	imbr->mount_bar_map_state = mount_bar_map_state;
	imbr->find_bar_map_state = find_bar_map_state;
	imbr->status_bar_map_state = status_bar_map_state;
	imbr->tlist_selected_thumb = -1;
	imbr->selected_dev_num = -1;
	imbr->last_recbin_items = -1;
	imbr->last_write_protect_state = -1;
	imbr->status_bar = NULL;
	imbr->fopdlg = NULL;


	/* Begin creating widgets */

	/* Toplevel */
	gtk_widget_push_visual(gdk_rgb_get_visual());
	gtk_widget_push_colormap(gdk_rgb_get_cmap());
	imbr->toplevel = w = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_pop_visual();
	gtk_widget_pop_colormap();
	gtk_widget_set_uposition(
	    w, toplevel_x, toplevel_y
	);
	gtk_widget_set_usize(
	    w, toplevel_width, toplevel_height
	);
	if(!STRISEMPTY(wm_name) && !STRISEMPTY(wm_class))
	    gtk_window_set_wmclass(GTK_WINDOW(w), wm_name, wm_class);
	else
	    gtk_window_set_wmclass(
		GTK_WINDOW(w), "image_browser", PROG_NAME
	    );
	gtk_window_set_policy(
	    GTK_WINDOW(w),
	    TRUE, TRUE, TRUE
	);
	gtk_widget_realize(w);
	style = gtk_widget_get_style(w);
	window = w->window;
	if(window != NULL)
	{
	    GdkGeometry geometry;

	    geometry.min_width = 100;
	    geometry.min_height = 70;

	    geometry.base_width = 0;
	    geometry.base_height = 0;

	    geometry.width_inc = 1;
	    geometry.height_inc = 1;
#if 0
	    geometry.min_aspect = 1.3f;
	    geometry.max_aspect = 1.3f;
#endif
	    gdk_window_set_geometry_hints(
		window, &geometry,
		GDK_HINT_MIN_SIZE |
		GDK_HINT_BASE_SIZE |
		/* GDK_HINT_ASPECT | */
		GDK_HINT_RESIZE_INC
	    );

	    colormap = gdk_window_get_colormap(window);

	    GUISetWMIcon(window, (guint8 **)image_browser_48x48_xpm);
	}
	gtk_signal_connect(
	    GTK_OBJECT(w), "delete_event",
	    GTK_SIGNAL_FUNC(EDVImbrDeleteEventCB), imbr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "destroy",
	    GTK_SIGNAL_FUNC(EDVImbrDestroyCB), imbr
	);
	gtk_container_set_border_width(GTK_CONTAINER(w), 0);
	gtk_window_add_accel_group(GTK_WINDOW(w), accelgrp);
	parent = w;


	/* Main vbox */
	imbr->main_vbox = w = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(parent), w);
	gtk_widget_show(w);
	parent = w;


	/* Vbox for tool bars */
	imbr->bars_vbox = w = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent2 = w;


	/* Handle for menu bar */
	imbr->menu_bar_handle = w = gtk_handle_box_new();
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_attached",
	    GTK_SIGNAL_FUNC(EDVImbrHandleChildAttachedCB), imbr
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_detached",
	    GTK_SIGNAL_FUNC(EDVImbrHandleChildDetachedCB), imbr
	);
	gtk_widget_show(w);
	/* Create menu bar */
	EDVImbrCreateMenuBar(imbr, w);


	/* Handle for tool bar */
	imbr->tool_bar_handle = w = gtk_handle_box_new();
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_attached",
	    GTK_SIGNAL_FUNC(EDVImbrHandleChildAttachedCB), imbr
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_detached",
	    GTK_SIGNAL_FUNC(EDVImbrHandleChildDetachedCB), imbr
	);
	if(imbr->tool_bar_map_state)
	    gtk_widget_show(w);
	/* Build tool bar later */
	imbr->toolbar = NULL;


	/* Location bar handle box */
	imbr->location_bar_handle = w = gtk_handle_box_new();
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_attached",
	    GTK_SIGNAL_FUNC(EDVImbrHandleChildAttachedCB), imbr
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_detached",
	    GTK_SIGNAL_FUNC(EDVImbrHandleChildDetachedCB), imbr
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	if(imbr->location_bar_map_state)
	    gtk_widget_show(w);
	parent2 = w;

	/* Location bar hbox for location bar */
	imbr->location_bar_hbox = w = gtk_hbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_widget_show(w);
	parent2 = w;


	/* Hbox for location icon and combo */
	w = gtk_hbox_new(FALSE, 0);	/* Don't need spacing between icon
					 * and combo because combo has it
					 * already.
					 */
	gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Vbox to orient location icon fixed parent */
	w = gtk_vbox_new(TRUE, 0);
	gtk_widget_set_usize(w, 20, 20);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Location icon fixed parent */
	imbr->location_icon_fixed = w = gtk_fixed_new();
	gtk_widget_add_events(
	    w,
	    GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK |
	    GDK_POINTER_MOTION_MASK |
	    GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, TRUE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "enter_notify_event",
	    GTK_SIGNAL_FUNC(EDVImbrLocBarIconCrossingCB), imbr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "leave_notify_event",
	    GTK_SIGNAL_FUNC(EDVImbrLocBarIconCrossingCB), imbr
	);
	gtk_widget_realize(w);
	cursor = EDVGetCursor(
	    (edv_core_struct *)core_ptr, EDV_CURSOR_CODE_HAND
	);
	gdk_window_set_cursor(w->window, cursor);
	GUISetWidgetTip(
	    w,
#ifdef PROG_LANGUAGE_ENGLISH
"Drag this to create a link to this location"
#endif
#ifdef PROG_LANGUAGE_SPANISH
"Arrastre esto crear un eslabn a esta ubicacin"
#endif
#ifdef PROG_LANGUAGE_FRENCH
"Traner ceci pour crer un lien  cet emplacement"
#endif
	);
	gtk_widget_show(w);

	/* Reset location icon pixmap */
	imbr->location_icon_pm = NULL;

	/* Location combo */
	glist = EDVOpenFileGList(location_history_file, 0);
	w = GUIComboCreate(
#ifdef PROG_LANGUAGE_ENGLISH
	    "Location:",
#endif
#ifdef PROG_LANGUAGE_SPANISH
	    "La Ubicacin:",
#endif
#ifdef PROG_LANGUAGE_FRENCH
	    "Emplacement:",
#endif
	    "/",
	    glist,
	    20,		/* Maximum items */
	    &combo_rtn,
	    imbr,
	    EDVImbrComboActivateCB,
	    NULL
	);
	if(glist != NULL)
	{
	    g_list_foreach(glist, (GFunc)g_free, NULL);
	    g_list_free(glist);
	    glist = NULL;
	}
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);

	imbr->location_combo = w = (GtkWidget *)combo_rtn;
	combo = GTK_COMBO(w);
	gtk_combo_set_case_sensitive(combo, TRUE);
	GUIDNDSetSrc(
	    imbr->location_icon_fixed,
	    dnd_src_types,
	    sizeof(dnd_src_types) / sizeof(GtkTargetEntry),
	    GDK_ACTION_COPY | GDK_ACTION_MOVE |
	    GDK_ACTION_LINK,                    /* Actions */
	    GDK_BUTTON1_MASK | GDK_BUTTON2_MASK,/* Buttons */
	    NULL,
	    EDVLocBarIconDragDataGet,
	    NULL,
	    NULL,
	    combo
	);
	EDVEntrySetDND((edv_core_struct *)core_ptr, combo->entry);
	EDVEntrySetCompletePath((edv_core_struct *)core_ptr, combo->entry);


	/* Mount bar handle box */
	imbr->mount_bar_handle = w = gtk_handle_box_new();
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_attached",
	    GTK_SIGNAL_FUNC(EDVImbrHandleChildAttachedCB), imbr
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_detached",
	    GTK_SIGNAL_FUNC(EDVImbrHandleChildDetachedCB), imbr
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	if(imbr->mount_bar_map_state)
	    gtk_widget_show(w);
	parent2 = w;

	/* Create mount bar */
	imbr->mountbar = EDVMountBarNew(
	    core_ptr, parent2,
	    EDVImbrMountBarMountCB,
	    EDVImbrMountBarEjectCB,
	    EDVImbrMountBarGoToCB,
	    EDVImbrBarStatusMessageCB,
	    imbr
	);
	EDVMountBarMap(imbr->mountbar);


	/* Find bar handle box */
	imbr->find_bar_handle = w = gtk_handle_box_new();
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_attached",
	    GTK_SIGNAL_FUNC(EDVImbrHandleChildAttachedCB), imbr
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_detached",
	    GTK_SIGNAL_FUNC(EDVImbrHandleChildDetachedCB), imbr
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	if(imbr->find_bar_map_state)
	    gtk_widget_show(w);
	parent2 = w;

	/* Create find bar */
	imbr->findbar = EDVFindBarNew(
	    core_ptr, parent2,
	    EDV_FINDBAR_ROLE_DISK_OBJECT,
	    EDVImbrBarStatusMessageCB,
	    EDVImbrBarStatusProgressCB,
	    EDVImbrFindBarLocationCB,
	    EDVImbrFindBarStartCB,
	    EDVImbrFindBarEndCB,
	    EDVImbrFindBarMatchCB,
	    imbr
	);
	EDVFindBarMap(imbr->findbar);



	/* Main paned */
	imbr->main_paned = w = gtk_hpaned_new();
	gtk_paned_set_position(GTK_PANED(w), paned_position);
	gtk_paned_set_handle_size(
	    GTK_PANED(w), EDV_DEF_PANED_HANDLE_SIZE
	);
	gtk_paned_set_gutter_size(
	    GTK_PANED(w), EDV_DEF_PANED_GUTTER_SIZE
	);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent2 = w;


	/* Create thumbs list */
	imbr->tlist = tlist = TListNew(
	    EDV_GET_B(EDV_CFG_PARM_IMBR_THUMB_LIST_HORIZONTAL),
	    EDV_GET_I(EDV_CFG_PARM_IMBR_THUMB_WIDTH),
	    EDV_GET_I(EDV_CFG_PARM_IMBR_THUMB_HEIGHT),
	    EDV_GET_I(EDV_CFG_PARM_IMBR_THUMB_BORDER),
	    imbr,
	    EDVImbrTListSelectCB,
	    EDVImbrTListUnselectCB
	);
	w = tlist->toplevel;
	gtk_paned_add1(GTK_PANED(parent2), w);
	TListDoubleBuffer(tlist, EDV_GET_B(EDV_CFG_PARM_LISTS_DOUBLE_BUFFER));
	TListSelectionMode(tlist, GTK_SELECTION_EXTENDED);
	TListShowThumbFrames(tlist, EDV_GET_B(EDV_CFG_PARM_IMBR_THUMB_SHOW_FRAMES));
	TListShowThumbLabels(tlist, EDV_GET_B(EDV_CFG_PARM_IMBR_THUMB_SHOW_LABELS));
	TListShowTextTips(tlist, EDV_GET_B(EDV_CFG_PARM_SHOW_TEXTTIPS));

	w = tlist->list_da;
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_press_event",
	    GTK_SIGNAL_FUNC(EDVTListKeyEventCB), imbr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_release_event",
	    GTK_SIGNAL_FUNC(EDVTListKeyEventCB), imbr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_press_event",
	    GTK_SIGNAL_FUNC(EDVTListButtonEventCB), imbr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_release_event",
	    GTK_SIGNAL_FUNC(EDVTListButtonEventCB), imbr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "motion_notify_event",
	    GTK_SIGNAL_FUNC(EDVTListMotionEventCB), imbr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_press_event",
	    GTK_SIGNAL_FUNC(EDVImbrKeyEventCB), imbr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_release_event",
	    GTK_SIGNAL_FUNC(EDVImbrKeyEventCB), imbr
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "button_press_event",
	    GTK_SIGNAL_FUNC(EDVImbrButtonPressEventCB), imbr
	);

	/* Set up DND for the thumbs list */
	GUIDNDSetSrc(
	    w,
	    dnd_src_types,
	    sizeof(dnd_src_types) / sizeof(GtkTargetEntry),
	    GDK_ACTION_COPY | GDK_ACTION_MOVE |
		GDK_ACTION_LINK,                /* Actions */
	    GDK_BUTTON1_MASK | GDK_BUTTON2_MASK,/* Buttons */
	    NULL,
	    EDVImbrTListDragDataGetCB,
	    EDVImbrTListDragDataDeleteCB,
	    NULL,
	    imbr
	);
	GUIDNDSetTar(
	    w,
	    dnd_tar_types,
	    sizeof(dnd_tar_types) / sizeof(GtkTargetEntry),
	    GDK_ACTION_COPY | GDK_ACTION_MOVE |
		GDK_ACTION_LINK,                /* Actions */
	    GDK_ACTION_MOVE,                    /* Default action if same */
	    GDK_ACTION_MOVE,                    /* Default action */
	    EDVImbrTListDragDataReceivedCB,
	    imbr
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "drag_motion",
	    GTK_SIGNAL_FUNC(EDVImbrTListDragMotionCB), imbr
	);
	TListMap(tlist);


	/* Create image viewer as a child widget */
	imbr->imgview = iv = ImgViewNew(
	    TRUE,			/* Show tool bar */
	    TRUE,			/* Show values */
	    FALSE,			/* Show status bar */
	    FALSE,			/* Show image on wm icon */
	    EDV_GET_I(EDV_CFG_PARM_IMAGE_QUALITY),	/* Quality (0 to 2) */
	    FALSE,			/* Toplevel to be a GtkWindow? */
	    &w				/* Toplevel return */
	);
	gtk_paned_add2(GTK_PANED(parent2), w);
	if(iv != NULL)
	{
	    /* Background color */
	    const cfg_color_struct *color = EDV_GET_COLOR(
		EDV_CFG_PARM_IMBR_COLOR_BG
	    );
	    if(color != NULL)
	    {
		GdkColor gdk_color[5];
		gint i, m = sizeof(gdk_color) / sizeof(GdkColor);
		const cfg_color_struct *sc = color;

		for(i = 0; i < m; i++)
		{
		    GDK_COLOR_SET_COEFF(
			&gdk_color[i],
			sc->r, sc->g, sc->b
		    )
		}
		ImgViewSetViewBG(iv, gdk_color);
	    }

	    ImgViewMap(iv);
	}

	/* Set up view widget */
	w = (GtkWidget *)ImgViewGetViewWidget(iv);
	if(w != NULL)
	{
	    gtk_signal_connect_after(
		GTK_OBJECT(w), "button_press_event",
		GTK_SIGNAL_FUNC(EDVImbrButtonPressEventCB), imbr
	    );

	    GUIDNDSetTar(
		w,
		dnd_tar_types,
		sizeof(dnd_tar_types) / sizeof(GtkTargetEntry),
		GDK_ACTION_COPY | GDK_ACTION_MOVE |
		    GDK_ACTION_LINK,		/* Actions */
		GDK_ACTION_MOVE,		/* Default action if same */
		GDK_ACTION_MOVE,		/* Default action */
		EDVImbrImgViewDragDataReceivedCB,
		imbr
	    );
	}


	/* Create tool bar */
	EDVImbrToolbarRegenerate(imbr);

	/* Create tlist right-click menu */
	EDVImbrTListMenuRegenerate(imbr);


	/* Create status bar */
	imbr->status_bar = status_bar = EDVStatusBarNew(
	    core_ptr, imbr->main_vbox
	);
	if(status_bar != NULL)
	{
	    if(imbr->status_bar_map_state)
		EDVStatusBarMap(status_bar);
	    else
		EDVStatusBarUnmap(status_bar);
	}


	/* Set initial RC styles */
	if(standard_rcstyle != NULL)
	    gtk_widget_modify_style_recursive(
		imbr->toplevel, standard_rcstyle
	    );
	if(lists_rcstyle != NULL)
	    gtk_widget_modify_style_recursive(
		imbr->tlist->list_da, lists_rcstyle
	    );
	w = ImgViewGetToplevelWidget(imbr->imgview);
	if(lists_rcstyle != NULL)
	    gtk_widget_modify_style_recursive(
		w, lists_rcstyle
	    );
	w = (GtkWidget *)ImgViewGetMenuWidget(imbr->imgview);
	if(standard_rcstyle != NULL)
	    gtk_widget_modify_style_recursive(
		w, standard_rcstyle
	    );
	if(standard_rcstyle != NULL)
	    gtk_widget_modify_style_recursive(
		imbr->tlist_menu, standard_rcstyle
	    );

	/* Load special icons */
	EDVLoadPixmap(
	    EDV_CORE(core_ptr),
	    (guint8 **)icon_folder_home_32x32_xpm,
	    "icon_folder_home_32x32_xpm",   
	    &imbr->folder_home_pixmap,
	    &imbr->folder_home_mask
	);
	EDVLoadPixmap(
	    EDV_CORE(core_ptr),
	    (guint8 **)icon_folder_parent_32x32_xpm,
	    "icon_folder_parent_32x32_xpm",
	    &imbr->folder_parent_pixmap,
	    &imbr->folder_parent_mask
	);
	EDVLoadPixmap(
	    EDV_CORE(core_ptr),
	    (guint8 **)icon_folder_noaccess_32x32_xpm,
	    "icon_folder_noaccess_32x32_xpm",
	    &imbr->folder_noaccess_pixmap,
	    &imbr->folder_noaccess_mask
	);
	EDVLoadPixmap(
	    EDV_CORE(core_ptr),
	    (guint8 **)icon_file_badimage_32x32_xpm,
	    "icon_file_badimage_32x32_xpm",
	    &imbr->file_badimage_pixmap,
	    &imbr->file_badimage_mask
	);


	/* Reset all values */
	EDVImbrReset(imbr, FALSE);

	/* Update menus */
	EDVImbrUpdateMenus(imbr);

	return(imbr);
}

/*
 *	Resets all values on the Image Browser.
 */
void EDVImbrReset(edv_imbr_struct *imbr, gboolean need_unmap)
{
	if(imbr == NULL)
	    return;

	EDVImbrSetTitle(imbr, NULL);


	if(need_unmap)
	    EDVImbrUnmap(imbr);
}

/*
 *	Syncronizes the Image Browser's widget values with other values.
 */
void EDVImbrSyncData(edv_imbr_struct *imbr)
{
	if(imbr == NULL)
	    return;

/* This function may be removed in the future, since there really is
 * no floating data from widgets to be synced to disk on the image
 * browser
 */

}


/*
 *	Updates the Image Browser's widgets to reflect current 
 *	values.
 */
void EDVImbrUpdateMenus(edv_imbr_struct *imbr)
{
	gboolean	write_protect,
			write_protect_changed = FALSE,
			loading_in_progress;
	gboolean sensitive, state;
	gint selected_dev_num;
	edv_device_struct *selected_dev_ptr;
	guint8 **icon_data, **recbin_icon_data;
	GtkWidget *w;
	gint tlist_selected_thumb;
	const cfg_item_struct *cfg_list;
	toolbar_struct *tb;
	edv_core_struct *core_ptr;


	if(imbr == NULL)
	    return;

	core_ptr = EDV_CORE(imbr->core_ptr);
	if(core_ptr == NULL)
	    return;

	cfg_list = core_ptr->cfg_list;

	tb = imbr->toolbar;

#define DO_SHOW			\
{ if(w != NULL) gtk_widget_show(w); }
#define DO_HIDE			\
{ if(w != NULL) gtk_widget_hide(w); }
#define DO_SET_CHECK_STATE	\
{ \
 if((w != NULL) ? GTK_IS_CHECK_MENU_ITEM(w) : FALSE) \
  GTK_CHECK_MENU_ITEM(w)->active = state; \
}


	/* Get loading in progress state */
	loading_in_progress = (imbr->loading_tocb > 0) ? TRUE : FALSE;

	/* Get global write protect state */
	write_protect = EDV_GET_B(EDV_CFG_PARM_WRITE_PROTECT);
	if(imbr->last_write_protect_state < 0)
	{
	    write_protect_changed = TRUE;
	}
	else
	{
	    if((write_protect && !imbr->last_write_protect_state) ||
	       (!write_protect && imbr->last_write_protect_state)
	    )
		write_protect_changed = TRUE;
	}
	imbr->last_write_protect_state = write_protect ? 1 : 0;

	/* Get last selected thumb */
	tlist_selected_thumb = imbr->tlist_selected_thumb;

	/* Get last selected device (if any) */
	selected_dev_num = imbr->selected_dev_num;
	if((selected_dev_num >= 0) && (selected_dev_num < core_ptr->total_devices))
	    selected_dev_ptr = core_ptr->device[selected_dev_num];
	else
	    selected_dev_ptr = NULL;

	/* Update recycle bin icon data, setting it to not NULL if it
	 * needs to be changed and update the image browser's
	 * last_recbin_items to match the value on the core structure.
	 */
	icon_data = NULL;
	if(imbr->last_recbin_items < 0)
	{
	    if(core_ptr->last_recbin_items > 0)
		icon_data = (guint8 **)icon_trash_20x20_xpm;
	    else
		icon_data = (guint8 **)icon_trash_empty_20x20_xpm;
	}
	else
	{
	    if(!imbr->last_recbin_items &&
	       core_ptr->last_recbin_items
	    )
		icon_data = (guint8 **)icon_trash_20x20_xpm;
	    else if(imbr->last_recbin_items &&
		    !core_ptr->last_recbin_items
	    )
		icon_data = (guint8 **)icon_trash_empty_20x20_xpm;
	}
	imbr->last_recbin_items = core_ptr->last_recbin_items;
	recbin_icon_data = icon_data;



	/* Update mount bar */
	EDVMountBarUpdateMenus(imbr->mountbar);

	/* Update find bar */
	EDVFindBarUpdateMenus(imbr->findbar);



	/* Begin updating menu items and tool bar items */

	/* File */
	/* Open and open with */
	sensitive = (tlist_selected_thumb > -1) ? TRUE : FALSE;
	/* Open */
	GTK_WIDGET_SET_SENSITIVE(imbr->open_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_OPEN, sensitive
	);
	/* Open with */
	GTK_WIDGET_SET_SENSITIVE(imbr->openwith_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_OPEN_WITH, sensitive
	);

	/* New object sub menu item */
	sensitive = TRUE;
	GTK_WIDGET_SET_SENSITIVE(imbr->new_object_submi, sensitive)
	/* New file */
	GTK_WIDGET_SET_SENSITIVE(imbr->new_file_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_NEW_FILE, sensitive
	);
	/* New directory */
	GTK_WIDGET_SET_SENSITIVE(imbr->new_directory_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_NEW_DIRECTORY, sensitive
	);
	/* New link */
	GTK_WIDGET_SET_SENSITIVE(imbr->new_link_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_NEW_LINK, sensitive
	);
	/* New fifo */
	GTK_WIDGET_SET_SENSITIVE(imbr->new_fifo_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_NEW_FIFO, sensitive
	);
	/* New block device */
	GTK_WIDGET_SET_SENSITIVE(imbr->new_device_block_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_NEW_DEVICE_BLOCK, sensitive
	);
	/* New character device */
	GTK_WIDGET_SET_SENSITIVE(imbr->new_device_character_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_NEW_DEVICE_CHARACTER, sensitive
	);
	/* New socket */
	GTK_WIDGET_SET_SENSITIVE(imbr->new_socket_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_NEW_SOCKET, sensitive
	);

	/* Go to parent */
	sensitive = TRUE;
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_GOTO_PARENT, sensitive
	);

	/* Edit */
	sensitive = (tlist_selected_thumb > -1) ? TRUE : FALSE;
	/* Move */
	GTK_WIDGET_SET_SENSITIVE(imbr->move_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_MOVE, sensitive
	);
	/* Copy */
	GTK_WIDGET_SET_SENSITIVE(imbr->copy_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_COPY, sensitive
	);
	/* Link */
	GTK_WIDGET_SET_SENSITIVE(imbr->link_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_LINK, sensitive
	);
	/* Rename */
	GTK_WIDGET_SET_SENSITIVE(imbr->rename_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_RENAME, sensitive
	);
	/* Change mode */
	GTK_WIDGET_SET_SENSITIVE(imbr->chmod_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_CHMOD, sensitive
	);
	/* Chown */
	GTK_WIDGET_SET_SENSITIVE(imbr->chown_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_CHOWN, sensitive
	);
	/* Delete */
	GTK_WIDGET_SET_SENSITIVE(imbr->delete_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_DELETE, sensitive
	);
	/* Properties */
	GTK_WIDGET_SET_SENSITIVE(imbr->properties_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_PROPERTIES, sensitive
	);
	/* Copy path */
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_COPY_PATH, sensitive
	);
	/* Copy URL */
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_COPY_URL, sensitive
	);

	/* View */
	/* Stop loading */
	sensitive = loading_in_progress;
	GTK_WIDGET_SET_SENSITIVE(imbr->stop_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_STOP, sensitive
	);
	/* Continue loading */
	sensitive = !loading_in_progress;
	GTK_WIDGET_SET_SENSITIVE(imbr->continue_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_CONTINUE, sensitive
	);

	/* Show tool bar */
	w = imbr->show_tool_bar_micheck;
	state = EDV_GET_B(EDV_CFG_PARM_IMBR_SHOW_TOOL_BAR);
	DO_SET_CHECK_STATE
	ToolBarItemSetToggleID(
	    tb, EDV_IMBR_OP_SHOW_TOOL_BAR, state
	);
	/* Show location bar */
	w = imbr->show_location_bar_micheck;
	state = EDV_GET_B(EDV_CFG_PARM_IMBR_SHOW_LOCATION_BAR);
	DO_SET_CHECK_STATE
	ToolBarItemSetToggleID(
	    tb, EDV_IMBR_OP_SHOW_LOCATION_BAR, state
	);
	/* Show mount bar */
	w = imbr->show_mount_bar_micheck;
	state = EDV_GET_B(EDV_CFG_PARM_IMBR_SHOW_MOUNT_BAR);
	DO_SET_CHECK_STATE
	ToolBarItemSetToggleID(
	    tb, EDV_IMBR_OP_SHOW_MOUNT_BAR, state
	);
	/* Show find bar */
	w = imbr->show_find_bar_micheck;
	state = EDV_GET_B(EDV_CFG_PARM_IMBR_SHOW_FIND_BAR);
	DO_SET_CHECK_STATE
	ToolBarItemSetToggleID(
	    tb, EDV_IMBR_OP_SHOW_FIND_BAR, state
	);
	/* Show status bar */
	w = imbr->show_status_bar_micheck;
	state = EDV_GET_B(EDV_CFG_PARM_IMBR_SHOW_STATUS_BAR);
	DO_SET_CHECK_STATE
	ToolBarItemSetToggleID(
	    tb, EDV_IMBR_OP_SHOW_STATUS_BAR, state
	);


	/* Device */
	w = imbr->mount_mi;
	sensitive = (selected_dev_ptr != NULL) ?
	    !selected_dev_ptr->no_unmount : FALSE;
	GTK_WIDGET_SET_SENSITIVE(w, sensitive)
	if(TRUE)
	{
	    const gchar *text;
	    guint8 **icon_data;
	    if(selected_dev_ptr != NULL)
	    {
		if(selected_dev_ptr->is_mounted)
		{
		    text = "Unmount";
		    icon_data = (guint8 **)icon_unmount_20x20_xpm;
		}
		else  
		{     
		    text = "Mount";
		    icon_data = (guint8 **)icon_mount_20x20_xpm;
		}
	    }
	    else
	    {
		text = "Mount/Unmount";
		icon_data = (guint8 **)icon_unmount_20x20_xpm;
	    }
	    GUIMenuItemSetPixmap(w, icon_data);
	    GUIMenuItemSetLabel(w, text);
	    ToolBarItemUpdateByID(
		tb, EDV_IMBR_OP_MOUNT, text, NULL, NULL
	    );
	}
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_MOUNT, sensitive
	);

	/* Eject */
	if(selected_dev_ptr != NULL)
	    sensitive = !STRISEMPTY(selected_dev_ptr->command_eject);
	else
	    sensitive = FALSE;
	GTK_WIDGET_SET_SENSITIVE(imbr->eject_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_EJECT, sensitive
	);


	/* Device check, tools, and format commands */
	if(selected_dev_ptr != NULL)
	    sensitive = !STRISEMPTY(selected_dev_ptr->command_check);
	else
	    sensitive = FALSE;
	GTK_WIDGET_SET_SENSITIVE(imbr->device_check_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_DEVICE_CHECK, sensitive
	);

	if(selected_dev_ptr != NULL)
	    sensitive = !STRISEMPTY(selected_dev_ptr->command_tools);
	else
	    sensitive = FALSE;
	GTK_WIDGET_SET_SENSITIVE(imbr->device_tools_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_DEVICE_TOOLS, sensitive
	);

	if(selected_dev_ptr != NULL)
	    sensitive = !STRISEMPTY(selected_dev_ptr->command_format);
	else
	    sensitive = FALSE;
	GTK_WIDGET_SET_SENSITIVE(imbr->device_format_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_IMBR_OP_DEVICE_FORMAT, sensitive
	);


	/* Settings */
	if(write_protect_changed)
	{
	    w = imbr->write_protect_mi;
	    if(w != NULL)
		GUIMenuItemSetPixmap(
		    w,
		    (guint8 **)(write_protect ?
			icon_secure_20x20_xpm : icon_insecure_20x20_xpm)
		);
	    ToolBarItemUpdateByID(
		tb, EDV_IMBR_OP_WRITE_PROTECT,
		NULL,
		(guint8 **)(write_protect ?
		    icon_secure_20x20_xpm : icon_insecure_20x20_xpm),
		NULL
	    );
	}


	/* Windows */
	if(recbin_icon_data != NULL)
	{
	    GUIMenuItemSetPixmap(
		imbr->window_recycle_bin_mi, recbin_icon_data
	    );
	    ToolBarItemUpdateByID(
		tb, EDV_IMBR_OP_RECYCLE_BIN,
		NULL, recbin_icon_data, NULL
	    );
	}


	/* Update right-click menu */
	sensitive = (tlist_selected_thumb > -1) ? TRUE : FALSE;
	GTK_WIDGET_SET_SENSITIVE(imbr->tlist_open_mi, sensitive)
	GTK_WIDGET_SET_SENSITIVE(imbr->tlist_openwith_mi, sensitive)
	GTK_WIDGET_SET_SENSITIVE(imbr->tlist_move_mi, sensitive)
	GTK_WIDGET_SET_SENSITIVE(imbr->tlist_copy_mi, sensitive)
	GTK_WIDGET_SET_SENSITIVE(imbr->tlist_link_mi, sensitive)
	GTK_WIDGET_SET_SENSITIVE(imbr->tlist_rename_mi, sensitive)
	GTK_WIDGET_SET_SENSITIVE(imbr->tlist_chmod_mi, sensitive)
	GTK_WIDGET_SET_SENSITIVE(imbr->tlist_chown_mi, sensitive)
	GTK_WIDGET_SET_SENSITIVE(imbr->tlist_delete_mi, sensitive)
	GTK_WIDGET_SET_SENSITIVE(imbr->tlist_properties_mi, sensitive)

	w = imbr->tlist_mount_mi;
	if(selected_dev_ptr == NULL)
	    DO_HIDE
	else
	    DO_SHOW
	sensitive = (selected_dev_ptr != NULL) ?
	    !selected_dev_ptr->no_unmount : FALSE;
	GTK_WIDGET_SET_SENSITIVE(w, sensitive)
	if(selected_dev_ptr != NULL)
	{
	    const gchar *text;
	    guint8 **icon_data;
	    if(selected_dev_ptr->is_mounted)
	    {
		text = "Unmount";
		icon_data = (guint8 **)icon_unmount_20x20_xpm;
	    }
	    else
	    {
		text = "Mount";
		icon_data = (guint8 **)icon_mount_20x20_xpm;
	    }   
	    GUIMenuItemSetPixmap(w, icon_data);   
	    GUIMenuItemSetLabel(w, text);
	}

	w = imbr->tlist_mount_misep;
	if(selected_dev_ptr == NULL)
	    DO_HIDE
	else
	    DO_SHOW

	/* Eject */
	w = imbr->tlist_eject_mi;
	if(selected_dev_ptr == NULL)
	    DO_HIDE
	else
	    DO_SHOW
	if(selected_dev_ptr != NULL)
	    sensitive = !STRISEMPTY(selected_dev_ptr->command_eject);
	else
	    sensitive = FALSE;
	GTK_WIDGET_SET_SENSITIVE(w, sensitive)




	/* Update status bar */
	EDVStatusBarUpdate(imbr->status_bar);

#undef DO_SHOW
#undef DO_HIDE
#undef DO_SET_CHECK_STATE
}

/*
 *	Marks the Image Browser as busy or ready.
 */
void EDVImbrSetBusy(edv_imbr_struct *imbr, gboolean is_busy)
{
	GdkCursor *cursor;
	GtkWidget *w;
	edv_core_struct *core_ptr;


	if(imbr == NULL)
	    return;

	core_ptr = EDV_CORE(imbr->core_ptr);
	if(core_ptr == NULL)
	    return;

	w = imbr->toplevel;
	if(w != NULL)
	{
	    if(is_busy)
	    {
		/* Increase busy count */
		imbr->busy_count++;

		/* If already busy then don't change anything */
		if(imbr->busy_count > 1)
		    return;

		cursor = EDVGetCursor(core_ptr, EDV_CURSOR_CODE_BUSY);
	    }
	    else
	    {
		/* Reduce busy count */
		imbr->busy_count--;
		if(imbr->busy_count < 0)
		    imbr->busy_count = 0;

		/* If still busy do not change anything */
		if(imbr->busy_count > 0)
		    return;

		cursor = NULL;	/* Use default cursor */
	    }

	    /* Update toplevel window's cursor */
	    if(w->window != NULL)
	    {
		gdk_window_set_cursor(w->window, cursor);
		gdk_flush();
	    }
	}
}

/*
 *	Checks if the Image Browser is mapped.
 */
gboolean EDVImbrIsMapped(edv_imbr_struct *imbr)
{
	GtkWidget *w = (imbr != NULL) ? imbr->toplevel : NULL;
	return((w != NULL) ? GTK_WIDGET_MAPPED(w) : FALSE);
}

/*
 *	Maps the Image Browser.
 */
void EDVImbrMap(edv_imbr_struct *imbr)
{
	GtkWidget *w = (imbr != NULL) ? imbr->toplevel : NULL;
	if(w == NULL)
	    return;

	gtk_widget_show_raise(w);
}

/*
 *	Unmaps the Image Browser.
 */
void EDVImbrUnmap(edv_imbr_struct *imbr)
{
	GtkWidget *w = (imbr != NULL) ? imbr->toplevel : NULL;
	if(w == NULL)
	    return;

	gtk_widget_hide(w);
}

/*
 *	Deletes the Image Browser.
 */
void EDVImbrDelete(edv_imbr_struct *imbr)
{
	if(imbr == NULL)
	    return;

	/* Remove loading timeout callback */
	GTK_TIMEOUT_REMOVE(imbr->loading_tocb);
	imbr->loading_tocb = 0;

	/* Reset last selected item references */
	imbr->tlist_selected_thumb = -1;

	/* Delete file operation dialog */
	EDVFOPDlgDelete(imbr->fopdlg);
	imbr->fopdlg = NULL;

	/* Right click menu */
	imbr->tlist_open_mi = NULL;
	imbr->tlist_openwith_mi = NULL;
	imbr->tlist_mount_mi = NULL;
	imbr->tlist_eject_mi = NULL;
	imbr->tlist_mount_misep = NULL;
	imbr->tlist_move_mi = NULL;
	imbr->tlist_copy_mi = NULL;
	imbr->tlist_link_mi = NULL;
	imbr->tlist_rename_mi = NULL;
	imbr->tlist_chmod_mi = NULL;
	imbr->tlist_chown_mi = NULL;
	imbr->tlist_delete_mi = NULL;
	imbr->tlist_properties_mi = NULL;
	GTK_WIDGET_DESTROY(imbr->tlist_menu)
	imbr->tlist_menu = NULL;

	/* Delete the Status Bar */
	EDVStatusBarDelete(imbr->status_bar);
	imbr->status_bar = NULL;

	/* Delete the Tool Bar */
	ToolBarDelete(imbr->toolbar);
	imbr->toolbar = NULL;

	/* Delete the Mount Bar */
	EDVMountBarDelete(imbr->mountbar);
	imbr->mountbar = NULL;

	/* Delete the Find Bar */
	EDVFindBarDelete(imbr->findbar);
	imbr->findbar = NULL;

	/* Delete the Location Bar */
	GTK_WIDGET_DESTROY(imbr->location_icon_pm)
	imbr->location_icon_pm = NULL;
	GTK_WIDGET_DESTROY(imbr->location_icon_fixed)
	imbr->location_icon_fixed = NULL;
	GTK_WIDGET_DESTROY(imbr->location_combo)
	imbr->location_combo = NULL;
	GTK_WIDGET_DESTROY(imbr->location_bar_hbox)
	imbr->location_bar_hbox = NULL;


	/* Delete Menus and the Menu Bar */
	imbr->new_file_mi = NULL;
	imbr->new_directory_mi = NULL;
	imbr->new_link_mi = NULL;
	imbr->new_fifo_mi = NULL;
	imbr->new_device_block_mi = NULL;
	imbr->new_device_character_mi = NULL;
	imbr->new_socket_mi = NULL;
	GTK_WIDGET_DESTROY(imbr->new_object_submenu)
	imbr->new_object_submenu = NULL;

	imbr->open_mi = NULL;
	imbr->openwith_mi = NULL;
	imbr->new_object_submi = NULL;
	imbr->sync_disks_mi = NULL;
	imbr->history_mi = NULL;
	imbr->run_mi = NULL;
	imbr->close_mi = NULL;

	imbr->move_mi = NULL;
	imbr->copy_mi = NULL;
	imbr->link_mi = NULL;
	imbr->rename_mi = NULL;
	imbr->chmod_mi = NULL;
	imbr->chown_mi = NULL;
	imbr->delete_mi = NULL;
	imbr->select_all_mi = NULL;
	imbr->unselect_all_mi = NULL;
	imbr->invert_selection_mi = NULL;
	imbr->find_mi = NULL;
	imbr->properties_mi = NULL;

	imbr->mount_mi = NULL;
	imbr->eject_mi = NULL;
	imbr->device_check_mi = NULL;
	imbr->device_tools_mi = NULL;
	imbr->device_format_mi = NULL;
	imbr->devices_mi = NULL;

	imbr->stop_mi = NULL;
	imbr->continue_mi = NULL;
	imbr->refresh_mi = NULL;
	imbr->refresh_all_mi = NULL;
	imbr->show_tool_bar_micheck = NULL;
	imbr->show_location_bar_micheck = NULL;
	imbr->show_mount_bar_micheck = NULL;
	imbr->show_find_bar_micheck = NULL;
	imbr->show_status_bar_micheck = NULL;
	imbr->mime_types_mi = NULL;

	imbr->write_protect_mi = NULL;
	imbr->options_mi = NULL;
	imbr->customize_mi = NULL;

	imbr->window_new_browser_mi = NULL;
	imbr->window_new_imbr_mi = NULL;
	imbr->window_new_archiver_mi = NULL;
	imbr->window_recycle_bin_mi = NULL;

	imbr->help_contents_mi = NULL;
	imbr->help_image_browser_mi = NULL;
	imbr->help_keys_list_mi = NULL;
	imbr->help_mime_types_mi = NULL;
	imbr->help_devices_mi = NULL;
	imbr->help_common_operations_mi = NULL;
	imbr->help_about_mi = NULL;

	GTK_WIDGET_DESTROY(imbr->menu_bar)
	imbr->menu_bar = NULL;


	/* Destroy the Thumb List and ImgView */
	TListDelete(imbr->tlist);
	imbr->tlist = NULL;
	ImgViewDelete(imbr->imgview);
	imbr->imgview = NULL;


	/* Destroy toplevel and the rest of the widgets */
	GTK_WIDGET_DESTROY(imbr->menu_bar_handle)
	imbr->menu_bar_handle = NULL;
	GTK_WIDGET_DESTROY(imbr->tool_bar_handle)
	imbr->tool_bar_handle = NULL;
	GTK_WIDGET_DESTROY(imbr->location_bar_handle)
	imbr->location_bar_handle = NULL;
	GTK_WIDGET_DESTROY(imbr->bars_vbox)
	imbr->bars_vbox = NULL;
	GTK_WIDGET_DESTROY(imbr->main_paned)
	imbr->main_paned = NULL;
	GTK_WIDGET_DESTROY(imbr->main_vbox)
	imbr->main_vbox = NULL;
	GTK_WIDGET_DESTROY(imbr->toplevel)
	imbr->toplevel = NULL;


	/* Unref special icons */
	GDK_PIXMAP_UNREF(imbr->folder_home_pixmap)
	GDK_BITMAP_UNREF(imbr->folder_home_mask)
	GDK_PIXMAP_UNREF(imbr->folder_parent_pixmap)
	GDK_BITMAP_UNREF(imbr->folder_parent_mask)
	GDK_PIXMAP_UNREF(imbr->folder_noaccess_pixmap)
	GDK_BITMAP_UNREF(imbr->folder_noaccess_mask)
	GDK_PIXMAP_UNREF(imbr->file_badimage_pixmap)
	GDK_BITMAP_UNREF(imbr->file_badimage_mask)

	GTK_ACCEL_GROUP_UNREF(imbr->accelgrp)

	/* Delete other resources */

	/* Operation IDs */
	EDVImbrOPIDListDelete(
	    imbr->opid, imbr->total_opids
	);

	g_free(imbr);
}
