/*
	     FSCK Manager Window Creation, Management, and Deletion
 */

#ifndef FSCKMANAGER_H
#define FSCKMANAGER_H

#include <stdio.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#include "../lib/endeavour2.h"

/*
 *	FSCK Manager Window:
 */
typedef struct {

	GtkWidget	*toplevel;
	gboolean	initialized;
	gboolean	map_state;
	gint		busy_count;
	GtkAccelGroup	*accelgrp;
	GdkColormap	*colormap;
	GdkGC		*gc;
	edv_context_struct *ctx;

	GdkCursor	*busy_cur,
			*text_cur;

	GdkColor	error_color;
	GdkFont		*text_font;

	GtkWidget	*main_vbox,
			*devices_clist,
			*bad_blocks_check,
			*verbose_check,
			*output_text,
			*progress_bar;

	GtkWidget	*devices_menu,
			*devices_start_mi,
			*devices_stop_mi;

	GtkWidget	*disk_anim_da;
	GdkPixmap	*disk_anim_pm;

	GdkPixmap	**disk_icon_pixmap;
	GdkBitmap	**disk_icon_mask;
	gint		last_disk_icon_num, total_disk_icons;

	GtkWidget	*start_btn,
			*stop_btn,
			*clear_btn,
			*close_btn;

	/* Queued this of rows in the devices_clist that we need
	 * to check.
	 */
	GList		*queued_device_to_check;

	guint		fsck_toid;
	pid_t		fsck_pid;
	FILE		*stdout_fp, *stderr_fp;
	gchar		*stdout_path, *stderr_path;

	gint		stop_count;
	gfloat		progress_pos_last;

	/* List of devices. */
	edv_device_struct	**device;
	gint			total_devices;

} fsck_manager_struct;

extern void FSCKManagerSetDevices(
	fsck_manager_struct *fm,
	edv_device_struct **device, gint total_devices
);
extern void FSCKManagerAppendMessage(
	fsck_manager_struct *fm,
	GdkFont *font, GdkColor *color_fg, GdkColor *color_bg,
	const gchar *text,
	gboolean allow_auto_scroll
);

extern fsck_manager_struct *FSCKManagerNew(edv_context_struct *ctx);
extern void FSCKManagerUpdateMenus(fsck_manager_struct *fm);
extern void FSCKManagerSetBusy(fsck_manager_struct *fm, gboolean is_busy);
extern void FSCKManagerSetProgress(
	fsck_manager_struct *fm, gfloat value,
	gboolean allow_gtk_iteration
);
extern void FSCKManagerMap(fsck_manager_struct *fm);
extern void FSCKManagerUnmap(fsck_manager_struct *fm);
extern void FSCKManagerDelete(fsck_manager_struct *fm);




#endif	/* FSCKMANAGER_H */
