/*
		      Endeavour GTK+ Utility Functions

	These functions are different from those in edvutils.c because
	they require either the pointer to the core (edv_core_struct *)
	or GTK+ resources.
 */

#ifndef EDVUTILSGTK_H
#define EDVUTILSGTK_H

#include <gtk/gtk.h>

#include "cfg.h"
#include "edvtypes.h"
#include "edvdevices.h"
#include "edvmimetypes.h"
#include "edvobj.h"
#include "endeavour.h"


/* String Formatting */
extern gchar *EDVGetObjectSizeStr(edv_core_struct *core_ptr, gulong i);

/* Pixmaps */
extern void EDVResizePixmap(
	GdkPixmap *pixmap, GdkBitmap *mask,
	gint width, gint height, 
	GdkPixmap **pixmap_rtn, GdkBitmap **mask_rtn
);
extern gboolean EDVLoadPixmap(
	edv_core_struct *core_ptr,
	guint8 **data, const gchar *name,
	GdkPixmap **pixmap_rtn, GdkBitmap **mask_rtn
);
extern GtkWidget *EDVNewPixmapWidget(
	edv_core_struct *core_ptr,
	guint8 **data, const gchar *name
);

/* Cursors */
extern GdkCursor *EDVGetCursor(
	edv_core_struct *core_ptr, gint cursor_code
);

/* GtkCTree Nodes */
extern gint EDVNodeGetLevel(GtkCTreeNode *node);
extern GtkCTreeNode *EDVNodeGetParent(GtkCTreeNode *node);
extern GtkCTreeNode *EDVNodeGetChild(GtkCTreeNode *node);
extern GtkCTreeNode *EDVNodeGetSibling(GtkCTreeNode *node);
extern GtkCTreeNode *EDVNodeGetToplevel(GtkCTree *ctree);

/* GtkCList & GtkCTree Utilities */
extern gint EDVCListGetSelectedLast(
	GtkCList *clist, GtkCListRow **row_ptr_rtn
);
extern GtkCTreeNode *EDVCTreeGetSelectedLast(
	GtkCTree *ctree, GtkCTreeRow **row_ptr_rtn
);
extern gboolean EDVNodeGetIndex(
	GtkCTree *ctree, GtkCTreeNode *node,
	gint *row_rtn, gint *column_rtn
);
extern GtkCTreeNode *EDVNodeGetByCoordinates(
	GtkCTree *ctree, gint x, gint y
);
extern void EDVScrollCListToPosition(
	GtkCList *clist, gfloat hpos, gfloat vpos
);

/* Endeavour Window Matching */
extern gboolean EDVMatchWindowFromToplevel(
	edv_core_struct *core_ptr, GtkWidget *toplevel,
	gint *browser_num,
	gint *imbr_num,
	gint *archiver_num,
	gint *recbin_num
);

/* Object Name Checking */
extern gboolean EDVObjectNameNotationOK(const gchar *name);
extern gboolean EDVCheckObjectHidden(
	edv_core_struct *core_ptr, edv_object_struct *object
);

/* Write Protect Utilities */
extern gboolean EDVCheckWriteProtect(
	edv_core_struct *core_ptr,
	gboolean verbose, GtkWidget *toplevel
);

/* Permission Checking */
extern gboolean EDVCheckUIDIsOwner(gint effective_uid, gint owner_id);
extern gboolean EDVCheckIsOwner(edv_core_struct *core_ptr, gint owner_id);
extern gboolean EDVCheckObjectAccessable(
	edv_core_struct *core_ptr, edv_object_struct *object
);
extern gboolean EDVCheckObjectReadable(
	edv_core_struct *core_ptr, edv_object_struct *object
);
extern gboolean EDVCheckObjectWriteable(
	edv_core_struct *core_ptr, edv_object_struct *object
);
extern gboolean EDVCheckObjectExecutable(
	edv_core_struct *core_ptr, edv_object_struct *object
);

/* Internal Supported Object Type Checking */
extern gboolean EDVCheckImlibImage(
	edv_core_struct *core_ptr, const gchar *path
);
extern gboolean EDVCheckEDVArchiverArchive(
	edv_core_struct *core_ptr, const gchar *path
);

/* Object MIME Type Matching Utilities */
extern gint EDVMatchObjectIcon(
	edv_device_struct **device, gint total_devices,
	edv_mimetype_struct **mimetype, gint total_mimetypes,
	edv_object_type type,	/* One of EDV_OBJECT_TYPE_* */
	const gchar *path,	/* Full path or name */
	gboolean link_valid,
	edv_permission_flags permissions,
	gint icon_size,		/* 0 = small, 1 = medium, 2 = large */
	GdkPixmap **pixmap_closed, GdkBitmap **mask_closed,
	GdkPixmap **pixmap_opened, GdkBitmap **mask_opened,
	GdkPixmap **pixmap_extended, GdkBitmap **mask_extended
);
extern gint EDVMatchObjectTypeString(
	edv_mimetype_struct **mimetype, gint total_mimetypes,
	edv_object_type type,	/* One of EDV_OBJECT_TYPE_* */
	edv_permission_flags permissions,
	const gchar *path,      /* Full path or just name */
	gchar **type_str
);

/* Message Output */
extern void EDVMessage(
	const gchar *title, const gchar *message, const gchar *details,
	GtkWidget *toplevel
);
extern void EDVMessageInfo(
	const gchar *title, const gchar *message, const gchar *details,
	GtkWidget *toplevel
);
extern void EDVMessageWarning(
	const gchar *title, const gchar *message, const gchar *details,
	GtkWidget *toplevel
);
extern void EDVMessageError(
	const gchar *title, const gchar *message, const gchar *details,
	GtkWidget *toplevel
);
extern void EDVMessageFromFile(
	const gchar *path, const gchar *title,
	gint cdialog_icon,
	GtkWidget *toplevel
);

/* Play Sound */
extern void EDVBeep(edv_core_struct *core_ptr);
extern void EDVPlaySoundBeep(edv_core_struct *core_ptr);
extern void EDVPlaySoundInfo(edv_core_struct *core_ptr);
extern void EDVPlaySoundQuestion(edv_core_struct *core_ptr);
extern void EDVPlaySoundWarning(edv_core_struct *core_ptr);
extern void EDVPlaySoundError(edv_core_struct *core_ptr);
extern void EDVPlaySoundCompleted(edv_core_struct *core_ptr);

/* Window Centering */
extern void EDVCenterWindowToWindow(GtkWidget *w1, GtkWidget *w2);
extern void EDVCenterWindowToWindowOffset(
	GtkWidget *w1, GtkWidget *w2, gint x_offset, gint y_offset
);

/* GtkEntry Setup Utilities */
extern void EDVEntrySetDND(edv_core_struct *core_ptr, GtkWidget *w);
extern void EDVEntrySetCompletePath(edv_core_struct *core_ptr, GtkWidget *w);

/* Scrolled Window Setup Utilities */
extern GtkWidget *EDVScrolledWindowNew(
	GtkPolicyType hscrollbar_policy,
	GtkPolicyType vscrollbar_policy,
	GtkWidget **event_box_rtn,
	GtkWidget **vbox_rtn
);

/* Copy Object Path Utilities */
extern void EDVCopyDiskObjectsToDDEPath(
	edv_core_struct *core_ptr,
	edv_object_struct **list, gint total,
	GtkWidget *owner
);
extern void EDVCopyDiskObjectsToDDEURL(
	edv_core_struct *core_ptr,
	edv_object_struct **list, gint total,
	GtkWidget *owner
);

/* Style Utilities */
extern GtkRcStyle *EDVCreateRCStyleFromCfg(
	const cfg_style_struct *style
);

/* History Utilities */
extern void EDVAppendHistory(
	edv_core_struct *core_ptr,
	edv_history_type type,	/* One of EDV_HISTORY_* */
	gulong time_start,	/* Time the operation first started */
	gulong time_end,	/* Time the operation ended */
	gint status,		/* Result of operation */
	const gchar *src_path,	/* Source Object/Operation/Value */
	const gchar *tar_path,	/* Target Object/Operation/Value */
	const gchar *comments	/* Comments */
);


#endif	/* EDVUTILSGTK_H */
