#include <glib.h>

#include "../include/disk.h"

#include "edvtypes.h"
#include "edvobj.h"
#include "edvrecbin.h"


gchar *EDVRecBinGetDirectoryFromIndexPath(const gchar *filename);

edv_recbin_object_struct *EDVRecBinObjectNew(void);
edv_recbin_object_struct *EDVRecBinObjectCopy(
	const edv_recbin_object_struct *obj
);
void EDVRecBinObjectDelete(
	edv_recbin_object_struct *obj
);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Returns the path to the Recycled Objects Directory parsed from
 *	the specified path to the Recycled Objects Index File.
 *
 *	The calling function needs to delete the returned string.
 */
gchar *EDVRecBinGetDirectoryFromIndexPath(const gchar *filename)
{
	if(STRISEMPTY(filename))
	    return(NULL);
	else
	    return(STRDUP(GetParentDir((const char *)filename)));
}

/*
 *	Creates a new Recycled Object.
 */
edv_recbin_object_struct *EDVRecBinObjectNew(void)
{
	edv_recbin_object_struct *obj = EDV_RECBIN_OBJECT(g_malloc0(
	    sizeof(edv_recbin_object_struct)
	));
	if(obj == NULL)
	    return(obj);

	obj->name = NULL;
	obj->original_path = NULL;
	obj->index = 0;
	obj->date_deleted = 0l;

	obj->type = EDV_OBJECT_TYPE_FILE;

	obj->linked_to = NULL;
	obj->permissions = 0x00000000;
	obj->access_time = 0l;
	obj->modify_time = 0l;
	obj->change_time = 0l;
	obj->owner_id = 0;
	obj->group_id = 0;
	obj->size = 0l;

	return(obj);
}

/*
 *	Coppies the Recycled Object.
 */
edv_recbin_object_struct *EDVRecBinObjectCopy(
	const edv_recbin_object_struct *obj
)
{
	const edv_recbin_object_struct *src = obj;
	edv_recbin_object_struct *tar;

	if(src == NULL)
	    return(NULL);

	tar = EDVRecBinObjectNew();

	tar->name = STRDUP(src->name);
	tar->original_path = STRDUP(src->original_path);
	tar->index = src->index;
	tar->date_deleted = src->date_deleted;

	tar->type = src->type;
	tar->linked_to = STRDUP(src->linked_to);
	tar->permissions = src->permissions;
	tar->access_time = src->access_time;
	tar->modify_time = src->modify_time;
	tar->change_time = src->change_time;
	tar->owner_id = src->owner_id;
	tar->group_id = src->group_id;
	tar->size = src->size;

	return(tar);
}

/*
 *	Deletes the Recycled Object.
 */
void EDVRecBinObjectDelete(edv_recbin_object_struct *obj)
{
	if(obj == NULL)
	    return;

	g_free(obj->name);
	g_free(obj->original_path);
	g_free(obj->linked_to);

	g_free(obj);
}
