#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <gtk/gtk.h>

#include "guiutils.h"
#include "fb.h"
#include "stacklist.h"

#include "cfg.h"
#include "edvtypes.h"
#include "edvdate.h"
#include "edvlistcb.h"
#include "browser.h"
#include "browsercb.h"
#include "optwin.h"
#include "edvoptions.h"
#include "endeavour.h"
#include "edvcb.h"
#include "edvutils.h"
#include "edvutilsgtk.h"
#include "edvcfglist.h"
#include "config.h"

#include "images/icon_options2_48x48.xpm"

#include "images/endeavour_48x48.xpm"
#include "images/image_browser_48x48.xpm"
#include "images/archiver_48x48.xpm"
#include "images/icon_trash_empty_48x48.xpm"

#include "images/icon_reload_20x20.xpm"
#include "images/icon_folder_opened_20x20.xpm"
#include "images/icon_trash_20x20.xpm"
#include "images/icon_purge_all_20x20.xpm"
#include "images/icon_mimetypes_20x20.xpm"
#include "images/icon_device_misc_20x20.xpm"
#include "images/icon_run_20x20.xpm"
#include "images/icon_terminal_20x20.xpm"
#include "images/icon_terminal_run_20x20.xpm"
#include "images/icon_planet_20x20.xpm"
#include "images/icon_mailbox_20x20.xpm"
#include "images/icon_move_file_20x20.xpm"
#include "images/icon_copy_file_20x20.xpm"
#include "images/icon_link2_20x20.xpm"
#include "images/icon_cancel_20x20.xpm"
#include "images/icon_archive_add_20x20.xpm"
#include "images/icon_archive_extract_20x20.xpm"
#include "images/icon_recover_20x20.xpm"
#include "images/icon_purge_20x20.xpm"
#include "images/icon_clear_20x20.xpm"

#include "images/icon_memory_32x32.xpm"
#include "images/icon_device_pointers_32x32.xpm"
#include "images/icon_trace_20x20.xpm"


typedef struct {
	GtkWidget	*format_entry,
			*sample_entry;
} DateFormatSampleData;
#define DATE_FORMAT_SAMPLE_DATA(p)	((DateFormatSampleData *)(p))
#define DATE_FORMAT_SAMPLE_DATA_KEY	"date_format_sample_data"


static void EDVOptionsWarnDeleteMethodPurge(
	GtkWidget *widget, gpointer data
);

static void EDVOptionsDateFormatSampleDataDestroyCB(gpointer data);
static gint EDVOptionsDateFormatListEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
static void EDVOptionsDateFormatSampleUpdateCB(
	GtkWidget *widget, gpointer data   
);

static void EDVOptionsRunCB(GtkWidget *widget, gpointer data);

static void EDVOptionsBrowseCB(gpointer button, gpointer data);
static void EDVOptionsBrowseProgramCB(gpointer button, gpointer data);

static void EDVOptionsToggledSensitiveCB(GtkWidget *widget, gpointer data);
static void EDVOptionsToggledInsensitiveCB(GtkWidget *widget, gpointer data);

static void EDVCreateOptionsMiscPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);
static void EDVCreateOptionsSoundsPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);
static void EDVCreateOptionsDatePage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);
static void EDVCreateOptionsConfirmationPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);
static void EDVCreateOptionsProgramsPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);
static void EDVCreateOptionsDisplayPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);
static void EDVCreateOptionsGeneralPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);

void EDVOptionsWindowSelectTab(
	optwin_struct *optwin, const gchar *tab_name
);
optwin_struct *EDVCreateOptionsWindow(
	gpointer core_ptr
);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


#define DATE_TIME_SUBS_LIST	{ \
"%a",	"Abbreviated weekday name", \
"%A",	"Full weekday name", \
"%b",	"Abbreviated month name", \
"%B",	"Full month name", \
"%c",	"Preferred date & time representation", \
"%C",	"Century number (year / 100) as a 2-digit integer", \
"%d",	"Day of the month as a decimal number (from 01 to 31)", \
"%D",	"Equivalent to %m/%d/%y", \
"%e",	"Day of the month as a decimal number (no leading zero)", \
"%E",	"Modifier: use alternative format, see below", \
"%G",	"ISO 8601 year with century as a decimal number", \
"%g",	"ISO 8601 year with century as a 2-digit year (from 00 to 99)", \
"%h",	"Equivalent to %b", \
"%H",	"Hour as a decimal number using 24-hour time (from 00 to 23)", \
"%I",	"Hour as a decimal number using 12-hour time (from 01 to 12)", \
"%j",	"Day of the year as a decimal number (range 001 to 366)", \
"%k",	"Equivalent to %H but with single digits preceded by a space", \
"%l",	"Equivalent to %I but with single digits preceded by a space", \
"%m",	"Month as a decimal number (from 01 to 12)", \
"%M",	"Minute as a decimal number (from 00 to 59)", \
"%O",	"Modifier: use alternative format, see below", \
"%p",	"Either \"AM\" or \"PM\" according to the time value", \
"%P",	"Equivalent to %p but in lowercase", \
"%r",	"Time in a.m. or p.m. notation", \
"%R",	"Time in 24-hour notation (equivalent to %H:%M)", \
"%s",	"Number of seconds since the Epoch (1970-01-01 00:00:00 UTC)", \
"%S",	"Second as a decimal number (from 00 to 61)", \
"%T",	"Time in 24-hour notation (equivalent to %H:%M:%S)", \
"%u",	"Day of the week as a decimal number (from 1 to 7 with monday\
 being 1)", \
"%U",	"Week number of the current year as a decimal number (from 00\
 to 53) starting with the first Sunday as the first day of week 01", \
"%V",	"ISO 8601:1988 week number of the current year as a\
 decimal number (from 01 to 53)", \
"%w",	"Day of the week as a decimal number (from 0 to 6 with sunday\
 being 0)", \
"%W",	"Week number of the current year as a decimal number (from 00\
 to 53) starting with the first Monday as the first day of week 01", \
"%x",	"Preferred date representation for the current locale without\
 the time", \
"%X",	"Preferred time representation for the current locale without\
 the date", \
"%y",	"Year as a decimal number without a century (from 00 to 99)", \
"%Y",	"Year as a decimal number including the century", \
"%z",	"Time zone as hour offset from GMT", \
"%Z",	"Time zone, name, or abbreviation", \
"%+",	"Date & time in date(1) format", \
"%%",	"Literal % character", \
NULL, NULL \
}


/*
 *	Called whenever the radio button for the parameter
 *	EDV_DELETE_METHOID_PURGE has been "toggled".
 */
static void EDVOptionsWarnDeleteMethodPurge(
	GtkWidget *widget, gpointer data
)
{
	edv_core_struct *core_ptr = EDV_CORE(data);
	if((widget == NULL) || (core_ptr == NULL))
	    return;

	if(!GTK_IS_TOGGLE_BUTTON(widget))
	    return;

	if(GTK_TOGGLE_BUTTON(widget)->active)
	{
	    EDVPlaySoundWarning(core_ptr);
	    EDVMessageWarning(
#if defined(PROG_LANGUAGE_SPANISH)
"Borre Advertir De Mtodo",
"Si usted borra un objeto que usa este mtodo, entonces\n\
usted no ser capaz de recuperar que se opone!\n\
\n\
Si usted desea usar un mtodo ms seguro de la supresin,\n\
escoge por favor \"MoverLos Al Cajn de la Recirculacin\"\n\
en lugar.\n",
#elif defined(PROG_LANGUAGE_FRENCH)
"Effacer L'Avertissement De Mthode",
"Si vous effacez un objet en utilisant cette mthode,\n\
alors vous ne pourrez pas retrouver cet objet!\n\
\n\
Si vous souhaitez utiliser une mthode plus sre de\n\
suppression, s'il vous plat choisir se \"Transfrer Les\n\
Au Recycler l'Huche\" plutt.\n",
#elif defined(PROG_LANGUAGE_GERMAN)
"Lschen Sie Methode Warnen",
"Wenn Sie lschen ein Objekt benutzt diese Methode, dann\n\
Sie nicht werden wiedererlangen knnen jenes Objekt! das!\n\
\n\
Um eine sicherere Methode der Lschung zu benutzen,\n\
whlen Sie \"Bewegen, das Sie Zum Behlter\n\
Wiederverwerten\".\n",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Cancellare L'Avvertimento Di Metodo",
"Se lei cancella un oggetto che usando questo metodo,\n\
poi lei non sar in grado di ricuperare quell'oggetto!\n\
\n\
Per usare un metodo pi sicuro di soppressione, scegliere\n\
\"il Trasloco Loro Al Contenitore per la raccolta differenziata\".\n",
#elif defined(PROG_LANGUAGE_DUTCH)
"Schrap Methode, Die Waarschuwt",
"Indien u een voorwerp schrappet, dat deze methode\n\
gebruikt, dan zult u niet kunnen terugkrijgen die bezwaar\n\
heeft!\n\
\n\
Om een veiliggere methode van schrapping te gebruiken,\n\
kies \"Bewegen, Dat Hen Aan Het Bak Recyclen\".\n",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Anule Aviso De Mtodo",
"Se anula um objeto que usando este mtodo, ento voc\n\
nao ser capaz de recuperar aquele objeto!\n\
\n\
Usar um mtodo mais seguro de anulao, escolhe \"Mover\n\
Os  Caixa De Recycle\".\n",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Stryk Method Warning",
"Om De stryker et objekt bruke denne metoden, da De ikke\n\
er kyndig utvinne det objektet! som!\n\
\n\
Bruke en sikrere metode av stryking, velg \"Moving Them To\n\
The Recycle Bin\".\n",
#else
"Delete Method Warning",
"If you delete an object using this method, then you\n\
will not be able to recover that object!\n\
\n\
To use a safer method of deletion, choose\n\
\"Moving Them To The Recycle Bin\"\n",
#endif
		NULL,
		gtk_widget_get_toplevel(widget)
	    );
	}
}


/*
 *	Date Format Sample Data "destroy" signal callback.
 */
static void EDVOptionsDateFormatSampleDataDestroyCB(gpointer data)
{
	DateFormatSampleData *d = DATE_FORMAT_SAMPLE_DATA(data);
	if(d == NULL)
	    return;

	g_free(d);
}

/*
 *	Date Format Substitutions GtkCList event signal callback.
 */
gint EDVOptionsDateFormatListEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
)
{
	gint status = FALSE;
	GtkCList *clist = (GtkCList *)widget;
	DateFormatSampleData *d = DATE_FORMAT_SAMPLE_DATA(data);
	if((clist == NULL) || (event == NULL) || (d == NULL))
	    return(status);

	switch((gint)event->type)
	{
	  case GDK_MAP:
	    if(clist->columns >= 2)
	    {
		gint i, row, width;
		gchar *strv[2];
		const gchar *line[] = DATE_TIME_SUBS_LIST;
		gtk_clist_freeze(clist);
		for(i = 0; line[i] != NULL; i += 2)
		{
		    strv[0] = (gchar *)line[i];
		    strv[1] = (gchar *)line[i + 1];
		    row = gtk_clist_append(clist, strv);
		    if(row < 0)
			break;

		    gtk_clist_set_selectable(clist, row, FALSE);
		}
		gtk_clist_thaw(clist);   

		width = gtk_clist_optimal_column_width(clist, 0);
		gtk_clist_set_column_width(clist, 0, width);
		width = gtk_clist_optimal_column_width(clist, 1);
		gtk_clist_set_column_width(clist, 1, width);
	    }
	    status = TRUE;
	    break;

	  case GDK_UNMAP:
	    gtk_clist_freeze(clist);
	    gtk_clist_clear(clist);
	    gtk_clist_thaw(clist);   
	    status = TRUE;
	    break;
	}

	return(status);
}

/*
 *	Date Format Sample update callback.
 */
static void EDVOptionsDateFormatSampleUpdateCB(
	GtkWidget *widget, gpointer data
)
{
	const gchar *s;
	GtkWidget *w;
	DateFormatSampleData *d = DATE_FORMAT_SAMPLE_DATA(data);
	if(d == NULL)
	    return;

	w = d->format_entry;
	s = EDVDateFormatString(
	    (gulong)time(NULL),
	    (w != NULL) ? gtk_entry_get_text(GTK_ENTRY(w)) : NULL,
	    EDV_DATE_RELATIVITY_ABSOLUTE
	);

	w = d->sample_entry;
	if((w != NULL) && (s != NULL))
	    gtk_entry_set_text(GTK_ENTRY(w), s);
}


/*
 *	Run callback.
 *
 *      The specified data must be a GtkEntry and the command to
 *	execute will be obtained from its value.
 */
static void EDVOptionsRunCB(GtkWidget *widget, gpointer data)
{
	const gchar *path;
	gchar *cmd;
	GtkEntry *entry = (GtkEntry *)data;
	if(entry == NULL)
	    return;

	/* Get object path */
	path = gtk_entry_get_text(entry);
	if(STRISEMPTY(path))
	    return;

	/* Format command */
	cmd = g_strdup_printf("%s &", path);

	/* Execute command */
	EDVSystem(cmd);

	g_free(cmd);
}


/*
 *	General browse callback.
 *
 *	The specified data must be a GtkEntry and the path to browse
 *	will be obtained from and set to its value.
 */
static void EDVOptionsBrowseCB(gpointer button, gpointer data)
{
	gboolean status;
	GtkWidget *toplevel;
	fb_type_struct **ftype = NULL, *ftype_rtn = NULL;
	gint total_ftypes = 0;
	gchar **path_rtn = NULL;
	gint total_path_rtns = 0;
	GtkEntry *entry = (GtkEntry *)data;
	if((entry == NULL) || FileBrowserIsQuery())
	    return;

	toplevel = gtk_widget_get_toplevel(GTK_WIDGET(entry));

	/* Create file types list */
	FileBrowserTypeListNew(
	    &ftype, &total_ftypes,
	    "*.*", "All files"
	);

	/* Query user for path */
	FileBrowserSetTransientFor(toplevel);
	status = FileBrowserGetResponse(
#if defined(PROG_LANGUAGE_SPANISH)
"El Objeto Selecto",
"Selecto",
"Cancele",
#elif defined(PROG_LANGUAGE_FRENCH)
"Objet Privilgi",
"Privilgi",
"Annuler",
#elif defined(PROG_LANGUAGE_GERMAN)
"Erlesenes Objekt",
"Erlesen",
"Heben",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Scegliere L'Oggetto",
"Scegliere",
"Annullare",
#elif defined(PROG_LANGUAGE_DUTCH)
"Uitgezocht Voorwerp",
"Uitgezocht",
"Annuleer",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Selecione Objeto",
"Selecione",
"Cancelamento",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utvalgt Objekt",
"Utvalgt",
"Kanseller",
#else
"Select Object",
"Select",
"Cancel",
#endif
	    gtk_entry_get_text(entry),          /* Startup path */
	    ftype, total_ftypes,
	    &path_rtn, &total_path_rtns,
	    &ftype_rtn
	);
	FileBrowserSetTransientFor(NULL);

	/* Got user response? */
	if(status)
	{
	    const gchar *path = (total_path_rtns > 0) ?
		path_rtn[0] : NULL;
	    if(!STRISEMPTY(path))
		gtk_entry_set_text(entry, path);
	}

	/* Delete file types list */
	FileBrowserDeleteTypeList(ftype, total_ftypes);
}

/*
 *	Browse Program callback.
 *
 *	The specified data must be a GtkEntry and the path to browse
 *	will be obtained from and set to its value.
 */
static void EDVOptionsBrowseProgramCB(gpointer button, gpointer data)
{
	gboolean status;
	GtkWidget *toplevel;
	fb_type_struct **ftype = NULL, *ftype_rtn = NULL;
	gint total_ftypes = 0;
	gchar **path_rtn = NULL;
	gint total_path_rtns = 0;
	GtkEntry *entry = (GtkEntry *)data;
	if((entry == NULL) || FileBrowserIsQuery())
	    return;

	toplevel = gtk_widget_get_toplevel(GTK_WIDGET(entry));

	/* Create file types list */
	FileBrowserTypeListNew(
	    &ftype, &total_ftypes,
	    "*.*", "All programs"
	);

	/* Query user for program path */
	FileBrowserSetTransientFor(toplevel);
	status = FileBrowserGetResponse(
#if defined(PROG_LANGUAGE_SPANISH)
"El Programa Selecto",
"Selecto",
"Cancele",
#elif defined(PROG_LANGUAGE_FRENCH)
"Programme Privilgi",
"Privilgi",
"Annuler",
#elif defined(PROG_LANGUAGE_GERMAN)
"Erlesenes Programm",
"Erlesen",
"Heben",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Scegliere Il Programma",
"Scegliere",
"Annullare",
#elif defined(PROG_LANGUAGE_DUTCH)
"Uitgezocht Programma",
"Uitgezocht",
"Annuleer",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Selecione Programa",
"Selecione",
"Cancelamento",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utvalgt Program",
"Utvalgt",
"Kanseller",
#else
"Select Program",
"Select",
"Cancel",
#endif
	    gtk_entry_get_text(entry),		/* Startup path */
	    ftype, total_ftypes,
	    &path_rtn, &total_path_rtns,
	    &ftype_rtn
	);
	FileBrowserSetTransientFor(NULL);

	/* Got user response? */
	if(status)
	{
	    const gchar *path = (total_path_rtns > 0) ?
		path_rtn[0] : NULL;
	    if(!STRISEMPTY(path))
		gtk_entry_set_text(entry, path);
	}

	/* Delete file types list */
	FileBrowserDeleteTypeList(ftype, total_ftypes);
}


/*
 *	GtkToggleButton "toggled" signal callback.
 *
 *	Sets the GtkWidget specified by data to be sensitive if
 *	toggled.
 */
static void EDVOptionsToggledSensitiveCB(GtkWidget *widget, gpointer data)
{
	GtkWidget *w = (GtkWidget *)data;
	if((widget == NULL) || (w == NULL))
	    return;

	GTK_WIDGET_SET_SENSITIVE(
	    w,
	    GTK_TOGGLE_BUTTON_GET_ACTIVE(widget)
	);
}

/*
 *	GtkToggleButton "toggled" signal callback.
 *
 *	Sets the GtkWidget specified by data to be insensitive if
 *      toggled.
 */
static void EDVOptionsToggledInsensitiveCB(GtkWidget *widget, gpointer data)
{
	GtkWidget *w = (GtkWidget *)data;
	if((widget == NULL) || (w == NULL))
	    return;

	GTK_WIDGET_SET_SENSITIVE(
	    w,
	    !GTK_TOGGLE_BUTTON_GET_ACTIVE(widget)
	);
}


/*
 *	Creates the Misc Page.
 */
static void EDVCreateOptionsMiscPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	gpointer entry_rtn, browse_rtn;
	GtkAdjustment *adj;
	GtkWidget *w, *parent2, *parent3, *parent4;
	optwin_wref_struct *wref;


	/* Memory Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Memoria"
#elif defined(PROG_LANGUAGE_FRENCH)
"Mmoire"
#elif defined(PROG_LANGUAGE_GERMAN)
"Erinnerung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Memoria"
#elif defined(PROG_LANGUAGE_DUTCH)
"Herinnering"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Memria"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Hukommelse"
#else
"Memory"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_hbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	w = EDVNewPixmapWidget(
	    core_ptr,
	    (guint8 **)icon_memory_32x32_xpm,
	    "icon_memory_32x32_xpm"
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Conserve Memory */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Conserve La Memoria"
#elif defined(PROG_LANGUAGE_FRENCH)
"Prserver La Mmoire"
#elif defined(PROG_LANGUAGE_GERMAN)
"Konservieren Sie Erinnerung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Conservare La Memoria"
#elif defined(PROG_LANGUAGE_DUTCH)
"Bewaar Herinnering"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Conserve Memria"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Konserver Hukommelse"
#else
"Conserve Memory"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"Verifique esto aminorar el uso de la memoria (esto puede ir ms\
 despacio el desempeo e incapacitar guardar de recursos)"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vrifier ceci pour minimiser l'usage de mmoire (ceci peut ralentir\
 l'excution et rend infirme cache de ressources)"
#elif defined(PROG_LANGUAGE_GERMAN)
"Prfen sie dies, speichergebrauch (dies kann verlangsamen leistung\
 und machen zu minimieren, unwirksam aufnehmend in den cachespeicher\
 von ressourcen)"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Controllare questo per minimizzare l'uso di memoria (questo pu\
 rallentare l'esecuzione e  incapace il caching di risorse)"
#elif defined(PROG_LANGUAGE_DUTCH)
"Controleer dit om herinnering gebruik (deze Mei vertraagt\
 prestatie te minimaliseren en maak onbruikbaar caching van\
 hulpbronnen)"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verifique isto reduzir uso de memria (isto vai mais devagar\
 desempenho e incapacita esconde de recursos)"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sjekk dette minimalisere hukommelsesbruk (dette kan saktner\
 prestasjon og udyktiggjr caching av ressurser)"
#else
"Check this to minimize memory use (this may slow down performance\
 and disable caching of resources)"
#endif
	);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_CONSERVE_MEMORY
	);


	/* Pointer Operations Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Las Operaciones De La Flecha"
#elif defined(PROG_LANGUAGE_FRENCH)
"Oprations De Pointeur"
#elif defined(PROG_LANGUAGE_GERMAN)
"Zeiger Betriebe"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Le Operazioni Di Indicatore"
#elif defined(PROG_LANGUAGE_DUTCH)
"Wijzer Werkingen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"As Operaes De Pointer"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Viser Operations"
#else
"Pointer Operations"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_hbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	w = EDVNewPixmapWidget(
	    core_ptr,
	    (guint8 **)icon_device_pointers_32x32_xpm,
	    "icon_device_pointers_32x32_xpm"
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Lists Middle Click Scrolls */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"El Clic Mediano Desplaza Las Listas"
#elif defined(PROG_LANGUAGE_FRENCH)
"Le Dclic De Milieu Dfile Des Listes"
#elif defined(PROG_LANGUAGE_GERMAN)
"Mittleres Klicken Rollt Listen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Lo Scatto Medio Scorre Degli Elenchi"
#elif defined(PROG_LANGUAGE_DUTCH)
"Middenklik Rolt Lijsten"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Scrolls De Estalido De Meio Alista"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"MidtClick Scrolls Lists"
#else
"Middle Click Scrolls Lists"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"Verifique esto permitir el clic mediano desplazando de listas,\
 de otro modo el clic mediano realiza la operacin de la rebelda\
 de listas"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vrifier ceci pour rendre capable le milieu cliquete dfile de\
 listes, autrement le milieu cliquete excute l'opration de\
 dfaut des listes"
#elif defined(PROG_LANGUAGE_GERMAN)
"Prfen sie dies, mittleres klicken rollen der listen zu\
 ermchtigen, fhrt sonst das mittlere klicken den standardbetrieb\
 der listen durch"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Controllare questo per permettere lo scatto medio scorre di\
 elenchi, altrimenti lo scatto medio esegue l'operazione\
 predefinita degli elenchi"
#elif defined(PROG_LANGUAGE_DUTCH)
"Controleer dit om aan de gelegenheid Middenklik te geven, die van\
 lijsten verrollen, verricht anders de Middenklik de\
 Standaardwerking van de lijsten"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verifique isto capacitar scrolling de estalido de meio de listas,\
 contrariamente o estalido de meio executa a operao de omisso\
 das listas"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sjekk dette muliggjre midtklikkrulling av lister, gjennomfrer\
 ellers midtklikken opplistingenes standarddrift"
#else
"Check this to enable middle click scrolling of lists, otherwise\
 the middle click performs the lists' default operation"
#endif
	);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_LISTS_MIDDLE_CLICK_SCROLL
	);

	/* Right Click Select Item & Map Menu */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Escoja Antes De Trazar Mens De Chasquido De Derecho"
#elif defined(PROG_LANGUAGE_FRENCH)
"Choisir Avant Les Menus De Dclic De Droite De Mapping"
#elif defined(PROG_LANGUAGE_GERMAN)
"Whlen Sie Vor Aufzeichnen Von Recht Klicken Mens Aus"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Scegliere Prima Mapping Fa Clic Col Pulsante Destro Dei Menu"
#elif defined(PROG_LANGUAGE_DUTCH)
"Selecteer Voor Brengen In Kaart Recht Klik Menu's"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Selecione Antes De Mapping Cardpios Direitos De Estalido"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utvalgt Before Mapping Right Click Menus"
#else
"Select Before Mapping Right Click Menus"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"El cheque este si usted quiere que el artculo bajo la flecha para sea\
 escogido cuando usted traza el men correcto del chasquido"
#elif defined(PROG_LANGUAGE_FRENCH)
"Le chque ceci si vous voulez que l'article sous le pointeur soit\
 choisi quand vous la carte le bon menu de dclic"
#elif defined(PROG_LANGUAGE_GERMAN)
"Kontrolle dieses, wenn Sie den Punkt unter dem Zeiger wollen,\
 ausgewhlt zu werden, wenn Sie das richtige Klicken Men\
 aufzeichnen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'assegno questo se lei vuole che l'articolo sotto l'indicatore di\
 essere scelto quando lei la mappa il fa clic col pulsante destro il\
 menu"
#elif defined(PROG_LANGUAGE_DUTCH)
"Controle deze indien u het onderdeel onder de wijzer wil\
 geselecteerd te worden wanneer u in kaart het juist klik menu\
 brengt"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verificar este se quer o item sob o pointer ser selecionado\
 quando voc mapa o cardpio direito de estalido"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Kontroll dette om De vil ha tingen under viseren valgt ut nr De\
 kartlegger den riktige klikkmeny"
#else
"Check this if you want the item under the pointer to be selected\
 when you map the right click menu"
#endif
	);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_RIGHT_CLICK_MENU_SELECTS
	);


	/* History frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Historia"
#elif defined(PROG_LANGUAGE_FRENCH)
"Histoire"
#elif defined(PROG_LANGUAGE_GERMAN)
"Geschichte"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Storia"
#elif defined(PROG_LANGUAGE_DUTCH)
"Geschiedenis"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Histria"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Historie"
#else
"History"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_hbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

#if 0
	w = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	w = EDVNewPixmapWidget(
	    core_ptr,
	    (guint8 **)icon_trace_32x32_xpm,
	    "icon_trace_32x32_xpm"
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
#endif

	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* History Events Log Prompt */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	w = GUIPromptBarWithBrowse(
	    (guint8 **)icon_trace_20x20_xpm,
	    NULL,
	    NULL, &entry_rtn, &browse_rtn,
	    NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"Entre el archivo del tronco de la historia"
#elif defined(PROG_LANGUAGE_FRENCH)
"Entrer le fichier de journal de bord d'histoire"
#elif defined(PROG_LANGUAGE_GERMAN)
"Tragen sie die geschichte klotz akte ein"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Entrare il file di ceppo di storia"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ga het geschiedenis boomstronk dossier binnen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Entre o arquivo de tora de histria"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"G inn i historieloggarkivet"
#else
"Enter the history log file"
#endif
	);
	EDVEntrySetDND(core_ptr, w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_FILE_HISTORY
	);
	w = (GtkWidget *)browse_rtn;
	GUISetWidgetTip(w, "Browse");
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(EDVOptionsBrowseCB), entry_rtn
	);


	/* History Events Max */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Label */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Los Acontecimientos Mximos"
#elif defined(PROG_LANGUAGE_FRENCH)
"Evnements Maximums"
#elif defined(PROG_LANGUAGE_GERMAN)
"Maximale Ereignisse"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Gli Avvenimenti Massimi"
#elif defined(PROG_LANGUAGE_DUTCH)
"Maximale Gebeurtenissen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Acontecimentos Mximos"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Maksimum Begivenheter"
#else
"Maximum Events"
#endif
	    ":"
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	/* Spin */
	adj = (GtkAdjustment *)gtk_adjustment_new(
	    0.0f, 0.0f, 1000000.0f,
	    10.0f, 100.0f, 100.0f
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 80, -1);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_HISTORY_EVENTS_MAX
	);

	/* Clear History Events Button */
#if 0
	w = gtk_vbox_new(TRUE, 0);
	gtk_box_pack_end(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent5 = w;
#endif
	w = GUIButtonPixmapLabelH(
	    (guint8 **)icon_clear_20x20_xpm,
#if defined(PROG_LANGUAGE_SPANISH)
"Claro History Events"
#elif defined(PROG_LANGUAGE_FRENCH)
"Clair History Events"
#elif defined(PROG_LANGUAGE_GERMAN)
"Klar History Events"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Chiaro History Events"
#elif defined(PROG_LANGUAGE_DUTCH)
"Helder History Events"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Claro History Events"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Klar History Events"
#else
"Clear History Events"
#endif
	    , NULL
	);
	gtk_box_pack_end(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(EDVClearHistoryCB), core_ptr
	);
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"El clic para borrar los acontecimientos de la historia apuntan el archivo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Le dclic pour effacer les vnements d'histoire notent le fichier"
#elif defined(PROG_LANGUAGE_GERMAN)
"Klicken, den geschichte ereignisse klotz zu lschen, legt ab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Lo scatto di cancellare gli avvenimenti di storia abbattono il file"
#elif defined(PROG_LANGUAGE_DUTCH)
"Klik het geschiedenis gebeurtenissen boomstronk dossier te schrappen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O estalido anular os acontecimentos de histria registrar arquivo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Klikk stryke historie begiven hets loggar kivet"
#else
"Click to delete the History Events Log File"
#endif
	);
	wref = OptWinWRefAppend(optwin, w, NULL, NULL);
	wref->ignore_changes = TRUE;
	gtk_widget_show(w);


	/* Hbox for clear history buttons */
	w = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	/* Clear Locations History Button */
	w = GUIButtonPixmapLabelH(
	    (guint8 **)icon_clear_20x20_xpm,
#if defined(PROG_LANGUAGE_SPANISH)
"Claro Locations History"
#elif defined(PROG_LANGUAGE_FRENCH)
"Clair Locations History"
#elif defined(PROG_LANGUAGE_GERMAN)
"Klar Locations History"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Chiaro Locations History"
#elif defined(PROG_LANGUAGE_DUTCH)
"Helder Locations History"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Claro Locations History"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Klar Locations History"
#else
"Clear Locations History"
#endif
	    , NULL
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(EDVClearLocationsHistoryCB), core_ptr
	);
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"El clic para borrar los Archivos del Tronco de la Historia de Ubicaciones"
#elif defined(PROG_LANGUAGE_FRENCH)
"Le dclic pour effacer les Fichiers de Journal de bord d'Histoire d'Emplacements"
#elif defined(PROG_LANGUAGE_GERMAN)
"Klicken, die Orte Geschichte Klotz Akten zu lschen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Lo scatto di cancellare i File di Ceppo di Storia di Posizioni"
#elif defined(PROG_LANGUAGE_DUTCH)
"Klik de Plaatzen Geschiedenis Boomstronk te schrappen Archiveert"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O estalido anular os Arquivos de Tora de Histria de Localidades"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Klikk stryke plasserings historie logg Arkivene"
#else
"Click to delete the Locations History Log Files"
#endif
	);
	wref = OptWinWRefAppend(optwin, w, NULL, NULL);
	wref->ignore_changes = TRUE;
	gtk_widget_show(w);

	/* Clear Run History Button */
	w = GUIButtonPixmapLabelH(
	    (guint8 **)icon_clear_20x20_xpm,
#if defined(PROG_LANGUAGE_SPANISH)
"Claro Run History"
#elif defined(PROG_LANGUAGE_FRENCH)
"Clair Run History"
#elif defined(PROG_LANGUAGE_GERMAN)
"Klar Run History"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Chiaro Run History"
#elif defined(PROG_LANGUAGE_DUTCH)
"Helder Run History"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Claro Run History"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Klar Run History"
#else
"Clear Run History"
#endif
	    , NULL
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(EDVClearRunHistoryCB), core_ptr
	);
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"El clic para borrar el Corre la Historia el Archivo del Tronco"
#elif defined(PROG_LANGUAGE_FRENCH)
"Le dclic pour effacer le Fichier de Journal de bord d'Histoire de Course"
#elif defined(PROG_LANGUAGE_GERMAN)
"Klicken, die Lauf Geschichte Klotz Akte zu lschen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Lo scatto di cancellare il Ha Corso il File di Ceppo di Storia"
#elif defined(PROG_LANGUAGE_DUTCH)
"Klik het Tocht Geschiedenis Boomstronk Dossier te schrappen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O estalido anular o Arquivo de Tora de Histria de Corrida"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Klikk stryke lphistorie logg Arkivet"
#else
"Click to delete the Run History Log File"
#endif
	);
	wref = OptWinWRefAppend(optwin, w, NULL, NULL);
	wref->ignore_changes = TRUE;
	gtk_widget_show(w);


}

/*
 *	Creates the Sound Page.
 */
static void EDVCreateOptionsSoundsPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	gpointer label_rtn, entry_rtn, browse_rtn;
	GtkWidget	*w, *parent2, *parent3,
			*use_system_sounds_check;
	optwin_wref_struct *wref;

	/* Sounds Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Los Sonidos"
#elif defined(PROG_LANGUAGE_FRENCH)
"Sons"
#elif defined(PROG_LANGUAGE_GERMAN)
"Klnge"
#elif defined(PROG_LANGUAGE_ITALIAN)
"I Suoni"
#elif defined(PROG_LANGUAGE_DUTCH)
"Geluiden"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Sons"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Lyder"
#else
"Sound"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;


	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Use System Sounds */
	use_system_sounds_check = w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"El Sistema Del Uso Suena"
#elif defined(PROG_LANGUAGE_FRENCH)
"Le Systme D'Usage Semble"
#elif defined(PROG_LANGUAGE_GERMAN)
"Benutzen Sie Systemklnge"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Sistema Di Uso Sembra"
#elif defined(PROG_LANGUAGE_DUTCH)
"Gebruik Systeem Geluiden"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Sistema De Uso Soa"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bruk SystemLyder"
#else
"Use System Sounds"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"Verifique este juego los sonidos definidos por el sistema para\
 los acontecimientos correspondientes"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vrifier cette pice les sons dfinis par le systme pour les\
 vnements qui correspond"
#elif defined(PROG_LANGUAGE_GERMAN)
"Prfen sie dieses spiel, das die klnge durch das system fr\
 die entsprechenden ereignisse definiert haben"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Controllare questo gioco i suoni definiti dal sistema per gli\
 avvenimenti corrispondenti"
#elif defined(PROG_LANGUAGE_DUTCH)
"Controleer deze toneelstuk, dat de geluiden door het systeem\
 voor de overeenkomende gebeurtenissen definieerden"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verifique este jogo os sons definidos pelo sistema para os\
 acontecimentos correspondentes"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sjekk dette skuespillet det lyder-definerte ved det systemet\
 for de korresponderende begivenhetene"
#else
"Check this play the sounds defined by the system for the\
 corresponding events"
#endif
	);
	gtk_widget_show(w);                                      
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_SOUND_USE_SYSTEM
	);

	w = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);


	/* Play Beep Sound Command */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(use_system_sounds_check), "toggled",
	    GTK_SIGNAL_FUNC(EDVOptionsToggledInsensitiveCB), w
	);
	gtk_widget_show(w);
	parent3 = w;
	w = GUIPromptBarWithBrowse(
	    NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"Orden Sonido Juego \"Beep\""
#elif defined(PROG_LANGUAGE_FRENCH)
"L'Ordre Son \"Beep\" Pice"
#elif defined(PROG_LANGUAGE_GERMAN)
"Spielen \"Beep\" Gesunden Befehl"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Comando Suono \"Beep\" Gioco"
#elif defined(PROG_LANGUAGE_DUTCH)
"Speel \"Beep\" Geluid Bevel"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Comando Som \"Beep\" Jogo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Lek \"Beep\" Sunn Kommando"
#else 
"Play \"Beep\" Sound Command"
#endif
	    ":", &label_rtn, &entry_rtn, &browse_rtn,
	     NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"Entre la orden que jugar un sonido para todos acontecimientos\
 de \"Beep\" o saldr este blanco para no jugar un sonido"
#elif defined(PROG_LANGUAGE_FRENCH)
"Entrer l'ordre qui jouera un son pour tous vnements de \"Beep\" ou\
 part ce vide pour ne pas jouer un son"
#elif defined(PROG_LANGUAGE_GERMAN)
"Tragen sie den befehl, der einen klang fr alle \"Beep\" ereignisse\
 spielen wird, ein oder verlassen sie diese leerstelle, keinen\
 klang zu spielen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Entrare il comando che giocher un suono per tutto gli\
 avvenimenti di \"Beep\" o lasciare lo spazio vuoto di questo per non\
 di giocare un suono"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ga het bevel dat een geluid voor alle \"Beep\" gebeurtenissen\
 spelen zal binnen of verlaat deze leegte om geen geluid te\
 spelen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Entre o comando que jogar um som para todos acontecimentos\
 de \"Beep\" ou saia desta lacuna no jogar um som"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"G inn i kommandoen som leker en lyd for all \"Beep\" begivenheter\
 eller forlate dette tomromet ikke leke en lyd"
#else
"Enter the command that will play a sound for all \"Beep\" events\
 or leave this blank to not play a sound"
#endif
	);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_SOUND_PLAY_BEEP
	);
	w = (GtkWidget *)browse_rtn;
	GUISetWidgetTip(w, "Browse");
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(EDVOptionsBrowseProgramCB), entry_rtn
	);
	w = GUIButtonPixmap(
	    (guint8 **)icon_run_20x20_xpm
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(EDVOptionsRunCB), entry_rtn
	);
	GUISetWidgetTip(w, "Test"); 
	gtk_widget_show(w);


	/* Play Info Sound Command */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(use_system_sounds_check), "toggled",
	    GTK_SIGNAL_FUNC(EDVOptionsToggledInsensitiveCB), w
	);
	gtk_widget_show(w);
	parent3 = w;
	w = GUIPromptBarWithBrowse(
	    NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"Orden Sonido Juego \"Info\""
#elif defined(PROG_LANGUAGE_FRENCH)
"L'Ordre Son \"Info\" Pice"
#elif defined(PROG_LANGUAGE_GERMAN)
"Spielen \"Info\" Gesunden Befehl"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Comando Suono \"Info\" Gioco"
#elif defined(PROG_LANGUAGE_DUTCH)
"Speel \"Info\" Geluid Bevel"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Comando Som \"Info\" Jogo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Lek \"Info\" Sunn Kommando"
#else
"Play \"Info\" Sound Command"
#endif
	    ":", &label_rtn, &entry_rtn, &browse_rtn,
	     NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"Entre la orden que jugar un sonido para todos acontecimientos\
 de \"Info\" o saldr este blanco para no jugar un sonido"
#elif defined(PROG_LANGUAGE_FRENCH)
"Entrer l'ordre qui jouera un son pour tous vnements de \"Info\" ou\
 part ce vide pour ne pas jouer un son"
#elif defined(PROG_LANGUAGE_GERMAN)
"Tragen sie den befehl, der einen klang fr alle \"Info\" ereignisse\
 spielen wird, ein oder verlassen sie diese leerstelle, keinen\
 klang zu spielen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Entrare il comando che giocher un suono per tutto gli\
 avvenimenti di \"Info\" o lasciare lo spazio vuoto di questo per non\
 di giocare un suono"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ga het bevel dat een geluid voor alle \"Info\" gebeurtenissen\
 spelen zal binnen of verlaat deze leegte om geen geluid te\
 spelen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Entre o comando que jogar um som para todos acontecimentos\
 de \"Info\" ou saia desta lacuna no jogar um som"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"G inn i kommandoen som leker en lyd for all \"Info\" begivenheter\
 eller forlate dette tomromet ikke leke en lyd"
#else
"Enter the command that will play a sound for all \"Info\" events\
 or leave this blank to not play a sound"
#endif
	);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_SOUND_PLAY_INFO
	);
	w = (GtkWidget *)browse_rtn;
	GUISetWidgetTip(w, "Browse");
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(EDVOptionsBrowseProgramCB), entry_rtn
	);
	w = GUIButtonPixmap(
	    (guint8 **)icon_run_20x20_xpm
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(EDVOptionsRunCB), entry_rtn
	);
	GUISetWidgetTip(w, "Test");
	gtk_widget_show(w);

	/* Play Question Sound */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(use_system_sounds_check), "toggled",
	    GTK_SIGNAL_FUNC(EDVOptionsToggledInsensitiveCB), w
	);
	gtk_widget_show(w);
	parent3 = w;
	w = GUIPromptBarWithBrowse(
	    NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"Orden Sonido Juego \"Question\""
#elif defined(PROG_LANGUAGE_FRENCH)
"L'Ordre Son \"Question\" Pice"
#elif defined(PROG_LANGUAGE_GERMAN)
"Spielen \"Question\" Gesunden Befehl"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Comando Suono \"Question\" Gioco"
#elif defined(PROG_LANGUAGE_DUTCH)
"Speel \"Question\" Geluid Bevel"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Comando Som \"Question\" Jogo"         
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Lek \"Question\" Sunn Kommando"
#else
"Play \"Question\" Sound Command"
#endif
	    ":", &label_rtn, &entry_rtn, &browse_rtn,
	     NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	GUISetWidgetTip(w, 
#if defined(PROG_LANGUAGE_SPANISH)
"Entre la orden que jugar un sonido para todos acontecimientos\
 de \"Question\" o saldr este blanco para no jugar un sonido"
#elif defined(PROG_LANGUAGE_FRENCH)
"Entrer l'ordre qui jouera un son pour tous vnements de \"Question\" ou\
 part ce vide pour ne pas jouer un son"
#elif defined(PROG_LANGUAGE_GERMAN)
"Tragen sie den befehl, der einen klang fr alle \"Question\" ereignisse\
 spielen wird, ein oder verlassen sie diese leerstelle, keinen\
 klang zu spielen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Entrare il comando che giocher un suono per tutto gli\
 avvenimenti di \"Question\" o lasciare lo spazio vuoto di questo per non\
 di giocare un suono"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ga het bevel dat een geluid voor alle \"Question\" gebeurtenissen\
 spelen zal binnen of verlaat deze leegte om geen geluid te\
 spelen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Entre o comando que jogar um som para todos acontecimentos\
 de \"Question\" ou saia desta lacuna no jogar um som"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"G inn i kommandoen som leker en lyd for all \"Question\" begivenheter\
 eller forlate dette tomromet ikke leke en lyd"
#else 
"Enter the command that will play a sound for all \"Question\" events\
 or leave this blank to not play a sound"
#endif
	);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_SOUND_PLAY_QUESTION
	);
	w = (GtkWidget *)browse_rtn;
	GUISetWidgetTip(w, "Browse");
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(EDVOptionsBrowseProgramCB), entry_rtn
	);
	w = GUIButtonPixmap(
	    (guint8 **)icon_run_20x20_xpm
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(EDVOptionsRunCB), entry_rtn
	);
	GUISetWidgetTip(w, "Test");
	gtk_widget_show(w);

	/* Play Warning Sound */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(use_system_sounds_check), "toggled",
	    GTK_SIGNAL_FUNC(EDVOptionsToggledInsensitiveCB), w
	);
	gtk_widget_show(w); 
	parent3 = w;
	w = GUIPromptBarWithBrowse(
	    NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"Orden Sonido Juego \"Warning\""
#elif defined(PROG_LANGUAGE_FRENCH)
"L'Ordre Son \"Warning\" Pice"
#elif defined(PROG_LANGUAGE_GERMAN)
"Spielen \"Warning\" Gesunden Befehl"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Comando Suono \"Warning\" Gioco"
#elif defined(PROG_LANGUAGE_DUTCH)
"Speel \"Warning\" Geluid Bevel"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Comando Som \"Warning\" Jogo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Lek \"Warning\" Sunn Kommando"
#else
"Play \"Warning\" Sound Command"
#endif  
	    ":", &label_rtn, &entry_rtn, &browse_rtn,
	     NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"Entre la orden que jugar un sonido para todos acontecimientos\
 de \"Warning\" o saldr este blanco para no jugar un sonido"
#elif defined(PROG_LANGUAGE_FRENCH)
"Entrer l'ordre qui jouera un son pour tous vnements de \"Warning\" ou\
 part ce vide pour ne pas jouer un son"
#elif defined(PROG_LANGUAGE_GERMAN)
"Tragen sie den befehl, der einen klang fr alle \"Warning\" ereignisse\
 spielen wird, ein oder verlassen sie diese leerstelle, keinen\
 klang zu spielen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Entrare il comando che giocher un suono per tutto gli\
 avvenimenti di \"Warning\" o lasciare lo spazio vuoto di questo per non\
 di giocare un suono"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ga het bevel dat een geluid voor alle \"Warning\" gebeurtenissen\
 spelen zal binnen of verlaat deze leegte om geen geluid te\
 spelen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Entre o comando que jogar um som para todos acontecimentos\
 de \"Warning\" ou saia desta lacuna no jogar um som"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"G inn i kommandoen som leker en lyd for all \"Warning\" begivenheter\
 eller forlate dette tomromet ikke leke en lyd"
#else
"Enter the command that will play a sound for all \"Warning\" events\
 or leave this blank to not play a sound"
#endif
	);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_SOUND_PLAY_WARNING
	);
	w = (GtkWidget *)browse_rtn;
	GUISetWidgetTip(w, "Browse");
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(EDVOptionsBrowseProgramCB), entry_rtn
	);
	w = GUIButtonPixmap(
	    (guint8 **)icon_run_20x20_xpm
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(EDVOptionsRunCB), entry_rtn
	);
	GUISetWidgetTip(w, "Test");
	gtk_widget_show(w);

	/* Play Error Sound */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(use_system_sounds_check), "toggled",
	    GTK_SIGNAL_FUNC(EDVOptionsToggledInsensitiveCB), w
	);
	gtk_widget_show(w);
	parent3 = w;
	w = GUIPromptBarWithBrowse(
	    NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"Orden Sonido Juego \"Error\""
#elif defined(PROG_LANGUAGE_FRENCH)
"L'Ordre Son \"Error\" Pice"
#elif defined(PROG_LANGUAGE_GERMAN)
"Spielen \"Error\" Gesunden Befehl"      
#elif defined(PROG_LANGUAGE_ITALIAN)
"Comando Suono \"Error\" Gioco"
#elif defined(PROG_LANGUAGE_DUTCH)
"Speel \"Error\" Geluid Bevel"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Comando Som \"Error\" Jogo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Lek \"Error\" Sunn Kommando"
#else
"Play \"Error\" Sound Command"
#endif
	    ":", &label_rtn, &entry_rtn, &browse_rtn,
	     NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"Entre la orden que jugar un sonido para todos acontecimientos\
 de \"Error\" o saldr este blanco para no jugar un sonido"
#elif defined(PROG_LANGUAGE_FRENCH)
"Entrer l'ordre qui jouera un son pour tous vnements de \"Error\" ou\
 part ce vide pour ne pas jouer un son"
#elif defined(PROG_LANGUAGE_GERMAN)
"Tragen sie den befehl, der einen klang fr alle \"Error\" ereignisse\
 spielen wird, ein oder verlassen sie diese leerstelle, keinen\
 klang zu spielen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Entrare il comando che giocher un suono per tutto gli\
 avvenimenti di \"Error\" o lasciare lo spazio vuoto di questo per non\
 di giocare un suono"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ga het bevel dat een geluid voor alle \"Error\" gebeurtenissen\
 spelen zal binnen of verlaat deze leegte om geen geluid te\
 spelen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Entre o comando que jogar um som para todos acontecimentos\
 de \"Error\" ou saia desta lacuna no jogar um som"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"G inn i kommandoen som leker en lyd for all \"Error\" begivenheter\
 eller forlate dette tomromet ikke leke en lyd"
#else
"Enter the command that will play a sound for all \"Error\" events\
 or leave this blank to not play a sound"
#endif
	);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_SOUND_PLAY_ERROR
	);
	w = (GtkWidget *)browse_rtn;
	GUISetWidgetTip(w, "Browse");
	gtk_signal_connect( 
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(EDVOptionsBrowseProgramCB), entry_rtn
	);
	w = GUIButtonPixmap(
	    (guint8 **)icon_run_20x20_xpm
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(EDVOptionsRunCB), entry_rtn
	);
	GUISetWidgetTip(w, "Test");
	gtk_widget_show(w);

	/* Play Operation Completed Sound Command */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(use_system_sounds_check), "toggled",
	    GTK_SIGNAL_FUNC(EDVOptionsToggledInsensitiveCB), w
	);
	gtk_widget_show(w);
	parent3 = w;
	w = GUIPromptBarWithBrowse(
	    NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"Orden Sonido Juego \"Operation Completed\""
#elif defined(PROG_LANGUAGE_FRENCH)
"L'Ordre Son \"Operation Completed\" Pice"
#elif defined(PROG_LANGUAGE_GERMAN)
"Spielen \"Operation Completed\" Gesunden Befehl"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Comando Suono \"Operation Completed\" Gioco"
#elif defined(PROG_LANGUAGE_DUTCH)
"Speel \"Operation Completed\" Geluid Bevel"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Comando Som \"Operation Completed\" Jogo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Lek \"Operation Completed\" Sunn Kommando"
#else 
"Play \"Operation Completed\" Sound Command"
#endif
	    ":", &label_rtn, &entry_rtn, &browse_rtn,
	     NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;  
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"Entre la orden que jugar un sonido para todos acontecimientos\
 de \"Operation Completed\" o saldr este blanco para no jugar un sonido"
#elif defined(PROG_LANGUAGE_FRENCH)
"Entrer l'ordre qui jouera un son pour tous vnements de \"Operation Completed\" ou\
 part ce vide pour ne pas jouer un son"
#elif defined(PROG_LANGUAGE_GERMAN)
"Tragen sie den befehl, der einen klang fr alle \"Operation Completed\" ereignisse\
 spielen wird, ein oder verlassen sie diese leerstelle, keinen\
 klang zu spielen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Entrare il comando che giocher un suono per tutto gli\
 avvenimenti di \"Operation Completed\" o lasciare lo spazio vuoto di questo per non\
 di giocare un suono"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ga het bevel dat een geluid voor alle \"Operation Completed\" gebeurtenissen\
 spelen zal binnen of verlaat deze leegte om geen geluid te\
 spelen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Entre o comando que jogar um som para todos acontecimentos\
 de \"Operation Completed\" ou saia desta lacuna no jogar um som"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"G inn i kommandoen som leker en lyd for all \"Operation Completed\" begivenheter\
 eller forlate dette tomromet ikke leke en lyd"
#else
"Enter the command that will play a sound for all \"Operation Completed\" events\
 or leave this blank to not play a sound"
#endif
	);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_SOUND_PLAY_COMPLETED
	);
	w = (GtkWidget *)browse_rtn;
	GUISetWidgetTip(w, "Browse");
	gtk_signal_connect(     
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(EDVOptionsBrowseProgramCB), entry_rtn
	);
	w = GUIButtonPixmap(
	    (guint8 **)icon_run_20x20_xpm
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(EDVOptionsRunCB), entry_rtn
	);
	GUISetWidgetTip(w, "Test");
	gtk_widget_show(w);


	/* Reset initial Use System Sounds value */
	GTK_TOGGLE_BUTTON(use_system_sounds_check)->active =
	    CFGItemListGetValueI(
		core_ptr->cfg_list,
		EDV_CFG_PARM_SOUND_USE_SYSTEM
	    );
	gtk_signal_emit_by_name(
	    GTK_OBJECT(use_system_sounds_check), "toggled"
	);

}

/*
 *      Creates the Date & Time Page.
 */
static void EDVCreateOptionsDatePage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	gchar *heading[2];
	GSList *gslist;
	gpointer label_rtn, entry_rtn;
	GtkWidget *w, *parent2, *parent3;
	GtkCList *clist;
	DateFormatSampleData *d;
	optwin_wref_struct *wref;


	/* Relativity frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Tiempo Relativo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Temps Relatif"
#elif defined(PROG_LANGUAGE_GERMAN)
"Abhngigkeit"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Relativit"
#elif defined(PROG_LANGUAGE_DUTCH)
"Relativiteit"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Relativity"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Relativity"
#else
"Relativity"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Absolute radio button */
	gslist = NULL;
	w = gtk_radio_button_new_with_label(
	    gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Absoluto"
#elif defined(PROG_LANGUAGE_FRENCH)
"Absolu"
#elif defined(PROG_LANGUAGE_GERMAN)
"Absolut"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Assoluto"
#elif defined(PROG_LANGUAGE_DUTCH)
"Absoluut"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Absoluto"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Absolutt"
#else
"Absolute"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"Verifique esto demostrar la fecha & el pariente de cuerdas de tiempo\
 al tiempo del principio of definido para el locale actual"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vrifier ceci pour montrer la date & les ficelles de temps relatives\
 au temps de of premier dfini pour le locale actuel"
#elif defined(PROG_LANGUAGE_GERMAN)
"Prfen sie dies, datum & zeit schnre verwandten zum beginnen der\
 zeit darzustellen, fr den jetzigen schauplatz hat definiert"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Controlla questo mostrare data & tempo relativo all'inizio di tempo\
 definito per l'attuale locale"
#elif defined(PROG_LANGUAGE_DUTCH)
"Controleer dit om datum & tijd koorden verwandte aan het beginnen\
 van tijd te tonen voor de huidig locale definieerde"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verifique isto exibir data & parente de barbantes de tempo ao comeo\
 de tempo definido para o locale atual"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sjekk dette vise dato & tidssnorslektning til begynningen av\
 tid-definert for den nvrendee locale"
#else
"Check this to display date & time strings relative to the beginning of\
 time defined for the current locale"
#endif
	);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_DATE_RELATIVITY
	);
	wref->radio_value = EDV_DATE_RELATIVITY_ABSOLUTE;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Current radio button */
	w = gtk_radio_button_new_with_label(
	    gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"La Corriente"
#elif defined(PROG_LANGUAGE_FRENCH)
"Courant"
#elif defined(PROG_LANGUAGE_GERMAN)
"Strmung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Corrente"
#elif defined(PROG_LANGUAGE_DUTCH)
"Stroom"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Corrente"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Strm"
#else
"Current"
#endif
	);
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"Verifique esto demostrar la fecha & el pariente de cuerdas de tiempo\
 al tiempo actual"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vrifier ceci pour montrer la date & les ficelles de temps relatives\
 au temps actuel"
#elif defined(PROG_LANGUAGE_GERMAN)
"Prfen sie dies, datum & zeit schnre verwandten zum jetzigen mal\
 darzustellen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Controllare questo per mostrare la data & le cordicelle di tempo\
 relative al tempo attuale"
#elif defined(PROG_LANGUAGE_DUTCH)
"Controleer dit om datum & tijd koorden verwandte aan de huidig tijd\
 te tonen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verifique isto exibir data & parente de barbantes de tempo ao tempo\
 atual"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sjekk dette vise dato & tidssnorslektning til den nvrendee tiden"
#else
"Check this to display date & time strings relative to the current time"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_DATE_RELATIVITY
	);
	wref->radio_value = EDV_DATE_RELATIVITY_CURRENT;


	/* Date format */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Formato De La Fecha"
#elif defined(PROG_LANGUAGE_FRENCH)
"Dater Le Format"
#elif defined(PROG_LANGUAGE_GERMAN)
"Datieren Sie Format"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Datare Il Formato"
#elif defined(PROG_LANGUAGE_DUTCH)
"Dateer Formaat"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Date Formato"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Dater Format"
#else
"Date Format"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Create Date Format Sample Data */
	d = DATE_FORMAT_SAMPLE_DATA(
	    g_malloc0(sizeof(DateFormatSampleData))
	);


	/* Hbox for Format String */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Format String */
	w = GUIPromptBar(
	    NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"Formatear Cuerda"
#elif defined(PROG_LANGUAGE_FRENCH)
"Ficelle De format"
#elif defined(PROG_LANGUAGE_GERMAN)
"Formatieren Sie Schnur"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Cordicella Di formato"
#elif defined(PROG_LANGUAGE_DUTCH)
"Formatteer Koord"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barbante De Formato"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Formater String"
#else
"Format String"
#endif
	    ":", &label_rtn, &entry_rtn
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);

	w = (GtkWidget *)entry_rtn;
	d->format_entry = w;
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"Entre la cuerda de formato por toda fecha demostrada & los valores\
 de tiempo (vea la lista abajo para sustituciones disponibles)"
#elif defined(PROG_LANGUAGE_FRENCH)
"Entrer la ficelle de format pour toute date montre & les valeurs\
 de temps (la liste d'vch au dessous pour les remplacements disponibles)"
#elif defined(PROG_LANGUAGE_GERMAN)
"Tragen die format schnur fr alles dargestellte datum & zeit werte\
 (siehe liste unten fr verfgbaren austausch)"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Entrare la cordicella di formato per tutta la data mostrata & i\
 valori di tempo (vedere l'elenco al di sotto per le sostituzioni disponibili)"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ga het formaat koord voor alle getoonde datum & tijd waarde binnen\
 (zie lijst beneden voor verkrijgbare substituties)"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Entre a barbante de formato para toda data exibida & valores de\
 tempo (veja lista embaixo para substituies disponveis)"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"G inn i formatsnoret for all vist dato & tidsverdier (se liste under\
 for tilgjengelige substitusjoner)"
#else
"Enter the format string for displaying all date & time values\
 (see list below for available substitutions)"
#endif
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "activate",
	    GTK_SIGNAL_FUNC(EDVOptionsDateFormatSampleUpdateCB), d
	);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_DATE_FORMAT
	);


	/* Hbox for Sample */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Sample */
	w = GUIPromptBar(
	    NULL,
	    "Sample:", &label_rtn, &entry_rtn
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	d->sample_entry = w;
	gtk_entry_set_editable(GTK_ENTRY(w), FALSE);
	wref = OptWinWRefAppend(optwin, w, NULL, NULL);
	wref->ignore_changes = TRUE;
	gtk_object_set_data_full(
	    GTK_OBJECT(w), DATE_FORMAT_SAMPLE_DATA_KEY,
	    d, EDVOptionsDateFormatSampleDataDestroyCB
	);

	/* Update Button */
	w = GUIButtonPixmapLabelH(
	    (guint8 **)icon_reload_20x20_xpm,
	    "Update",
	    NULL
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(EDVOptionsDateFormatSampleUpdateCB), d
	);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(optwin, w, NULL, NULL);
	wref->ignore_changes = TRUE;

	/* Format String Substitutions List */
	/* GtkScrolledWindow */
	w = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(         
	    GTK_SCROLLED_WINDOW(w),
	    GTK_POLICY_AUTOMATIC,
	    GTK_POLICY_AUTOMATIC
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
	gtk_widget_show(w);                                    
	parent3 = w;
	/* GtkCList */
	heading[0] = "Substitution";
	heading[1] = "Description";
	w = gtk_clist_new_with_titles(2, heading);
	clist = GTK_CLIST(w);                                         
	gtk_widget_add_events(
	    w,
	    GDK_STRUCTURE_MASK | GDK_EXPOSURE_MASK |
	    GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK |
	    GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK |
	    GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK |
	    GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "map_event",
	    GTK_SIGNAL_FUNC(EDVOptionsDateFormatListEventCB), d
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "unmap_event",
	    GTK_SIGNAL_FUNC(EDVOptionsDateFormatListEventCB), d
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_press_event",
	    GTK_SIGNAL_FUNC(EDVCListKeyEventCB), core_ptr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_release_event",
	    GTK_SIGNAL_FUNC(EDVCListKeyEventCB), core_ptr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_press_event",
	    GTK_SIGNAL_FUNC(EDVCListButtonEventCB), core_ptr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_release_event",
	    GTK_SIGNAL_FUNC(EDVCListButtonEventCB), core_ptr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "motion_notify_event",
	    GTK_SIGNAL_FUNC(EDVCListMotionEventCB), core_ptr
	);
	gtk_clist_column_titles_passive(clist);
	gtk_clist_column_titles_show(clist);
	gtk_clist_set_shadow_type(clist, GTK_SHADOW_IN);
	gtk_clist_set_selection_mode(clist, GTK_SELECTION_SINGLE);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_widget_show(w);

	wref = OptWinWRefAppend(optwin, w, NULL, NULL);
	wref->ignore_changes = TRUE;

}


/*
 *      Creates the Confirmation Page on options window.
 */
static void EDVCreateOptionsConfirmationPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	const gchar *s;
	GtkWidget *w, *parent2, *parent3, *parent4;
	optwin_wref_struct *wref;

#define CREATE_CHECK(icon_d,icon_n,label,parm)	{	\
 w = gtk_hbox_new(FALSE, border_minor);		\
 gtk_box_pack_start(				\
  GTK_BOX(parent3), w, FALSE, FALSE, 0		\
 );						\
 gtk_widget_show(w);				\
 parent4 = w;					\
 /* Icon */					\
 if((icon_d) != NULL) {				\
  w = EDVNewPixmapWidget(			\
   core_ptr, (guint8 **)(icon_d), (icon_n)	\
  );						\
  gtk_box_pack_start(				\
   GTK_BOX(parent4), w, FALSE, FALSE, 0		\
  );						\
  gtk_widget_show(w);				\
 }						\
 /* Check button */				\
 w = gtk_check_button_new_with_label(label);	\
 gtk_box_pack_start(				\
  GTK_BOX(parent4), w, FALSE, FALSE, 0		\
 );						\
 gtk_widget_show(w);				\
 wref = OptWinWRefAppend(			\
  optwin, w, NULL, (parm)			\
 );						\
}

	/* Confirm When frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Confirme Cundo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Confirmer Quand"
#elif defined(PROG_LANGUAGE_GERMAN)
"Besttigen Sie Wenn"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Confermare Quando"
#elif defined(PROG_LANGUAGE_DUTCH)
"Bevestiig Wanneer"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Confirme Quando"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bekreft Nr"
#else
"Confirm When"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;


	/* Vbox for general operation confirmations */
	w = gtk_vbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Moving An Object */
	s =
#if defined(PROG_LANGUAGE_SPANISH)
"Mover Un Objeto"
#elif defined(PROG_LANGUAGE_FRENCH)
"Dmnagement D'Un Objet"
#elif defined(PROG_LANGUAGE_GERMAN)
"Bewegen Eines Objekts"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Trasloco Di Un Oggetto"
#elif defined(PROG_LANGUAGE_DUTCH)
"Bewegen Van Een Voorwerp"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Mover Um Objeto"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Flytting Av Et Objekt"
#else
"Moving An Object"
#endif
	;
	CREATE_CHECK(
	    icon_move_file_20x20_xpm,
	    "icon_move_file_20x20_xpm",
	    s,
	    EDV_CFG_PARM_CONFIRM_MOVE
	);

	/* Copying An Object */
	s =
#if defined(PROG_LANGUAGE_SPANISH)
"Copiar Un Objeto"
#elif defined(PROG_LANGUAGE_FRENCH)
"Copier Un Objet"
#elif defined(PROG_LANGUAGE_GERMAN)
"Kopieren Eines Objekts"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Copiare Un Oggetto"
#elif defined(PROG_LANGUAGE_DUTCH)
"Kopiren Van Een Voorwerp"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Copiar Um Objeto"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Kopiering Av Et Objekt"
#else
"Copying An Object"
#endif
	;
	CREATE_CHECK(
	    icon_copy_file_20x20_xpm,
	    "icon_copy_file_20x20_xpm",
	    s,
	    EDV_CFG_PARM_CONFIRM_COPY
	);

	/* Linking An Object */
	s =
#if defined(PROG_LANGUAGE_SPANISH)
"Ligar Un Objeto"
#elif defined(PROG_LANGUAGE_FRENCH)
"Relier Un Objet"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verknpfen Eines Objekts"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Concatenare Un Oggetto"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verbinden Van Een Voorwerp"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Ligao Um Objeto"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Forbinding Av Et Objekt"
#else
"Linking An Object"
#endif
	;
	CREATE_CHECK(
	    icon_link2_20x20_xpm,
	    "icon_link2_20x20_xpm",
	    s,
	    EDV_CFG_PARM_CONFIRM_LINK
	);

	/* Deleting An Object */
	s =
#if defined(PROG_LANGUAGE_SPANISH)
"Borrar Un Objeto"
#elif defined(PROG_LANGUAGE_FRENCH)
"Effacer Un Objet"
#elif defined(PROG_LANGUAGE_GERMAN)
"Lschen Eines Objekts"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Cancellare Un Oggetto"
#elif defined(PROG_LANGUAGE_DUTCH)
"Schrappen Van Een Voorwerp"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Anular Um Objeto"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Stryking Av Et Objekt"
#else
"Deleting An Object"
#endif
	;
	CREATE_CHECK(
	    icon_cancel_20x20_xpm,
	    "icon_cancel_20x20_xpm",
	    s,
	    EDV_CFG_PARM_CONFIRM_DELETE
	);


	/* Vbox for archive operation confirmations */
	w = gtk_vbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Adding An Object To An Archive */
	s =
#if defined(PROG_LANGUAGE_SPANISH)
"Agregar Un Objeto A Un Archivo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Ajouter Un Objet A Une Archive"
#elif defined(PROG_LANGUAGE_GERMAN)
"Hinzufgen Eines Objekts Zu Einem Archiv"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'aggiunta Di Un Oggetto A Un'Archivio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Toevoegen Van Een Voorwerp Te Een Archief"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Adicionar Um Objeto A Um Arquivo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tilfying Av Et Objekt Til Et Arkiv"
#else
"Adding An Object To An Archive"
#endif
	;
	CREATE_CHECK(
	    icon_archive_add_20x20_xpm,
	    "icon_archive_add_20x20_xpm",
	    s,
	    EDV_CFG_PARM_CONFIRM_ARCHIVE_ADD
	);

	/* Extracting An Object From An Archive */
	s =
#if defined(PROG_LANGUAGE_SPANISH)
"Extraer Un Objeto De Un Archivo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Extraire Un Objet D'Une Archive"
#elif defined(PROG_LANGUAGE_GERMAN)
"Extrahieren Eines Objekts Von Einem Archiv"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Estrarre Un Oggetto Da Un'Archivio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Onttrekken Van Een Voorwerp Van Een Archief"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Extrair Um Objeto De Um Arquivo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Trekking Ut Av Et Objekt Fra Et Arkiv"
#else
"Extracting An Object From An Archive"
#endif
	;
	CREATE_CHECK(
	    icon_archive_extract_20x20_xpm,
	    "icon_archive_extract_20x20_xpm",
	    s,
	    EDV_CFG_PARM_CONFIRM_ARCHIVE_EXTRACT
	);

	/* Deleting An Object In An Archive */
	s =
#if defined(PROG_LANGUAGE_SPANISH)
"Borrar Un Objeto En Un Archivo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Effacer Un Objet Dans Une Archive"
#elif defined(PROG_LANGUAGE_GERMAN)
"Lschen Eines Objekts In Einem Archiv"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Cancellare Un Oggetto In Un'Archivio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Schrappen Van Een Voorwerp In Een Archief"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Anular Um Objeto NUm Arquivo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Stryking Av Et Objekt I Et Arkiv"
#else
"Deleting An Object In An Archive"
#endif
	;
	CREATE_CHECK(
	    icon_cancel_20x20_xpm,
	    "icon_cancel_20x20_xpm",
	    s,
	    EDV_CFG_PARM_CONFIRM_ARCHIVE_DELETE
	);


	/* Vbox for recycled object operation confirmations */
	w = gtk_vbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Recovering An Object From The Recycle Bin */
	s =
#if defined(PROG_LANGUAGE_SPANISH)
"Recuperar Un Objeto Del Cajn del Recirculacin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Retrouver Un Objet Du Recycle L'Huche"
#elif defined(PROG_LANGUAGE_GERMAN)
"Wiedererlangen Eines Objekts Vom Verwertet Behlter Wieder"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Ricuperare Un Oggetto Dal Contenitore Per La Raccolta Differenziata"
#elif defined(PROG_LANGUAGE_DUTCH)
"Terugkrijgen Van Een Voorwerp Van Het Recyclt Bak"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Recuperar Um Objeto DO Recicla Caixa"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utvinning Av Et Objekt Fra Den Resirkulasjons Beholderen"
#else
"Recovering An Object From The Recycle Bin"
#endif
	;
	CREATE_CHECK(
	    icon_recover_20x20_xpm,
	    "icon_recover_20x20_xpm",
	    s,
	    EDV_CFG_PARM_CONFIRM_RECOVER
	);

	/* Purging An Object From The Recycle Bin */
	s =
#if defined(PROG_LANGUAGE_SPANISH)
"Purgando Un Objeto Del Cajn del Recirculacin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Purger Un Objet Du Recycle l'Huche"
#elif defined(PROG_LANGUAGE_GERMAN)
"Reinigung Eines Objekts Vom Verwertet Behlter Wieder"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Proscioglimento Un Oggetto Dal Contenitore Per La Raccolta Differenziata"
#elif defined(PROG_LANGUAGE_DUTCH)
"Reinigen Van Een Voorwerp Van Het Recyclt Bak"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Purgue Um Objeto DO Recicla Caixa"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Rensing av Et Objekt Fra Den Resirkulasjons Beholderen"
#else
"Purging An Object From The Recycle Bin"
#endif
	;
	CREATE_CHECK(
	    icon_purge_20x20_xpm,
	    "icon_purge_20x20_xpm",
	    s,
	    EDV_CFG_PARM_CONFIRM_PURGE
	);


	/* Vbox for other object operation confirmations */
	w = gtk_vbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Downloading An Object */
	s =
#if defined(PROG_LANGUAGE_SPANISH)
"Descargar Un Objeto"
#elif defined(PROG_LANGUAGE_FRENCH)
"Tlcharger Un Objet"
#elif defined(PROG_LANGUAGE_GERMAN)
"Laden Eines Objekts"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Scaricare Un Oggetto"
#elif defined(PROG_LANGUAGE_DUTCH)
"Downloaden Van Een Voorwerp"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Download Um Objeto"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Downloading Et Objekt"
#else
"Downloading An Object"
#endif
	;
	CREATE_CHECK(
	    icon_planet_20x20_xpm,
	    "icon_planet_20x20_xpm",
	    s,
	    EDV_CFG_PARM_CONFIRM_DOWNLOAD
	);

#undef CREATE_CHECK
}

/*
 *      Creates the Programs Page on options window.
 */
static void EDVCreateOptionsProgramsPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	guint8 **icon;
	const gchar *label;
	gpointer label_rtn, entry_rtn, browse_rtn;
	GtkWidget *w, *parent2, *parent3;
	optwin_wref_struct *wref;


	/* Create a scrolled window to allow scrolling through the many
	 * widgets on this page
	 */
	parent2 = EDVScrolledWindowNew(
	    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC,
	    NULL, &w
	);
	gtk_box_pack_start(GTK_BOX(parent), parent2, TRUE, TRUE, 0);
	gtk_widget_show(parent2);

	gtk_box_set_spacing(GTK_BOX(w), border_major);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	parent2 = w;

#define DO_CREATE_PROMPT(_parent_,_parm_) {	\
 GtkWidget *w, *box;				\
						\
 box = w = gtk_hbox_new(FALSE, border_minor);	\
 gtk_box_pack_start(				\
  GTK_BOX(_parent_), w, FALSE, FALSE, 0		\
 );						\
 gtk_widget_show(w);				\
						\
 /* Create Prompt */				\
 w = GUIPromptBarWithBrowse(			\
  icon, label,					\
  &label_rtn, &entry_rtn, &browse_rtn,		\
  NULL, NULL					\
 );						\
 gtk_box_pack_start(				\
  GTK_BOX(box), w, TRUE, TRUE, 0		\
 );						\
 gtk_widget_show(w);				\
						\
 /* Set up browse button */			\
 w = (GtkWidget *)browse_rtn;			\
 if(w != NULL) {				\
  GUISetWidgetTip(w, "Browse");			\
  gtk_signal_connect(				\
   GTK_OBJECT(w), "clicked",			\
   GTK_SIGNAL_FUNC(EDVOptionsBrowseProgramCB),	\
   entry_rtn					\
  );						\
 }						\
						\
 /* Set up entry */				\
 w = (GtkWidget *)entry_rtn;			\
 if(w != NULL) {				\
  EDVEntrySetDND(core_ptr, w);			\
  wref = OptWinWRefAppend(			\
   optwin, w, NULL, _parm_			\
  );						\
 }						\
						\
 /* Create Run Button */			\
 w = GUIButtonPixmap(				\
  (guint8 **)icon_run_20x20_xpm			\
 );						\
 gtk_box_pack_start(				\
  GTK_BOX(box), w, FALSE, FALSE, 0		\
 );						\
 gtk_signal_connect(				\
  GTK_OBJECT(w), "clicked",			\
  GTK_SIGNAL_FUNC(EDVOptionsRunCB), entry_rtn	\
 );						\
 GUISetWidgetTip(w, "Test");			\
 gtk_widget_show(w);				\
}

        /* Viewers Frame */
        w = gtk_frame_new("Viewers");
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;

        icon = NULL;
        label = "Default Viewer:";
        DO_CREATE_PROMPT(parent3, EDV_CFG_PARM_PROG_DEF_VIEWER)


	/* Terminal Programs Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Las Terminales"
#elif defined(PROG_LANGUAGE_FRENCH)
"Terminaux"
#elif defined(PROG_LANGUAGE_GERMAN)
"Terminale"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Le Estremit"
#elif defined(PROG_LANGUAGE_DUTCH)
"Eindpunten"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Terminais"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Terminaler"
#else
"Terminals"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	icon = (guint8 **)icon_terminal_20x20_xpm;
	label =
#if defined(PROG_LANGUAGE_SPANISH)
"La Terminal"
#elif defined(PROG_LANGUAGE_FRENCH)
"Terminal"
#elif defined(PROG_LANGUAGE_GERMAN)
"Terminal"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Estremit"
#elif defined(PROG_LANGUAGE_DUTCH)
"Eindpunt"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Terminal"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Terminal"
#else
"Terminal"
#endif
	":";
	DO_CREATE_PROMPT(parent3, EDV_CFG_PARM_PROG_TERMINAL)

	icon = (guint8 **)icon_terminal_run_20x20_xpm;
	label =
#if defined(PROG_LANGUAGE_SPANISH)
"Terminal & Corra Program"
#elif defined(PROG_LANGUAGE_FRENCH)
"Terminal & Courir Program"
#elif defined(PROG_LANGUAGE_GERMAN)
"Terminal & Lauf Programmiert"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Estremit & Ha Corso Il Programma"
#elif defined(PROG_LANGUAGE_DUTCH)
"Eindpunt & Tocht Programma"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Terminal & Programa De Corrida"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Terminal & Run Program"
#else
"Terminal & Run Program"
#endif
	":";
	DO_CREATE_PROMPT(parent3, EDV_CFG_PARM_PROG_TERMINAL_RUN)


	/* Archiver programs frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Archivo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Archive"
#elif defined(PROG_LANGUAGE_GERMAN)
"Archiv"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Archivio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Archief"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Arquivo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arkiv"
#else
"Archivers"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	icon = NULL;
	label = "ARJ:";
	DO_CREATE_PROMPT(parent3, EDV_CFG_PARM_PROG_ARJ)

	icon = NULL;
	label = "LHA:";
	DO_CREATE_PROMPT(parent3, EDV_CFG_PARM_PROG_LHA)

	icon = NULL;
	label = "RAR:";
	DO_CREATE_PROMPT(parent3, EDV_CFG_PARM_PROG_RAR)

	icon = NULL;
	label = "RPM:";
	DO_CREATE_PROMPT(parent3, EDV_CFG_PARM_PROG_RPM)

	icon = NULL;
	label = "TAR:";
	DO_CREATE_PROMPT(parent3, EDV_CFG_PARM_PROG_TAR)

	icon = NULL;
	label = "Zip:";
	DO_CREATE_PROMPT(parent3, EDV_CFG_PARM_PROG_ZIP)

	icon = NULL;
	label = "UnZip:";
	DO_CREATE_PROMPT(parent3, EDV_CFG_PARM_PROG_UNZIP)

	icon = NULL;
	label = "Compress:";
	DO_CREATE_PROMPT(parent3, EDV_CFG_PARM_PROG_COMPRESS)

	icon = NULL;
	label = "UnCompress:";
	DO_CREATE_PROMPT(parent3, EDV_CFG_PARM_PROG_UNCOMPRESS)

	icon = NULL;
	label = "GZip:";
	DO_CREATE_PROMPT(parent3, EDV_CFG_PARM_PROG_GZIP)

	icon = NULL;
	label = "GUnZip:";
	DO_CREATE_PROMPT(parent3, EDV_CFG_PARM_PROG_GUNZIP)

	icon = NULL;
	label = "BZip2:";
	DO_CREATE_PROMPT(parent3, EDV_CFG_PARM_PROG_BZIP2)

	icon = NULL;
	label = "BUnZip2:";
	DO_CREATE_PROMPT(parent3, EDV_CFG_PARM_PROG_BUNZIP2)

	/* Network programs frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Red"
#elif defined(PROG_LANGUAGE_FRENCH)
"Rseau"
#elif defined(PROG_LANGUAGE_GERMAN)
"Netz"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Rete"
#elif defined(PROG_LANGUAGE_DUTCH)
"Net"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Rede"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Nettverk"
#else
"Network"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	icon = (guint8 **)icon_planet_20x20_xpm;
	label =
#if defined(PROG_LANGUAGE_SPANISH)
"La Descarga"
#elif defined(PROG_LANGUAGE_FRENCH)
"Chargement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Laden Sie"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Scaricare"
#elif defined(PROG_LANGUAGE_DUTCH)
"Download"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Download"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Download"
#else
"Download"
#endif
	":";
	DO_CREATE_PROMPT(parent3, EDV_CFG_PARM_PROG_NET_DOWNLOAD)

	icon = (guint8 **)icon_mailbox_20x20_xpm;
	label =
#if defined(PROG_LANGUAGE_SPANISH)
"Enve A Cliente"
#elif defined(PROG_LANGUAGE_FRENCH)
"Client De Courrier"
#elif defined(PROG_LANGUAGE_GERMAN)
"Postkunde"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Cliente Di Posta"
#elif defined(PROG_LANGUAGE_DUTCH)
"Postklant"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Remeta Cliente"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Post Client"
#else
"E-Mail Client"
#endif
	":";
	DO_CREATE_PROMPT(parent3, EDV_CFG_PARM_PROG_MAIL_CLIENT)


#undef DO_CREATE_PROMPT
}

/*
 *      Creates the Display Page on options window.
 */
static void EDVCreateOptionsDisplayPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	GList *glist;
	gpointer combo_rtn;
	GtkWidget *w, *parent2, *parent3;
	optwin_wref_struct *wref;


	/* Image Quality Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Imagine La Calidad"
#elif defined(PROG_LANGUAGE_FRENCH)
"Qualit D'Image"
#elif defined(PROG_LANGUAGE_GERMAN)
"Bildnis Qualitt"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Qualit Di Immagine"
#elif defined(PROG_LANGUAGE_DUTCH)
"Beeld Kwaliteit"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Qualidade De Imagem"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Avbilde Quality"
#else
"Image Quality"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Hbox for image quality combo */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Create list of image quality setting strings, enumerated
	 * to match the image quality values in the cfg list
	 */
	glist = NULL;
#define APPEND(s)	glist = g_list_append(glist, (s))
#if defined(PROG_LANGUAGE_SPANISH)
	APPEND("Pobre/Rapidamente");
	APPEND("El Medio/Optimul");
	APPEND("Mejor/Ms Lento");
#elif defined(PROG_LANGUAGE_FRENCH)
	APPEND("Pauvre/Jene");
	APPEND("Milieu/Optimul");
	APPEND("Mieux/Plus Lent");
#elif defined(PROG_LANGUAGE_GERMAN)
	APPEND("Arm/Schnellsten");
	APPEND("Medium/Ideal");
	APPEND("Besten/Langsamsten");
#elif defined(PROG_LANGUAGE_ITALIAN)
	APPEND("Povero/Digiuno");
	APPEND("Mezzo/Ottima");
	APPEND("Meglio/Pi Lento");
#elif defined(PROG_LANGUAGE_DUTCH)
	APPEND("Arm/Snel");
	APPEND("Middel/Optimaal");
	APPEND("Best/Langzaam");
#elif defined(PROG_LANGUAGE_PORTUGUESE)
	APPEND("Pobre/Rpido");
	APPEND("Mdio/Optimal");
	APPEND("Melhor/Lento");
#elif defined(PROG_LANGUAGE_NORWEGIAN)
	APPEND("Fattig/Fortest");
	APPEND("Middel/Optimal");
	APPEND("Best/Langsom");
#else
	APPEND("Poor/Fastest");
	APPEND("Medium/Optimal");
	APPEND("Best/Slowest");
#endif
#undef APPEND
	/* Image Quality Combo */
	w = (GtkWidget *)GUIComboCreate(
	    NULL,
	    (const gchar *)((glist != NULL) ? glist->data : ""),
	    glist,				/* List */
	    MAX(g_list_length(glist), 1),	/* Items in list */
	    &combo_rtn,
	    NULL,
	    NULL,
	    NULL
	);
	g_list_free(glist);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	w = (GtkWidget *)combo_rtn;
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMAGE_QUALITY
	);

	w = GTK_COMBO(w)->entry;
	gtk_widget_set_usize(w, 160, -1);
	gtk_entry_set_editable(GTK_ENTRY(w), FALSE);


	/* Lists frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Las Listas"
#elif defined(PROG_LANGUAGE_FRENCH)
"Listes"
#elif defined(PROG_LANGUAGE_GERMAN)
"Listen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Gli Elenchi"
#elif defined(PROG_LANGUAGE_DUTCH)
"Lijsten"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"As Listas"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Lister"
#else
"Lists"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;


	/* Hbox for animated list updates */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	/* Animated List Updates Check */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Anime Actualice"
#elif defined(PROG_LANGUAGE_FRENCH)
"Animer Des Mises A Jour"
#elif defined(PROG_LANGUAGE_GERMAN)
"Lebende Aktualisierungen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Animare Gli Aggiornamenti"
#elif defined(PROG_LANGUAGE_DUTCH)
"Levende Herziening"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Anime Atualiza"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Opplivende Updates"
#else
"Animate Updates"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"Verifique esto animar artculos de lista durante actualiza (donde\
 disponible)"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vrifier ceci pour animer les articles de liste pendant les mises \
 jour (o disponible)"
#elif defined(PROG_LANGUAGE_GERMAN)
"Prfen Sie dies, Liste Punkte whrend Aktualisierungen (wo verfgbar)\
 zu beleben"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Controllare questo per animare gli articoli di elenco durante gli\
 aggiornamenti (dove disponibile)"
#elif defined(PROG_LANGUAGE_DUTCH)
"Controleer dit om lijst onderdelen gedurende herziening (waar\
 verkrijgbaar) te bezielen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verifique isto animar itens de lista durante atualizar (onde\
 disponvel)"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sjekk dette live opp listeting i lpet av oppdateringer (hvor\
 tilgjengelig)"
#else
"Check this to animate list updates, this produces a slower but more\
 verbose update"
#endif
	);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_LISTS_ANIMATE_UPDATES
	);

	/* Hbox for double buffer */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	/* Double Buffer Check */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"La Memoria Intermedia Doble"
#elif defined(PROG_LANGUAGE_FRENCH)
"Tampon Double"
#elif defined(PROG_LANGUAGE_GERMAN)
"Doppelpuffer"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Tampone Doppio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Dubbele Buffer"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Memria Dupla Intermediria"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Dobbel Buffer"
#else
"Double Buffer"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"Verifique esto usar las memorias intermedias dobles para listas,\
 esto producir ms liso actualiza pero va ms despacio el desempeo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vrifier ceci pour utiliser des tampons doubles pour les listes,\
 ceci produira des mises  jour plus lisses mais ralentit l'excution"
#elif defined(PROG_LANGUAGE_GERMAN)
"Prfen sie dies, doppelpuffer fr listen, dies wird herstellen\
 glattere aktualisierungen zu benutzen, aber verlangsamen sie leistung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Controllare questo per usare i tamponi doppi per gli elenchi, questo\
 produrr degli aggiornamenti pi lisci ma rallenta l'esecuzione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Controleer dit om dubbele buffers voor lijsten, dit zal produceren\
 gladdere herziening te gebruiken, maar prestatie vertraagt"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verifique isto usar memrias duplas intermediria para listas, isto\
 produzir mais liso atualiza mas vai mais devagar desempenho"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sjekk dette bruke dobble buffere for lister, dette produserer glatt\
 oppdateringer men saktner prestasjon"
#else
"Check this to use double buffers for lists, this will produce\
 smoother updates but slow down performance"
#endif
	);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_LISTS_DOUBLE_BUFFER
	);

	/* Hbox for tree expand optimize position */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	/* Double Buffer Check */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Optimice La Posicin De Ensanchar De Arbol"
#elif defined(PROG_LANGUAGE_FRENCH)
"Optimiser L'Arbre Augmente La Position"
#elif defined(PROG_LANGUAGE_GERMAN)
"Optimieren Sie Baum Ausbreitet Position"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Ottimizzare L'Albero Allarga La Posizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Optimaliseer Boom Uitbreidt Positie"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A rvore De Optimize Expande Posio"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Optimer Tre Utvider Posisjon"
#else
"Optimize Tree Expand Position"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"Verifique esto desplazar automticamente las listas de rbol a las\
 la mayora de las posiciones de la optimul cuando ensanchar ramifica"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vrifier ceci automatiquement pour dfiler les listes d'arbre au plus\
 de optimul la position en augmentant diverge"
#elif defined(PROG_LANGUAGE_GERMAN)
"Prfen sie dies automatisch, baum listen zur meisten optimul position\
 zu rollen, beim ausbreiten abzweigt"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Controllare questo automaticamente per scorrere gli elenchi di albero\
 al la maggior parte della posizione di optimul quando allargare dirama"
#elif defined(PROG_LANGUAGE_DUTCH)
"Controleer dit automatisch om boom lijsten aan de meeste optimul\
 positie te rollen wanneer uitbreiden aftakt"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verifique isto a automaticamente listas de rvore de scroll a mais\
 posio de optimul quando expandir ramos"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sjekk dette automatisk rulle trelister til den meste optimul\
 posisjon ved deler seg utvide"
#else
"Check this to automatically scroll tree lists to the most\
 optimul position when expanding branches"
#endif
	);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_TREE_EXPAND_OPTIMIZE_POS
	);




}

/*
 *      Creates the General Page on options window.
 */
static void EDVCreateOptionsGeneralPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	gpointer entry_rtn, browse_rtn;
	GtkWidget *w, *parent2, *parent3, *parent4;
	optwin_wref_struct *wref;
	GSList *gslist;


	/* Create a scrolled window to allow scrolling through the many
	 * widgets on this page
	 */
	parent2 = EDVScrolledWindowNew(
	    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC,
	    NULL, &w
	);
	gtk_box_pack_start(GTK_BOX(parent), parent2, TRUE, TRUE, 0);
	gtk_widget_show(parent2);

	gtk_box_set_spacing(GTK_BOX(w), border_major);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	parent = w;


	/* Startup With frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Arranque Con"
#elif defined(PROG_LANGUAGE_FRENCH)
"Mettre En Route Avec"
#elif defined(PROG_LANGUAGE_GERMAN)
"Start Mit"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Avvio Con"
#elif defined(PROG_LANGUAGE_DUTCH)
"Start Met"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Startup Com"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Oppstarting With"
#else
"Startup With"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;


	w = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* File Browser Toggle */
	w = GUIToggleButtonPixmapLabelV(
	    (guint8 **)endeavour_48x48_xpm,
#if defined(PROG_LANGUAGE_SPANISH)
"Examinador\nArchivo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Browser\nFichier"
#elif defined(PROG_LANGUAGE_GERMAN)
"Datei\nBrowser"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Schedare\nBrowser"
#elif defined(PROG_LANGUAGE_DUTCH)
"Archiveer\nBrowser"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Arquive\nBrowser"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arkiver\nBrowser"
#else
"File\nBrowser"
#endif
	    , NULL
	);
	gtk_widget_set_usize(w, 80, 80);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_STARTUP_BROWSER
	);

	/* Image Browser Toggle */
	w = (GtkWidget *)GUIToggleButtonPixmapLabelV(
	    (guint8 **)image_browser_48x48_xpm,
#if defined(PROG_LANGUAGE_SPANISH)
"Examinador\nImagen"
#elif defined(PROG_LANGUAGE_FRENCH)
"Browser\nD'Image"
#elif defined(PROG_LANGUAGE_GERMAN)
"Bildnis\nBrowser"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Browser\nImmagine"
#elif defined(PROG_LANGUAGE_DUTCH)
"Beeld\nBrowser"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Browser\nImagem"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Avbilde\nBrowser"
#else
"Image\nBrowser"
#endif
	    , NULL
	);
	gtk_widget_set_usize(w, 80, 80);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_STARTUP_IMBR
	);

	/* Archiver Toggle */
	w = (GtkWidget *)GUIToggleButtonPixmapLabelV(
	    (guint8 **)archiver_48x48_xpm,
#if defined(PROG_LANGUAGE_SPANISH)
"Fabricante\nArchivo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Archiver\nFabricant"
#elif defined(PROG_LANGUAGE_GERMAN)
"Archivieren\nHersteller"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Fabbricante\nArchivio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Archief\nMaker"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Criador\nArquivo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arkiv\nSkaper"
#else
"Archiver"
#endif
	    , NULL
	);
	gtk_widget_set_usize(w, 80, 80);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_STARTUP_ARCHIVER
	);

	/* Recycle Bin Toggle */
	w = (GtkWidget *)GUIToggleButtonPixmapLabelV(
	    (guint8 **)icon_trash_empty_48x48_xpm,
#if defined(PROG_LANGUAGE_SPANISH)
"Cajn\nRecirculacin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Recycler\nL'Huche"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verwerten\nBehlter"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Contenitore\nRaccolta"
#elif defined(PROG_LANGUAGE_DUTCH)
"Recycl\nBak"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Caixa\nRecycle"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Resirkulasjons\nBin"
#else
"Recycle\nBin"
#endif
	    , NULL
	);
	gtk_widget_set_usize(w, 80, 80);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_STARTUP_RECBIN
	);


	/* Startup Location frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Ubicacin De Startup"
#elif defined(PROG_LANGUAGE_FRENCH)
"Emplacement De Dmarrage"
#elif defined(PROG_LANGUAGE_GERMAN)
"Start Ort"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Posizione Di Avvio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Start Plaats"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Localidade De Startup"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Oppstarting Location"
#else
"Startup Location"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Startup Directory Prompt */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	w = GUIPromptBarWithBrowse(
	    (guint8 **)icon_folder_opened_20x20_xpm,
	    NULL,
	    NULL, &entry_rtn, &browse_rtn,
	    NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"Entre la ubicacin de arranque"
#elif defined(PROG_LANGUAGE_FRENCH)
"Entrer l'emplacement de dmarrage"
#elif defined(PROG_LANGUAGE_GERMAN)
"Tragen sie den start ort ein"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Entrare la posizione di avvio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ga de start plaats binnen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Entre a localidade de startup"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"G inn i opp startings plasseringen"
#else
"Enter the startup location"
#endif
	);
	EDVEntrySetDND(core_ptr, w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_DIR_START_UP
	);
	w = (GtkWidget *)browse_rtn;
	GUISetWidgetTip(w, "Browse");
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(EDVOptionsBrowseCB), entry_rtn
	);

	/* Record Startup Directory Check */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Automticamente Registro Dura La Ubicacin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Automatiquement Le Disque Dure L'Emplacement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Zeichnen Sie Automatisch Letzten Ort Auf"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Automaticamente Il Disco Dura La Posizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Automatisch Verslag Leest Plaats"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Automaticamente Registro ltima Localidade"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Automatisk Record Last Location"
#else
"Automatically Record Last Location"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"Verifique esto actualizar automticamente el arranca la ubicacin\
 para la prxima sesin basada en la ubicacin que era ltima accesado.\
 Cundo esto se verifica, usted no necesita modificar el arranca el\
 valor de la ubicacin abajo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vrifier ceci automatiquement pour mettre  jour le met\
 en route l'emplacement pour la sance prochaine base sur\
 l'emplacement qui tait dernier accessed. Quand ceci est vrifi,\
 vous n'avez pas besoin de modifier le met en route la valeur\
 d'emplacement au dessous"
#elif defined(PROG_LANGUAGE_GERMAN)
"Prfen Sie dies automatisch, das zu aktualisieren, ort startet fr\
 die nchste sitzung, die auf dem ort basiert worden ist, der letzt\
 war, auf whrend dieser Sitzung hat zugegriffen. Sie mssen das ort\
 unten nicht modifizieren startet, wenn dies geprft ist."
#elif defined(PROG_LANGUAGE_ITALIAN)
"Controlla questo automaticamente di aggiornare l'avvia posizione per\
 il prossimo sessione basato sulla posizione che era ultimo accesso\
 a durante questa sessione. Lei non ha bisogno di modificare l'avvia\
 la posizione al di sotto se questo  controllato."
#elif defined(PROG_LANGUAGE_DUTCH)
"Controleer dit automatisch om het te actualiseren opstart plaats voor\
 de volgende zitting, die op de plaats die gebaseerd is, was voriges\
 had toegang tot gedurende deze zitting. U moet het plaats onder niet\
 wijzigen opstart indien dit gecontroleerd is."
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verifique isto automaticamente atualizar o comea para localidade de\
 cima para a prxima sesso baseado na localidade que era ltimo\
 acedido durante esta sesso. Voc nao necessita modificar o comea\
 para localidade de cima embaixo se isto est verificado."
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sjekk dette automatisk oppdatere starten opp plassering for den neste\
 sesjonen basert p plasseringen var som siste kommet til i lpet av\
 denne sesjonen. De modifiserer ikke starten opp plassering under om\
 dette sjekker."
#else
"Check this to automatically update the startup location for\
 the next session based on the location that was last accessed\
 during this session.\
 You do not need to modify the startup location if this is checked."
#endif
	);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_RECORD_START_UP_DIR
	);


	/* Delete Method frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Borre Objetos Por"
#elif defined(PROG_LANGUAGE_FRENCH)
"Effacer Des Pbjets Pa"
#elif defined(PROG_LANGUAGE_GERMAN)
"Lschen Sie Objekte Durch"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Cancellare Gli Oggetti Da"
#elif defined(PROG_LANGUAGE_DUTCH)
"Schrap Voorwerpen Door"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Anule Objetos Por"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Stryk Objects By"
#else
"Delete Objects By"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Hbox for radio buttons */
	w = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	gslist = NULL;

	/* Moving To Recycle Bin */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Icon */
	w = EDVNewPixmapWidget(
	    core_ptr,
	    (guint8 **)icon_trash_20x20_xpm,
	    "icon_trash_20x20_xpm"
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	/* Radio Button */
	w = gtk_radio_button_new_with_label(
	    gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"MoverLos Al Cajn De La Recirculacin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Se Transfrer Les Au Recycler l'Huche"
#elif defined(PROG_LANGUAGE_GERMAN)
"Bewegen, Das Sie Zum Behlter Wiederverwerten"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Trasloco Loro Al Contenitore Per La Raccolta Differenziata"
#elif defined(PROG_LANGUAGE_DUTCH)
"Bewegen, Dat Hen Aan het Bak Recyclen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Mover Os  Caixa De Recycle"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Flyttende Them To The Recycle Bin"
#else
"Moving Them To The Recycle Bin"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"Verifique esto mover los objetos al Cajn de la Recirculacin cuando\
 borrarles"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vrifier ceci pour se transfrer les objets au Recycle l'Huche en\
 effaant les"
#elif defined(PROG_LANGUAGE_GERMAN)
"Prfen die dies, die objekte zum zu bewegen, Berwertet Nehlter\
 beim lschen sie wieder"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Controllare questo per muovere gli oggetti al Contenitore per la\
 raccolta differenziata quando cancellare loro"
#elif defined(PROG_LANGUAGE_DUTCH)
"Controleer dit om de voorwerpen aan het te bewegen Bak Recyclt\
 wanneer schrappen hen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verifique isto mover os objetos  Caixa de Recycle quando anular os"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sjekk dette flytte objektene til Recycle Bin ved stryke av dem"
#else
"Check this to move the objects to the Recycle Bin when deleting\
 them (default)"
#endif
	);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_DELETE_METHOD
	);
	wref->radio_value = EDV_DELETE_METHOD_MOVE_TO_RECBIN;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Purge On Delete */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Icon */
	w = EDVNewPixmapWidget(
	    core_ptr,
	    (guint8 **)icon_purge_20x20_xpm,
	    "icon_purge_20x20_xpm"
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	/* Radio Button */
	w = gtk_radio_button_new_with_label(
	    gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Permanentemente Purging Ellos"
#elif defined(PROG_LANGUAGE_FRENCH)
"D'une Faon permanente Purger Les"
#elif defined(PROG_LANGUAGE_GERMAN)
"Permanent Reinigung Sie"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Permanentemente Prosciogliere Loro"
#elif defined(PROG_LANGUAGE_DUTCH)
"Permanent Reinigen Hen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Permanentemente Purging Os"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Permanent Purging Them"
#else
"Permanently Purging Them"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"Verifique esto purgar permanentemente los objetos cuando borrarlos.\
 Los objetos borrados no se pueden recuperar utilizando este mtodo!"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vrifier ceci d'une faon permanente pour purger les objets en\
 effaant les. Les objets effacs ne peuvent pas tre retrouvs\
 l'utilisation de cette mthode!"
#elif defined(PROG_LANGUAGE_GERMAN)
"Prfen Sie dies permanent, die Objekte beim Lschen sie zu reinigen.\
 Die gelschten Objekte knnen Gebrauch dieser Methode nicht \
 wiedererlangt werden!"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Controllare questo permanentemente per prosciogliere gli oggetti\
 quando cancellare loro. Gli oggetti cancellati non possono essere\
 ricuperati per usare questo metodo!"
#elif defined(PROG_LANGUAGE_DUTCH)
"Controleer dit permanent om de voorwerpen wanneer schrappen hen te\
 reinigen. De geschrappenene voorwerpen zullen gebruik van deze\
 methode niet misschien teruggekregen worden!"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verifique isto a permanentemente purge os objetos quando anular os.\
 Os objetos anulados nao podem ser recuperados usar este mtodo!"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sjekk dette permanent rense objektene ved stryke av dem.\
 De strkne objektene utvunnet ikke bruk av denne metoden!"
#else
"Check this to permanently purge the objects when deleting them\
 (the deleted objects may not be recovered)"
#endif
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "toggled",
	    GTK_SIGNAL_FUNC(EDVOptionsWarnDeleteMethodPurge),
	    core_ptr
	);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_DELETE_METHOD
	);
	wref->radio_value = EDV_DELETE_METHOD_PURGE;


	/* Recycle Bin frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Recicle Cajn"
#elif defined(PROG_LANGUAGE_FRENCH)
"Recycler L'Huche"
#elif defined(PROG_LANGUAGE_GERMAN)
"Werfen Sie Dose Weg"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Bidone"
#elif defined(PROG_LANGUAGE_DUTCH)
"Recycl Bak"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Recicle Caixa"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Forkast Boks"
#else
"Recycle Bin"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Recycled Objects Index File */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	w = GUIPromptBarWithBrowse(
	    (guint8 **)icon_trash_20x20_xpm,
	    NULL,
	    NULL, &entry_rtn, &browse_rtn,
	    NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"Entre la ubicacin de los objetos reciclados indexa el archivo.\
 La gua reciclada de objetos ser la ubicacin (gua de padre)\
 de este archivo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Entrer l'emplacement du fichier d'index d'objets recycl.\
 L'annuaire recycl d'objets sera l'emplacement (l'annuaire de\
 parent) de ce fichier"
#elif defined(PROG_LANGUAGE_GERMAN)
"Tragen sie den ort index der wiederverwerteten objekte ablegt ein.\
 das wiederverwertete objekte Verzeichnis wird der ort (elternteil\
 verzeichnis) von dieser akte sein"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Entrare la posizione del file di indice di oggetti riciclato.\
 L'elenco di oggetti riciclato sar la posizione (l'elenco di\
 genitore) di questo file"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ga de plaats van de gerecyclde voorwerpen index dossier binnen.\
 De gerecyclde voorwerpen gids zal de plaats (ouder gids) van deze\
 dossier zijn"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Entre a localidade do arquivo reciclado de ndice de objetos. O\
 guia reciclado de objetos ser a localidade (guia de pai) deste\
 arquivo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"G inn i plasseringen av det resirkuleredde objektindeksarkiv.\
 Den resirkuleredde objektkatalog er plasseringen (moreller\
 farkatalog) av dette arkivet"
#else
"Enter the location of the Recycled Objects Index file. The\
 recycled objects directory will be the location (parent directory)\
 of this file"
#endif
	);
	EDVEntrySetDND(core_ptr, w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_FILE_RECYCLED_INDEX
	);
	w = (GtkWidget *)browse_rtn;
	GUISetWidgetTip(w, "Browse");
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(EDVOptionsBrowseCB), entry_rtn
	);

	/* Recycle Bin Size Warn */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	/* Label */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Advierta Cundo Tamao De Suma Excede"
#elif defined(PROG_LANGUAGE_FRENCH)
"Avertir Quand La Taille Totale Dpasse"
#elif defined(PROG_LANGUAGE_GERMAN)
"Warnen Sie, Wenn Gesamte Gre berschreitet"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Avvertire Quando Sommare La Misura Eccede"
#elif defined(PROG_LANGUAGE_DUTCH)
"Waarschuuw Wanneer Totaal Maat Overschrijdt"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Advirta Quando Tamanho Total Excede"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Advar When Total Size Exceeds"
#else
"Warn When Total Size Exceeds"
#endif
	    ":"
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	/* Entry */
	w = gtk_entry_new();
	gtk_widget_set_usize(w, 110, -1);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	EDVEntrySetDND(core_ptr, w);
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"Cundo el tamao total de todos objetos de recycled excede este\
 valor, una advertencia ser impresa al usuario en arranca. Usted puede\
 especificar tambin un valor de 0 en incapacitar este cheque"
#elif defined(PROG_LANGUAGE_FRENCH)
"Quand la taille totale de tous objets recycls dpasse cette valeur,\
 un avertissement sera imprim  l'utilisateur  met en route. Vous\
 pouvez spcifier aussi une valeur de 0 rendre infirme ce chque"
#elif defined(PROG_LANGUAGE_GERMAN)
"N startet die gesamte gre uberschreiten diese viele nytes aller\
 wiederverwerteten objekte, eine earnung zum berbraucher an wird\
 gedruckt werden. Sie knnen auch einen eert von 0 angeben, unwirksam\
 dieses kennzeichen zu machen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"N la misura totale di tutti gli oggetti riciclati eccede questi\
 numerosi byte, un avvertimento sar stampato all'operatore a avvia.\
 Lei pu specificare anche un valore di 0 di essere incapace questa\
 caratteristica"
#elif defined(PROG_LANGUAGE_DUTCH)
"N opstart de totale maat van alle gerecyclde voorwerpen\
 overschrijdenen deze vele-byte, een waarschuwing te de gebruiker\
 aan zal afgedrukt worden. U kan ook een waarde van 0 specificeren\
 onbruikbaar deze kenmerk te maken"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O n o tamanho total de todo recycled ope-se excede tantos bytes, um\
 aviso ser imprimido ao operador em comear para cima. Voc tambm\
 pode especificar um valor de 0 incapacitar esta caracterstica"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"N den totale strrelsen av alle resirkuleredde objektoverskrider dene\
 mange bytene, en varsling trykt til brukeren p start opp. De\
 spesifiserer ogs en verdi av 0 udyktiggjre dette kjennetegnet"
#else
"Enter the size (in bytes) that specifies when a warning will be\
 displayed (on startup) when the total size of all the recycled\
 objects has reached or exceeded this size (enter 0 to disable\
 this feature)"
#endif
	);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_RECBIN_SIZE_WARN
	);

	w = gtk_label_new("bytes");
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);


	/* Purge Recycle Bin Button */
	w = gtk_vbox_new(TRUE, 0);
	gtk_box_pack_end(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	w = GUIButtonPixmapLabelH(
	    (guint8 **)icon_purge_all_20x20_xpm,
#if defined(PROG_LANGUAGE_SPANISH)
"Purga"
#elif defined(PROG_LANGUAGE_FRENCH)
"La Purge"
#elif defined(PROG_LANGUAGE_GERMAN)
"Reinigen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Purga"
#elif defined(PROG_LANGUAGE_DUTCH)
"Zuivering"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Limpeza"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Rens"
#else
"Purge Recycle Bin"
#endif
	    , NULL
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, TRUE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(EDVPurgeAllRecycledObjectsCB), core_ptr
	);
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"Purgue todo se opone en el cajn del recirculacin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Purger tous objets dans le recycle l'huche"
#elif defined(PROG_LANGUAGE_GERMAN)
"Reinigen sie alle objekte im wiederverwerten behlter"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Prosciogliere tutto l'obbietta nel contenitore per la raccolta\
 differenziata"
#elif defined(PROG_LANGUAGE_DUTCH)
"Reiniig alle voorwerpen in het recyclen bak"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Purgue todo ope-se no recicla caixa"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Rens alle objekt i den resirkulasjons beholderen"
#else
"Click to purge all objects in the recycle bin"
#endif
	);
	wref = OptWinWRefAppend(
	    optwin, w, NULL, NULL
	);
	wref->ignore_changes = TRUE;
	gtk_widget_show(w);


	/* MIME Types frame */
	w = gtk_frame_new("MIME Types");
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Global MIME Types File Prompt */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	w = GUIPromptBarWithBrowse(
	    (guint8 **)icon_mimetypes_20x20_xpm,
	    "Global:",
	    NULL, &entry_rtn, &browse_rtn,
	    NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	GUISetWidgetTip(w,
"Enter the location of the global MIME Types file"
	);
	EDVEntrySetDND(core_ptr, w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_FILE_MIME_TYPES_GLOBAL
	);
	w = (GtkWidget *)browse_rtn;
	GUISetWidgetTip(w, "Browse");
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(EDVOptionsBrowseCB), entry_rtn
	);

	/* Local MIME Types File Prompt */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	w = GUIPromptBarWithBrowse(
	    (guint8 **)icon_mimetypes_20x20_xpm,
	    "Local:",
	    NULL, &entry_rtn, &browse_rtn,
	    NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	GUISetWidgetTip(w,
"Enter the location of the local MIME Types file"
	);
	EDVEntrySetDND(core_ptr, w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_FILE_MIME_TYPES
	);
	w = (GtkWidget *)browse_rtn;
	GUISetWidgetTip(w, "Browse");
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(EDVOptionsBrowseCB), entry_rtn
	);


	/* Devices frame */
	w = gtk_frame_new("Devices");
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Devices File Prompt */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	w = GUIPromptBarWithBrowse(
	    (guint8 **)icon_device_misc_20x20_xpm,
	    NULL,
	    NULL, &entry_rtn, &browse_rtn,
	    NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	GUISetWidgetTip(w,
"Enter the location of the Devices Reference file"
	);
	EDVEntrySetDND(core_ptr, w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_FILE_DEVICES
	);
	w = (GtkWidget *)browse_rtn;
	GUISetWidgetTip(w, "Browse");
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(EDVOptionsBrowseCB), entry_rtn
	);
}

/*
 *	Selects the notebook tab specified by tab_name for the given
 *	options window.
 */
void EDVOptionsWindowSelectTab(
	optwin_struct *optwin, const gchar *tab_name
)
{
	gint page_num;
	GtkNotebook *notebook;


	if(optwin == NULL)
	    return;

	notebook = (GtkNotebook *)optwin->notebook;
	if(notebook == NULL)
	    return;

	if(tab_name != NULL)
	{
	    if(!g_strcasecmp(tab_name, "General"))
		page_num = 0;
	    else if(!g_strcasecmp(tab_name, "Display"))
		page_num = 1;
	    else if(!g_strcasecmp(tab_name, "Programs"))
		page_num = 2;
	    else if(!g_strcasecmp(tab_name, "Confirmation"))
		page_num = 3;
	    else if(!g_strcasecmp(tab_name, "Date & Time"))
		page_num = 4;
	    else if(!g_strcasecmp(tab_name, "Misc"))
		page_num = 5;
	    else
	    {
		g_printerr(
"EDVOptionsWindowSelectTab(): Warning:\
 Invalid tab name \"%s\".\n",
		    tab_name
		);
		page_num = -1;
	    }
	}
	else
	{
	    page_num = 0;
	}

	/* Got valid page? */
	if(page_num > -1)
	    gtk_notebook_set_page(notebook, page_num);
}

/*
 *	Creates a new options window.
 */
optwin_struct *EDVCreateOptionsWindow(
	gpointer core_ptr
)
{
	const gint border_major = 5;
	GtkWidget *w, *parent, *parent2;
	optwin_struct *optwin = OptWinNew(
	    core_ptr,
#if defined(PROG_LANGUAGE_SPANISH)
"Las Opciones"
#elif defined(PROG_LANGUAGE_FRENCH)
"Options"
#elif defined(PROG_LANGUAGE_GERMAN)
"Optionen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Le Opzioni"
#elif defined(PROG_LANGUAGE_DUTCH)
"Opties"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"As Opes"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Alternativer"
#else
"Options"
#endif
	    , (guint8 **)icon_options2_48x48_xpm);
	if(optwin == NULL)
	    return(optwin);


	/* Begin creating the General Page */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"General"
#elif defined(PROG_LANGUAGE_FRENCH)
"Gnral"
#elif defined(PROG_LANGUAGE_GERMAN)
"General"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Generale"
#elif defined(PROG_LANGUAGE_DUTCH)
"Generaal"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O General"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"General"
#else
"General"
#endif
	);
	parent = OptWinPageAppend(optwin, w);
	if(parent != NULL)
	{
	    gtk_container_border_width(GTK_CONTAINER(parent), border_major);
	    gtk_box_set_spacing(GTK_BOX(parent), border_major);
	    parent2 = parent;

	    EDVCreateOptionsGeneralPage(
		EDV_CORE(core_ptr), optwin, parent2
	    );
	}

	/* Begin creating the Display Page */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Despliegue"
#elif defined(PROG_LANGUAGE_FRENCH)
"Exposition"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausstellung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Mostra"
#elif defined(PROG_LANGUAGE_DUTCH)
"Tentoonstelling"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Exposio"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utstilling"
#else
"Display"
#endif
	);
	parent = OptWinPageAppend(optwin, w);
	if(parent != NULL)
	{
	    gtk_container_border_width(GTK_CONTAINER(parent), border_major);
	    gtk_box_set_spacing(GTK_BOX(parent), border_major);
	    parent2 = parent;

	    EDVCreateOptionsDisplayPage(
		EDV_CORE(core_ptr), optwin, parent2
	    );
	}

	/* Begin creating the Programs Page */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Los Programas"
#elif defined(PROG_LANGUAGE_FRENCH)
"Programmes"
#elif defined(PROG_LANGUAGE_GERMAN)
"Programme"
#elif defined(PROG_LANGUAGE_ITALIAN)
"I Programmi"
#elif defined(PROG_LANGUAGE_DUTCH)
"Programma's"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Programas"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Programer"
#else
"Programs"
#endif
	);
	parent = OptWinPageAppend(optwin, w);
	if(parent != NULL)
	{
	    gtk_container_border_width(GTK_CONTAINER(parent), border_major);
	    gtk_box_set_spacing(GTK_BOX(parent), border_major);
	    parent2 = parent;

	    EDVCreateOptionsProgramsPage(
		EDV_CORE(core_ptr), optwin, parent2
	    );
	}

	/* Begin creating the Confirmation Page */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Confirmacin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Confirmation"
#elif defined(PROG_LANGUAGE_GERMAN)
"Besttigung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Conferma"
#elif defined(PROG_LANGUAGE_DUTCH)
"Bevestiging"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Confirmao"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bekreftelse"
#else
"Confirmation"
#endif
	);
	parent = OptWinPageAppend(optwin, w);
	if(parent != NULL)
	{
	    gtk_container_border_width(GTK_CONTAINER(parent), border_major);
	    gtk_box_set_spacing(GTK_BOX(parent), border_major);
	    parent2 = parent;

	    EDVCreateOptionsConfirmationPage(
		EDV_CORE(core_ptr), optwin, parent2
	    );
	}

	/* Begin creating the Date & Time Page */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Fecha & Tiempo"
#elif defined(PROG_LANGUAGE_FRENCH)
"La Date & Le Temps"
#elif defined(PROG_LANGUAGE_GERMAN)
"Datum & Zeit"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Data & Il Tempo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Datum & Tijd"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Data & Tempo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Dato & Time"
#else
"Date & Time"
#endif
	);
	parent = OptWinPageAppend(optwin, w);
	if(parent != NULL)
	{
	    gtk_container_border_width(GTK_CONTAINER(parent), border_major);
	    gtk_box_set_spacing(GTK_BOX(parent), border_major);
	    parent2 = parent;

	    EDVCreateOptionsDatePage(
		EDV_CORE(core_ptr), optwin, parent2
	    );
	}

	/* Begin creating the Sound Page */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Los Sonidos"
#elif defined(PROG_LANGUAGE_FRENCH)
"Sons"
#elif defined(PROG_LANGUAGE_GERMAN)
"Klnge"
#elif defined(PROG_LANGUAGE_ITALIAN)  
"I Suoni"
#elif defined(PROG_LANGUAGE_DUTCH)
"Geluiden"
#elif defined(PROG_LANGUAGE_PORTUGUESE)  
"Os Sons"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Lyder"
#else
"Sound"
#endif
	);
	parent = OptWinPageAppend(optwin, w);
	if(parent != NULL)
	{
	    gtk_container_border_width(GTK_CONTAINER(parent), border_major);
	    gtk_box_set_spacing(GTK_BOX(parent), border_major);
	    parent2 = parent;

	    EDVCreateOptionsSoundsPage(
		EDV_CORE(core_ptr), optwin, parent2
	    );
	}

	/* Begin creating the Misc Page */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Otro"
#elif defined(PROG_LANGUAGE_FRENCH)
"Autre"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ander"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Altro"
#elif defined(PROG_LANGUAGE_DUTCH)
"Anders"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Outro"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Andre"
#else
"Misc"
#endif
	);
	parent = OptWinPageAppend(optwin, w);
	if(parent != NULL)
	{
	    gtk_container_border_width(GTK_CONTAINER(parent), border_major);
	    gtk_box_set_spacing(GTK_BOX(parent), border_major);
	    parent2 = parent;

	    EDVCreateOptionsMiscPage(
		EDV_CORE(core_ptr), optwin, parent2
	    );
	}


	return(optwin);
}
