/*
			Endeavour Procedures
 */

#ifndef EDVOP_H
#define EDVOP_H

#include <gtk/gtk.h>

#include "url.h"
#include "browser.h"
#include "imbr.h"
#include "archiver.h"
#include "propdlg.h"
#include "endeavour.h"


/* New/Map Window Nexus */
extern gint EDVDoWindowNexus(
	edv_core_struct *core_ptr,
	const gchar *name,		/* Name of window */
	const gchar *path,		/* Initial object path */
	const gchar *extra,
	GtkWidget *toplevel
);


/* New Windows */
extern gint EDVDoNewBrowser(edv_core_struct *core_ptr);
extern gint EDVDoNewImbr(edv_core_struct *core_ptr);
extern gint EDVDoNewArchiverOpen(
	edv_core_struct *core_ptr, const gchar *path
);
extern gint EDVDoNewArchiver(edv_core_struct *core_ptr);

extern gint EDVDoNewPropertiesDialogPage(
	edv_core_struct *core_ptr, edv_object_struct *obj,
	const gchar *page_name,
	GtkWidget *toplevel
);
extern gint EDVDoNewPropertiesDialog(
	edv_core_struct *core_ptr, edv_object_struct *obj,
	GtkWidget *toplevel
);


/* Running */
extern void EDVDoRunDeviceCheck(
	edv_core_struct *core_ptr, edv_device_struct *dev_ptr,
	GtkWidget *toplevel
);
extern void EDVDoRunDeviceTools(
	edv_core_struct *core_ptr, edv_device_struct *dev_ptr,
	GtkWidget *toplevel
);
extern void EDVDoRunDeviceFormat(
	edv_core_struct *core_ptr, edv_device_struct *dev_ptr,
	GtkWidget *toplevel
);

extern void EDVDoRunTerminal(
	edv_core_struct *core_ptr, const gchar *cmd,
	GtkWidget *toplevel
);


/* Window Mapping */
extern void EDVDoMapRecBinDeskIcon(edv_core_struct *core_ptr);
extern void EDVDoMapRecBin(edv_core_struct *core_ptr);

extern void EDVDoMapHistoryListWin(
	edv_core_struct *core_ptr, GtkWidget *toplevel
);

extern void EDVDoMapOptionsWinPage(
	edv_core_struct *core_ptr,
	const gchar *page_name,
	GtkWidget *toplevel
);
extern void EDVDoMapOptionsWin(
	edv_core_struct *core_ptr, GtkWidget *toplevel
);

extern void EDVDoMapCustomizeWin(
	edv_core_struct *core_ptr, GtkWidget *toplevel
);

extern void EDVDoMapDevicesListWin(
	edv_core_struct *core_ptr, GtkWidget *toplevel
);

extern void EDVDoMapMIMETypesListWin(
	edv_core_struct *core_ptr, GtkWidget *toplevel
);

extern void EDVDoMapRunDialogCommand(
	edv_core_struct *core_ptr,
	const gchar *command,
	const gchar *working_dir,
	GtkWidget *toplevel
);
extern void EDVDoMapRunDialog(
	edv_core_struct *core_ptr, GtkWidget *toplevel
);

extern void EDVDoMapBrowserFindWin(
	edv_core_struct *core_ptr, edv_browser_struct *browser
);
extern void EDVDoMapImbrFindWin(
	edv_core_struct *core_ptr, edv_imbr_struct *imbr
);
extern void EDVDoMapArchiverFindWin(
	edv_core_struct *core_ptr, edv_archiver_struct *archiver
);
extern void EDVDoMapRecBinFindWin(
	edv_core_struct *core_ptr, edv_recbin_struct *recbin
);


/* About */
extern void EDVDoAboutPage(
	edv_core_struct *core_ptr,
	const gchar *page_name,
	GtkWidget *toplevel
);
extern void EDVDoAbout(
	edv_core_struct *core_ptr, GtkWidget *toplevel
);


/* Update Resources & Widgets */
extern void EDVDoUpdateRCStyles(edv_core_struct *core_ptr);
extern void EDVDoUpdateDevicesPUList(edv_core_struct *core_ptr);
extern void EDVDoUpdateMIMETypeHintIndices(edv_core_struct *core_ptr);
extern void EDVDoUpdateOpenWithPUList(edv_core_struct *core_ptr);


/* Sync */
extern void EDVDoSyncDisks(edv_core_struct *core_ptr);


/* Clearing */
extern void EDVDoClearHistoryEvents(
	edv_core_struct *core_ptr, GtkWidget *toplevel
);
extern void EDVDoClearLocationsHistory(
	edv_core_struct *core_ptr, GtkWidget *toplevel
);
extern void EDVDoClearRunHistory(
	edv_core_struct *core_ptr, GtkWidget *toplevel
);


/* Network */
extern void EDVDoInternetDownloadObject(
	edv_core_struct *core_ptr,
	const url_struct *url,			/* Source */
	const gchar *target_path,		/* Target */
	GtkWidget *toplevel
);


/* Recycle Bin Size Check */
extern void EDVDoRecycleBinSizeCheck(
	edv_core_struct *core_ptr, GtkWidget *toplevel
);


#endif	/* EDVOP_H */
