#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "guiutils.h"
#include "stacklist.h"
#include "csd.h"

#include "cfg.h"
#include "edvtypes.h"
#include "browser.h"
#include "browsercb.h"
#include "recbin.h"
#include "recbincb.h"
#include "optwin.h"
#include "edvcustomize.h"
#include "endeavour.h"
#include "edvutils.h"
#include "edvutilsgtk.h"
#include "edvcfglist.h"
#include "config.h"

#include "images/icon_customize_48x48.xpm"
#include "images/icon_endeavour_logo_20x20.xpm"
#include "images/endeavour_20x20.xpm"
#include "images/image_browser_20x20.xpm"
#include "images/archiver_20x20.xpm"
#include "images/icon_trash_20x20.xpm"


typedef struct {
	edv_core_struct	*core_ptr;
	GtkWidget	*drawing_area,
			*show_frame_check,
			*show_label_check;
	GtkAdjustment	*width_adj,
			*height_adj,
			*border_adj;
} ThumbSampleData;
#define THUMB_SAMPLE_DATA(p)	((ThumbSampleData *)(p))
#define THUMB_SAMPLE_DATA_KEY	"thumb_sample_data"


/* Recycle Bin */
static void EDVCreateCustomizeRecBinContentsListPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);
static void EDVCreateCustomizeRecBinToolBarPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);
static void EDVCreateCustomizeRecBinAppearancePage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);

/* Archiver */
static void EDVCreateCustomizeArchiverContentsListPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);
static void EDVCreateCustomizeArchiverToolBarPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);
static void EDVCreateCustomizeArchiverAppearancePage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);

/* Image Browser */
static void EDVCustomizeImbrThumbSampleDataDestroyCB(gpointer data);
static gint EDVCustomizeImbrThumbSampleEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
static void EDVCustomizeImbrThumbSampleUpdateCB(
	GtkWidget *widget, gpointer data
);
static void EDVCustomizeImbrThumbValueChangedCB(
	GtkAdjustment *adj, gpointer data
);
static void EDVCustomizeImbrThumbSampleDraw(ThumbSampleData *d);
static void EDVCreateCustomizeImbrThumbsListPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);
static void EDVCreateCustomizeImbrToolBarPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);
static void EDVCreateCustomizeImbrAppearancePage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);

/* File Browser */
static void EDVCreateCustomizeBrowserContentsListPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);
static void EDVCreateCustomizeBrowserToolBarPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);
static void EDVCreateCustomizeBrowserAppearancePage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);

/* General */
static void EDVCreateCustomizeGeneralNewObjectsMenuPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);
static void EDVCreateCustomizeGeneralStylesPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);
static void EDVCreateCustomizeGeneralAppearancePage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
);

/* Utilities */
void EDVCustomizeWindowSelectTab(
	optwin_struct *optwin, const gchar *tab_name
);

/* Front Ends */
optwin_struct *EDVCreateCustomizeWindow(
	gpointer core_ptr
);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Creates the Recycle Bin Contents List page.
 */
static void EDVCreateCustomizeRecBinContentsListPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	GtkWidget *w, *parent2;
	optwin_wref_struct *wref;
	stack_list_struct *slist;


	/* Display options frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Las Opciones Del Despliegue De La Clula"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Options D'Exposition De Cellule"
#elif defined(PROG_LANGUAGE_GERMAN)
"Zelle Ausstellung Optionen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Le Opzioni Di Mostra Di Cellula"
#elif defined(PROG_LANGUAGE_DUTCH)
"Cel Tentoonstelling Opties"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"As Opes De Exposio De Clula"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Celleut Stillings Alternativer"
#else
"Cell Display Options"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Hide dir size check */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Esconda Tamao Gua"
#elif defined(PROG_LANGUAGE_FRENCH)
"Cacher Taille D'Annuaire"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verstecken Sie Verzeichnis Gre"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Misura Di Elenco Di Nascondiglio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verberg Gids Maat"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Esconda Tamanho De Guia"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Gjemm Katalog Strrelse"
#else
"Hide Directory Size"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_RECBIN_CONTENTS_HIDE_DIR_SIZE
	);

	/* Hide link size check */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Esconda Tamao Eslabn"
#elif defined(PROG_LANGUAGE_FRENCH)
"Cacher Taille Lien"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verstecken Sie Verbindung Gre"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Misura Di Maglia Di Nascondiglio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verberg Schakel Maat"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Tamanho De Elo De Couro"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Gjemm LeddStrrelse"
#else
"Hide Link Size"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_RECBIN_CONTENTS_HIDE_LINK_SIZE
	);

	/* Hide link permission check */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Esconda Permisos Eslabn"
#elif defined(PROG_LANGUAGE_FRENCH)
"Cacher Permissions Lien"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verstecken Sie Verbindung Erlaubnis"
#elif defined(PROG_LANGUAGE_ITALIAN)
"I Permessi Di Maglia Di Nascondiglio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verberg Schakel Toestemmingen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"As Permisses De Elo De Couro"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Gjemm Ledd Tillatelse"
#else
"Hide Link Permissions"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_RECBIN_CONTENTS_HIDE_LINK_PERMISSIONS
	);


	/* Arrangement frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Arreglo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Arrangement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Anordnung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Disposizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Schikking"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Arranjo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arrangement"
#else
"Arrangement"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Create contents list stack list */
	slist = StackListNew(
	    parent2,
#if defined(PROG_LANGUAGE_SPANISH)
"Disponible", "La Corriente"
#elif defined(PROG_LANGUAGE_FRENCH)
"Disponible", "Courant"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verfgbar", "Strmung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Disponibile", "La Corrente"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verkrijgbaar", "Stroom"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Disponvel", "A Corrente"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tilgjengelig", "Strm"
#else
"Available", "Current"
#endif
	);
	StackListShowDescription(slist, TRUE, TRUE);
	StackListSetMaintainSourceOrder(slist, TRUE);
	StackListMap(slist);
	wref = OptWinWRefAppend(
	    optwin, NULL, NULL,
	    EDV_CFG_PARM_RECBIN_CONTENTS_COLUMN
	);
	OptWinWRefSetStackList(wref, slist);

	/* Create Contents List Headings Stack List */
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Nombre",
"El nombre del objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Nom",
"Le nom de l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Name",
"Name des objekts",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Nome",
"Il nome dell'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Naam",
"Naam van het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Nome",
"O nome do objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Navn",
"Navn av objektet",
#else
"Name",
"Name of the object",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_RECBIN_COLUMN_TYPE_NAME,
	    FALSE, TRUE         /* No multiple, stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Tamao",
"El tamao del objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Taille",
"La taille de l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Gre.",
"Gre des objekts",
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Misura",
"La misura dell'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Maat",
"Maat van het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Tamanho",
"O tamanho do objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Strrelse",
"Strrelse av objektet",
#else
"Size",
"Size of the object",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_RECBIN_COLUMN_TYPE_SIZE,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Tipo",
"De tipo MIME se asoci con el objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Type",
"Le Type de MIME a associ avec l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Typ",
"MIME Typ hat verbunden mit dem objekt",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Tipo",
"Il tipo di MIME  frequentato l'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Type",
"MIME type associeerde met het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Tipo",
"O tipo de MIME associou-se com o objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Type",
"MIME maskinskriver tilknyttet med objektet",
#else
"Type",
"MIME Type associated with the object",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_RECBIN_COLUMN_TYPE_TYPE,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"Los Permisos",
"Los permisos para el objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Permissions",
"Les permissions pour l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Erlaubnis",
"Erlaubnis fr das objekt",
#elif defined(PROG_LANGUAGE_ITALIAN)
"I Permessi",
"I permessi per l'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Toestemmingen",
"Toestemmingen voor het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"As Permisses",
"As permisses para o objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tillatelse",
"Tillatelse for objektet",
#else
"Permissions",
"Permissions for the object",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_RECBIN_COLUMN_TYPE_PERMISSIONS,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Dueo",
"El dueo del objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Propritaire",
"Le propritaire de l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Eigentmer",
"Eigentmer des objekts",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Proprietario",
"Il proprietario dell'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Eigenaar",
"Eigenaar van het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Proprietrio",
"O proprietrio do objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Eier",
"Eier av objektet",
#else
"Owner",
"Owner of the object",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_RECBIN_COLUMN_TYPE_OWNER,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Grupo",
"La propiedad agrupada del objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Groupe",
"La possession groupe de l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Gruppe",
"Klassifiziertes eigentumsrecht des objekts",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Gruppo",
"La propriet raggruppata dell'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Groep",
"Gegroepeerd eigendomsrecht van het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Grupo",
"Posse agrupada do objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Gruppe",
"Gruppert eiendomsrett av objektet",
#else
"Group",
"Grouped ownership of the object",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_RECBIN_COLUMN_TYPE_GROUP,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Acceso De La Fecha",
"Feche que el objeto era ltimo conseguir acceso a",
#elif defined(PROG_LANGUAGE_FRENCH)
"Accs De Date",
"Dater que l'objet tait dernier a accd ",
#elif defined(PROG_LANGUAGE_GERMAN)
"Datieren Sie Zugriff",
"Datum, da das objekt zuletzt auf zugegriffen wurde",
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Accesso Di Data",
"Data che l'oggetto era ultimo accesso a",
#elif defined(PROG_LANGUAGE_DUTCH)
"Dateer Toegang",
"Datum dat het voorwerp was vorig toegang tot had",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Acesso De Data",
"Date que o objeto era ltimo acedido",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Dater Tilgang",
"Dato at objektet var siste kommet til",
#else
"Date Access",
"Date that the object was last accessed",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_RECBIN_COLUMN_TYPE_DATE_ACCESS,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"Feche Modificado",
"La fecha que el objeto era ltimo modificado",
#elif defined(PROG_LANGUAGE_FRENCH)
"Dater Modifi",
"La date que l'objet tait dernier",
#elif defined(PROG_LANGUAGE_GERMAN)
"Datum Hat Modifiziert",
"Datum, da das objekt zuletzt modifiziert wurde",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Datare Modificato",
"Data che l'oggetto era ultimo modificato",
#elif defined(PROG_LANGUAGE_DUTCH)
"Datum Wijzigde",
"Datum dat het voorwerp vorig gewijzigde was",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Date Modificado",
"Data que o objeto era ltimos modificados",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Dato Modifisert",
"Dato at objektet var siste modifisert",
#else
"Date Modified",
"Date that the object was last modified",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_RECBIN_COLUMN_TYPE_DATE_MODIFIED,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"Feche Cambiado",
"Feche que el objeto era ltimo cambiado",
#elif defined(PROG_LANGUAGE_FRENCH)
"Dater Chang",
"Dater que l'objet tait dernier",
#elif defined(PROG_LANGUAGE_GERMAN)
"Datum Hat Gendert",
"Datum, da das objekt zuletzt gendert wurde",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Datare Cambiato",
"Data che l'oggetto era ultimo cambiato",
#elif defined(PROG_LANGUAGE_DUTCH)
"Datum Veranderde",
"Datum dat het voorwerp vorig veranderde was",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Date Mudado",
"Date que o objeto era ltimo mudado",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Dato Forandret Seg",
"Dato at objektet var siste forandret",
#else
"Date Changed",
"Date that the object was last changed",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_RECBIN_COLUMN_TYPE_DATE_CHANGED,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
"Date Deleted",
"Date that the object was deleted on",
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_RECBIN_COLUMN_TYPE_DATE_DELETED,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"Ligado A",
"Ligue el destino",
#elif defined(PROG_LANGUAGE_FRENCH)
"Reli A",
"Relier la destination",
#elif defined(PROG_LANGUAGE_GERMAN)
"Verknpft Zu",
"Verknpfen sie reiseziel",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Concatenato A",
"Concatenare la destinazione",
#elif defined(PROG_LANGUAGE_DUTCH)
"Verbindenene Te",
"Verbind bestemming",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Ligado A",
"Ligue destino",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Forbundet Til",
"Forbind destinasjon",
#else
"Linked To",
"Link destination",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_RECBIN_COLUMN_TYPE_LINKED_TO,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
"Original Location",
"Location of the object before it was deleted",
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_RECBIN_COLUMN_TYPE_ORIGINAL_LOCATION,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
"Index",
"Recycled object index number",
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_RECBIN_COLUMN_TYPE_INDEX,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);

	StackListUpdateMenus(slist);

}

/*
 *	Creates the Recycle Bin Tool Bar page.
 */
static void EDVCreateCustomizeRecBinToolBarPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	gint i;
	gchar *s;
	GSList *gslist;
	GtkWidget *w, *parent2, *parent3;
	optwin_wref_struct *wref;
	stack_list_struct *slist;
	edv_recbin_opid_struct **opid, *opid_ptr;
	gint total_opids;
	gchar slist_item_name[256];


	/* Hbox for toolbar display and relief frames */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent2 = w;


	/* Display Buttons As Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Despliegue Abrocha Como"
#elif defined(PROG_LANGUAGE_FRENCH)
"L'exposition Boutonne Comme"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausstellung Knpft Als Zu"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Mostra Abbottona Come"
#elif defined(PROG_LANGUAGE_DUTCH)
"Tentoonstelling Knoopt Als Dicht"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Exiba Botes Como"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utstilling Knapper Som"
#else
"Display Buttons As"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Text */
	gslist = NULL;
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Texto"
#elif defined(PROG_LANGUAGE_FRENCH)
"Texte"
#elif defined(PROG_LANGUAGE_GERMAN)
"Text"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Testo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Tekst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Texto"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tekst"
#else
"Text"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_RECBIN_TOOL_BAR_DISPLAY
	);
	wref->radio_value = TOOLBAR_DISPLAY_TEXT;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Pictures */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Los Retratos"
#elif defined(PROG_LANGUAGE_FRENCH)
"Images"
#elif defined(PROG_LANGUAGE_GERMAN)
"Bilder"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Le Immagini"
#elif defined(PROG_LANGUAGE_DUTCH)
"Afbeelding"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Quadros"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bilder"
#else
"Pictures"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_RECBIN_TOOL_BAR_DISPLAY
	);
	wref->radio_value = TOOLBAR_DISPLAY_PICTURES;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Pictures & Text */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Los Retratos & Texto"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Images & Le Texte"
#elif defined(PROG_LANGUAGE_GERMAN)
"Bilder & Text"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Le Immagini & Il Testo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Afbeelding & Tekst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Quadros & Texto"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bilder & Tekst"
#else
"Pictures & Text"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_RECBIN_TOOL_BAR_DISPLAY
	);
	wref->radio_value = TOOLBAR_DISPLAY_PICTURES_AND_TEXT;


	/* Buttons Relief Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Alivio De Botones"
#elif defined(PROG_LANGUAGE_FRENCH)
"Soulagement De Boutons"
#elif defined(PROG_LANGUAGE_GERMAN)
"Knpfe Erleichterung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Sollievo Di Bottoni"
#elif defined(PROG_LANGUAGE_DUTCH)
"Knopen Steun"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Alvio De Botes"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Knapp Lettelse"
#else
"Buttons Relief"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Flush */
	gslist = NULL;
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Rubor"
#elif defined(PROG_LANGUAGE_FRENCH)
"Eclat"
#elif defined(PROG_LANGUAGE_GERMAN)
"Splen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Flusso"
#elif defined(PROG_LANGUAGE_DUTCH)
"Vloed"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Nivele"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Spyl"
#else
"Flush"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_RECBIN_TOOL_BAR_RELIEF
	);
	wref->radio_value = TOOLBAR_RELIEF_NONE;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Half */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"La Mitad"
#elif defined(PROG_LANGUAGE_FRENCH)
"Moiti"
#elif defined(PROG_LANGUAGE_GERMAN)
"Hlfte"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Met"
#elif defined(PROG_LANGUAGE_DUTCH)
"Helft"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Metade"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Halvdel"
#else
"Half"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_RECBIN_TOOL_BAR_RELIEF
	);
	wref->radio_value = TOOLBAR_RELIEF_HALF;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Raised */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Levantado"
#elif defined(PROG_LANGUAGE_FRENCH)
"Hauss"
#elif defined(PROG_LANGUAGE_GERMAN)
"Erhoben"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Aumentato"
#elif defined(PROG_LANGUAGE_DUTCH)
"Opgetilde"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Levantado"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Hevet"
#else
"Raised"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_RECBIN_TOOL_BAR_RELIEF
	);
	wref->radio_value = TOOLBAR_RELIEF_NORMAL;


	/* Arrangement Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Arreglo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Arrangement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Anordnung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Disposizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Schikking"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Arranjo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arrangement"
#else
"Arrangement"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Create Tool Bar Stack List */
	slist = StackListNew(
	    parent2,
#if defined(PROG_LANGUAGE_SPANISH)
"Disponible", "La Corriente"
#elif defined(PROG_LANGUAGE_FRENCH)
"Disponible", "Courant"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verfgbar", "Strmung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Disponibile", "La Corrente"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verkrijgbaar", "Stroom"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Disponvel", "A Corrente"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tilgjengelig", "Strm"
#else
"Available", "Current"
#endif
	);
	StackListShowDescription(slist, TRUE, TRUE);
	StackListSetMaintainSourceOrder(slist, TRUE);
	StackListMap(slist);
	wref = OptWinWRefAppend(
	    optwin, NULL, NULL,
	    EDV_CFG_PARM_RECBIN_TOOL_BAR
	);
	OptWinWRefSetStackList(wref, slist);

	/* Create tool bar items from recycle bin operation ids */
	opid = EDVRecBinOPIDListNew(NULL, &total_opids);
	for(i = 0; i < total_opids; i++)
	{
	    opid_ptr = opid[i];
	    if(opid_ptr == NULL)
		continue;

	    /* Copy the menu name from the OPID to the Stack List Item
	     * name and sanitize it
	     */
	    strncpy(
		slist_item_name,
		(opid_ptr->menu_name != NULL) ?
		    opid_ptr->menu_name : "(null)",
		sizeof(slist_item_name)
	    );
	    slist_item_name[sizeof(slist_item_name) - 1] = '\0';

	    s = strstr(slist_item_name, "...");
	    if(s != NULL)
		*s = '\0';

	    /* Append a new Stack List Item from this OPID */
	    StackListAppend(
		slist, slist_item_name, opid_ptr->tooltip,
		opid_ptr->button_icon_data,
		NULL,				/* Client Data */
		(gint)opid_ptr->op,		/* ID */
		opid_ptr->allow_multiple,	/* Allow Multiple? */
		FALSE				/* Fixed On Target? */
	    );
	}
	/* Delete Operation IDs */
	EDVRecBinOPIDListDelete(opid, total_opids);
	StackListUpdateMenus(slist);

}

/*
 *	Creates the Recycle Bin Appearance page.
 */
static void EDVCreateCustomizeRecBinAppearancePage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	GtkWidget *w, *parent2, *parent3, *parent4;
	optwin_wref_struct *wref;


	/* Hbox to separate two columns */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent = w;


	/* First column vbox */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent2 = w;

	/* Show In Title Bar Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Muestre En La Barra Del Ttulo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Montrer Dans La Barre De Titre"
#elif defined(PROG_LANGUAGE_GERMAN)
"Zeigen Sie In Titel Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Mostrare Nella Sbarra Di Titolo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Toon In Titel Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Mostre Em Barra De Ttulo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Vis In Title Bar"
#else
"Show In Title Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;


	/* Show User Name */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"El Nombre Del Usuario"
#elif defined(PROG_LANGUAGE_FRENCH)
"Nom D'Utilisateur"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verbraucher Name"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Nome Di Operatore"
#elif defined(PROG_LANGUAGE_DUTCH)
"Gebruiker Naam"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Nome De Operador"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bruker Name"
#else
"User Name"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_RECBIN_TITLE_WITH_USER
	);


	/* Display Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Despliegue"
#elif defined(PROG_LANGUAGE_FRENCH)
"Exposition"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausstellung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Mostra"
#elif defined(PROG_LANGUAGE_DUTCH)
"Tentoonstelling"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Exposio"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utstilling"
#else
"Display"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Show Tool Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra De Instrumento"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre D'Outil"
#elif defined(PROG_LANGUAGE_GERMAN)
"Werkzeug Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Di attrezzo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Werktuig Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra De Ferramenta"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Redskap Bar"
#else
"Tool Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_RECBIN_SHOW_TOOL_BAR
	);

	/* Show Find Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra La Encuentre"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre La Trouver"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stab Sie Finden"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Trova"
#elif defined(PROG_LANGUAGE_DUTCH)
"Sluit Vondst Uit"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra Acha"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sperr Find"
#else
"Find Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_RECBIN_SHOW_FIND_BAR
	);

	/* Show Status Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra La Posicin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre La Statut"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stab Sie Status"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Lo Stato"
#elif defined(PROG_LANGUAGE_DUTCH)
"Sluit Status"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra Estado"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sperr Status"
#else
"Status Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_RECBIN_SHOW_STATUS_BAR
	);

	/* Show Desktop Icon */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Icono De Sobremesa"
#elif defined(PROG_LANGUAGE_FRENCH)
"Icne De Plan Travail"
#elif defined(PROG_LANGUAGE_GERMAN)
"Schreibtisch Abbild"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Icona Di Desktop"
#elif defined(PROG_LANGUAGE_DUTCH)
"Bureau Beeld"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Desktop Icon"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Skrivebord Icon"
#else
"Desktop Icon"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_RECBIN_SHOW_DESKTOP_ICON
	);

}


/*
 *	Create Archiver Contents List page.
 */
static void EDVCreateCustomizeArchiverContentsListPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	GtkWidget *w, *parent2;
	optwin_wref_struct *wref;
	stack_list_struct *slist;


	/* Display options frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Las Opciones Del Despliegue De La Clula"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Options D'Exposition De Cellule"
#elif defined(PROG_LANGUAGE_GERMAN)
"Zelle Ausstellung Optionen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Le Opzioni Di Mostra Di Cellula"
#elif defined(PROG_LANGUAGE_DUTCH)
"Cel Tentoonstelling Opties"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"As Opes De Exposio De Clula"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Celleut Stillings Alternativer"
#else
"Cell Display Options"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Hide dir size check */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Esconda Tamao Gua"
#elif defined(PROG_LANGUAGE_FRENCH)
"Cacher Taille D'Annuaire"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verstecken Sie Verzeichnis Gre"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Misura Di Elenco Di Nascondiglio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verberg Gids Maat"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Esconda Tamanho De Guia"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Gjemm Katalog Strrelse"
#else
"Hide Directory Size"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_ARCHIVER_CONTENTS_HIDE_DIR_SIZE
	);

	/* Hide link size check */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Esconda Tamao Eslabn"
#elif defined(PROG_LANGUAGE_FRENCH)
"Cacher Taille Lien"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verstecken Sie Verbindung Gre"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Misura Di Maglia Di Nascondiglio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verberg Schakel Maat"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Tamanho De Elo De Couro"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Gjemm LeddStrrelse"
#else
"Hide Link Size"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_ARCHIVER_CONTENTS_HIDE_LINK_SIZE
	);

	/* Hide link permission check */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Esconda Permisos Eslabn"
#elif defined(PROG_LANGUAGE_FRENCH)
"Cacher Permissions Lien"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verstecken Sie Verbindung Erlaubnis"
#elif defined(PROG_LANGUAGE_ITALIAN)
"I Permessi Di Maglia Di Nascondiglio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verberg Schakel Toestemmingen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"As Permisses De Elo De Couro"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Gjemm Ledd Tillatelse"
#else
"Hide Link Permissions"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_ARCHIVER_CONTENTS_HIDE_LINK_PERMISSIONS
	);


	/* Arrangement frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Arreglo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Arrangement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Anordnung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Disposizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Schikking"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Arranjo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arrangement"
#else
"Arrangement"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Create contents list stack list */
	slist = StackListNew(
	    parent2,
#if defined(PROG_LANGUAGE_SPANISH)
"Disponible", "La Corriente"
#elif defined(PROG_LANGUAGE_FRENCH)
"Disponible", "Courant"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verfgbar", "Strmung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Disponibile", "La Corrente"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verkrijgbaar", "Stroom"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Disponvel", "A Corrente"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tilgjengelig", "Strm"
#else
"Available", "Current"
#endif
	);
	StackListShowDescription(slist, TRUE, TRUE);
	StackListSetMaintainSourceOrder(slist, TRUE);
	StackListMap(slist);
	wref = OptWinWRefAppend(
	    optwin, NULL, NULL,
	    EDV_CFG_PARM_ARCHIVER_CONTENTS_COLUMN
	);
	OptWinWRefSetStackList(wref, slist);

	/* Create Contents List Headings Stack List */
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Nombre",
"El nombre del objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Nom",
"Le nom de l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Name",
"Name des objekts",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Nome",
"Il nome dell'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Naam",
"Naam van het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Nome",
"O nome do objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Navn",
"Navn av objektet",
#else
"Name",
"Name of the object",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_ARCHIVER_COLUMN_TYPE_NAME,
	    FALSE, TRUE         /* No multiple, stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Tamao",
"El tamao del objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Taille",
"La taille de l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Gre.",
"Gre des objekts",
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Misura",
"La misura dell'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Maat",
"Maat van het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Tamanho",
"O tamanho do objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Strrelse",
"Strrelse av objektet",
#else
"Size",
"Size of the object",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_ARCHIVER_COLUMN_TYPE_SIZE,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Tamao Comprimido",
"El tamao comprimido del objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Taille Serre",
"La taille serre de l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Zusammengedrckte Gre",
"Zusammengedrckte gre des objekts",
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Misura Compressa",
"La misura compressa dell'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Samengedrukte Maat",
"Samengedrukte maat van het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Tamanho Comprimido",
"Tamanho comprimido do objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Komprimert Strrelse",
"Komprimert strrelse av objektet",
#else
"Compressed Size",
"Compressed size of the object",
#endif
	    NULL,		/* No icon data */
	    NULL,		/* No client data */
	    EDV_ARCHIVER_COLUMN_TYPE_COMPRESSED_SIZE,
	    FALSE, FALSE	/* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Tipo",
"De tipo MIME se asoci con el objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Type",
"Le Type de MIME a associ avec l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Typ",
"MIME Typ hat verbunden mit dem objekt",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Tipo",
"Il tipo di MIME  frequentato l'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Type",
"MIME type associeerde met het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Tipo",
"O tipo de MIME associou-se com o objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Type",
"MIME maskinskriver tilknyttet med objektet",
#else
"Type",
"MIME Type associated with the object",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_ARCHIVER_COLUMN_TYPE_TYPE,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"Los Permisos",
"Los permisos para el objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Permissions",
"Les permissions pour l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Erlaubnis",
"Erlaubnis fr das objekt",
#elif defined(PROG_LANGUAGE_ITALIAN)
"I Permessi",
"I permessi per l'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Toestemmingen",
"Toestemmingen voor het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"As Permisses",
"As permisses para o objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tillatelse",
"Tillatelse for objektet",
#else
"Permissions",
"Permissions for the object",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_ARCHIVER_COLUMN_TYPE_PERMISSIONS,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Dueo",
"El dueo del objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Propritaire",
"Le propritaire de l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Eigentmer",
"Eigentmer des objekts",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Proprietario",
"Il proprietario dell'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Eigenaar",
"Eigenaar van het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Proprietrio",
"O proprietrio do objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Eier",
"Eier av objektet",
#else
"Owner",
"Owner of the object",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_ARCHIVER_COLUMN_TYPE_OWNER,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Grupo",
"La propiedad agrupada del objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Groupe",
"La possession groupe de l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Gruppe",
"Klassifiziertes eigentumsrecht des objekts",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Gruppo",
"La propriet raggruppata dell'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Groep",
"Gegroepeerd eigendomsrecht van het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Grupo",
"Posse agrupada do objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Gruppe",
"Gruppert eiendomsrett av objektet",
#else
"Group",
"Grouped ownership of the object",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_ARCHIVER_COLUMN_TYPE_GROUP,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Acceso De La Fecha",
"Feche que el objeto era ltimo conseguir acceso a",
#elif defined(PROG_LANGUAGE_FRENCH)
"Accs De Date",
"Dater que l'objet tait dernier a accd ",
#elif defined(PROG_LANGUAGE_GERMAN)
"Datieren Sie Zugriff",
"Datum, da das objekt zuletzt auf zugegriffen wurde",
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Accesso Di Data",
"Data che l'oggetto era ultimo accesso a",
#elif defined(PROG_LANGUAGE_DUTCH)
"Dateer Toegang",
"Datum dat het voorwerp was vorig toegang tot had",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Acesso De Data",
"Date que o objeto era ltimo acedido",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Dater Tilgang",
"Dato at objektet var siste kommet til",
#else
"Date Access",
"Date that the object was last accessed",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_ARCHIVER_COLUMN_TYPE_DATE_ACCESS,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"Feche Modificado",
"La fecha que el objeto era ltimo modificado",
#elif defined(PROG_LANGUAGE_FRENCH)
"Dater Modifi",
"La date que l'objet tait dernier",
#elif defined(PROG_LANGUAGE_GERMAN)
"Datum Hat Modifiziert",
"Datum, da das objekt zuletzt modifiziert wurde",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Datare Modificato",
"Data che l'oggetto era ultimo modificato",
#elif defined(PROG_LANGUAGE_DUTCH)
"Datum Wijzigde",
"Datum dat het voorwerp vorig gewijzigde was",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Date Modificado",
"Data que o objeto era ltimos modificados",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Dato Modifisert",
"Dato at objektet var siste modifisert",
#else
"Date Modified",
"Date that the object was last modified",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_ARCHIVER_COLUMN_TYPE_DATE_MODIFIED,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"Feche Cambiado",
"Feche que el objeto era ltimo cambiado",
#elif defined(PROG_LANGUAGE_FRENCH)
"Dater Chang",
"Dater que l'objet tait dernier",
#elif defined(PROG_LANGUAGE_GERMAN)
"Datum Hat Gendert",
"Datum, da das objekt zuletzt gendert wurde",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Datare Cambiato",
"Data che l'oggetto era ultimo cambiato",
#elif defined(PROG_LANGUAGE_DUTCH)
"Datum Veranderde",
"Datum dat het voorwerp vorig veranderde was",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Date Mudado",
"Date que o objeto era ltimo mudado",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Dato Forandret Seg",
"Dato at objektet var siste forandret",
#else
"Date Changed",
"Date that the object was last changed",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_ARCHIVER_COLUMN_TYPE_DATE_CHANGED,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"La Ubicacin",
"La ubicacin para el objeto cuando extrado",
#elif defined(PROG_LANGUAGE_FRENCH)
"Emplacement",
"L'emplacement pour l'objet quand extrait",
#elif defined(PROG_LANGUAGE_GERMAN)
"Ort",
"Ort fr das objekt wenn extrahiert",
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Posizione",
"La posizione per l'oggetto quando estratto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Plaats",
"Plaats voor het voorwerp wanneer onttrekkenene",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Localidade",
"A localidade para o objeto quando extrado",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Plassering",
"Plassering for objektet nr trukket ut",
#else
"Location",
"Location for the object when extracted",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_ARCHIVER_COLUMN_TYPE_LOCATION,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"Ligado A",
"Ligue el destino",
#elif defined(PROG_LANGUAGE_FRENCH)
"Reli A",
"Relier la destination",
#elif defined(PROG_LANGUAGE_GERMAN)
"Verknpft Zu",
"Verknpfen sie reiseziel",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Concatenato A",
"Concatenare la destinazione",
#elif defined(PROG_LANGUAGE_DUTCH)
"Verbindenene Te",
"Verbind bestemming",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Ligado A",
"Ligue destino",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Forbundet Til",
"Forbind destinasjon",
#else
"Linked To",
"Link destination",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_ARCHIVER_COLUMN_TYPE_LINKED_TO,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"De Tipo Dispositivo",
"El dispositivo el par mayor y secundario del nmero",
#elif defined(PROG_LANGUAGE_FRENCH)
"Type D'Appareil",
"Le commandant d'appareil et la paire de numro mineure",
#elif defined(PROG_LANGUAGE_GERMAN)
"Gertetyp",
"Gertemajor und minderjhriger zhlen paar",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Tipo Di Congegno",
"Congegno maggiore e minore numero",
#elif defined(PROG_LANGUAGE_DUTCH)
"Apparaat Type",
"Apparaat majoor en minderjarige nummeren paar",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Tipo De Artifcio",
"O artifcio par menor importante de nmero",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Innretnings Type",
"Innretnings major og mindr erigantall par",
#else
"Device Type",
"Device major and minor number pair",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_ARCHIVER_COLUMN_TYPE_DEVICE_TYPE,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"La Compresin",
"La proporcin de la compresin de los datos de objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Compression",
"La proportion de compression des donnes de l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Kompression",
"Kompression verhltnis die daten des des objekts",
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Compressione",
"l rapporto di compressione dei dati dell'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Samendrukking",
"Samendrukking verhouding van het voorwerp's de gegevens",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Compresso",
"A relao de compresso dos dados do objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Kompresjon",
"Kompresjonsforhold av objektets data",
#else
"Compression",
"Compression ratio of the object's data",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_ARCHIVER_COLUMN_TYPE_COMPRESSION,
	    FALSE, FALSE	/* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Mtodo",
"El mtodo de almacenar el objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Mthode",
"La mthode d'emmagasiner l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Methode",
"Methode das objekt der dpeicherung",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Metodo",
"Il metodo di immagazzinare l'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Methode",
"Methode het voorwerp op te slaan",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Mtodo",
"O mtodo de armazenar o objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Metode",
"Metode av  lagre objektet",
#else
"Method",
"Method of storing the object",
#endif
	    NULL,		/* No icon data */
	    NULL,		/* No client data */
	    EDV_ARCHIVER_COLUMN_TYPE_METHOD,
	    FALSE, FALSE	/* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"CRC",
"Checksum de CRC de los datos de objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"CRC",
"CRC checksum des donnes de l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"CRC",
"CRC checksum die Daten des des Objekts",
#elif defined(PROG_LANGUAGE_ITALIAN)
"CRC",
"Il totale di verifica di CRC dei dati dell'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"CRC",
"CRC checksum van het voorwerp's de gegevens",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"CRC",
"O checksum de CRC dos dados do objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"CRC",
"CRC checksum av objektets data",
#else
"CRC",
"CRC checksum of the object's data",
#endif
	    NULL,		/* No icon data */
	    NULL,		/* No client data */
	    EDV_ARCHIVER_COLUMN_TYPE_CRC,
	    FALSE, FALSE	/* No multiple, no stay on target */
	);

	StackListUpdateMenus(slist);

}

/*
 *      Creates the Archiver Tool Bar page.
 */
static void EDVCreateCustomizeArchiverToolBarPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	gint i;
	gchar *s;
	GSList *gslist;
	GtkWidget *w, *parent2, *parent3;
	optwin_wref_struct *wref;
	stack_list_struct *slist;
	edv_archiver_opid_struct **opid, *opid_ptr;
	gint total_opids;
	gchar slist_item_name[256];


	/* Hbox for toolbar display and relief frames */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent2 = w;


	/* Tool Bar Display Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Despliegue Abrocha Como"
#elif defined(PROG_LANGUAGE_FRENCH)
"L'exposition Boutonne Comme"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausstellung Knpft Als Zu"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Mostra Abbottona Come"
#elif defined(PROG_LANGUAGE_DUTCH)
"Tentoonstelling Knoopt Als Dicht"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Exiba Botes Como"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utstilling Knapper Som"
#else
"Display Buttons As"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Text */
	gslist = NULL;
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Texto"
#elif defined(PROG_LANGUAGE_FRENCH)
"Texte"
#elif defined(PROG_LANGUAGE_GERMAN)
"Text"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Testo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Tekst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Texto"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tekst"
#else
"Text"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_ARCHIVER_TOOL_BAR_DISPLAY
	);
	wref->radio_value = TOOLBAR_DISPLAY_TEXT;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Pictures */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Los Retratos"
#elif defined(PROG_LANGUAGE_FRENCH)
"Images"
#elif defined(PROG_LANGUAGE_GERMAN)
"Bilder"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Le Immagini"
#elif defined(PROG_LANGUAGE_DUTCH)
"Afbeelding"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Quadros"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bilder"
#else
"Pictures"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_ARCHIVER_TOOL_BAR_DISPLAY
	);
	wref->radio_value = TOOLBAR_DISPLAY_PICTURES;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Pictures & Text */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Los Retratos & Texto"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Images & Le Texte"
#elif defined(PROG_LANGUAGE_GERMAN)
"Bilder & Text"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Le Immagini & Il Testo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Afbeelding & Tekst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Quadros & Texto"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bilder & Tekst"
#else
"Pictures & Text"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_ARCHIVER_TOOL_BAR_DISPLAY
	);
	wref->radio_value = TOOLBAR_DISPLAY_PICTURES_AND_TEXT;


	/* Buttons Relief Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Alivio De Botones"
#elif defined(PROG_LANGUAGE_FRENCH)
"Soulagement De Boutons"
#elif defined(PROG_LANGUAGE_GERMAN)
"Knpfe Erleichterung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Sollievo Di Bottoni"
#elif defined(PROG_LANGUAGE_DUTCH)
"Knopen Steun"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Alvio De Botes"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Knapp Lettelse"
#else
"Buttons Relief"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Flush */
	gslist = NULL;
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Rubor"
#elif defined(PROG_LANGUAGE_FRENCH)
"Eclat"
#elif defined(PROG_LANGUAGE_GERMAN)
"Splen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Flusso"
#elif defined(PROG_LANGUAGE_DUTCH)
"Vloed"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Nivele"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Spyl"
#else
"Flush"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_ARCHIVER_TOOL_BAR_RELIEF
	);
	wref->radio_value = TOOLBAR_RELIEF_NONE;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Half */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"La Mitad"
#elif defined(PROG_LANGUAGE_FRENCH)
"Moiti"
#elif defined(PROG_LANGUAGE_GERMAN)
"Hlfte"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Met"
#elif defined(PROG_LANGUAGE_DUTCH)
"Helft"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Metade"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Halvdel"
#else
"Half"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_ARCHIVER_TOOL_BAR_RELIEF
	);
	wref->radio_value = TOOLBAR_RELIEF_HALF;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Raised */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Levantado"
#elif defined(PROG_LANGUAGE_FRENCH)
"Hauss"
#elif defined(PROG_LANGUAGE_GERMAN)
"Erhoben"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Aumentato"
#elif defined(PROG_LANGUAGE_DUTCH)
"Opgetilde"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Levantado"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Hevet"
#else
"Raised"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_ARCHIVER_TOOL_BAR_RELIEF
	);
	wref->radio_value = TOOLBAR_RELIEF_NORMAL;


	/* Arrangement Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Arreglo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Arrangement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Anordnung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Disposizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Schikking"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Arranjo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arrangement"
#else
"Arrangement"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Create Tool Bar Stack List */
	slist = StackListNew(
	    parent2,
#if defined(PROG_LANGUAGE_SPANISH)
"Disponible", "La Corriente"
#elif defined(PROG_LANGUAGE_FRENCH)
"Disponible", "Courant"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verfgbar", "Strmung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Disponibile", "La Corrente"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verkrijgbaar", "Stroom"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Disponvel", "A Corrente"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tilgjengelig", "Strm"
#else
"Available", "Current"
#endif
	);
	StackListShowDescription(slist, TRUE, TRUE);
	StackListSetMaintainSourceOrder(slist, TRUE);
	StackListMap(slist);
	wref = OptWinWRefAppend(
	    optwin, NULL, NULL,
	    EDV_CFG_PARM_ARCHIVER_TOOL_BAR
	);
	OptWinWRefSetStackList(wref, slist);

	/* Create tool bar items from archiver operation ids */
	opid = EDVArchiverOPIDListNew(NULL, &total_opids);
	for(i = 0; i < total_opids; i++)
	{
	    opid_ptr = opid[i];
	    if(opid_ptr == NULL)
		continue;

	    /* Copy menu name from opid to the slist item name buffer
	     * and sanitize it
	     */
	    strncpy(
		slist_item_name,
		(opid_ptr->menu_name != NULL) ?
		    opid_ptr->menu_name : "(null)",
		sizeof(slist_item_name)
	    );
	    slist_item_name[sizeof(slist_item_name) - 1] = '\0';

	    s = strstr(slist_item_name, "...");
	    if(s != NULL)
		*s = '\0';

	    /* Add slist item from this opid */
	    StackListAppend(
		slist, slist_item_name, opid_ptr->tooltip,
		opid_ptr->button_icon_data,
		NULL,				/* Client Data */
		(gint)opid_ptr->op,		/* ID */
		opid_ptr->allow_multiple,	/* Allow Multiple */
		FALSE				/* Fixed On Target? */
	    );
	}
	/* Delete Operation IDs */
	EDVArchiverOPIDListDelete(opid, total_opids);
	StackListUpdateMenus(slist);

}

/*
 *	Creates the Archiver Appearance page.
 */
static void EDVCreateCustomizeArchiverAppearancePage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	GtkWidget *w, *parent2, *parent3, *parent4;
	optwin_wref_struct *wref;


	/* Hbox to separate two columns */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent = w;


	/* First column vbox */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent2 = w;

	/* Show In Title Bar Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Muestre En La Barra Del Ttulo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Montrer Dans La Barre De Titre"
#elif defined(PROG_LANGUAGE_GERMAN)
"Zeigen Sie In Titel Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Mostrare Nella Sbarra Di Titolo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Toon In Titel Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Mostre Em Barra De Ttulo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Vis In Title Bar"
#else
"Show In Title Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Show User Name */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"El Nombre Del Usuario"
#elif defined(PROG_LANGUAGE_FRENCH)
"Nom D'Utilisateur"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verbraucher Name"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Nome Di Operatore"
#elif defined(PROG_LANGUAGE_DUTCH)
"Gebruiker Naam"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Nome De Operador"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bruker Name"
#else
"User Name"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_ARCHIVER_TITLE_WITH_USER
	);

	/* Show Location */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"La Ubicacin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Emplacement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ort"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Posizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Plaats"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Localidade"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Plassering"
#else
"Location"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_ARCHIVER_TITLE_WITH_LOCATION
	);


	/* Display Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Despliegue"
#elif defined(PROG_LANGUAGE_FRENCH)
"Exposition"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausstellung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Mostra"
#elif defined(PROG_LANGUAGE_DUTCH)
"Tentoonstelling"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Exposio"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utstilling"
#else
"Display"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Show Tool Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra De Instrumento"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre D'Outil"
#elif defined(PROG_LANGUAGE_GERMAN)
"Werkzeug Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Di attrezzo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Werktuig Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra De Ferramenta"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Redskap Bar"
#else
"Tool Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_ARCHIVER_SHOW_TOOL_BAR
	);

	/* Show Location Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra De Ubicacin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre D'Emplacement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ort Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Di Posizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Plaats Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra De Localidade"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Plassering Bar"
#else
"Location Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_ARCHIVER_SHOW_LOCATION_BAR
	);

	/* Show Find Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra La Encuentre"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre La Trouver"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stab Sie Finden"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Trova"
#elif defined(PROG_LANGUAGE_DUTCH)
"Sluit Vondst Uit"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra Acha"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sperr Find"
#else
"Find Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_ARCHIVER_SHOW_FIND_BAR
	);

	/* Show Status Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra La Posicin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre La Statut"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stab Sie Status"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Lo Stato"
#elif defined(PROG_LANGUAGE_DUTCH)
"Sluit Status"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra Estado"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sperr Status"
#else
"Status Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_ARCHIVER_SHOW_STATUS_BAR
	);


	/* Second column vbox */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent2 = w;

	/* Archive Display Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Despliegue Del Archivo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Archiver L'Exposition"
#elif defined(PROG_LANGUAGE_GERMAN)
"Archiv Ausstellung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Mostra Di Archivio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Archief Tentoonstelling"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Exposio De Arquivo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arkiv Display"
#else
"Archive Display"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Show Archive Info On Open */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Muestre Archivo Informacin En Abierto"
#elif defined(PROG_LANGUAGE_FRENCH)
"Montrer L'Information D'Archive Sur L'Ouverture"
#elif defined(PROG_LANGUAGE_GERMAN)
"Zeigen Sie Archiv Info Auf Offen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Mostrare Le Informazioni Di Archivio Su Aperto"
#elif defined(PROG_LANGUAGE_DUTCH)
"Toon Aan Archief Info Op Open"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Mostre Info De Arquivo Em Aberto"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Vis Archive Info On Open"
#else
"Map Archive Info On Open"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_ARCHIVER_SHOW_ARCHIVE_INFO_ON_OPEN
	);

}



/*
 *	Image Browser Thumbs List thumb sample "destroy" signal
 *	callback.
 */
static void EDVCustomizeImbrThumbSampleDataDestroyCB(gpointer data)
{
	ThumbSampleData *d = THUMB_SAMPLE_DATA(data);
	if(d == NULL)
	    return;

	g_free(d);
}

/*
 *	Image Browser Thumbs List Sample Thumb event signal callback.
 */
static gint EDVCustomizeImbrThumbSampleEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
)
{
	gint status = FALSE;
	GdkEventConfigure *configure;
	GdkEventExpose *expose;
	ThumbSampleData *d = THUMB_SAMPLE_DATA(data);
	if((widget == NULL) || (event == NULL) || (d == NULL))
	    return(status);

	switch((gint)event->type)
	{
	  case GDK_CONFIGURE:
	    configure = (GdkEventConfigure *)event;
	    status = TRUE;
	    break;

	  case GDK_EXPOSE:
	    expose = (GdkEventExpose *)event;
	    EDVCustomizeImbrThumbSampleDraw(d);
	    status = TRUE;
	    break;

	}

	return(status);
}

/*
 *	Image Browser Thumbs List Thumb Sample update callback.
 */
static void EDVCustomizeImbrThumbSampleUpdateCB(
	GtkWidget *widget, gpointer data
)
{
	ThumbSampleData *d = THUMB_SAMPLE_DATA(data);
	if(d == NULL)
	    return;

	EDVCustomizeImbrThumbSampleDraw(d);
}

/*
 *	Image Browser Thumbs List thumb size "value_changed"
 *	signal callback.
 */
static void EDVCustomizeImbrThumbValueChangedCB(
	GtkAdjustment *adj, gpointer data
)
{
	ThumbSampleData *d = THUMB_SAMPLE_DATA(data);
	if(d == NULL)
	    return;

	EDVCustomizeImbrThumbSampleDraw(d);
}

/*
 *	Redraws the Image Browser Thumbs List Thumb Sample.
 */
static void EDVCustomizeImbrThumbSampleDraw(ThumbSampleData *d)
{
	gboolean show_frame, show_label;
	gint	width, height,
		thumb_width, thumb_height,
		thumb_border, thumb_iborder = 2;
	GdkWindow *window;
	GdkDrawable *drawable;
	GtkStateType state;
	GtkStyle *style;
	GtkWidget *w = (d != NULL) ? d->drawing_area : NULL;
	if(w == NULL)
	    return;

	width = w->allocation.width;
	height = w->allocation.height;
	window = w->window;
	state = GTK_WIDGET_STATE(w);
	style = gtk_widget_get_style(w);
	if((window == NULL) || (width <= 0) || (height <= 0) ||
	   (style == NULL)
	)
	    return;

	drawable = window;

	/* Get size adjustments */
	thumb_width = GTK_ADJUSTMENT_GET_VALUE(d->width_adj);
	thumb_height = GTK_ADJUSTMENT_GET_VALUE(d->height_adj);
	thumb_border = GTK_ADJUSTMENT_GET_VALUE(d->border_adj);

	/* Get show options */
	show_frame = GTK_TOGGLE_BUTTON_GET_ACTIVE(d->show_frame_check);
	show_label = GTK_TOGGLE_BUTTON_GET_ACTIVE(d->show_label_check);


	/* Begin drawing */

	/* Clear background */
	gdk_draw_rectangle(
	    drawable, style->base_gc[state], TRUE,
	    0, 0, width, height
	);

	if((thumb_width > 0) && (thumb_height > 0))
	{
	    const gint	x = (width / 2) - (thumb_width / 2),
			y = (height / 2) - (thumb_height / 2);
	    GdkFont *font = style->font;

	    /* Draw thumb frame or outline */
	    if(show_frame)
	    {
		gtk_draw_box(
		    style, drawable, state, GTK_SHADOW_OUT,
		    x, y, thumb_width, thumb_height
		);
		if(thumb_border >= 2)
#if 0
		    gtk_draw_box(
			style, drawable, state, GTK_SHADOW_IN,
			x + thumb_border, y + thumb_border,
			MAX(thumb_width - (2 * thumb_border), 10),
			MAX(thumb_height - (2 * thumb_border), 10)
		    );
#else
		    gdk_draw_rectangle(
			drawable, style->fg_gc[state], FALSE,
			x + thumb_border, y + thumb_border,
			MAX(thumb_width - (2 * thumb_border), 10),
			MAX(thumb_height - (2 * thumb_border), 10)
		    );
#endif
	    }
	    else
	    {
		gdk_draw_rectangle(   
		    drawable, style->fg_gc[state], FALSE,
		    x, y, thumb_width, thumb_height
		);
		if(thumb_border >= 2)
		    gdk_draw_rectangle(
			drawable, style->fg_gc[state], FALSE,
			x + thumb_border, y + thumb_border,
			MAX(thumb_width - (2 * thumb_border), 10),
			MAX(thumb_height - (2 * thumb_border), 10)
		    );
	    }

	    /* Draw "image" */
	    if(font != NULL)
	    {
		const gint font_height = font->ascent + font->descent;
		GdkRectangle rect2;
		GdkTextBounds b;
		GdkGC *gc;
		const gchar *s = "Image";

		gdk_string_bounds(font, s, &b);

		if(show_label)
		{
		    const gint image_height = MAX(
			thumb_height - (2 * thumb_border) -
			(5 * thumb_iborder) - font_height,
			0
		    );
		    rect2.width = MIN(
			b.width,
			thumb_width - (2 * thumb_border) - (2 * thumb_iborder)
		    );
		    rect2.height = font_height;
		    rect2.x = x + MAX(
			(thumb_width / 2) - (rect2.width / 2),
			0
		    );
		    rect2.y = y + thumb_border + thumb_iborder
			+ (image_height / 2) - (rect2.height / 2);
		}
		else
		{
		    rect2.width = b.width;
		    rect2.height = font_height;
		    rect2.x = x + MAX(
			(thumb_width / 2) - (rect2.width / 2),
			0
		    );
		    rect2.y = y + MAX(
			(thumb_height / 2) - (rect2.height / 2),
			0
		    );
		}

		gc = style->text_gc[state];
		gdk_gc_set_clip_rectangle(gc, &rect2);
		gdk_draw_string(            
		    drawable, font, gc,
		    rect2.x + (rect2.width / 2) - (b.width / 2) + b.lbearing,
		    rect2.y + font->ascent,
		    s
		);
		gdk_gc_set_clip_rectangle(gc, NULL);
	    }

	    /* Draw label */
	    if(show_label && (font != NULL))
	    {
		const gint font_height = font->ascent + font->descent;
		GdkRectangle rect2;
		GdkTextBounds b;
		GdkGC *gc;
		const gchar *s = "Label";

		gdk_string_bounds(font, s, &b);

		rect2.width = MAX(
		    thumb_width - (2 * thumb_border) -
		    (2 * thumb_iborder),
		    5
		);
		rect2.height = font_height + (2 * thumb_iborder);
		rect2.x = x + MAX(
		    (thumb_width / 2) - (rect2.width / 2),
		    0
		);
		rect2.y = y + MAX(
		    thumb_height - thumb_border -
		    thumb_iborder - rect2.height,
		    thumb_height / 2
		);

		gdk_draw_rectangle(
		    drawable, style->base_gc[state], TRUE,
		    rect2.x, rect2.y, rect2.width, rect2.height
		);

		gc = style->text_gc[state];
		gdk_gc_set_clip_rectangle(gc, &rect2);
		gdk_draw_string(
		    drawable, font, gc,
		    rect2.x + (rect2.width / 2) - (b.width / 2) + b.lbearing,
		    rect2.y + thumb_iborder + font->ascent,
		    s
		);
		gdk_gc_set_clip_rectangle(gc, NULL);

		if(show_frame)
		    gtk_draw_shadow(
			style, drawable, state, GTK_SHADOW_IN,
			rect2.x, rect2.y, rect2.width, rect2.height
		    );
		else
		    gdk_draw_rectangle(
			drawable, style->fg_gc[state], FALSE,
			rect2.x, rect2.y, rect2.width, rect2.height
		    );

	    }
	}

	/* Send drawable to window if drawable is not the window */
	if(drawable != window)
	    gdk_draw_pixmap(
		window, style->fg_gc[state], drawable,
		0, 0, 0, 0, width, height
	    );
}

/*
 *	Creates the Image Browser Thumbs List page.
 */
static void EDVCreateCustomizeImbrThumbsListPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	GSList *gslist;
	GtkAdjustment *adj;
	GtkWidget *w, *parent2, *parent3, *parent4, *parent5;
	ThumbSampleData *d;
	optwin_wref_struct *wref;


	/* Create Thumb Sample Data */
	d = THUMB_SAMPLE_DATA(
	    g_malloc0(sizeof(ThumbSampleData))
	);   
	d->core_ptr = core_ptr;


	/* Hbox for multiple columns */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent = w;


	/* Left column vbox */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent2 = w;


	/* Thumb Tiling Orientation Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Embaldosar La Orientacin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Orientation Carrelant"
#elif defined(PROG_LANGUAGE_GERMAN)
"Tiling Orientierung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Che La Pavimentando Orientazione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Tiling Orintatie"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Orientao De Tiling"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tiling Orientering"
#else
"Thumb Tiling Orientation"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_widget_show(w);
	parent3 = w;

	/* Horizontal */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Radio Button */
	gslist = NULL;
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Horizontal"
#elif defined(PROG_LANGUAGE_FRENCH)
"Horizontal"
#elif defined(PROG_LANGUAGE_GERMAN)
"Horizontale"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Orizzontale"
#elif defined(PROG_LANGUAGE_DUTCH)
"Horizontale Lijn"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Horizontal"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Horisontal"
#else
"Horizontal"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_THUMB_LIST_HORIZONTAL
	);
	wref->radio_value = TRUE;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Vertical */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Radio Button */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Vertical"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vertical"
#elif defined(PROG_LANGUAGE_GERMAN)
"Senkrecht"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Verticale"
#elif defined(PROG_LANGUAGE_DUTCH)
"Vertikaal"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Vertical"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Vertikal"
#else
"Vertical"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_THUMB_LIST_HORIZONTAL
	);
	wref->radio_value = FALSE;


	/* Display Thumb Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Pulgar Del Despliegue"
#elif defined(PROG_LANGUAGE_FRENCH)
"Afficher Le Pouce"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stellen Sie Daumen Dar"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Pollice Di Mostra"
#elif defined(PROG_LANGUAGE_DUTCH)
"Toon Duim"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Exiba Polegar"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Vis Tommelfinger"
#else
"Display Thumb"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;        

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_widget_show(w);
	parent3 = w;

	/* Frame */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	d->show_frame_check = w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"El Marco"
#elif defined(PROG_LANGUAGE_FRENCH)
"Cadre"
#elif defined(PROG_LANGUAGE_GERMAN)
"Rahmen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Cornice"
#elif defined(PROG_LANGUAGE_DUTCH)
"Omlijsting"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Armao"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Ramm Inn"
#else
"Frame"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_THUMB_SHOW_FRAMES
	);

	/* Label */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	d->show_label_check = w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"La Etiqueta"
#elif defined(PROG_LANGUAGE_FRENCH)
"Etiquette"
#elif defined(PROG_LANGUAGE_GERMAN)
"Etikett"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Etichetta"
#elif defined(PROG_LANGUAGE_DUTCH)
"Etiket"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Etiqueta"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Merke"
#else
"Label"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_THUMB_SHOW_LABELS
	);


	/* Misc Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Variado"
#elif defined(PROG_LANGUAGE_FRENCH)
"Divers"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verschieden"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Miscellaneo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verscheiden"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Miscelnea"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Forskjellig"
#else
"Miscellaneous"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_widget_show(w);
	parent3 = w;

	/* Do Not Enlarge Thumbs */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"No Amplie Las Imgenes Pequeas"
#elif defined(PROG_LANGUAGE_FRENCH)
"Ne Pas Agrandir De Petites Images"
#elif defined(PROG_LANGUAGE_GERMAN)
"Vergrern Sie Kleine Bildnisse Nicht"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Non Ingrandire Le Immagini Piccole"
#elif defined(PROG_LANGUAGE_DUTCH)
"Vergroot Niet Kleine Beelden"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"No Aumente Imagens Pequenas"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Forstrr Ikke Sm Avbilder"
#else
"Do Not Enlarge Small Images"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"No amplie el pulgar si la imagen verdadera es ms pequea"
#elif defined(PROG_LANGUAGE_FRENCH)
"Ne pas agrandir le pouce si l'image vritable est plus petite"
#elif defined(PROG_LANGUAGE_GERMAN)
"Vergrern sie den daumen nicht, wenn das eigentliche bildnis kleiner\
 ist"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Non ingrandire il pollice se l'immagine reale  pi piccola"
#elif defined(PROG_LANGUAGE_DUTCH)
"Vergroot niet de duim indien de eigenlijke beeld kleiner is"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"No aumente o polegar se a imagem real  menor"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Forstrr ikke tommelfingeren om det aktuelle avbildet er liten"
#else
"Do not enlarge the thumb if the actual image is smaller"
#endif
	);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_THUMB_NO_ENLARGE
	);


	/* Right column vbox */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent2 = w;

	/* Thumb Geometry Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Hojee La Geometra"
#elif defined(PROG_LANGUAGE_FRENCH)
"Gomtrie De Pouce"
#elif defined(PROG_LANGUAGE_GERMAN)
"Daumen Geometrie"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Sciupare La Geometria"
#elif defined(PROG_LANGUAGE_DUTCH)
"Duim Geometry"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Geometria De Polegar"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tommelfinger Geometri"
#else
"Thumb Geometry"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_widget_show(w);
	parent3 = w;


	/* Hbox for prompts */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;


	/* Hbox for size prompts */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent5 = w;
	/* Width */
	/* Label */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Width"
#elif defined(PROG_LANGUAGE_FRENCH)
"Width"
#elif defined(PROG_LANGUAGE_GERMAN)
"Width"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Width"
#elif defined(PROG_LANGUAGE_DUTCH)
"Width"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Width"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Width"
#else
"Width"
#endif
	    ":"
	);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	/* Spin Button */
	d->width_adj = adj = (GtkAdjustment *)gtk_adjustment_new(
	    20.0f, 20.0f, 320.0f, 1.0f, 5.0f, 0.0f
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 60, -1);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_THUMB_WIDTH
	);
	/* Height */
	/* Label */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Height"
#elif defined(PROG_LANGUAGE_FRENCH)
"Height"
#elif defined(PROG_LANGUAGE_GERMAN)
"Height"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Height"
#elif defined(PROG_LANGUAGE_DUTCH)
"Height"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Height"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Height"
#else
"Height"
#endif
	    ":"
	);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	/* Spin */
	d->height_adj = adj = (GtkAdjustment *)gtk_adjustment_new(
	    20.0f, 20.0f, 320.0f, 1.0f, 5.0f, 0.0f
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 60, -1);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_THUMB_HEIGHT
	);

	/* Hbox for border */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent5 = w;
	/* Label */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Border"
#elif defined(PROG_LANGUAGE_FRENCH)
"Border"
#elif defined(PROG_LANGUAGE_GERMAN)
"Border"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Border"
#elif defined(PROG_LANGUAGE_DUTCH)
"Border"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Border"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Border"
#else
"Border"
#endif
	    ":"
	);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	/* Spin Button */
	d->border_adj = adj = (GtkAdjustment *)gtk_adjustment_new(
	    2.0f, 0.0f, 48.0f, 1.0f, 5.0f, 0.0f
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 50, -1);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_THUMB_BORDER
	);


	/* Hbox for sample thumb */
	w = gtk_hbox_new(TRUE, border_major);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	w = gtk_frame_new(NULL);
	gtk_box_pack_start(GTK_BOX(parent4), w, TRUE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_IN);
	gtk_widget_show(w);
	parent4 = w;

	/* Create sample thumb drawing area */
	d->drawing_area = w = gtk_drawing_area_new();
	gtk_object_set_data_full(
	    GTK_OBJECT(w), THUMB_SAMPLE_DATA_KEY,
	    d, EDVCustomizeImbrThumbSampleDataDestroyCB
	);
	gtk_widget_add_events(
	    w,
	    GDK_STRUCTURE_MASK | GDK_EXPOSURE_MASK
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "configure_event",
	    GTK_SIGNAL_FUNC(EDVCustomizeImbrThumbSampleEventCB), d
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "expose_event",
	    GTK_SIGNAL_FUNC(EDVCustomizeImbrThumbSampleEventCB), d
	);
	gtk_widget_set_usize(w, 320, 240);
	gtk_container_add(GTK_CONTAINER(parent4), w);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL, NULL
	);
	wref->ignore_changes = TRUE;

	gtk_signal_connect(
	    GTK_OBJECT(d->show_frame_check), "toggled",
	    GTK_SIGNAL_FUNC(EDVCustomizeImbrThumbSampleUpdateCB), d
	);
	gtk_signal_connect(
	    GTK_OBJECT(d->show_label_check), "toggled",
	    GTK_SIGNAL_FUNC(EDVCustomizeImbrThumbSampleUpdateCB), d
	);
	gtk_signal_connect(
	    GTK_OBJECT(d->width_adj), "value_changed",
	    GTK_SIGNAL_FUNC(EDVCustomizeImbrThumbValueChangedCB), d
	);
	gtk_signal_connect(
	    GTK_OBJECT(d->height_adj), "value_changed",
	    GTK_SIGNAL_FUNC(EDVCustomizeImbrThumbValueChangedCB), d
	);
	gtk_signal_connect(
	    GTK_OBJECT(d->border_adj), "value_changed",
	    GTK_SIGNAL_FUNC(EDVCustomizeImbrThumbValueChangedCB), d
	);


}

/*
 *	Creates the Image Browser Tool Bar page.
 */
static void EDVCreateCustomizeImbrToolBarPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	gint i;
	gchar *s;
	GSList *gslist;
	GtkWidget *w, *parent2, *parent3;
	optwin_wref_struct *wref;
	stack_list_struct *slist;
	edv_imbr_opid_struct **opid, *opid_ptr;
	gint total_opids;
	gchar slist_item_name[256];


	/* Hbox for toolbar display and relief frames */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent2 = w;


	/* Display Buttons As Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Despliegue Abrocha Como"
#elif defined(PROG_LANGUAGE_FRENCH)
"L'exposition Boutonne Comme"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausstellung Knpft Als Zu"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Mostra Abbottona Come"
#elif defined(PROG_LANGUAGE_DUTCH)
"Tentoonstelling Knoopt Als Dicht"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Exiba Botes Como"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utstilling Knapper Som"
#else
"Display Buttons As"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Text */
	gslist = NULL;
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Texto"
#elif defined(PROG_LANGUAGE_FRENCH)
"Texte"
#elif defined(PROG_LANGUAGE_GERMAN)
"Text"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Testo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Tekst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Texto"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tekst"
#else
"Text"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_TOOL_BAR_DISPLAY
	);
	wref->radio_value = TOOLBAR_DISPLAY_TEXT;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Pictures */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Los Retratos"
#elif defined(PROG_LANGUAGE_FRENCH)
"Images"
#elif defined(PROG_LANGUAGE_GERMAN)
"Bilder"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Le Immagini"
#elif defined(PROG_LANGUAGE_DUTCH)
"Afbeelding"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Quadros"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bilder"
#else
"Pictures"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_TOOL_BAR_DISPLAY
	);
	wref->radio_value = TOOLBAR_DISPLAY_PICTURES;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Pictures & Text */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Los Retratos & Texto"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Images & Le Texte"
#elif defined(PROG_LANGUAGE_GERMAN)
"Bilder & Text"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Le Immagini & Il Testo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Afbeelding & Tekst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Quadros & Texto"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bilder & Tekst"
#else
"Pictures & Text"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_TOOL_BAR_DISPLAY
	);
	wref->radio_value = TOOLBAR_DISPLAY_PICTURES_AND_TEXT;


	/* Buttons Relief Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Alivio De Botones"
#elif defined(PROG_LANGUAGE_FRENCH)
"Soulagement De Boutons"
#elif defined(PROG_LANGUAGE_GERMAN)
"Knpfe Erleichterung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Sollievo Di Bottoni"
#elif defined(PROG_LANGUAGE_DUTCH)
"Knopen Steun"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Alvio De Botes"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Knapp Lettelse"
#else
"Buttons Relief"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Flush */
	gslist = NULL;
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Rubor"
#elif defined(PROG_LANGUAGE_FRENCH)
"Eclat"
#elif defined(PROG_LANGUAGE_GERMAN)
"Splen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Flusso"
#elif defined(PROG_LANGUAGE_DUTCH)
"Vloed"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Nivele"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Spyl"
#else
"Flush"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_TOOL_BAR_RELIEF
	);
	wref->radio_value = TOOLBAR_RELIEF_NONE;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Half */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"La Mitad"
#elif defined(PROG_LANGUAGE_FRENCH)
"Moiti"
#elif defined(PROG_LANGUAGE_GERMAN)
"Hlfte"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Met"
#elif defined(PROG_LANGUAGE_DUTCH)
"Helft"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Metade"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Halvdel"
#else
"Half"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_TOOL_BAR_RELIEF
	);
	wref->radio_value = TOOLBAR_RELIEF_HALF;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Raised */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Levantado"
#elif defined(PROG_LANGUAGE_FRENCH)
"Hauss"
#elif defined(PROG_LANGUAGE_GERMAN)
"Erhoben"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Aumentato"
#elif defined(PROG_LANGUAGE_DUTCH)
"Opgetilde"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Levantado"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Hevet"
#else
"Raised"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_TOOL_BAR_RELIEF
	);
	wref->radio_value = TOOLBAR_RELIEF_NORMAL;



	/* Arrangement Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Arreglo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Arrangement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Anordnung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Disposizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Schikking"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Arranjo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arrangement"
#else
"Arrangement"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;


	/* Create Tool Bar Stack List */
	slist = StackListNew(
	    parent2,
#if defined(PROG_LANGUAGE_SPANISH)
"Disponible", "La Corriente"
#elif defined(PROG_LANGUAGE_FRENCH)
"Disponible", "Courant"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verfgbar", "Strmung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Disponibile", "La Corrente"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verkrijgbaar", "Stroom"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Disponvel", "A Corrente"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tilgjengelig", "Strm"
#else
"Available", "Current"
#endif
	);
	StackListShowDescription(slist, TRUE, TRUE);
	StackListSetMaintainSourceOrder(slist, TRUE);
	StackListMap(slist);
	wref = OptWinWRefAppend(
	    optwin, NULL, NULL,
	    EDV_CFG_PARM_IMBR_TOOL_BAR
	);
	OptWinWRefSetStackList(wref, slist);

	/* Create tool bar items from image browser operation ids */
	opid = EDVImbrOPIDListNew(NULL, &total_opids);
	for(i = 0; i < total_opids; i++)
	{
	    opid_ptr = opid[i];
	    if(opid_ptr == NULL)
		continue;

	    /* Copy menu name from opid to the slist item name buffer
	     * and sanitize it
	     */
	    strncpy(
		slist_item_name,
		(opid_ptr->menu_name != NULL) ?
		    opid_ptr->menu_name : "(null)",
		sizeof(slist_item_name)
	    );
	    slist_item_name[sizeof(slist_item_name) - 1] = '\0';

	    s = strstr(slist_item_name, "...");
	    if(s != NULL)
		*s = '\0';

	    /* Add slist item from this opid */
	    StackListAppend(
		slist, slist_item_name, opid_ptr->tooltip,
		opid_ptr->button_icon_data,
		NULL,				/* Client Data */
		(gint)opid_ptr->op,		/* ID */
		opid_ptr->allow_multiple,	/* Allow Multiple? */
		FALSE				/* Fixed On Target? */
	    );
	}
	/* Delete Operation IDs */
	EDVImbrOPIDListDelete(opid, total_opids);
	StackListUpdateMenus(slist);

}

/*
 *	Creates the Image Browser Appearance page.
 */
static void EDVCreateCustomizeImbrAppearancePage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	GtkWidget *w, *parent2, *parent3, *parent4;
	optwin_wref_struct *wref;


	/* Hbox to separate two columns */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent = w;


	/* First column vbox */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent2 = w;

	/* Show In Title Bar Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Muestre En La Barra Del Ttulo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Montrer Dans La Barre De Titre"
#elif defined(PROG_LANGUAGE_GERMAN)
"Zeigen Sie In Titel Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Mostrare Nella Sbarra Di Titolo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Toon In Titel Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Mostre Em Barra De Ttulo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Vis In Title Bar"
#else
"Show In Title Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Show User Name */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"El Nombre Del Usuario"
#elif defined(PROG_LANGUAGE_FRENCH)
"Nom D'Utilisateur"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verbraucher Name"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Nome Di Operatore"
#elif defined(PROG_LANGUAGE_DUTCH)
"Gebruiker Naam"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Nome De Operador"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bruker Name"
#else
"User Name"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_TITLE_WITH_USER
	);

	/* Show Location */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"La Ubicacin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Emplacement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ort"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Posizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Plaats"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Localidade"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Plassering"
#else
"Location"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_TITLE_WITH_LOCATION
	);


	/* Display Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Despliegue"
#elif defined(PROG_LANGUAGE_FRENCH)
"Exposition"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausstellung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Mostra"
#elif defined(PROG_LANGUAGE_DUTCH)
"Tentoonstelling"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Exposio"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utstilling"
#else
"Display"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Show Tool Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra De Instrumento"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre D'Outil"
#elif defined(PROG_LANGUAGE_GERMAN)
"Werkzeug Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Di attrezzo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Werktuig Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra De Ferramenta"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Redskap Bar"
#else
"Tool Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_SHOW_TOOL_BAR
	);

	/* Show Location Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra De Ubicacin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre D'Emplacement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ort Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Di Posizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Plaats Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra De Localidade"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Plassering Bar"
#else
"Location Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_SHOW_LOCATION_BAR
	);

	/* Show Mount Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra El Monte"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre Mont"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stab Untersatz"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Sbarra Il Monte"
#elif defined(PROG_LANGUAGE_DUTCH)
"Staaf Berg"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Barra O Monte"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bar Fotstykke"
#else
"Mount Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_SHOW_MOUNT_BAR
	);

	/* Show Find Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra La Encuentre"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre La Trouver"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stab Sie Finden"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Trova"
#elif defined(PROG_LANGUAGE_DUTCH)
"Sluit Vondst Uit"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra Acha"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sperr Find"
#else
"Find Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_SHOW_FIND_BAR
	);

	/* Show Status Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra La Posicin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre La Statut"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stab Sie Status"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Lo Stato"
#elif defined(PROG_LANGUAGE_DUTCH)
"Sluit Status"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra Estado"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sperr Status"
#else
"Status Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_SHOW_STATUS_BAR
	);


	/* Second column vbox */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent2 = w;


	/* Filter Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Filtro"
#elif defined(PROG_LANGUAGE_FRENCH)
"Filtre"
#elif defined(PROG_LANGUAGE_GERMAN)
"Filter"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Filtro"
#elif defined(PROG_LANGUAGE_DUTCH)
"Filter"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Filtro"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Filter"
#else
"Filter"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Show Hidden Objects */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Los Objetos Escondidos"
#elif defined(PROG_LANGUAGE_FRENCH)
"Objets Cachs"
#elif defined(PROG_LANGUAGE_GERMAN)
"Versteckte Objekte"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Gli Oggetti Nascosti"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verbergenene Voorwerpen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Objetos Escondidos"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Gjemte Objekt"
#else
"Hidden Objects"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_SHOW_OBJECT_HIDDEN
	);

	/* Show No Access Objects */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Ningn Acceso Se Opone"
#elif defined(PROG_LANGUAGE_FRENCH)
"Aucuns Objets D'accs"
#elif defined(PROG_LANGUAGE_GERMAN)
"Keine Zugriffsobjekte"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Nessuno Accesso Obbietta"
#elif defined(PROG_LANGUAGE_DUTCH)
"Geen Toegang Heeft Bezwaar"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Nenhum Acesso Ope-se"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Ingen Tilgang Protesterer"
#else
"No Access Objects"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_SHOW_OBJECT_NOACCESS
	);

	/* Show Non-Image Objects */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"No Objetos De Imagen"
#elif defined(PROG_LANGUAGE_FRENCH)
"La Non-Image S'Oppose"
#elif defined(PROG_LANGUAGE_GERMAN)
"Nicht-Bildnis Wendet Gegen Ein"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Non-Immagine Obbietta"
#elif defined(PROG_LANGUAGE_DUTCH)
"Niete-beeld Heeft Bezwaar"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A No-Imagem Ope-se"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Ikke--avbilde Protesterer"
#else
"Non-Image Objects"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_IMBR_SHOW_OBJECT_NONIMAGE
	);


	/* Color Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Los Colores"
#elif defined(PROG_LANGUAGE_FRENCH)
"Couleurs"
#elif defined(PROG_LANGUAGE_GERMAN)
"Farben"
#elif defined(PROG_LANGUAGE_ITALIAN)
"I Colori"
#elif defined(PROG_LANGUAGE_DUTCH)
"Kleuren"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"As Cores"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Farger"
#else
"Colors"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	/* Table */
	w = gtk_table_new(3, 2, FALSE);
	gtk_table_set_row_spacings(GTK_TABLE(w), border_minor);
	gtk_table_set_col_spacings(GTK_TABLE(w), border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;
	if(parent3 != NULL)
	{
	    gint row = 0;
	    const gchar *name;
	    GtkWidget *parent4;

#define ADD_LINE(row,name,parm)		{			\
 GtkAttachOptions       x_attach_opt = 0,			\
			y_attach_opt = 0;			\
 guint  x_pad = 0, y_pad = 0;					\
								\
 /* Alignment for name label */					\
 w = gtk_alignment_new(1.0f, 0.5f, 0.0f, 0.0f);			\
 gtk_widget_set_usize(w, 80, -1);				\
 gtk_table_attach(						\
  GTK_TABLE(parent3), w,					\
  0, 1, (row), (row) + 1,					\
  x_attach_opt, y_attach_opt, x_pad, y_pad			\
 );								\
 gtk_widget_show(w);						\
 parent4 = w;							\
 /* Name label */						\
 w = gtk_label_new((name));                                     \
 gtk_container_add(GTK_CONTAINER(parent4), w);                  \
 gtk_widget_show(w);						\
								\
 /* Alignment for color button */				\
 w = gtk_alignment_new(0.5f, 0.5f, 0.0f, 0.0f);			\
/* gtk_widget_set_usize(w, 250, -1); */				\
 gtk_table_attach(						\
  GTK_TABLE(parent3), w,					\
  1, 2, (row), (row) + 1,					\
  x_attach_opt, y_attach_opt, x_pad, y_pad			\
 );								\
 gtk_widget_show(w);						\
 parent4 = w;							\
 /* Color button */						\
 w = CSDColorButtonNewSimple(NULL, -1);				\
 gtk_container_add(GTK_CONTAINER(parent4), w);                  \
 gtk_widget_show(w);                                            \
 wref = OptWinWRefAppend(					\
  optwin, NULL, NULL, (parm)					\
 );								\
 OptWinWRefSetColorButton(wref, w);				\
}

	    name =
#if defined(PROG_LANGUAGE_SPANISH)
"Primera Plana"
#elif defined(PROG_LANGUAGE_FRENCH)
"Premier Plan"
#elif defined(PROG_LANGUAGE_GERMAN)
"Vordergrund"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Primo Piano"
#elif defined(PROG_LANGUAGE_DUTCH)
"Voorgrond"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Cho De Frente"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Forgrunn"
#else
"Foreground"
#endif
	    ":";
	    ADD_LINE(row, name, EDV_CFG_PARM_IMBR_COLOR_FG);
	    row++;

	    name =
#if defined(PROG_LANGUAGE_SPANISH)
"El Fondo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Arrire-Plan"
#elif defined(PROG_LANGUAGE_GERMAN)
"Hintergrund"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Lo Sfondo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Achtergrond"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Cho Posterior"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bakgrunn"
#else
"Background"
#endif
	    ":";
	    ADD_LINE(row, name, EDV_CFG_PARM_IMBR_COLOR_BG);
	    row++;

	    name =
#if defined(PROG_LANGUAGE_SPANISH)
"La Frontera"
#elif defined(PROG_LANGUAGE_FRENCH)
"Frontire"
#elif defined(PROG_LANGUAGE_GERMAN)
"Rand"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Frontiera"
#elif defined(PROG_LANGUAGE_DUTCH)
"Rand"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Fronteira"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Grense"
#else
"Border"
#endif
	    ":";
	    ADD_LINE(row, name, EDV_CFG_PARM_IMBR_COLOR_BORDER);
	    row++;

#undef ADD_LINE
	}


}


/*
 *      Creates the File Browser Contents List page.
 */
static void EDVCreateCustomizeBrowserContentsListPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	GtkWidget *w, *parent2;
	optwin_wref_struct *wref;
	stack_list_struct *slist;


	/* Display options frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Las Opciones Del Despliegue De La Clula"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Options D'Exposition De Cellule"
#elif defined(PROG_LANGUAGE_GERMAN)
"Zelle Ausstellung Optionen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Le Opzioni Di Mostra Di Cellula"
#elif defined(PROG_LANGUAGE_DUTCH)
"Cel Tentoonstelling Opties"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"As Opes De Exposio De Clula"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Celleut Stillings Alternativer"
#else
"Cell Display Options"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Hide dir size check */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Esconda Tamao Gua"
#elif defined(PROG_LANGUAGE_FRENCH)
"Cacher Taille D'Annuaire"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verstecken Sie Verzeichnis Gre"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Misura Di Elenco Di Nascondiglio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verberg Gids Maat"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Esconda Tamanho De Guia"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Gjemm Katalog Strrelse"
#else
"Hide Directory Size"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_BROWSER_CONTENTS_HIDE_DIR_SIZE
	);

	/* Hide link size check */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Esconda Tamao Eslabn"
#elif defined(PROG_LANGUAGE_FRENCH)
"Cacher Taille Lien"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verstecken Sie Verbindung Gre"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Misura Di Maglia Di Nascondiglio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verberg Schakel Maat"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Tamanho De Elo De Couro"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Gjemm LeddStrrelse"
#else
"Hide Link Size"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_BROWSER_CONTENTS_HIDE_LINK_SIZE
	);

	/* Hide link permission check */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Esconda Permisos Eslabn"
#elif defined(PROG_LANGUAGE_FRENCH)
"Cacher Permissions Lien"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verstecken Sie Verbindung Erlaubnis"
#elif defined(PROG_LANGUAGE_ITALIAN)
"I Permessi Di Maglia Di Nascondiglio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verberg Schakel Toestemmingen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"As Permisses De Elo De Couro"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Gjemm Ledd Tillatelse"
#else
"Hide Link Permissions"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_BROWSER_CONTENTS_HIDE_LINK_PERMISSIONS
	);


	/* Arrangement frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Arreglo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Arrangement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Anordnung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Disposizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Schikking"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Arranjo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arrangement"
#else
"Arrangement"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Create contents list stack list */
	slist = StackListNew(
	    parent2,
#if defined(PROG_LANGUAGE_SPANISH)
"Disponible", "La Corriente"
#elif defined(PROG_LANGUAGE_FRENCH)
"Disponible", "Courant"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verfgbar", "Strmung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Disponibile", "La Corrente"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verkrijgbaar", "Stroom"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Disponvel", "A Corrente"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tilgjengelig", "Strm"
#else
"Available", "Current"
#endif
	);
	StackListShowDescription(slist, TRUE, TRUE);
	StackListSetMaintainSourceOrder(slist, TRUE);
	StackListMap(slist);
	wref = OptWinWRefAppend(
	    optwin, NULL, NULL,
	    EDV_CFG_PARM_BROWSER_CONTENTS_COLUMN
	);
	OptWinWRefSetStackList(wref, slist);

	/* Create Contents List Headings Stack List */
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Nombre",
"El nombre del objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Nom",
"Le nom de l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Name",
"Name des objekts",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Nome",
"Il nome dell'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Naam",
"Naam van het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Nome",
"O nome do objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Navn",
"Navn av objektet",
#else
"Name",
"Name of the object",
#endif
	    NULL,		/* No icon data */
	    NULL,		/* No client data */
	    EDV_BROWSER_COLUMN_TYPE_NAME,
	    FALSE, TRUE		/* No multiple, stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Tamao",
"El tamao del objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Taille",
"La taille de l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Gre.",
"Gre des objekts",
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Misura",
"La misura dell'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Maat",
"Maat van het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Tamanho",
"O tamanho do objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Strrelse",
"Strrelse av objektet",
#else
"Size",
"Size of the object",
#endif
	    NULL,               /* No icon data */
	    NULL,		/* No client data */
	    EDV_BROWSER_COLUMN_TYPE_SIZE,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Tipo",
"De tipo MIME se asoci con el objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Type",
"Le Type de MIME a associ avec l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Typ",
"MIME Typ hat verbunden mit dem objekt",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Tipo",
"Il tipo di MIME  frequentato l'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Type",
"MIME type associeerde met het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Tipo",
"O tipo de MIME associou-se com o objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Type",
"MIME maskinskriver tilknyttet med objektet",
#else
"Type",
"MIME Type associated with the object",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_TYPE,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"Los Permisos",
"Los permisos para el objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Permissions",
"Les permissions pour l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Erlaubnis",
"Erlaubnis fr das objekt",
#elif defined(PROG_LANGUAGE_ITALIAN)
"I Permessi",
"I permessi per l'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Toestemmingen",
"Toestemmingen voor het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"As Permisses",
"As permisses para o objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tillatelse",
"Tillatelse for objektet",
#else
"Permissions",
"Permissions for the object",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_PERMISSIONS,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Dueo",
"El dueo del objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Propritaire",
"Le propritaire de l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Eigentmer",
"Eigentmer des objekts",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Proprietario",
"Il proprietario dell'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Eigenaar",
"Eigenaar van het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Proprietrio",
"O proprietrio do objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Eier",
"Eier av objektet",
#else
"Owner",
"Owner of the object",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_OWNER,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Grupo",
"La propiedad agrupada del objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Groupe",
"La possession groupe de l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Gruppe",
"Klassifiziertes eigentumsrecht des objekts",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Gruppo",
"La propriet raggruppata dell'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Groep",
"Gegroepeerd eigendomsrecht van het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Grupo",
"Posse agrupada do objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Gruppe",
"Gruppert eiendomsrett av objektet",
#else
"Group",
"Grouped ownership of the object",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_GROUP,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Acceso De La Fecha",
"Feche que el objeto era ltimo conseguir acceso a",
#elif defined(PROG_LANGUAGE_FRENCH)
"Accs De Date",
"Dater que l'objet tait dernier a accd ",
#elif defined(PROG_LANGUAGE_GERMAN)
"Datieren Sie Zugriff",
"Datum, da das objekt zuletzt auf zugegriffen wurde",
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Accesso Di Data",
"Data che l'oggetto era ultimo accesso a",
#elif defined(PROG_LANGUAGE_DUTCH)
"Dateer Toegang",
"Datum dat het voorwerp was vorig toegang tot had",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Acesso De Data",
"Date que o objeto era ltimo acedido",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Dater Tilgang",
"Dato at objektet var siste kommet til",
#else
"Date Access",
"Date that the object was last accessed",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_DATE_ACCESS,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"Feche Modificado",
"La fecha que el objeto era ltimo modificado",
#elif defined(PROG_LANGUAGE_FRENCH)
"Dater Modifi",
"La date que l'objet tait dernier",
#elif defined(PROG_LANGUAGE_GERMAN)
"Datum Hat Modifiziert",
"Datum, da das objekt zuletzt modifiziert wurde",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Datare Modificato",
"Data che l'oggetto era ultimo modificato",
#elif defined(PROG_LANGUAGE_DUTCH)
"Datum Wijzigde",
"Datum dat het voorwerp vorig gewijzigde was",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Date Modificado",
"Data que o objeto era ltimos modificados",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Dato Modifisert",
"Dato at objektet var siste modifisert",
#else
"Date Modified",
"Date that the object was last modified",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_DATE_MODIFIED,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"Feche Cambiado",
"Feche que el objeto era ltimo cambiado",
#elif defined(PROG_LANGUAGE_FRENCH)
"Dater Chang",
"Dater que l'objet tait dernier",
#elif defined(PROG_LANGUAGE_GERMAN)
"Datum Hat Gendert",
"Datum, da das objekt zuletzt gendert wurde",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Datare Cambiato",
"Data che l'oggetto era ultimo cambiato",
#elif defined(PROG_LANGUAGE_DUTCH)
"Datum Veranderde",
"Datum dat het voorwerp vorig veranderde was",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Date Mudado",
"Date que o objeto era ltimo mudado",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Dato Forandret Seg",
"Dato at objektet var siste forandret",
#else
"Date Changed",
"Date that the object was last changed",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_DATE_CHANGED,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
"Hard Links",
"Number of hard links to the object",
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_HARD_LINKS,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"Ligado A",
"Ligue el destino",
#elif defined(PROG_LANGUAGE_FRENCH)
"Reli A",
"Relier la destination",
#elif defined(PROG_LANGUAGE_GERMAN)
"Verknpft Zu",
"Verknpfen sie reiseziel",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Concatenato A",
"Concatenare la destinazione",
#elif defined(PROG_LANGUAGE_DUTCH)
"Verbindenene Te",
"Verbind bestemming",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Ligado A",
"Ligue destino",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Forbundet Til",
"Forbind destinasjon",
#else
"Linked To",
"Link destination",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_LINKED_TO,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
"Device",
"Device that the object exists on",
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_DEVICE,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
"INode",
"Address on the device that the object is located at",
 	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_INODE,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"De Tipo Dispositivo",
"El dispositivo el par mayor y secundario del nmero",
#elif defined(PROG_LANGUAGE_FRENCH)
"Type D'Appareil",
"Le commandant d'appareil et la paire de numro mineure",
#elif defined(PROG_LANGUAGE_GERMAN)
"Gertetyp",
"Gertemajor und minderjhriger zhlen paar",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Tipo Di Congegno",
"Congegno maggiore e minore numero",
#elif defined(PROG_LANGUAGE_DUTCH)
"Apparaat Type",
"Apparaat majoor en minderjarige nummeren paar",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Tipo De Artifcio",
"O artifcio par menor importante de nmero",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Innretnings Type",
"Innretnings major og mindr erigantall par",
#else
"Device Type",
"Device major and minor number pair",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_DEVICE_TYPE,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
"Block Size",
"Block size for file system IO",
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_BLOCK_SIZE,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
"Blocks",
"Number of blocks allocated for the object",
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_BLOCKS,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);

	StackListUpdateMenus(slist);

}

/*
 *	Creates the File Browser Tool Bar page.
 */
static void EDVCreateCustomizeBrowserToolBarPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	gint i;
	gchar *s;
	GSList *gslist;
	GtkWidget *w, *parent2, *parent3;
	optwin_wref_struct *wref;
	stack_list_struct *slist;
	edv_browser_opid_struct **opid, *opid_ptr;
	gint total_opids;
	gchar slist_item_name[256];


	/* Hbox for toolbar display and relief frames */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent2 = w;


	/* Display Buttons As Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Despliegue Abrocha Como"
#elif defined(PROG_LANGUAGE_FRENCH)
"L'exposition Boutonne Comme"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausstellung Knpft Als Zu"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Mostra Abbottona Come"
#elif defined(PROG_LANGUAGE_DUTCH)
"Tentoonstelling Knoopt Als Dicht"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Exiba Botes Como"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utstilling Knapper Som"
#else
"Display Buttons As"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Text */
	gslist = NULL;
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Texto"
#elif defined(PROG_LANGUAGE_FRENCH)
"Texte"
#elif defined(PROG_LANGUAGE_GERMAN)
"Text"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Testo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Tekst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Texto"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tekst"
#else
"Text"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_BROWSER_TOOL_BAR_DISPLAY
	);
	wref->radio_value = TOOLBAR_DISPLAY_TEXT;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Pictures */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Los Retratos"
#elif defined(PROG_LANGUAGE_FRENCH)
"Images"
#elif defined(PROG_LANGUAGE_GERMAN)
"Bilder"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Le Immagini"
#elif defined(PROG_LANGUAGE_DUTCH)
"Afbeelding"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Quadros"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bilder"
#else
"Pictures"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_BROWSER_TOOL_BAR_DISPLAY
	);
	wref->radio_value = TOOLBAR_DISPLAY_PICTURES;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Pictures & Text */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Los Retratos & Texto"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Images & Le Texte"
#elif defined(PROG_LANGUAGE_GERMAN)
"Bilder & Text"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Le Immagini & Il Testo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Afbeelding & Tekst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Quadros & Texto"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bilder & Tekst"
#else
"Pictures & Text"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_BROWSER_TOOL_BAR_DISPLAY
	);
	wref->radio_value = TOOLBAR_DISPLAY_PICTURES_AND_TEXT;


	/* Buttons Relief Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Alivio De Botones"
#elif defined(PROG_LANGUAGE_FRENCH)
"Soulagement De Boutons"
#elif defined(PROG_LANGUAGE_GERMAN)
"Knpfe Erleichterung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Sollievo Di Bottoni"
#elif defined(PROG_LANGUAGE_DUTCH)
"Knopen Steun"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Alvio De Botes"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Knapp Lettelse"
#else
"Buttons Relief"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Flush */
	gslist = NULL;
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Rubor"
#elif defined(PROG_LANGUAGE_FRENCH)
"Eclat"
#elif defined(PROG_LANGUAGE_GERMAN)
"Splen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Flusso"
#elif defined(PROG_LANGUAGE_DUTCH)
"Vloed"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Nivele"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Spyl"
#else
"Flush"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_BROWSER_TOOL_BAR_RELIEF
	);
	wref->radio_value = TOOLBAR_RELIEF_NONE;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Half */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"La Mitad"
#elif defined(PROG_LANGUAGE_FRENCH)
"Moiti"
#elif defined(PROG_LANGUAGE_GERMAN)
"Hlfte"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Met"
#elif defined(PROG_LANGUAGE_DUTCH)
"Helft"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Metade"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Halvdel"
#else
"Half"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_BROWSER_TOOL_BAR_RELIEF
	);
	wref->radio_value = TOOLBAR_RELIEF_HALF;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Raised */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Levantado"
#elif defined(PROG_LANGUAGE_FRENCH)
"Hauss"
#elif defined(PROG_LANGUAGE_GERMAN)
"Erhoben"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Aumentato"
#elif defined(PROG_LANGUAGE_DUTCH)
"Opgetilde"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Levantado"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Hevet"
#else
"Raised"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_BROWSER_TOOL_BAR_RELIEF
	);
	wref->radio_value = TOOLBAR_RELIEF_NORMAL;



	/* Arrangement Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Arreglo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Arrangement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Anordnung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Disposizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Schikking"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Arranjo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arrangement"
#else
"Arrangement"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Create Tool Bar Stack List */
	slist = StackListNew(
	    parent2,
#if defined(PROG_LANGUAGE_SPANISH)
"Disponible", "La Corriente"
#elif defined(PROG_LANGUAGE_FRENCH)
"Disponible", "Courant"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verfgbar", "Strmung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Disponibile", "La Corrente"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verkrijgbaar", "Stroom"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Disponvel", "A Corrente"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tilgjengelig", "Strm"
#else
"Available", "Current"
#endif
	);
	StackListShowDescription(slist, TRUE, TRUE);
	StackListSetMaintainSourceOrder(slist, TRUE);
	StackListMap(slist);
	wref = OptWinWRefAppend(
	    optwin, NULL, NULL,
	    EDV_CFG_PARM_BROWSER_TOOL_BAR
	);
	OptWinWRefSetStackList(wref, slist);

	/* Create tool bar items from browser operation ids */
	opid = EDVBrowserOPIDListNew(NULL, &total_opids);
	for(i = 0; i < total_opids; i++)
	{
	    opid_ptr = opid[i];
	    if(opid_ptr == NULL)
		continue;

	    /* Copy menu name from opid to the slist item name buffer
	     * and sanitize it
	     */
	    strncpy(
		slist_item_name,
		(opid_ptr->menu_name != NULL) ?
		    opid_ptr->menu_name : "(null)",
		sizeof(slist_item_name)
	    );
	    slist_item_name[sizeof(slist_item_name) - 1] = '\0';

	    s = strstr(slist_item_name, "...");
	    if(s != NULL)
		*s = '\0';

	    /* Add slist item from this opid */
	    StackListAppend(
		slist, slist_item_name, opid_ptr->tooltip,
		opid_ptr->button_icon_data,
		NULL,				/* Client Data */
		(gint)opid_ptr->op,		/* ID */
		opid_ptr->allow_multiple,	/* Allow Multiples? */
		FALSE				/* Fixed On Target? */
	    );
	}
	/* Delete Operation IDs */
	EDVBrowserOPIDListDelete(opid, total_opids);
	StackListUpdateMenus(slist);

}

/*
 *	Creates the File Browser Appearance page.
 */
static void EDVCreateCustomizeBrowserAppearancePage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	GtkWidget *w, *parent2, *parent3, *parent4;
	optwin_wref_struct *wref;


	/* Hbox to separate two columns */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent = w;


	/* First column vbox */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent2 = w;

	/* Show In Title Bar Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Muestre En La Barra Del Ttulo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Montrer Dans La Barre De Titre"
#elif defined(PROG_LANGUAGE_GERMAN)
"Zeigen Sie In Titel Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Mostrare Nella Sbarra Di Titolo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Toon In Titel Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Mostre Em Barra De Ttulo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Vis In Title Bar"
#else
"Show In Title Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Show User Name */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"El Nombre Del Usuario"
#elif defined(PROG_LANGUAGE_FRENCH)
"Nom D'Utilisateur"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verbraucher Name"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Nome Di Operatore"
#elif defined(PROG_LANGUAGE_DUTCH)
"Gebruiker Naam"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Nome De Operador"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bruker Name"
#else
"User Name"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_BROWSER_TITLE_WITH_USER
	);

	/* Show Location */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"La Ubicacin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Emplacement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ort"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Posizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Plaats"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Localidade"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Plassering"
#else
"Location"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_BROWSER_TITLE_WITH_LOCATION
	);


	/* Display Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Despliegue"
#elif defined(PROG_LANGUAGE_FRENCH)
"Exposition"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausstellung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Mostra"
#elif defined(PROG_LANGUAGE_DUTCH)
"Tentoonstelling"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Exposio"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utstilling"
#else
"Display"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Show Tool Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra De Instrumento"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre D'Outil"
#elif defined(PROG_LANGUAGE_GERMAN)
"Werkzeug Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Di attrezzo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Werktuig Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra De Ferramenta"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Redskap Bar"
#else
"Tool Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_BROWSER_SHOW_TOOL_BAR
	);

	/* Show Location Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra De Ubicacin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre D'Emplacement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ort Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Di Posizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Plaats Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra De Localidade"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Plassering Bar"
#else
"Location Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_BROWSER_SHOW_LOCATION_BAR
	);

	/* Show Mount Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra El Monte"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre Mont"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stab Untersatz"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Sbarra Il Monte"
#elif defined(PROG_LANGUAGE_DUTCH)
"Staaf Berg"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Barra O Monte"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bar Fotstykke"
#else
"Mount Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_BROWSER_SHOW_MOUNT_BAR
	);

	/* Show Find Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra La Encuentre"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre La Trouver"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stab Sie Finden"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Trova"
#elif defined(PROG_LANGUAGE_DUTCH)
"Sluit Vondst Uit"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra Acha"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sperr Find"
#else
"Find Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_BROWSER_SHOW_FIND_BAR
	);

	/* Show Status Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra La Posicin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre La Statut"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stab Sie Status"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Lo Stato"
#elif defined(PROG_LANGUAGE_DUTCH)
"Sluit Status"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra Estado"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sperr Status"
#else
"Status Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_BROWSER_SHOW_STATUS_BAR
	);


	/* Second column vbox */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent2 = w;


	/* Filter Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Filtro"
#elif defined(PROG_LANGUAGE_FRENCH)
"Filtre"
#elif defined(PROG_LANGUAGE_GERMAN)
"Filter"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Filtro"
#elif defined(PROG_LANGUAGE_DUTCH)
"Filter"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Filtro"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Filter"
#else
"Filter"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Show Hidden Objects */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Los Objetos Escondidos"
#elif defined(PROG_LANGUAGE_FRENCH)
"Objets Cachs"
#elif defined(PROG_LANGUAGE_GERMAN)
"Versteckte Objekte"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Gli Oggetti Nascosti"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verbergenene Voorwerpen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Objetos Escondidos"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Gjemte Objekt"
#else
"Hidden Objects"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_BROWSER_SHOW_OBJECT_HIDDEN
	);

	/* Show No Access Objects */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Ningn Acceso Se Opone"
#elif defined(PROG_LANGUAGE_FRENCH)
"Aucuns Objets D'accs"
#elif defined(PROG_LANGUAGE_GERMAN)
"Keine Zugriffsobjekte"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Nessuno Accesso Obbietta"
#elif defined(PROG_LANGUAGE_DUTCH)
"Geen Toegang Heeft Bezwaar"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Nenhum Acesso Ope-se"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Ingen Tilgang Protesterer"
#else
"No Access Objects"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_BROWSER_SHOW_OBJECT_NOACCESS
	);

}

/*
 *	Creates the General New Objects Menu page.
 */
static void EDVCreateCustomizeGeneralNewObjectsMenuPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{





}

/*
 *	Creates the General Styles page.
 */
static void EDVCreateCustomizeGeneralStylesPage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5, 
			border_minor = 2; 
	GtkWidget *w, *parent2, *parent3;
	optwin_wref_struct *wref;
	style_edit_struct *se;

	/* Styles Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Estilo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Styles"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stil"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Lo Stile"
#elif defined(PROG_LANGUAGE_DUTCH)
"Stijl"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Estilo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Stil"
#else
"Styles"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Override GTK Style Check */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Haga Caso Omiso El Estilo De GTK"
#elif defined(PROG_LANGUAGE_FRENCH)
"Annuler Le Style De GTK"
#elif defined(PROG_LANGUAGE_GERMAN)
"Heben Sie GTK Stil Auf"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Annullare Lo Stile Di GTK"
#elif defined(PROG_LANGUAGE_DUTCH)
"Hef GTK Stijl Op"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Anule Estilo De GTK"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tilsidesettende GTK Stil"
#else
"Override GTK Style"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL, EDV_CFG_PARM_GTK_STYLE_OVERRIDE
	);

	w = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Standard Style Edit */
	se = StyleEditNew(
	    parent2,
#if defined(PROG_LANGUAGE_SPANISH)
"El Estilo Uniforme"
#elif defined(PROG_LANGUAGE_FRENCH)
"Style Standard"
#elif defined(PROG_LANGUAGE_GERMAN)
"Normaler Stil"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Lo Stile Standard"
#elif defined(PROG_LANGUAGE_DUTCH)
"Normale Stijl"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Estilo Normal"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Normal Stil"
#else
"Standard Style"
#endif   
	);
	wref = OptWinWRefAppend(
	    optwin, NULL, NULL, EDV_CFG_PARM_STYLE_STANDARD 
	);
	OptWinWRefSetStyleEdit(wref, se);

	w = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Lists Style Edit */
	se = StyleEditNew(
	    parent2,
#if defined(PROG_LANGUAGE_SPANISH)
"El Estilo De Listas"
#elif defined(PROG_LANGUAGE_FRENCH)
"Style De Listes"    
#elif defined(PROG_LANGUAGE_GERMAN)
"Listen Stil"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Lo Stile Di Elenchi"
#elif defined(PROG_LANGUAGE_DUTCH)
"Lijsten Stijl"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Estilo De Listas"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Liste Stil"
#else
"Lists Style"
#endif   
	);
	wref = OptWinWRefAppend(
	    optwin, NULL, NULL, EDV_CFG_PARM_STYLE_LISTS    
	);
	OptWinWRefSetStyleEdit(wref, se);
}

/*
 *	Creates the General Appearance page.
 */
static void EDVCreateCustomizeGeneralAppearancePage(
	edv_core_struct *core_ptr, optwin_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	GtkAdjustment *adj;
	GtkWidget *w, *parent2, *parent3;
	optwin_wref_struct *wref;


	/* Window Placement Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Colocacin De La Ventana"
#elif defined(PROG_LANGUAGE_FRENCH)
"Placement De Fentre"
#elif defined(PROG_LANGUAGE_GERMAN)
"Fenster Unterbringung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Collocamento Di Finestra"
#elif defined(PROG_LANGUAGE_DUTCH)
"Raam Plaatsing"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Colocao De Janela"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Vindu Plassering"
#else
"Window Placement"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Hbox for Window Cascade Offset X */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	/* Label */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Desviacin De La Cascada"
#elif defined(PROG_LANGUAGE_FRENCH)
"La Cascade A Dcal"
#elif defined(PROG_LANGUAGE_GERMAN)
"Strzen Sie Ausgleich Herab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Cascata Contrappone"
#elif defined(PROG_LANGUAGE_DUTCH)
"Val Compensatie"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Cascata Compensar"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Cascade Motvekt"
#else
"Cascade Offset"
#endif
	    " X:"
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Cascade Offset X Spin */
	adj = (GtkAdjustment *)gtk_adjustment_new(
	    0.0f, -100000.0f, 100000.0f,
	    1.0f, 5.0f, 0.0f
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 60, -1);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_WINDOW_CASCADE_OFFSET_X
	);

	/* Label */
	w = gtk_label_new("Y:");
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	/* Cascade Offset Y Spin */
	adj = (GtkAdjustment *)gtk_adjustment_new(
	    0.0f, -100000.0f, 100000.0f,
	    1.0f, 5.0f, 0.0f
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 60, -1);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_WINDOW_CASCADE_OFFSET_Y
	);


	/* Tool Tips Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Instrumento Inclina"
#elif defined(PROG_LANGUAGE_FRENCH)
"L'Outil Se Renverse"
#elif defined(PROG_LANGUAGE_GERMAN)
"Werkzeug Neigt"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Attrezzo Rovescia"
#elif defined(PROG_LANGUAGE_DUTCH)
"Werktuig Tipt"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Ferramenta Vira"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Redskap Velter"
#else
"Tool Tips"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Hbox for Show Tooltips & Texttips */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	/* Show Tooltips Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Instrumento De La Exposicin Inclina"
#elif defined(PROG_LANGUAGE_FRENCH)
"L'Outil De Spectacle Se Renverse"
#elif defined(PROG_LANGUAGE_GERMAN)
"Zeigen Sie Werkzeug Spitzen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Attrezzo Di Mostra Rovescia"
#elif defined(PROG_LANGUAGE_DUTCH)
"Toon Aan Werktuig Fooien"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Ferramenta De Exposio Vira"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Vis RedskapTupper"
#else
"Show Tooltips"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_SHOW_TOOLTIPS
	);

	/* Show Texttips Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Texto De La Exposicio'n Inclina"
#elif defined(PROG_LANGUAGE_FRENCH)
"Texte De Spectacle Se Renverse"
#elif defined(PROG_LANGUAGE_GERMAN)
"Schauentext Neigt"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Testo Di Mostra Rovescia"
#elif defined(PROG_LANGUAGE_DUTCH)
"De Vertoning Tekst Tipt"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Texto De Exposic"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utstillingstekst Velter"
#else
"Show Texttips"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = OptWinWRefAppend(
	    optwin, w, NULL,
	    EDV_CFG_PARM_SHOW_TEXTTIPS
	);



}

/*
 *	Selects the notebook tab specified by tab_name for the given
 *	customize window.
 */
void EDVCustomizeWindowSelectTab(
	optwin_struct *optwin, const gchar *tab_name
)
{
	gint page_num;
	GtkNotebook *notebook;


	if(optwin == NULL)
	    return;

	notebook = (GtkNotebook *)optwin->notebook;
	if(notebook == NULL)
	    return;

	/* Tab name given? */
	if(!STRISEMPTY(tab_name))
	{
	    /* Handle by tab name */
	    if(!g_strcasecmp(tab_name, "Global") ||
	       !g_strcasecmp(tab_name, "General")
	    )
		page_num = 0;
	    else if(!g_strcasecmp(tab_name, "File Browser"))
		page_num = 1;
	    else if(!g_strcasecmp(tab_name, "Image Browser"))
		page_num = 2;
	    else if(!g_strcasecmp(tab_name, "Archiver"))
		page_num = 3;
	    else if(!g_strcasecmp(tab_name, "Recycle Bin"))
		page_num = 4;
	    else
	    {
		page_num = -1;
		g_printerr(
"EDVCustomizeWindowSelectTab(): Warning:\
 Invalid tab name \"%s\".\n",
		    tab_name
		);
	    }
	}
	else
	{
	    page_num = 0;
	}

	/* Got valid page? */
	if(page_num > -1)
	    gtk_notebook_set_page(notebook, page_num);
}

/*
 *	Creates a new customize window.
 */
optwin_struct *EDVCreateCustomizeWindow(
	gpointer core_ptr
)
{
	const gint	border_major = 5,
			border_minor = 2;
	GtkWidget *w, *parent, *parent2;
	optwin_struct *optwin = OptWinNew(
	    core_ptr,
#if defined(PROG_LANGUAGE_SPANISH)
"Haga Personal"
#elif defined(PROG_LANGUAGE_FRENCH)
"Personnaliser"
#elif defined(PROG_LANGUAGE_GERMAN)
"Passen Sie An"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Personalizzare"
#elif defined(PROG_LANGUAGE_DUTCH)
"Aanpas"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Pessoal"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Personlig"
#else
"Customize"
#endif
	    , (guint8 **)icon_customize_48x48_xpm
	);
	if(optwin == NULL)
	    return(optwin);


	/* Begin creating general page */
	parent = gtk_hbox_new(FALSE, border_minor);
	w = EDVNewPixmapWidget(
	    core_ptr,
	    (guint8 **)icon_endeavour_logo_20x20_xpm,
	    "icon_endeavour_logo_20x20_xpm"
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Global"
#elif defined(PROG_LANGUAGE_FRENCH)
"Global"
#elif defined(PROG_LANGUAGE_GERMAN)
"Global"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Globale"
#elif defined(PROG_LANGUAGE_DUTCH)
"Globaal"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Global"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Global"
#else
"Global"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = parent;
	parent = OptWinPageAppend(optwin, w);
	if(parent != NULL)
	{
	    gtk_container_border_width(GTK_CONTAINER(parent), border_major);
	    gtk_box_set_spacing(GTK_BOX(parent), border_major);
	    parent2 = parent;

	    /* Notebook */
	    w = gtk_notebook_new();
	    gtk_notebook_set_tab_pos(GTK_NOTEBOOK(w), GTK_POS_TOP);
	    gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
	    gtk_notebook_set_scrollable(GTK_NOTEBOOK(w), TRUE);
	    gtk_notebook_set_show_tabs(GTK_NOTEBOOK(w), TRUE);
	    gtk_notebook_set_show_border(GTK_NOTEBOOK(w), TRUE);
	    gtk_widget_show(w);
	    parent2 = w;

	    /* Appearance Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Apariencia"
#elif defined(PROG_LANGUAGE_FRENCH)
"Apparence"
#elif defined(PROG_LANGUAGE_GERMAN)
"Erscheinung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Apparenza"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verschijning"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Aparncia"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utseende"
#else
"Appearance"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCreateCustomizeGeneralAppearancePage(
		EDV_CORE(core_ptr), optwin, w
	    );

	    /* Styles Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Estilo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Styles"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stil"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Lo Stile"
#elif defined(PROG_LANGUAGE_DUTCH)
"Stijl"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Estilo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Stil"
#else
"Styles"
#endif
		)
	    );   
	    gtk_widget_show(w);
	    EDVCreateCustomizeGeneralStylesPage(
		EDV_CORE(core_ptr), optwin, w
	    );

#if 0
	    /* New Objects Menu */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
"New Objects Menu"
		)
	    );
	    gtk_widget_show(w);
	    EDVCreateCustomizeGeneralNewObjectsMenuPage(
		EDV_CORE(core_ptr), optwin, w
	    );
#endif

	}

	/* Begin creating File Browser Page */
	parent = gtk_hbox_new(FALSE, border_minor);
	w = EDVNewPixmapWidget(
	    core_ptr,
	    (guint8 **)endeavour_20x20_xpm,
	    "endeavour_20x20_xpm"
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Archive A Examinador"
#elif defined(PROG_LANGUAGE_FRENCH)
"Classer Le Navigateur"
#elif defined(PROG_LANGUAGE_GERMAN)
"Datei Browser"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Schedare Il Browser"
#elif defined(PROG_LANGUAGE_DUTCH)
"Archiveer Browser"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Arquive Browser"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arkiver Browser"
#else
"File Browser"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = parent;
	parent = OptWinPageAppend(optwin, w);
	if(parent != NULL)
	{
	    gtk_container_border_width(GTK_CONTAINER(parent), border_major);
	    gtk_box_set_spacing(GTK_BOX(parent), border_major);
	    parent2 = parent;


	    /* Notebook */
	    w = gtk_notebook_new();
	    gtk_notebook_set_tab_pos(GTK_NOTEBOOK(w), GTK_POS_TOP);
	    gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
	    gtk_notebook_set_scrollable(GTK_NOTEBOOK(w), TRUE);
	    gtk_notebook_set_show_tabs(GTK_NOTEBOOK(w), TRUE);
	    gtk_notebook_set_show_border(GTK_NOTEBOOK(w), TRUE);
	    gtk_widget_show(w);
	    parent2 = w;


	    /* Appearance Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Apariencia"
#elif defined(PROG_LANGUAGE_FRENCH)
"Apparence"
#elif defined(PROG_LANGUAGE_GERMAN)
"Erscheinung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Apparenza"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verschijning"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Aparncia"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utseende"
#else
"Appearance"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCreateCustomizeBrowserAppearancePage(
		EDV_CORE(core_ptr), optwin, w
	    );

	    /* Tool Bar Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Barra Del Instrumento"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre D'Outil"
#elif defined(PROG_LANGUAGE_GERMAN)
"Werkzeug Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Di Attrezzo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Werktuig Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra De Ferramenta"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Redskap Bar"
#else
"Tool Bar"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCreateCustomizeBrowserToolBarPage(
		EDV_CORE(core_ptr), optwin, w
	    );

	    /* Contents List Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Lista Del Contenido"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Contenus Enumrent"
#elif defined(PROG_LANGUAGE_GERMAN)
"Inhalt Liste"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Elenco Di Contenuto"
#elif defined(PROG_LANGUAGE_DUTCH)
"Inhoud Lijst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Lista De Contedo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Innhold Liste"
#else
"Contents List"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCreateCustomizeBrowserContentsListPage(
		EDV_CORE(core_ptr), optwin, w
	    );

	}

	/* Begin creating image browser page */
	parent = gtk_hbox_new(FALSE, border_minor);
	w = EDVNewPixmapWidget(
	    core_ptr,
	    (guint8 **)image_browser_20x20_xpm,
	    "image_browser_20x20_xpm"
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Imagine A Examinador"
#elif defined(PROG_LANGUAGE_FRENCH)
"Navigateur D'Image"
#elif defined(PROG_LANGUAGE_GERMAN)
"Bildnis Browser"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Browser Di Immagine"
#elif defined(PROG_LANGUAGE_DUTCH)
"Beeld Browser"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Browser De Imagem"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Avbilde Browser"
#else
"Image Browser"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = parent;
	parent = OptWinPageAppend(optwin, w);
	if(parent != NULL)
	{
	    gtk_container_border_width(GTK_CONTAINER(parent), border_major);
	    gtk_box_set_spacing(GTK_BOX(parent), border_major);
	    parent2 = parent;


	    /* Notebook */
	    w = gtk_notebook_new();
	    gtk_notebook_set_tab_pos(GTK_NOTEBOOK(w), GTK_POS_TOP);
	    gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
	    gtk_notebook_set_scrollable(GTK_NOTEBOOK(w), TRUE);
	    gtk_notebook_set_show_tabs(GTK_NOTEBOOK(w), TRUE);
	    gtk_notebook_set_show_border(GTK_NOTEBOOK(w), TRUE);
	    gtk_widget_show(w);
	    parent2 = w;


	    /* Appearance Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Apariencia"
#elif defined(PROG_LANGUAGE_FRENCH)
"Apparence"
#elif defined(PROG_LANGUAGE_GERMAN)
"Erscheinung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Apparenza"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verschijning"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Aparncia"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utseende"
#else
"Appearance"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCreateCustomizeImbrAppearancePage(
		EDV_CORE(core_ptr), optwin, w
	    );

	    /* Tool Bar Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Barra Del Instrumento"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre D'Outil"
#elif defined(PROG_LANGUAGE_GERMAN)
"Werkzeug Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Di Attrezzo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Werktuig Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra De Ferramenta"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Redskap Bar"
#else
"Tool Bar"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCreateCustomizeImbrToolBarPage(
		EDV_CORE(core_ptr), optwin, w
	    );

	    /* Thumbs List Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Lista De Pulgares"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Pouces Enumrent"
#elif defined(PROG_LANGUAGE_GERMAN)
"Daumen Fhren Auf"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Elenco Di Pollici"
#elif defined(PROG_LANGUAGE_DUTCH)
"Duimen Lijst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Polegares Alistam"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tommelfinger Lister Opp"
#else
"Thumbs List"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCreateCustomizeImbrThumbsListPage(
		EDV_CORE(core_ptr), optwin, w
	    );

	}


	/* Begin creating Archiver Page */
	parent = gtk_hbox_new(FALSE, border_minor);
	w = EDVNewPixmapWidget(
	    core_ptr,
	    (guint8 **)archiver_20x20_xpm,
	    "archiver_20x20_xpm"
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Fabricante Del Archivo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Archiver Le Fabricant"
#elif defined(PROG_LANGUAGE_GERMAN)
"Archivieren Sie Hersteller"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Fabbricante Di Archivio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Archief Maker"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Criador De Arquivo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arkiv Skaper"
#else
"Archiver"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = parent;
	parent = OptWinPageAppend(optwin, w);
	if(parent != NULL)
	{
	    gtk_container_border_width(GTK_CONTAINER(parent), border_major);
	    gtk_box_set_spacing(GTK_BOX(parent), border_major);
	    parent2 = parent;


	    /* Notebook */
	    w = gtk_notebook_new();
	    gtk_notebook_set_tab_pos(GTK_NOTEBOOK(w), GTK_POS_TOP);
	    gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
	    gtk_notebook_set_scrollable(GTK_NOTEBOOK(w), TRUE);
	    gtk_notebook_set_show_tabs(GTK_NOTEBOOK(w), TRUE);
	    gtk_notebook_set_show_border(GTK_NOTEBOOK(w), TRUE);
	    gtk_widget_show(w);
	    parent2 = w;


	    /* Appearance Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Apariencia"
#elif defined(PROG_LANGUAGE_FRENCH)
"Apparence"
#elif defined(PROG_LANGUAGE_GERMAN)
"Erscheinung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Apparenza"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verschijning"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Aparncia"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utseende"
#else
"Appearance"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCreateCustomizeArchiverAppearancePage(
		EDV_CORE(core_ptr), optwin, w
	    );

	    /* Tool Bar Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Barra Del Instrumento"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre D'Outil"
#elif defined(PROG_LANGUAGE_GERMAN)
"Werkzeug Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Di Attrezzo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Werktuig Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra De Ferramenta"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Redskap Bar"
#else
"Tool Bar"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCreateCustomizeArchiverToolBarPage(
		EDV_CORE(core_ptr), optwin, w
	    );

	    /* Contents List Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Lista Del Contenido"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Contenus Enumrent"
#elif defined(PROG_LANGUAGE_GERMAN)
"Inhalt Liste"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Elenco Di Contenuto"
#elif defined(PROG_LANGUAGE_DUTCH)
"Inhoud Lijst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Lista De Contedo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Innhold Liste"
#else
"Contents List"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCreateCustomizeArchiverContentsListPage(
		EDV_CORE(core_ptr), optwin, w
	    );

	}


	/* Begin creating Recycle Bin Page */
	parent = gtk_hbox_new(FALSE, border_minor);
	w = EDVNewPixmapWidget(
	    core_ptr,
	    (guint8 **)icon_trash_20x20_xpm,
	    "icon_trash_20x20_xpm"
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Cajn De Refycle"
#elif defined(PROG_LANGUAGE_FRENCH)
"Refycle Huche"
#elif defined(PROG_LANGUAGE_GERMAN)
"Refycle Behlter"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Recipiente Di Refycle"
#elif defined(PROG_LANGUAGE_DUTCH)
"Refycle Bak"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Caixa De Refycle"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Refycle Beholder"
#else
"Recycle Bin"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = parent;
	parent = OptWinPageAppend(optwin, w);
	if(parent != NULL)
	{
	    gtk_container_border_width(GTK_CONTAINER(parent), border_major);
	    gtk_box_set_spacing(GTK_BOX(parent), border_major);
	    parent2 = parent;


	    /* Notebook */
	    w = gtk_notebook_new();
	    gtk_notebook_set_tab_pos(GTK_NOTEBOOK(w), GTK_POS_TOP);
	    gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
	    gtk_notebook_set_scrollable(GTK_NOTEBOOK(w), TRUE);
	    gtk_notebook_set_show_tabs(GTK_NOTEBOOK(w), TRUE);
	    gtk_notebook_set_show_border(GTK_NOTEBOOK(w), TRUE);
	    gtk_widget_show(w);
	    parent2 = w;


	    /* Appearance page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Apariencia"
#elif defined(PROG_LANGUAGE_FRENCH)
"Apparence"
#elif defined(PROG_LANGUAGE_GERMAN)
"Erscheinung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Apparenza"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verschijning"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Aparncia"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utseende"
#else
"Appearance"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCreateCustomizeRecBinAppearancePage(
		EDV_CORE(core_ptr), optwin, w
	    );

	    /* Tool Bar Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Barra Del Instrumento"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre D'Outil"
#elif defined(PROG_LANGUAGE_GERMAN)
"Werkzeug Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Di Attrezzo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Werktuig Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra De Ferramenta"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Redskap Bar"
#else
"Tool Bar"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCreateCustomizeRecBinToolBarPage(
		EDV_CORE(core_ptr), optwin, w
	    );

	    /* Contents List Page */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
	    gtk_notebook_append_page(
		GTK_NOTEBOOK(parent2), w, gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Lista Del Contenido"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Contenus Enumrent"
#elif defined(PROG_LANGUAGE_GERMAN)
"Inhalt Liste"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Elenco Di Contenuto"
#elif defined(PROG_LANGUAGE_DUTCH)
"Inhoud Lijst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Lista De Contedo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Innhold Liste"
#else
"Contents List"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCreateCustomizeRecBinContentsListPage(
		EDV_CORE(core_ptr), optwin, w
	    );

	}





	return(optwin);
}
