/*
		   Endeavour Pointer Cursor Structure
 */

#ifndef EDVCURSOR_H
#define EDVCURSOR_H

#include <gtk/gtk.h>


/*
 *      Cursor codes:
 *
 *	Must start from 0 and no skipping indices.
 */
#define EDV_CURSOR_CODE_BUSY    	0
#define EDV_CURSOR_CODE_TEXT		1
#define EDV_CURSOR_CODE_TRANSLATE	2
#define EDV_CURSOR_CODE_RESIZE		3
#define EDV_CURSOR_CODE_CROSSHAIR	4
#define EDV_CURSOR_CODE_HAND		5

/*
 *	Cursor structure:
 */
typedef struct {

	gint code;		/* One of EDV_CURSOR_CODE_* */
	GdkCursor *cursor;	/* Cursor loaded from GDK */

} edv_cursor_struct;
#define EDV_CURSOR(p)	((edv_cursor_struct *)(p))


extern edv_cursor_struct *EDVCursorNewByGDKPreset(
	gint cursor_code, GdkCursorType gdk_cursor_type
);
extern void EDVCursorDelete(edv_cursor_struct *cur);


#endif	/* EDVCURSOR_H */
