/*
		      Endeavour Browser Callbacks
 */

#ifndef BROWSERCB_H
#define BROWSERCB_H

#include <sys/stat.h>
#include <gtk/gtk.h>
#include "edvdevices.h"
#include "edvmimetypes.h"
#include "stacklist.h"
#include "browser.h"


extern void EDVBrowserContentsItemDestroyCB(gpointer data);
extern void EDVBrowserDirTreeItemDestroyCB(gpointer data);

extern gint EDVBrowserDeleteEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
extern void EDVBrowserDestroyCB(GtkObject *object, gpointer data);

extern gint EDVBrowserKeyEventCB(
	 GtkWidget *widget, GdkEventKey *key, gpointer data
);
extern gint EDVBrowserButtonPressEventCB(
	GtkWidget *widget, GdkEventButton *button, gpointer data
);

extern void EDVBrowserHandleChildAttachedCB(
	GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);
extern void EDVBrowserHandleChildDetachedCB(
	GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);

extern void EDVBrowserTreeSelectRowCB(
	GtkCTree *ctree, GtkCTreeNode *node, gint column,
	gpointer data
);
extern void EDVBrowserTreeUnselectRowCB(
	GtkCTree *ctree, GtkCTreeNode *node, gint column,
	gpointer data
);
extern void EDVBrowserTreeExpandCB(
	GtkCTree *ctree, GtkCTreeNode *node, gpointer data
);
extern void EDVBrowserTreeCollapseCB(
	GtkCTree *ctree, GtkCTreeNode *node, gpointer data
);

extern void EDVBrowserResizeColumnCB(
	GtkCList *clist, gint column, gint width, gpointer data
);
extern void EDVBrowserClickColumnCB(
	GtkCList *clist, gint column, gpointer data
);
extern void EDVBrowserSelectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);
extern void EDVBrowserUnselectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);

extern void EDVBrowserComboActivateCB(GtkWidget *widget, gpointer data);

extern void EDVBrowserWriteProtectChangedCB(
	edv_browser_struct *browser, gboolean state
);
extern void EDVBrowserObjectAddedNotifyCB(
	edv_browser_struct *browser, const gchar *path,
	const struct stat *lstat_buf
);
extern void EDVBrowserObjectModifiedNotifyCB(
	edv_browser_struct *browser, const gchar *path,
	const gchar *new_path,
	const struct stat *lstat_buf
);
extern void EDVBrowserObjectRemovedNotifyCB(
	edv_browser_struct *browser, const gchar *path
);

extern void EDVBrowserMountNotifyCB(
	edv_browser_struct *browser,
	gint dev_num, edv_device_struct *dev_ptr,
	gboolean is_mounted
);

extern void EDVBrowserRecycledObjectAddedNotifyCB(
	edv_browser_struct *browser, guint index
);
extern void EDVBrowserRecycledObjectRemovedNotifyCB(
	edv_browser_struct *browser, guint index
);

extern void EDVBrowserReconfiguredNotifyCB(edv_browser_struct *browser);

extern void EDVBrowserMimeTypeAddedCB(
	edv_browser_struct *browser,
	gint mt_num, edv_mimetype_struct *mt_ptr
);
extern void EDVBrowserMimeTypeModifiedCB(
	edv_browser_struct *browser,
	gint mt_num, edv_mimetype_struct *mt_ptr
);
extern void EDVBrowserMimeTypeRemovedCB(
	edv_browser_struct *browser, gint mt_num
);

extern void EDVBrowserDeviceAddedCB(
	edv_browser_struct *browser,
	gint dev_num, edv_device_struct *dev_ptr
);
extern void EDVBrowserDeviceModifiedCB(
	edv_browser_struct *browser,
	gint dev_num, edv_device_struct *dev_ptr
);
extern void EDVBrowserDeviceRemovedCB(
	edv_browser_struct *browser, gint dev_num
);


#endif	/* BROWSERCB_H */
