/*
	                   Endeavour File Browser
 */

#ifndef BROWSER_H
#define BROWSER_H


#include <gtk/gtk.h>

#include "edvtypes.h"
#include "edvstatusbar.h"
#include "toolbar.h"
#include "mountbar.h"
#include "findbar.h"
#include "fopdlg.h"


/*
 *	File Browser Contents List Column Types:
 */
typedef enum {
	EDV_BROWSER_COLUMN_TYPE_NAME		= 0,
	EDV_BROWSER_COLUMN_TYPE_SIZE		= 1,
	EDV_BROWSER_COLUMN_TYPE_TYPE		= 2,
	EDV_BROWSER_COLUMN_TYPE_PERMISSIONS	= 3,
	EDV_BROWSER_COLUMN_TYPE_OWNER		= 4,
	EDV_BROWSER_COLUMN_TYPE_GROUP		= 5,
	EDV_BROWSER_COLUMN_TYPE_DATE_ACCESS	= 6,
	EDV_BROWSER_COLUMN_TYPE_DATE_MODIFIED	= 7,
	EDV_BROWSER_COLUMN_TYPE_DATE_CHANGED	= 8,
	EDV_BROWSER_COLUMN_TYPE_HARD_LINKS	= 9,
	EDV_BROWSER_COLUMN_TYPE_LINKED_TO	= 10,
	EDV_BROWSER_COLUMN_TYPE_DEVICE		= 11,
	EDV_BROWSER_COLUMN_TYPE_INODE		= 12,
	EDV_BROWSER_COLUMN_TYPE_DEVICE_TYPE	= 13,
	EDV_BROWSER_COLUMN_TYPE_BLOCK_SIZE	= 14,
	EDV_BROWSER_COLUMN_TYPE_BLOCKS		= 15
} edv_browser_column_type;
/* Total number of column types */
#define EDV_BROWSER_CONTENTS_CLIST_COLUMNS_MAX	16


/*
 *	File Browser Column List Cell Styles:
 *
 *	Cell Style value corresponds to the index of the cell_style
 *	on the edv_browser_struct.
 */
typedef enum {
	EDV_BROWSER_CELL_STYLE_NO_ACCESS	= 0,
	EDV_BROWSER_CELL_STYLE_DANGLING_LINK	= 1,
	EDV_BROWSER_CELL_STYLE_HIDDEN		= 2,
	EDV_BROWSER_CELL_STYLE_EXECUTABLE	= 3
} edv_browser_cell_style;
/* Total number of cell styles */
#define EDV_BROWSER_TOTAL_CELL_STYLES		4


/*
 *	File Browser Operations:
 */
typedef enum {

	EDV_BROWSER_OP_NONE			= 0,
	EDV_BROWSER_OP_SEPARATOR		= 10,

	EDV_BROWSER_OP_CLOSE			= 20,
	EDV_BROWSER_OP_EXIT			= 21,

	EDV_BROWSER_OP_SYNC_DISKS		= 30,
	EDV_BROWSER_OP_RUN			= 31,
	EDV_BROWSER_OP_RUN_TERMINAL		= 32,
	EDV_BROWSER_OP_WRITE_PROTECT    	= 35,

	EDV_BROWSER_OP_NEW			= 40,
	EDV_BROWSER_OP_NEW_FILE			= 41,
	EDV_BROWSER_OP_NEW_DIRECTORY		= 42,
	EDV_BROWSER_OP_NEW_LINK			= 43,
	EDV_BROWSER_OP_NEW_FIFO			= 44,
	EDV_BROWSER_OP_NEW_DEVICE_BLOCK		= 45,
	EDV_BROWSER_OP_NEW_DEVICE_CHARACTER	= 46,
	EDV_BROWSER_OP_NEW_SOCKET		= 47,

	EDV_BROWSER_OP_OPEN			= 50,
	EDV_BROWSER_OP_OPEN_WITH		= 51,

	EDV_BROWSER_OP_GOTO_PARENT		= 60,
	EDV_BROWSER_OP_GOTO_HOME		= 61,
	EDV_BROWSER_OP_EXPAND			= 62,
	EDV_BROWSER_OP_MOUNT			= 63,	/* Mount/unmount */
	EDV_BROWSER_OP_EJECT			= 64,

	EDV_BROWSER_OP_MOVE			= 65,
	EDV_BROWSER_OP_COPY			= 66,
	EDV_BROWSER_OP_LINK			= 67,
	EDV_BROWSER_OP_RENAME			= 68,
	EDV_BROWSER_OP_CHMOD			= 69,
	EDV_BROWSER_OP_CHOWN			= 70,
	EDV_BROWSER_OP_DELETE			= 71,
	EDV_BROWSER_OP_SELECT_ALL		= 72,
	EDV_BROWSER_OP_UNSELECT_ALL		= 73,
	EDV_BROWSER_OP_INVERT_SELECTION		= 74,
	EDV_BROWSER_OP_PROPERTIES		= 75,

	EDV_BROWSER_OP_FIND			= 76,

	EDV_BROWSER_OP_HISTORY			= 77,
	EDV_BROWSER_OP_COPY_PATH		= 78,
	EDV_BROWSER_OP_COPY_URL			= 79,

	EDV_BROWSER_OP_REFRESH			= 80,
	EDV_BROWSER_OP_REFRESH_ALL		= 81,

	EDV_BROWSER_OP_DOWNLOAD			= 85,

	EDV_BROWSER_OP_SHOW_TOOL_BAR		= 90,
	EDV_BROWSER_OP_SHOW_LOCATION_BAR	= 91,
	EDV_BROWSER_OP_SHOW_MOUNT_BAR		= 92,
	EDV_BROWSER_OP_SHOW_FIND_BAR		= 93,
	EDV_BROWSER_OP_SHOW_STATUS_BAR		= 94,

	EDV_BROWSER_OP_DIRECTORY_TREE_ORIGIN	= 97,

	EDV_BROWSER_OP_MIME_TYPES		= 100,
	EDV_BROWSER_OP_DEVICES			= 101,

	EDV_BROWSER_OP_NEW_BROWSER		= 110,
	EDV_BROWSER_OP_NEW_IMBR			= 111,
	EDV_BROWSER_OP_NEW_ARCHIVER		= 112,
	EDV_BROWSER_OP_RECYCLE_BIN		= 113,

	EDV_BROWSER_OP_OPTIONS			= 150,
	EDV_BROWSER_OP_CUSTOMIZE		= 151,

	EDV_BROWSER_OP_DEVICE_CHECK		= 180,
	EDV_BROWSER_OP_DEVICE_TOOLS		= 181,
	EDV_BROWSER_OP_DEVICE_FORMAT		= 182,

	EDV_BROWSER_OP_HELP_ABOUT		= 1000,
	EDV_BROWSER_OP_HELP_CONTENTS		= 1001,
	EDV_BROWSER_OP_HELP_FILE_BROWSER	= 1002,
	EDV_BROWSER_OP_HELP_IMAGE_BROWSER	= 1003,
	EDV_BROWSER_OP_HELP_ARCHIVER		= 1004,
	EDV_BROWSER_OP_HELP_RECYCLE_BIN		= 1005,
	EDV_BROWSER_OP_HELP_KEYS_LIST		= 1006,
	EDV_BROWSER_OP_HELP_MIME_TYPES		= 1007,
	EDV_BROWSER_OP_HELP_DEVICES		= 1008,
	EDV_BROWSER_OP_HELP_COMMON_OPERATIONS	= 1009

} edv_browser_op;


/*
 *	File Browser Operation ID:
 */
typedef struct {

	gpointer	browser;
	edv_browser_op	op;
	gboolean	allow_multiple;		/* Allow multiple instances
						 * of this operation in
						 * lists */
	toolbar_item_type tb_item_type;		/* Type of item when placed
						 * on the tool bar */

	/* Operation callback */
	void	(*func_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* OPID */
	);

	/* Enter and leave notify callbacks */
	void	(*enter_func_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* OPID */
	);
	void	(*leave_func_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* OPID */
	);

	gchar	*button_name,	/* Name as it would appear on a button */
		*menu_name,	/* Name as it would appear on a menu item */
		*tooltip;	/* Tool tip or description (one line) */

	guint	accel_key,	/* Accelerator key */
		accel_mods;	/* Accelerator key modifiers */

	guint8	**button_icon_data,	/* Shared */
		**menu_icon_data;	/* Shared */

} edv_browser_opid_struct;
#define EDV_BROWSER_OPID(p)	((edv_browser_opid_struct *)(p))

/*
 *	File Browser:
 */
typedef struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	processing;
	gint		busy_count,
			freeze_count;
	gpointer	core_ptr;

	edv_browser_opid_struct	**opid;
	gint			total_opids;

	gboolean	tool_bar_map_state,
			location_bar_map_state,
			mount_bar_map_state,
			find_bar_map_state,
			status_bar_map_state;

	GtkWidget	*main_vbox,
			*menu_bar,
			*bars_vbox,		/* Toolbars GtkVBox */

			*menu_bar_handle,
			*tool_bar_handle,
			*location_bar_handle,
			*mount_bar_handle,
			*find_bar_handle,

			*location_bar_hbox,	/* GtkHBox parent for location bar */
			*location_icon_fixed,
			*location_icon_pm,
			*location_combo,

			*main_paned,		/* GtkHPaned */
			*directory_ctree,	/* Directory GtkCTree */
			*contents_clist;	/* Contents GtkCList */

	guint		directory_ctree_expand_optimize_idleid;

	/* General tool bar */
	toolbar_struct	*toolbar;

	/* Mount bar */
	edv_mountbar_struct	*mountbar;

	/* Find bar */
	edv_findbar_struct	*findbar;

	/* Important menu items */
	GtkWidget	*open_mi,
			*openwith_mi,
			*new_object_submi,
			*new_object_submenu,
			*new_file_mi,
			*new_directory_mi,
			*new_link_mi,
			*new_fifo_mi,
			*new_device_block_mi,
			*new_device_character_mi,
			*new_socket_mi,
			*sync_disks_mi,
			*history_mi,
			*run_mi,
			*close_mi,

			*move_mi,
			*copy_mi,
			*link_mi,
			*rename_mi,
			*chmod_mi,
			*chown_mi,
			*delete_mi,
			*select_all_mi,
			*unselect_all_mi,
			*invert_selection_mi,
			*find_mi,
			*properties_mi,

			*mount_mi,
			*eject_mi,
			*device_check_mi,
			*device_tools_mi,
			*device_format_mi,
			*devices_mi,

			*refresh_mi,
			*refresh_all_mi,
			*show_tool_bar_micheck,
			*show_location_bar_micheck,
			*show_mount_bar_micheck,
			*show_find_bar_micheck,
			*show_status_bar_micheck,
			*directory_tree_origin_mi,
			*mime_types_mi,

			*write_protect_mi,
			*options_mi,
			*customize_mi,

			*window_new_browser_mi,
			*window_new_imbr_mi,
			*window_new_archiver_mi,
			*window_recycle_bin_mi,

			*help_contents_mi,
			*help_file_browser_mi,
			*help_keys_list_mi,
			*help_mime_types_mi,
			*help_devices_mi,
			*help_common_operations_mi,
			*help_about_mi;


	/* Directory ctree right-click menu */
	GtkWidget	*directory_ctree_menu,
			*directory_ctree_expand_mi,	/* Expand or colapse */
			*directory_ctree_mount_mi,
			*directory_ctree_eject_mi,
			*directory_ctree_mount_misep,
			*directory_ctree_move_mi,
			*directory_ctree_copy_mi,
			*directory_ctree_link_mi,
			*directory_ctree_rename_mi,
			*directory_ctree_chmod_mi,
			*directory_ctree_chown_mi,
			*directory_ctree_delete_mi,
			*directory_ctree_properties_mi;

	/* Contents ctree right-click menu */
	GtkWidget       *contents_clist_menu,
			*contents_clist_open_mi,
			*contents_clist_openwith_mi,
			*contents_clist_move_mi,
			*contents_clist_copy_mi,
			*contents_clist_link_mi,
			*contents_clist_rename_mi,
			*contents_clist_chmod_mi,
			*contents_clist_chown_mi,
			*contents_clist_delete_mi,
			*contents_clist_properties_mi;



	/* Styles for directory_ctree and contents_clist cells */
	GtkStyle	*cell_style[EDV_BROWSER_TOTAL_CELL_STYLES];

	/* Special icons */
	GdkPixmap	*folder_home_pixmap;
	GdkBitmap	*folder_home_mask;
	GdkPixmap	*folder_parent_pixmap;
	GdkBitmap	*folder_parent_mask;
	GdkPixmap	*folder_noaccess_pixmap;
	GdkBitmap	*folder_noaccess_mask;

	/* Directory toplevel origin directory */
	gchar		*directory_ctree_origin_path;

	/* Last selected node on the ctree (can be NULL)
	 * Note that even if this value is not NULL it should still
	 * be verified that it is a valid node that actuall exists on
	 * the ctree
	 */
	GtkCTreeNode	*directory_ctree_selected_node;

	/* Selected device, reflects the device of the disk object of
	 * the node specified by directory_ctree_selected_node
	 *
	 * This device number corresponds with a device on the core's
	 * list of devices
	 */
	gint		selected_dev_num;

	/* Last selected row on the clist (can be -1 for none)
	 *
	 * Note that this does not reflect other selected rows since
	 * multiple selections are allowed
	 */
	gint		contents_clist_selected_row;


	/* Last known items in recycle bin, this is used as a quick access
	 * value to check if the recycle bin has contents or not
	 *
	 * Can be -1 to indicate undefined
	 */
	gint		last_recbin_items;

	/* Last known write protect state (can be -1 to indicate
	 * undefined)
	 */
	gint		last_write_protect_state;



	/* Status bar */
	edv_status_bar_struct	*status_bar;


	/* File operation dialog */
	edv_fopdlg_struct	*fopdlg;

} edv_browser_struct;
#define EDV_BROWSER(p)	((edv_browser_struct *)(p))


extern void EDVBrowserSetTitle(
	edv_browser_struct *browser,
	const gchar *path
);

extern gchar *EDVBrowserCurrentLocation(edv_browser_struct *browser);
extern void EDVBrowserSetLocation(
	edv_browser_struct *browser,
	const gchar *path, gboolean record_history
);
extern void EDVBrowserUpdateLocationIcon(
	edv_browser_struct *browser, const gchar *path
);

extern void EDVBrowserToolBarRegenerate(edv_browser_struct *browser);
extern void EDVBrowserDirectoryMenuRegenerate(edv_browser_struct *browser);
extern void EDVBrowserContentsMenuRegenerate(edv_browser_struct *browser);

extern void EDVBrowserSyncConfiguration(edv_browser_struct *browser);

extern edv_browser_opid_struct **EDVBrowserOPIDListNew(
	edv_browser_struct *browser,    /* Can be NULL */
	gint *total
);
extern void EDVBrowserOPIDListDelete(
	edv_browser_opid_struct **list, gint total
);

extern void EDVBrowserNewObjectMenuRegenerate(edv_browser_struct *browser);
extern void EDVBrowserListStylesRegenerate(edv_browser_struct *browser);

extern edv_browser_struct *EDVBrowserNew(gpointer core_ptr);
extern void EDVBrowserReset(edv_browser_struct *browser, gboolean need_unmap);
extern void EDVBrowserSyncData(edv_browser_struct *browser);
extern void EDVBrowserUpdateMenus(edv_browser_struct *browser);
extern void EDVBrowserSetBusy(edv_browser_struct *browser, gboolean is_busy);
extern gboolean EDVBrowserIsMapped(edv_browser_struct *browser);
extern void EDVBrowserMap(edv_browser_struct *browser);
extern void EDVBrowserUnmap(edv_browser_struct *browser);
extern void EDVBrowserDelete(edv_browser_struct *browser);


#endif	/* BROWSER_H */
