#include <stdlib.h>
#include <string.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "../include/disk.h"

#include "guiutils.h"
#include "toolbar.h"

#include "edvtypes.h"
#include "edvlistcb.h"
#include "cfg.h"
#include "edvobj.h"
#include "edvdevices.h"
#include "edvstatusbar.h"
#include "fopdlg.h"
#include "browser.h"
#include "browsercb.h"
#include "browseropcb.h"
#include "browserdirtree.h"
#include "browsercontents.h"
#include "browserdnd.h"
#include "endeavour.h"
#include "edvcb.h"
#include "edvutils.h"
#include "edvutilsgtk.h"
#include "edvcfglist.h"
#include "config.h"

#include "images/icon_hsep_20x20.xpm"
#include "images/icon_terminal_20x20.xpm"
#include "images/icon_copy_20x20.xpm"
#include "images/icon_new_20x20.xpm"
#include "images/icon_save_20x20.xpm"
#include "images/icon_trace_20x20.xpm"
#include "images/icon_close_20x20.xpm"
#include "images/icon_exit_20x20.xpm"
#include "images/icon_mount_20x20.xpm"
#include "images/icon_unmount_20x20.xpm"
#include "images/icon_eject_20x20.xpm"
#include "images/icon_move_file_20x20.xpm"
#include "images/icon_copy_file_20x20.xpm"
#include "images/icon_rename_20x20.xpm"
#include "images/icon_cancel_20x20.xpm"
#include "images/icon_chmod_20x20.xpm"
#include "images/icon_owned_20x20.xpm"
#include "images/icon_properties2_20x20.xpm"
#include "images/icon_select_20x20.xpm"
#include "images/icon_run_20x20.xpm"
#include "images/icon_reload_20x20.xpm"
#include "images/icon_planet_20x20.xpm"
#include "images/icon_search_20x20.xpm"
#include "images/icon_mimetypes_20x20.xpm"
#include "images/icon_device_misc_20x20.xpm"
#include "images/icon_tool_bar_20x20.xpm"
#include "images/icon_status_bar_20x20.xpm"
#include "images/icon_options2_20x20.xpm"
#include "images/icon_customize_20x20.xpm"
#include "images/icon_tree_origin_20x20.xpm"
#include "images/icon_insecure_20x20.xpm"
#include "images/icon_secure_20x20.xpm"
#include "images/icon_fsck_20x20.xpm"
#include "images/icon_tools_20x20.xpm"
#include "images/icon_floppy_20x20.xpm"

#include "images/icon_open_20x20.xpm"
#include "images/icon_file_20x20.xpm"
#include "images/icon_folder_closed_20x20.xpm"
#include "images/icon_folder_parent_20x20.xpm"
#include "images/icon_folder_home_20x20.xpm"
#include "images/icon_link2_20x20.xpm"
#include "images/icon_pipe_20x20.xpm"
#include "images/icon_device_block_20x20.xpm"
#include "images/icon_device_character_20x20.xpm"
#include "images/icon_socket_20x20.xpm"
#include "images/icon_folder_noaccess_20x20.xpm"

#include "images/icon_trash_empty_20x20.xpm"
#include "images/icon_trash_20x20.xpm"
#include "images/icon_help_20x20.xpm"
#include "images/icon_about_20x20.xpm"

#include "images/endeavour_20x20.xpm"
#include "images/endeavour_48x48.xpm"
#include "images/image_browser_20x20.xpm"
#include "images/archiver_20x20.xpm"


static edv_browser_opid_struct *EDVBrowserMatchOPID(
	edv_browser_struct *browser, edv_browser_op op
);

void EDVBrowserSetTitle(
	edv_browser_struct *browser, const gchar *path
);

gchar *EDVBrowserCurrentLocation(edv_browser_struct *browser);
void EDVBrowserSetLocation(
	edv_browser_struct *browser,
	const gchar *path, gboolean record_history
);
void EDVBrowserUpdateLocationIcon(
	edv_browser_struct *browser, const gchar *path
);

void EDVBrowserToolBarRegenerate(edv_browser_struct *browser);
void EDVBrowserDirectoryMenuRegenerate(edv_browser_struct *browser);
void EDVBrowserContentsMenuRegenerate(edv_browser_struct *browser);

void EDVBrowserSyncConfiguration(edv_browser_struct *browser);

edv_browser_opid_struct **EDVBrowserOPIDListNew(
	edv_browser_struct *browser, gint *total
);
void EDVBrowserOPIDListDelete(
	edv_browser_opid_struct **list, gint total
);

void EDVBrowserNewObjectMenuRegenerate(edv_browser_struct *browser);
static void EDVBrowserCreateMenuBar(
	edv_browser_struct *browser, GtkWidget *parent
);
void EDVBrowserListStylesRegenerate(edv_browser_struct *browser);

edv_browser_struct *EDVBrowserNew(gpointer core_ptr);
void EDVBrowserReset(edv_browser_struct *browser, gboolean need_unmap);
void EDVBrowserSyncData(edv_browser_struct *browser);
void EDVBrowserUpdateMenus(edv_browser_struct *browser);
void EDVBrowserSetBusy(edv_browser_struct *browser, gboolean is_busy);
gboolean EDVBrowserIsMapped(edv_browser_struct *browser);
void EDVBrowserMap(edv_browser_struct *browser);
void EDVBrowserUnmap(edv_browser_struct *browser);
void EDVBrowserDelete(edv_browser_struct *browser);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Returns the File Browser Operation ID that matches the given
 *	operation.
 */
static edv_browser_opid_struct *EDVBrowserMatchOPID(
	edv_browser_struct *browser, edv_browser_op op
)
{
	gint i;
	edv_browser_opid_struct *opid;

	if(browser == NULL)
	    return(NULL);

	for(i = 0; i < browser->total_opids; i++)
	{
	    opid = browser->opid[i];
	    if((opid != NULL) ? (opid->op == op) : FALSE)
		return(opid);
	}

	return(NULL);
}


/*
 *	Sets the File Browser's title.
 *
 *	The given path is optional, it can be either the current
 *	selected location or the last selected object.
 */
void EDVBrowserSetTitle(
	edv_browser_struct *browser, const gchar *path
)
{
	gboolean include_user_name, include_location;
	const gchar *prog_name = PROG_NAME;
	gchar *title;
	GtkWidget *w;
	const cfg_item_struct *cfg_list;
	edv_core_struct *core_ptr;


	if(browser == NULL)
	    return;

	w = browser->toplevel;
	core_ptr = EDV_CORE(browser->core_ptr);
	if((w == NULL) || (core_ptr == NULL))
	    return;

	cfg_list = core_ptr->cfg_list;

	if(!STRISEMPTY(core_ptr->title))
	    prog_name = core_ptr->title;

	include_user_name = EDV_GET_B(EDV_CFG_PARM_BROWSER_TITLE_WITH_USER);
	include_location = EDV_GET_B(EDV_CFG_PARM_BROWSER_TITLE_WITH_LOCATION);

	/* Generate new title string */
	if(include_user_name && include_location &&
	   (path != NULL)
	)
	    title = g_strdup_printf(
		"%s: %s %s",
		prog_name,
		core_ptr->effective_user_id_host_str,
		path
	    );
	else if(include_location && (path != NULL))
	    title = g_strdup_printf(
		"%s: %s",
		prog_name, path
	    );
	else if(include_user_name)
	    title = g_strdup_printf(
		"%s: %s",
		prog_name,
		core_ptr->effective_user_id_host_str
	    );
	else
	    title = STRDUP(prog_name);

	/* Set new title */
	gtk_window_set_title(GTK_WINDOW(w), title);

	g_free(title);
}

/*
 *	Returns the File Browser's current location.
 */
gchar *EDVBrowserCurrentLocation(edv_browser_struct *browser)
{
	GtkCombo *combo = (GtkCombo *)((browser != NULL) ?
	    browser->location_combo : NULL
	);
	return((combo != NULL) ?
	    gtk_entry_get_text(GTK_ENTRY(combo->entry)) : NULL
	);
}

/*
 *	Sets the File Browser's location to the specified path.
 *
 *	If record_history is TRUE then the new location will be
 *	recorded on the locations history.
 */
void EDVBrowserSetLocation(
	edv_browser_struct *browser,
	const gchar *path, gboolean record_history
)
{
	const gchar *s;
	gchar *new_path;
	GtkEntry *entry;
	GtkCombo *combo = (GtkCombo *)((browser != NULL) ?
	    browser->location_combo : NULL
	);
	if((combo == NULL) || STRISEMPTY(path))
	    return;

	entry = GTK_ENTRY(combo->entry);

	/* Get new path */
	new_path = STRDUP(path);

	/* Simplify new path */
	SimplifyPath(new_path);

	/* No change? */
	s = gtk_entry_get_text(entry);
	if((s != NULL) ? !strcmp(s, new_path) : FALSE)
	{
	    g_free(new_path);
	    return;
	}

	/* Record new location on the location history? */
	if(record_history)
	    GUIComboAddItem(GTK_WIDGET(combo), new_path);

	/* Set new location */
	gtk_entry_set_text(entry, new_path);
	gtk_entry_set_position(entry, -1);

	g_free(new_path);
}

/*
 *	Updates the File Browser's location bar icon with the object
 *	specified by path.
 *
 *	If the given path is NULL then the icon will be set as unknown.
 */
void EDVBrowserUpdateLocationIcon(
	edv_browser_struct *browser, const gchar *path
)
{
	gint width, height;
	edv_object_type type;
	edv_permission_flags permissions;
	GdkPixmap *pixmap_closed, *pixmap_opened;
	GdkBitmap *mask_closed, *mask_opened;
	GtkWidget *parent, *w;
	edv_core_struct *core_ptr;

	if(browser == NULL)
	    return;

	parent = browser->location_icon_fixed;
	core_ptr = EDV_CORE(browser->core_ptr);
	if((parent == NULL) || (core_ptr == NULL))
	    return;

	/* Get type and permissions of the object specified by path */
	type = EDV_OBJECT_TYPE_DIRECTORY;
	permissions = 0x00000000;
	if(!STRISEMPTY(path))
	{
	    struct stat lstat_buf;
	    if(!lstat(path, &lstat_buf))
	    {
		mode_t m = lstat_buf.st_mode;
		type = EDVObjectGetTypeFromStatMode(m);
		permissions = EDVObjectGetPermissionsFromStatMode(m);
	    }
	}

	/* Get pixmap and mask for the icon */
	EDVMatchObjectIcon(
	    core_ptr->device, core_ptr->total_devices,
	    core_ptr->mimetype, core_ptr->total_mimetypes,
	    type,
	    path,
	    TRUE,
	    permissions,
	    0,			/* Small icons */
	    &pixmap_closed, &mask_closed,
	    &pixmap_opened, &mask_opened,
	    NULL, NULL
	);
	/* If the opened pixmap is not available then revert to the
	 * closed pixmap
	 */
	if(pixmap_opened == NULL)
	{
	    pixmap_opened = pixmap_closed;
	    mask_opened = mask_closed;
	}
	if(pixmap_opened == NULL)
	    return;

	/* Create new icon pixmap widget as needed */
	w = browser->location_icon_pm;
	if(w == NULL)
	{
	    browser->location_icon_pm = w = gtk_pixmap_new(
		pixmap_opened, mask_opened
	    );
	    gtk_fixed_put(GTK_FIXED(parent), w, 0, 0);
	    gtk_widget_show(w);
	}
	else
	{
	    gtk_pixmap_set(GTK_PIXMAP(w), pixmap_opened, mask_opened);
	}

	gdk_window_get_size(pixmap_opened, &width, &height);
}


/*
 *	Recreates the File Browser's Tool Bar.
 */
void EDVBrowserToolBarRegenerate(edv_browser_struct *browser)
{
	gint i, total_items;
	toolbar_display tb_display;
	toolbar_relief tb_relief;
	GtkWidget *w, *parent;
	const cfg_intlist_struct *intlist;
	const cfg_item_struct *cfg_list;
	edv_browser_opid_struct *opid;
	toolbar_item_struct **item, *item_ptr;
	edv_core_struct *core_ptr;

	if(browser == NULL)
	    return;

	parent = w = browser->tool_bar_handle;
	core_ptr = EDV_CORE(browser->core_ptr);
	if((w == NULL) || (core_ptr == NULL))
	    return;

	cfg_list = core_ptr->cfg_list;

	/* Get Tool Bar configuration */
	tb_display = (toolbar_display)EDV_GET_I(
	    EDV_CFG_PARM_BROWSER_TOOL_BAR_DISPLAY
	);
	tb_relief = (toolbar_relief)EDV_GET_I(
	    EDV_CFG_PARM_BROWSER_TOOL_BAR_RELIEF
	);
	intlist = EDV_GET_INTLIST(EDV_CFG_PARM_BROWSER_TOOL_BAR);
	if(intlist == NULL)
	    return;

	/* Delete existing Tool Bar if any */
	ToolBarDelete(browser->toolbar);
	browser->toolbar = NULL;

	/* Create Tool Bar items list */
	total_items = intlist->total;
	if(total_items > 0)
	{
	    item = (toolbar_item_struct **)g_malloc0(
		total_items * sizeof(toolbar_item_struct *)
	    );
	    if(item == NULL)
		total_items = 0;
	}
	else
	{
	    item = NULL;
	}
	for(i = 0; i < total_items; i++)
	{
	    /* Get Operation ID */
	    opid = EDVBrowserMatchOPID(browser, intlist->i[i]);
	    if(opid == NULL)
		continue;

	    /* Handle by the Operation ID's operation */
	    switch(opid->op)
	    {
	      case EDV_BROWSER_OP_NONE:
		item[i] = item_ptr = NULL;
		break;

	      default:
		item[i] = item_ptr = ToolBarItemNew(
		    opid->tb_item_type,
		    opid->button_name,
		    opid->button_icon_data,
		    opid->tooltip,
		    opid->op,
		    EDVBrowserOPCB, opid,
		    EDVBrowserOPEnterCB, opid,                    
		    EDVBrowserOPLeaveCB, opid
		);
		break;
	    }

	}

	/* Create new Tool Bar */
	browser->toolbar = ToolBarNew(
	    item, total_items, parent,
	    tb_display, tb_relief, FALSE
	);
	ToolBarMap(browser->toolbar);

	/* Delete Tool Bar items list */
	ToolBarItemListDeleteAll(&item, &total_items);

	/* Need to queue resize since Tool Bar size may have changed */
	w = browser->toplevel;
	if(w != NULL)
	    gtk_widget_queue_resize(w);
}

/*
 *	Recreates the File Browser directory tree's right click menu.
 */
void EDVBrowserDirectoryMenuRegenerate(edv_browser_struct *browser)
{
	if(browser == NULL)
	    return;

	/* Destroy existing menu if any */
	GTK_WIDGET_DESTROY(browser->directory_ctree_menu);
	browser->directory_ctree_menu = NULL;

	/* Create new menu */
	if(TRUE)
	{
	    edv_browser_op op;
	    guint8 **icon_data = NULL;
	    GtkAccelGroup *accelgrp = NULL;
	    GtkWidget *w, *menu, **w_record, **fw_record;

#define DO_ADD_MENU_ITEM_LABEL		{	\
 edv_browser_opid_struct *opid =		\
  EDVBrowserMatchOPID(browser, op);		\
 if(opid != NULL) {				\
  w = GUIMenuItemCreate(			\
   menu, GUI_MENU_ITEM_TYPE_LABEL, accelgrp,	\
   (guint8 **)((icon_data != NULL) ?		\
    icon_data : opid->menu_icon_data),		\
   opid->menu_name,				\
   opid->accel_key, opid->accel_mods,		\
   (gpointer *)fw_record,			\
   (gpointer)opid, EDVBrowserMenuItemCB		\
  );						\
  GUISetMenuItemCrossingCB(			\
   w,						\
   (gpointer)EDVBrowserMenuItemEnterCB, opid,	\
   (gpointer)EDVBrowserMenuItemLeaveCB, opid	\
  );						\
  if(w_record != NULL)				\
   *w_record = w;				\
 }						\
}
#define DO_ADD_MENU_SEP		{		\
 w = GUIMenuItemCreate(				\
  menu, GUI_MENU_ITEM_TYPE_SEPARATOR, NULL,	\
  NULL, NULL, 0, 0, NULL,			\
  NULL, NULL					\
 );						\
}

	    /* Create menu */
	    browser->directory_ctree_menu = menu = GUIMenuCreate();

	    op = EDV_BROWSER_OP_EXPAND;
	    w_record = &browser->directory_ctree_expand_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_BROWSER_OP_MOUNT;
	    w_record = &browser->directory_ctree_mount_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_EJECT;
	    w_record = &browser->directory_ctree_eject_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP
	    browser->directory_ctree_mount_misep = w;

	    op = EDV_BROWSER_OP_MOVE;
	    w_record = &browser->directory_ctree_move_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_COPY;
	    w_record = &browser->directory_ctree_copy_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_LINK;
	    w_record = &browser->directory_ctree_link_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_RENAME;
	    w_record = &browser->directory_ctree_rename_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_CHMOD;
	    w_record = &browser->directory_ctree_chmod_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_CHOWN;
	    w_record = &browser->directory_ctree_chown_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_DELETE;
	    w_record = &browser->directory_ctree_delete_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_BROWSER_OP_PROPERTIES;
	    w_record = &browser->directory_ctree_properties_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

#undef DO_ADD_MENU_ITEM_LABEL
#undef DO_ADD_MENU_SEP
	}
}

/*
 *	Recreates the File Browser contents list's right click menu.
 */
void EDVBrowserContentsMenuRegenerate(edv_browser_struct *browser)
{
	if(browser == NULL)
	    return;

	/* Destroy existing menu if any */
	GTK_WIDGET_DESTROY(browser->contents_clist_menu);
	browser->contents_clist_menu = NULL;

	/* Create new menu */
	if(TRUE)
	{
	    edv_browser_op op;
	    guint8 **icon_data = NULL;
	    GtkAccelGroup *accelgrp = NULL;
	    GtkWidget *w, *menu, **w_record, **fw_record;

#define DO_ADD_MENU_ITEM_LABEL          {       \
 edv_browser_opid_struct *opid =                \
  EDVBrowserMatchOPID(browser, op);             \
 if(opid != NULL) {                             \
  w = GUIMenuItemCreate(                        \
   menu, GUI_MENU_ITEM_TYPE_LABEL, accelgrp,    \
   (guint8 **)((icon_data != NULL) ?            \
    icon_data : opid->menu_icon_data),          \
   opid->menu_name,                             \
   opid->accel_key, opid->accel_mods,           \
   (gpointer *)fw_record,                       \
   (gpointer)opid, EDVBrowserMenuItemCB         \
  );                                            \
  GUISetMenuItemCrossingCB(                     \
   w,                                           \
   (gpointer)EDVBrowserMenuItemEnterCB, opid,   \
   (gpointer)EDVBrowserMenuItemLeaveCB, opid    \
  );                                            \
  if(w_record != NULL)                          \
   *w_record = w;                               \
 }                                              \
}
#define DO_ADD_MENU_SEP         {               \
 w = GUIMenuItemCreate(                         \
  menu, GUI_MENU_ITEM_TYPE_SEPARATOR, NULL,     \
  NULL, NULL, 0, 0, NULL,                       \
  NULL, NULL                                    \
 );                                             \
}

	    /* Create menu */
	    browser->contents_clist_menu = menu = GUIMenuCreate();

	    op = EDV_BROWSER_OP_OPEN;
	    w_record = &browser->contents_clist_open_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_OPEN_WITH;
	    w_record = &browser->contents_clist_openwith_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_BROWSER_OP_MOVE;
	    w_record = &browser->contents_clist_move_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_COPY;
	    w_record = &browser->contents_clist_copy_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_LINK;
	    w_record = &browser->contents_clist_link_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_RENAME;
	    w_record = &browser->contents_clist_rename_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_CHMOD;
	    w_record = &browser->contents_clist_chmod_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_CHOWN;
	    w_record = &browser->contents_clist_chown_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_DELETE;
	    w_record = &browser->contents_clist_delete_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_BROWSER_OP_PROPERTIES;
	    w_record = &browser->contents_clist_properties_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL


#undef DO_ADD_MENU_ITEM_LABEL
#undef DO_ADD_MENU_SEP
	}
}


/*
 *	Sets the File Browser's values to the configuration.
 */
void EDVBrowserSyncConfiguration(edv_browser_struct *browser)
{
	GtkWidget *w;
	cfg_item_struct *cfg_list;
	edv_core_struct *core_ptr = (browser != NULL) ?
	    EDV_CORE(browser->core_ptr) : NULL;
	if(core_ptr == NULL)
	    return;

	cfg_list = core_ptr->cfg_list;

	/* Location history */
	w = browser->location_combo;
	if(w != NULL)
	{
	    GList *glist = GUIComboGetList(w);
	    const gchar *path = EDV_GET_S(
		EDV_CFG_PARM_FILE_BROWSER_LOCATION_HISTORY
	    );
	    EDVSaveFileGList(path, glist);
	}

	/* Toplevel geometry */
	w = browser->toplevel;
	if(w != NULL)
	{
	    GdkWindow *window = w->window;
	    gint x = 0, y = 0;

	    if(window != NULL)
		gdk_window_get_root_origin(window, &x, &y);

	    EDV_SET_I(EDV_CFG_PARM_BROWSER_X, x);
	    EDV_SET_I(EDV_CFG_PARM_BROWSER_Y, y);
	    EDV_SET_I(EDV_CFG_PARM_BROWSER_WIDTH, w->allocation.width);
	    EDV_SET_I(EDV_CFG_PARM_BROWSER_HEIGHT, w->allocation.height);
	}

	/* Main paned position */
	w = browser->main_paned;
	if(w != NULL)
	{
	    EDV_SET_I(
		EDV_CFG_PARM_BROWSER_PANED_POSITION,
		GTK_PANED(w)->child1_size
	    );
	}

	/* EDV_CFG_PARM_BROWSER_CONTENTS_COLUMN_WIDTH parameter is updated
	 * as they change in EDVBrowserResizeColumnCB() or when the
	 * configuration list is changed directly
	 */

	/* EDV_CFG_PARM_BROWSER_CONTENTS_COLUMN parameter is updated
	 * when the configuration list is changed directly
	 */

	/* Set new startup directory as the last directory of this
	 * window's location
	 */
	if(EDV_GET_B(EDV_CFG_PARM_RECORD_START_UP_DIR))
	{
	    EDV_SET_S(
		EDV_CFG_PARM_DIR_START_UP,
		EDVBrowserCurrentLocation(browser)
	    );
	}

	/* Directory tree origin path */
	if(!STRISEMPTY(browser->directory_ctree_origin_path))
	{
	    EDV_SET_S(
		EDV_CFG_PARM_BROWSER_DIR_TREE_ORIGIN,
		browser->directory_ctree_origin_path
	    );
	}
}


/*
 *	Creates a new File Browser Operaton IDs list.
 *
 *	The specified File Browser may be NULL.
 */
edv_browser_opid_struct **EDVBrowserOPIDListNew(
	edv_browser_struct *browser, gint *total
)
{
	gint i;
	edv_browser_op op;
	gboolean allow_multiple;
	toolbar_item_type tb_item_type;
	const gchar *button_name, *menu_name, *tooltip;
	guint accel_key, accel_mods;
	guint8 **button_icon_data, **menu_icon_data;
	edv_browser_opid_struct **list, *opid;
	void (*func_cb)(toolbar_item_struct *, gint, gpointer);
	void (*enter_func_cb)(toolbar_item_struct *, gint, gpointer);

	if(total == NULL)
	    return(NULL);

	*total = 0;
	list = NULL;

#define DO_APPEND_OPID	{			\
 i = MAX(*total, 0);				\
 *total = i + 1;				\
 list = (edv_browser_opid_struct **)g_realloc(	\
  list,						\
  (*total) * sizeof(edv_browser_opid_struct *)	\
 );						\
 if(list == NULL) {				\
  *total = 0;					\
  return(list);					\
 } else {					\
  list[i] = opid = EDV_BROWSER_OPID(		\
   g_malloc0(sizeof(edv_browser_opid_struct))	\
  );						\
  if(opid != NULL) {				\
   opid->browser = browser;			\
   opid->op = op;				\
   opid->allow_multiple = allow_multiple;	\
   opid->tb_item_type = tb_item_type;		\
   opid->func_cb = func_cb;			\
   opid->enter_func_cb = enter_func_cb;		\
   opid->button_name = STRDUP(button_name);	\
   opid->menu_name = STRDUP(menu_name);		\
   opid->tooltip = STRDUP(tooltip);		\
   opid->accel_key = accel_key;			\
   opid->accel_mods = accel_mods;		\
   opid->button_icon_data = button_icon_data;	\
   opid->menu_icon_data = menu_icon_data;	\
  }						\
 }						\
}

	func_cb = EDVBrowserOPCB;
	enter_func_cb = EDVBrowserOPEnterCB;


	op = EDV_BROWSER_OP_SEPARATOR;
	tb_item_type = TOOLBAR_ITEM_SEPARATOR;
	allow_multiple = TRUE;
	button_icon_data = (guint8 **)icon_hsep_20x20_xpm;
	menu_icon_data = button_icon_data;
#if defined(PROG_LANGUAGE_SPANISH)
	button_name = "Separador";
	menu_name = "Separador";
	tooltip = "Separador";
#elif defined(PROG_LANGUAGE_FRENCH)
	button_name = "Sparateur";
	menu_name = "Sparateur";
	tooltip = "Sparateur";
#elif defined(PROG_LANGUAGE_GERMAN)
	button_name = "Separator";
	menu_name = "Separator";
	tooltip = "Separator";
#elif defined(PROG_LANGUAGE_ITALIAN)
	button_name = "Separatore";
	menu_name = "Separatore";
	tooltip = "Separatore";
#elif defined(PROG_LANGUAGE_DUTCH)
	button_name = "Separator";
	menu_name = "Separator";
	tooltip = "Separator";
#elif defined(PROG_LANGUAGE_PORTUGUESE)
	button_name = "Separador";
	menu_name = "Separador";
	tooltip = "Separador";
#elif defined(PROG_LANGUAGE_NORWEGIAN)
	button_name = "Separator";
	menu_name = "Separator";
	tooltip = "Separator";
#else
	button_name = "Separator";
	menu_name = "Separator";
	tooltip = "Separator";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_BROWSER_OP_CLOSE;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_close_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Close";
	menu_name = "Close";
	tooltip = "Close this window";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Cierre";
	menu_name = "Cierre";
	tooltip = "Cierre esta ventana";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Proche";
	menu_name = "Proche";
	tooltip = "Fermer cette fentre";
#endif
	accel_key = 'w';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_EXIT;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_exit_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Exit";
	menu_name = "Exit";
	tooltip = "Close all windows in the application and exit";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "La Salida";
	menu_name = "La Salida";
	tooltip = "Cierra todas ventanas en la aplicacin y la";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Sortie";
	menu_name = "Sortie";
	tooltip = "Ferme toutes fentres dans l'application et sortie";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_BROWSER_OP_WRITE_PROTECT;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_secure_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Protect";
	menu_name = "Write Protect";
	tooltip = "Enable/disable write protect";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Proteja";
	menu_name = "Escriba Proteja";
	tooltip = "Habilite/incapacita escribe protege";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Protge";
	menu_name = "Protge En criture";
	tooltip = "Rend capable/rend infirme protge en criture";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_SYNC_DISKS;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_save_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Sync Disks";
	menu_name = "Sync Disks";
	tooltip = "Flush any pending data transfers to disk";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Discos Sincro";
	menu_name = "Discos Sincro";
	tooltip = "Limpan cualquiera transferencias pendientes de datos al disco";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Disq Syn";
	menu_name = "Les Disques De Syn";
	tooltip = "Rincer des transferts de donnes en attente au disque";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_RUN;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_run_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Run";
	menu_name = "Run...";
	tooltip = "Run a program";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Corra";
	menu_name = "Corra...";
	tooltip = "Corra un programa";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Courir";
	menu_name = "Courir...";
	tooltip = "Excute un programme";
#endif
	accel_key = 'r';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_RUN_TERMINAL;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_terminal_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Terminal";
	menu_name = "Terminal";
	tooltip = "Run a terminal";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "La Terminal";
	menu_name = "La Terminal";
	tooltip = "Corre una terminal";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Le Terminal";
	menu_name = "Le Terminal";
	tooltip = "Courir un terminal";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_BROWSER_OP_NEW;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_new_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "New";
	menu_name = "New";
	tooltip = "Create a new object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Nuevo";
	menu_name = "Nuevo";
	tooltip = "Crea un objeto nuevo";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Nouveau";
	menu_name = "Nouveau";
	tooltip = "Crer un nouvel objet";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_NEW_FILE;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_file_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "New File";
	menu_name = "File";
	tooltip = "Create a new file object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Archivo";
	menu_name = "El Archivo";
	tooltip = "Crea un objeto nuevo del archivo";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Fichier";
	menu_name = "Fichier";
	tooltip = "Crer un nouvel objet de fichier";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_NEW_DIRECTORY;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_folder_closed_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "New Dir";
	menu_name = "Directory";
	tooltip = "Create a new directory object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "La Gua";
	menu_name = "La Gua";
	tooltip = "Crea un objeto nuevo de gua";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Annuaire";
	menu_name = "Annuaire";
	tooltip = "Crer un nouvel objet d'annuaire";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_NEW_LINK;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_link2_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "New Lnk";
	menu_name = "Link";
	tooltip = "Create a new symbolic link object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Eslabn";
	menu_name = "El Eslabn";
	tooltip = "Crea un objeto simblico nuevo del eslabn";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Lien";
	menu_name = "Lien";
	tooltip = "Cre un nouveau symbolique lien";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_NEW_FIFO;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_pipe_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "New FIFO";
	menu_name = "FIFO Pipe";
	tooltip = "Create a new FIFO pipe object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "FIFO";
	menu_name = "FIFO Tubo";
	tooltip = "Crea un objeto nuevo de tubo de FIFO";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "FIFO";
	menu_name = "FIFO Tuyau";
	tooltip = "Crer un nouvel objet de tuyau de FIFO";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_NEW_DEVICE_BLOCK;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_device_block_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "New BDev";
	menu_name = "Block Device";
	tooltip = "Create a new block (buffered) device node object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "BArtefacto";
	menu_name = "El Artefacto Del Bloque";
	tooltip = "Crea un objeto nuevo de nodo de artefacto de bloque (buffered)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "BL'Appareil";
	menu_name = "Le Priphrique  Blocs";
	tooltip = "Crer un nouveau bloc (buffered) l'objet de noeu";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_NEW_DEVICE_CHARACTER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_device_character_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "New CDev";
	menu_name = "Character Device";
	tooltip = "Create a new character (unbuffered) device node object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "CArtefacto";
	menu_name = "El Artefacto Del Carcter";
	tooltip = "Crea un objeto nuevo de nodo de artefacto de carcter (unbuffered)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "CL'Appareil";
	menu_name = "Le Priphrique  Caractres";
	tooltip = "Crer un nouveau caractre (unbuffered) l'objet de noeud d'appareil";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_NEW_SOCKET;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_socket_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "New Sock";
	menu_name = "Socket";
	tooltip = "Create a new socket object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Enchufe";
	menu_name = "El Enchufe";
	tooltip = "Crea un objeto nuevo del enchufe";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Douille";
	menu_name = "La Douille";
	tooltip = "Crer un nouvel objet de douille";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_BROWSER_OP_OPEN;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_open_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Open";
	menu_name = "Open";
	tooltip = "Open selected object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Abierto";
	menu_name = "Abierto";
	tooltip = "Abre escogido se opone";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Ouvert";
	menu_name = "Ouvert";
	tooltip = "Ouvrir l'objet choisi";
#endif
	accel_key = GDK_Return;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_OPEN_WITH;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_open_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Open With";
	menu_name = "Open With...";
	tooltip = "Open selected object using a specific method";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Abra Con";
	menu_name = "Abra Con...";
	tooltip = "Abre escogido se opone usar un mtodo especfico";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Ouvrir Avec";
	menu_name = "Ouvrir Avec...";
	tooltip = "Ouvrir l'objet choisi pour utiliser une mthode spcifique";
#endif
	accel_key = GDK_Return;
	accel_mods = GDK_SHIFT_MASK;
	DO_APPEND_OPID


	op = EDV_BROWSER_OP_GOTO_PARENT;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_folder_parent_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Parent";
	menu_name = "Go To Parent";
	tooltip = "Go to the parent directory";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "El Padre";
	menu_name = "Va A Actuar Como Padre";
	tooltip = "Para Ir a la gua del padre";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Parent";
	menu_name = "Aller Au Parent";
	tooltip = "Aller  l'annuaire de parent";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_GOTO_HOME;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_folder_home_20x20_xpm;
	menu_icon_data = button_icon_data;
	button_name = "Home";
	menu_name = "Go To Home";
	tooltip = "Go to the home directory";
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_EXPAND;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = NULL;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Expand";
	menu_name = "Expand";
	tooltip = "Expand/collapse selected tree branch";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Ensanchar";
	menu_name = "Ensanchar";
	tooltip = "Ensanchar/el desplome escogi rama de rbol";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Augmenter";
	menu_name = "Augmenter";
	tooltip = "L'Augmente/Effondrement branche d'arbre choisie";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_MOUNT;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = NULL;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Mount";
	menu_name = "Mount";
	tooltip = "Mount/unmount selected mount point directory";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Monte";
	menu_name = "El Monte";
	tooltip = "El Monte/unmount escogi gua de punto de monte";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Le Mont";
	menu_name = "Le Mont";
	tooltip = "Le Mont/unmount a choisi l'annuaire de point de mont";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_EJECT;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_eject_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Eject";
	menu_name = "Eject";
	tooltip = "Eject media from device";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Expulse";
	menu_name = "Expulse";
	tooltip = "Expulse medios del artefacto";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Ejecter";
	menu_name = "Ejecter";
	tooltip = "Ejecter le presse de l'appareil";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_BROWSER_OP_MOVE;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_move_file_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Move";
	menu_name = "Move...";
	tooltip = "Move selected object(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Mueva";
	menu_name = "Mueva...";
	tooltip = "Mueva escogido se opone(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Mouvement";
	menu_name = "Le mouvement...";
	tooltip = "Le Mouvement a choisi l'objet(s)";
#endif
	accel_key = GDK_F7;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_COPY;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_copy_file_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Copy";
	menu_name = "Copy...";
	tooltip = "Copy selected object(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Copia";
	menu_name = "La Copia...";
	tooltip = "La Copia escogi se opone(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Copia";
	menu_name = "La Copie...";
	tooltip = "La Copie a choisi l'objet(s)";
#endif
	accel_key = GDK_F8;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_LINK;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_link2_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Link";
	menu_name = "Link...";
	tooltip = "Link selected object(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Eslabn";
	menu_name = "El Eslabn...";
	tooltip = "El Eslabn escogi se opone(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Le Lien";
	menu_name = "Le Lien...";
	tooltip = "Le Lien a choisi l'objet(s)";
#endif
	accel_key = GDK_F6;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_RENAME;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_rename_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Rename";
	menu_name = "Rename";
	tooltip = "Rename selected object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Reagrupe";
	menu_name = "Reagrupe";
	tooltip = "Reagrupe escogido se opone";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Renommer";
	menu_name = "Renommer";
	tooltip = "Renomme l'objet choisi";
#endif
	accel_key = GDK_F2;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_CHMOD;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_chmod_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "ChMod";
	menu_name = "Change Permissions...";
	tooltip = "Change permissions of the selected object(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "ChMod";
	menu_name = "Cambie El Modo...";
	tooltip = "El Cambio escogi los permisos de objetos";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "ChMod";
	menu_name = "Changer Le Mode...";
	tooltip = "Le Changement a choisi des permissions des objets";
#endif
	accel_key = GDK_F9;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_CHOWN;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_owned_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Chown";
	menu_name = "Change Ownership...";
	tooltip = "Change ownership of the selected object(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Chown";
	menu_name = "Change Ownership...";
	tooltip = "Chown escogi se opone(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Chown";
	menu_name = "Change Ownership...";
	tooltip = "Chown a choisi l'objet(s)";
#endif
	accel_key = GDK_F10;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_DELETE;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_cancel_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Delete";
	menu_name = "Delete";
	tooltip = "Delete selected object(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Borre";
	menu_name = "Borre";
	tooltip = "Borre escogido se opone(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Effacer";
	menu_name = "Effacer";
	tooltip = "Efface l'objet choisi(s)";
#endif
	accel_key = GDK_Delete;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_SELECT_ALL;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_select_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "SelAll";
	menu_name = "Select All";
	tooltip = "Select all objects";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "SelAll";
	menu_name = "Escoja Todo";
	tooltip = "Escoge todo se opone";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "SelAll";
	menu_name = "Choisir Tout";
	tooltip = "Choisir tous objets";
#endif
	accel_key = 'a';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_UNSELECT_ALL;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_select_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "UnSelAll";
	menu_name = "Unselect All";
	tooltip = "Unselect all objects";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "UnSelAll";
	menu_name = "Unescoja Todo";
	tooltip = "Unescoge todo se opone";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "UnSelAll";
	menu_name = "Unchoisir Tout";
	tooltip = "Unchoisir tous objets";
#endif
	accel_key = 'u';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_INVERT_SELECTION;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_select_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "InvSel";
	menu_name = "Invert Selection";
	tooltip =
 "Select all unselected objects and unselect all selected objects";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "InvSel";
	menu_name = "Invierta Seleccin";
	tooltip =
 "Selectos todos objetos y unselect no seleccionados todos objetos escogidos";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "InvSel";
	menu_name = "Inverser Slection";
	tooltip =
 "Choisir tous objets dslections et deslectionner tous objets choisis";
#endif
	accel_key = 'i';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_PROPERTIES;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_properties2_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Properties";
	menu_name = "Properties...";
	tooltip = "Modify selected object's properties";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Props";
	menu_name = "Las Propiedades";
	tooltip = "Modifican escogi las propiedades de objeto";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Props";
	menu_name = "Les Proprits";
	tooltip = "Modifier a choisi les proprits de l'objet";
#endif
	accel_key = GDK_Return;
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_FIND;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_search_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Find";
	menu_name = "Find...";
	tooltip = "Find object(s) by specific attributes";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Hallazgo";
	menu_name = "El Hallazgo";
	tooltip = "El Hallazgo se opone (s) por atributos especificados";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Dcouverte";
	menu_name = "La Dcouverte";
	tooltip = "L'objet de Dcouverte (s) par les attributs spcifis ";
#endif
	accel_key = 'f';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_HISTORY;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_trace_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "History";
	menu_name = "History...";
	tooltip = "History of commands processed by this application";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Historia";
	menu_name = "La Historia...";
	tooltip = "La Historia de rdenes procesadas por esta aplicacin";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "L'Histoire";
	menu_name = "L'Histoire...";
	tooltip = "L'Histoire d'ordres traits par cette application";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_COPY_PATH;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_copy_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "CopyPath";
	menu_name = "Copy Path";
	tooltip = "Copy the location of the selected object(s) as path(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "CopiSende";
	menu_name = "Copie Sendero";
	tooltip = "Copia la ubicacin del objeto(s) escogido como sendero(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "CopiSenti";
	menu_name = "Copier Le Sentier";
	tooltip = "Copier l'emplacement de l'objet choisi(s) comme le sentier(s)";
#endif
	accel_key = 'c';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_COPY_URL;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_copy_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "CopyURL";
	menu_name = "Copy URL";
	tooltip = "Copy the location of the selected object(s) as url(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "CopiURL";
	menu_name = "Copie URL";
	tooltip = "Copie la ubicacin del objeto(s) escogido como url(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "CopiURL";
	menu_name = "Copier URL";
	tooltip = "Copier l'emplacement de l'objet choisi(s) comme url(s)";
#endif
	accel_key = 'c';
	accel_mods = GDK_CONTROL_MASK | GDK_SHIFT_MASK;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_REFRESH;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_reload_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Refresh";
	menu_name = "Refresh";
	tooltip = "Refresh the selected directory's listing";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Refresque";
	menu_name = "Refresque";
	tooltip = "Refresque gua escogida es listar";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Rafrachir";
	menu_name = "Rafrachir";
	tooltip = "Rafrachit a choisi l'numrer de l'annuaire";
#endif
	accel_key = GDK_F5;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_REFRESH_ALL;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_reload_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Refresh All";
	menu_name = "Refresh All";
	tooltip = "Refresh all listings";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Refresque Todo";
	menu_name = "Refresque Todo";
	tooltip = "Refresca todas listas";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Rafrachir Tout";
	menu_name = "Rafrachir Tout";
	tooltip = "Rafrachir toutes listes";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_BROWSER_OP_DOWNLOAD;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_planet_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Download";
	menu_name = "Download";
	tooltip = "Download an object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Download";
	menu_name = "Download";
	tooltip = "Download del objeto";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Download";
	menu_name = "Download";
	tooltip = "Download de l'objet";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_BROWSER_OP_SHOW_TOOL_BAR;
	tb_item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_tool_bar_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "ToolBar";
	menu_name = "Tool Bar";
	tooltip = "Show/hide tool bar";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "ToolBar";
	menu_name = "Tool Bar";
	tooltip = "La Exposicin/la barra de herramienta de cuero";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "ToolBar";
	menu_name = "Tool Bar";
	tooltip = "La barre d'outil de montre/peau";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_SHOW_LOCATION_BAR;
	tb_item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_tool_bar_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "LocBar";
	menu_name = "Location Bar";
	tooltip = "Show/hide location bar";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "LocBar";
	menu_name = "Location Bar";
	tooltip = "La exposicin/la barra de la ubicacin del cuero";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "LocBar";
	menu_name = "Location Bar";
	tooltip = "La barre d'emplacement de montre/peau";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_SHOW_MOUNT_BAR;
	tb_item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_tool_bar_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "MountBar";
	menu_name = "Mount Bar";
	tooltip = "Show/hide mount bar";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "MountBar";
	menu_name = "Mount Bar";
	tooltip = "La Exposicin/la barra del monte del cuero";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "MountBar";
	menu_name = "Mount Bar";
	tooltip = "La barre de mont de Show/Peau";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_SHOW_FIND_BAR;
	tb_item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_tool_bar_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "FindBar";
	menu_name = "Find Bar";
	tooltip = "Show/hide find bar";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "FindBar";
	menu_name = "Find Bar";
	tooltip = "La exposicin/la barra del hallazgo del cuero";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "FindBar";
	menu_name = "Find Bar";
	tooltip = "La barre de dcouverte de montre/peau";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_SHOW_STATUS_BAR;
	tb_item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_status_bar_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "StatusBar";
	menu_name = "Status Bar";
	tooltip = "Show/hide status bar";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "StatusBar";
	menu_name = "Status Bar";
	tooltip = "La exposicin/la barra de la posicin del cuero";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "StatusBar";
	menu_name = "Status Bar";
	tooltip = "La barre de statut de montre/peau";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_DIRECTORY_TREE_ORIGIN;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_tree_origin_20x20_xpm;
	menu_icon_data = button_icon_data;                      
	button_name = "TreeOrig";
	menu_name = "Directory Tree Origin...";
	tooltip = "Set the directory tree origin";
	accel_key = 'j';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_MIME_TYPES;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_mimetypes_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "MIMETypes";
	menu_name = "MIME Types...";
	tooltip = "View/modify MIME Types";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "MIMETypes";
	menu_name = "MIME Types...";
	tooltip = "El panorama/modifica MIME Types";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "MIMETypes";
	menu_name = "MIME Types...";
	tooltip = "Vue/modifie MIME Types";
#endif
	accel_key = 'm';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_DEVICES;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_device_misc_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Devices";
	menu_name = "Devices...";
	tooltip = "View/modify file system device references";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Artefactos";
	menu_name = "Los Artefactos...";
	tooltip = "El Panorama/modifica las referencias de artefacto de sistema de archivo";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Appareils";
	menu_name = "Les Appareils...";
	tooltip = "Les rfrences de priphrique-systme de fichier de Vue/Modifie ";
#endif
	accel_key = 'd';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID


	op = EDV_BROWSER_OP_NEW_BROWSER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)endeavour_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "FBrowser";
	menu_name = "New File Browser";
	tooltip = "Create a new file browser";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "FBrowser";
	menu_name = "El Examinador Nuevo Del Archivo";
	tooltip = "Crea a un examinador nuevo del archivo";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "FBrowser";
	menu_name = "Nouveau Browser de Fichier";
	tooltip = "Crer un nouveau browser de fichier";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_NEW_IMBR;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)image_browser_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "IBrowser";
	menu_name = "New Image Browser";
	tooltip = "Create a new image browser";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "IBrowser";
	menu_name = "El Examinador Nuevo De La Imagen";
	tooltip = "Crea a un examinador nuevo de la imagen";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "IBrowser";
	menu_name = "Nouveau Browser D'Image";
	tooltip = "Crer un nouveau browser d'image";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_NEW_ARCHIVER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)archiver_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Archiver";
	menu_name = "New Archiver";
	tooltip = "Create a new archiver";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Archiver";
	menu_name = "Archiver Nuevo";
	tooltip = "Crea un archiver nuevo";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Archiver";
	menu_name = "Nouveau Archiver";
	tooltip = "Crer un nouveau archiver";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_RECYCLE_BIN;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_trash_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "RecBin";
	menu_name = "Recycle Bin";
	tooltip = "Open Recycle Bin";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "RecBin";
	menu_name = "El Cajn De La Recirculacin";
	tooltip = "Cajn de Recirculacin (basura puede)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "RecBin";
	menu_name = "Recycler L'Huche";
	tooltip = "Recycler l'huche (la poubelle)";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_BROWSER_OP_OPTIONS;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_options2_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Options";
	menu_name = "Options...";
	tooltip = "Modify this application's options";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Las Opciones";
	menu_name = "Las Opciones...";
	tooltip = "Modifican estas opciones de la aplicacin";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Les Options";
	menu_name = "Les Options";
	tooltip = "Modifier ces options de l'application";
#endif
	accel_key = 'o';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_CUSTOMIZE;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_customize_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Custom";
	menu_name = "Customize...";
	tooltip = "Customize the look and feel of this application";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Personal";
	menu_name = "Personaliza...";
	tooltip = "Personaliza la mirada y se siente de esta aplicacin";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Personnal";
	menu_name = "Personnalise...";
	tooltip = "Personnalise le regard et sens de cette application";
#endif
	accel_key = 't';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID


	op = EDV_BROWSER_OP_DEVICE_CHECK;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_fsck_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "FSCK";
	menu_name = "File System Check...";
	tooltip = "Check the device's file system";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "FSCK";
	menu_name = "Archive Cheque De Sistema...";
	tooltip = "Verifique el sistema del archivo de artefacto";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "FSCK";
	menu_name = "Classer Le Chque De Systme...";
	tooltip = "Vrifier le systme de fichier de l'appareil";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_DEVICE_TOOLS;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_tools_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "DevTool";
	menu_name = "Device Tools...";
	tooltip = "Run the device's tools program";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "DevTool";
	menu_name = "Artefacto Equipar Herramienta...";
	tooltip = "Corra el programa de herramientas de artefacto";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "DevTool";
	menu_name = "Outils D'Appareil...";
	tooltip = "Courir le programme d'outils de l'appareil";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_DEVICE_FORMAT;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_floppy_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Format";
	menu_name = "Format Media...";
	tooltip = "Format the media in the device";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Format";
	menu_name = "Formatear Medios...";
	tooltip = "Formatear los medios en el artefacto";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Format";
	menu_name = "Met Format Presse...";
	tooltip = "Met en format le presse dans l'appareil";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_BROWSER_OP_HELP_CONTENTS;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Help";
	menu_name = "Contents";
	tooltip = "Index of all help pages";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "La Ayuda";
	menu_name = "El Contenido";
	tooltip = "El Indice de toda ayuda pagina";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "L'Aide";
	menu_name = "Les Contenus";
	tooltip = "L'Index de toutes pages d'aide";
#endif
	accel_key = GDK_F1;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_HELP_FILE_BROWSER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
	button_name = "Help";
	menu_name = "File Browser";
	tooltip = "Help on using the file browser";
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_HELP_IMAGE_BROWSER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
	button_name = "Help";
	menu_name = "Image Browser";
	tooltip = "Help on using the image browser";
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_HELP_ARCHIVER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
	button_name = "Help";
	menu_name = "Archiver";
	tooltip = "Help on using the archiver";
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_HELP_RECYCLE_BIN;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
	button_name = "Help";
	menu_name = "Recycle Bin";
	tooltip = "Help on using the recycle bin";
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_HELP_KEYS_LIST;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "HelpKeys";
	menu_name = "Keys List";
	tooltip = "List of all keyboard key operations";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "HelpKeys";
	menu_name = "La Lista De Llaves";
	tooltip = "La Lista de todo teclado las operaciones claves";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "HelpKeys";
	menu_name = "La Liste De Clefs";
	tooltip = "La Liste de tout clavier toutes oprations principales";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_HELP_MIME_TYPES;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "HelpMIME";
	menu_name = "Mime Types";
	tooltip = "Help on setting up MIME Types";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "HelpMIME";
	menu_name = "Mime Types";
	tooltip = "Ayude a establecer MIME Types";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "HelpMIME";
	menu_name = "Mime Types";
	tooltip = "Aider sur montant MIME Types";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_HELP_DEVICES;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "HelpDev";
	menu_name = "Devices";
	tooltip = "Help on setting up devices";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "HelpDev";
	menu_name = "Los Artefactos";
	tooltip = "La Ayuda a establecer artefactos";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "HelpDev";
	menu_name = "Les Appareils";
	tooltip = "L'Aide sur montant des appareils";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_HELP_COMMON_OPERATIONS;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "HelpOp";
	menu_name = "Common Operations";
	tooltip = "Help on the most common operations";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "HelpOp";
	menu_name = "Las Operaciones Comunes";
	tooltip = "La Ayuda en las operaciones ms comunes";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "HelpOp";
	menu_name = "Les Oprations Communes";
	tooltip = "L'Aide sur montant des appareils";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_BROWSER_OP_HELP_ABOUT;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_about_20x20_xpm;
	menu_icon_data = (guint8 **)icon_about_20x20_xpm;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "About";
	menu_name = "About";
	tooltip = "About this application";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Acerca";
	menu_name = "Acerca De";
	tooltip = "Acerca de esta aplicacin";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "De";
	menu_name = "De";
	tooltip = "De cette application";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


#undef DO_APPEND_OPID

	return(list);
}

/*
 *	Deletes the File Browser Operation IDs list.
 */
void EDVBrowserOPIDListDelete(
	edv_browser_opid_struct **list, gint total
)
{
	gint i;
	edv_browser_opid_struct *opid;

	if(list == NULL)
	    return;

	for(i = 0; i < total; i++)
	{
	    opid = list[i];
	    if(opid == NULL)
		continue;

	    g_free(opid->button_name);
	    g_free(opid->menu_name);
	    g_free(opid->tooltip);

	    g_free(opid);
	}
	g_free(list);
}

/*
 *	Recreates the File Browser's new objects submenu.
 */
void EDVBrowserNewObjectMenuRegenerate(edv_browser_struct *browser)
{
	edv_browser_op op;
	guint8 **icon_data = NULL;
	GtkAccelGroup *accelgrp;
	GtkWidget *menu, *w, **w_record, **fw_record;

	if(browser == NULL)
	    return;

	accelgrp = browser->accelgrp;

	/* Destroy the new object submenu if any */
	GTK_WIDGET_DESTROY(browser->new_object_submenu);
	browser->new_object_submenu = NULL;

#define DO_ADD_MENU_ITEM_LABEL	{		\
 edv_browser_opid_struct *opid =		\
  EDVBrowserMatchOPID(browser, op);		\
 if(opid != NULL) {				\
  w = GUIMenuItemCreate(			\
   menu, GUI_MENU_ITEM_TYPE_LABEL, accelgrp,	\
   (guint8 **)((icon_data != NULL) ?		\
    icon_data : opid->menu_icon_data),		\
   opid->menu_name,				\
   opid->accel_key, opid->accel_mods,		\
   (gpointer *)fw_record,			\
   (gpointer)opid, EDVBrowserMenuItemCB		\
  );						\
  GUISetMenuItemCrossingCB(			\
   w,						\
   (gpointer)EDVBrowserMenuItemEnterCB, opid,	\
   (gpointer)EDVBrowserMenuItemLeaveCB, opid	\
  );						\
  if(w_record != NULL)				\
   *w_record = w;				\
 }						\
}

#define DO_ADD_MENU_SEP	{			\
 w = GUIMenuItemCreate(				\
  menu, GUI_MENU_ITEM_TYPE_SEPARATOR, NULL,	\
  NULL, NULL, 0, 0, NULL,			\
  NULL, NULL					\
 );						\
}

	/* Create new object submenu */
	menu = GUIMenuCreate();
	if(menu != NULL)
	{
	    op = EDV_BROWSER_OP_NEW_FILE;
	    w_record = &browser->new_file_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_NEW_DIRECTORY;
	    w_record = &browser->new_directory_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_NEW_LINK;
	    w_record = &browser->new_link_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_NEW_FIFO;
	    w_record = &browser->new_fifo_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_NEW_DEVICE_BLOCK;
	    w_record = &browser->new_device_block_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_NEW_DEVICE_CHARACTER;
	    w_record = &browser->new_device_character_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_NEW_SOCKET;
	    w_record = &browser->new_socket_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL
	}
	browser->new_object_submenu = menu;


	/* Attach submenu to new object menu item */
	w = browser->new_object_submi;
	GUIMenuItemSetSubMenu(w, menu);

#undef DO_ADD_MENU_SEP
#undef DO_ADD_MENU_ITEM_LABEL
}


/*
 *	Creates the File Browser's menu bar.
 *
 *	This function should be called by EDVBrowserNew().
 */
static void EDVBrowserCreateMenuBar(
	edv_browser_struct *browser, GtkWidget *parent
)
{
	edv_browser_op op;
	guint8 **icon_data = NULL;
	GtkAccelGroup *accelgrp = browser->accelgrp;
	GtkWidget *menu_bar, *menu, *w, **w_record, **fw_record;

	/* Create menu bar */
	menu_bar = GUIMenuBarCreate(NULL);
	browser->menu_bar = menu_bar;
	gtk_container_add(GTK_CONTAINER(parent), menu_bar);
	gtk_widget_show(menu_bar);

#define DO_ADD_MENU_ITEM_LABEL	{		\
 edv_browser_opid_struct *opid =		\
  EDVBrowserMatchOPID(browser, op);		\
 if(opid != NULL) {				\
  w = GUIMenuItemCreate(			\
   menu, GUI_MENU_ITEM_TYPE_LABEL, accelgrp,	\
   (guint8 **)((icon_data != NULL) ?		\
    icon_data : opid->menu_icon_data),		\
   opid->menu_name,				\
   opid->accel_key, opid->accel_mods,		\
   (gpointer *)fw_record,			\
   (gpointer)opid, EDVBrowserMenuItemCB		\
  );						\
  GUISetMenuItemCrossingCB(			\
   w,						\
   (gpointer)EDVBrowserMenuItemEnterCB, opid,	\
   (gpointer)EDVBrowserMenuItemLeaveCB, opid	\
  );						\
  if(w_record != NULL)				\
   *w_record = w;				\
 }						\
}

#define DO_ADD_MENU_ITEM_CHECK	{		\
 edv_browser_opid_struct *opid =		\
  EDVBrowserMatchOPID(browser, op);		\
 if(opid != NULL) {				\
  w = GUIMenuItemCreate(			\
   menu, GUI_MENU_ITEM_TYPE_CHECK, accelgrp,	\
   (guint8 **)((icon_data != NULL) ?		\
    icon_data : opid->menu_icon_data),		\
   opid->menu_name,				\
   opid->accel_key, opid->accel_mods,		\
   (void **)fw_record,				\
   (gpointer)opid, EDVBrowserMenuItemCB		\
  );						\
  GUISetMenuItemCrossingCB(			\
   w,						\
   (gpointer)EDVBrowserMenuItemEnterCB, opid,	\
   (gpointer)EDVBrowserMenuItemLeaveCB, opid	\
  );						\
  if(w_record != NULL)				\
   *w_record = w;				\
 }						\
}

#define DO_ADD_MENU_SEP	{			\
 w = GUIMenuItemCreate(				\
  menu, GUI_MENU_ITEM_TYPE_SEPARATOR, NULL,	\
  NULL, NULL, 0, 0, NULL,			\
  NULL, NULL					\
 );						\
}
	/* Create file menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_BROWSER_OP_OPEN;
	    w_record = &browser->open_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_OPEN_WITH;
	    w_record = &browser->openwith_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_BROWSER_OP_NEW;
	    w_record = &browser->new_object_submi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_BROWSER_OP_SYNC_DISKS;
	    w_record = &browser->sync_disks_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_BROWSER_OP_HISTORY;
	    w_record = &browser->history_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_BROWSER_OP_RUN;
	    w_record = &browser->run_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_BROWSER_OP_CLOSE;
	    w_record = &browser->close_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Archivo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Fichier"
#elif defined(PROG_LANGUAGE_GERMAN)
"Akte"
#elif defined(PROG_LANGUAGE_ITALIAN)
"File"
#elif defined(PROG_LANGUAGE_DUTCH)
"Dossier"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Arquivo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arkiv"
#else
"File"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);


	/* Create edit menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_BROWSER_OP_MOVE;
	    w_record = &browser->move_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_COPY;
	    w_record = &browser->copy_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_LINK;
	    w_record = &browser->link_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_RENAME;
	    w_record = &browser->rename_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_CHMOD;
	    w_record = &browser->chmod_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_CHOWN;
	    w_record = &browser->chown_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_DELETE;
	    w_record = &browser->delete_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_BROWSER_OP_SELECT_ALL;
	    w_record = &browser->select_all_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_UNSELECT_ALL;
	    w_record = &browser->unselect_all_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_INVERT_SELECTION;
	    w_record = &browser->invert_selection_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_FIND;
	    w_record = &browser->find_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_BROWSER_OP_PROPERTIES;
	    w_record = &browser->properties_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Redacte"
#elif defined(PROG_LANGUAGE_FRENCH)
"Editer"
#elif defined(PROG_LANGUAGE_GERMAN)
"Redigieren"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Redigere"
#elif defined(PROG_LANGUAGE_DUTCH)
"Bewerking"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Edite"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Rediger"
#else
"Edit"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);


	/* Create view menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_BROWSER_OP_REFRESH;
	    w_record = &browser->refresh_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_REFRESH_ALL;
	    w_record = &browser->refresh_all_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_BROWSER_OP_SHOW_TOOL_BAR;
	    w_record = &browser->show_tool_bar_micheck;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_CHECK

	    op = EDV_BROWSER_OP_SHOW_LOCATION_BAR;
	    w_record = &browser->show_location_bar_micheck;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_CHECK

	    op = EDV_BROWSER_OP_SHOW_MOUNT_BAR;
	    w_record = &browser->show_mount_bar_micheck;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_CHECK

	    op = EDV_BROWSER_OP_SHOW_FIND_BAR;
	    w_record = &browser->show_find_bar_micheck;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_CHECK

	    op = EDV_BROWSER_OP_SHOW_STATUS_BAR;
	    w_record = &browser->show_status_bar_micheck;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_CHECK

	    DO_ADD_MENU_SEP

	    op = EDV_BROWSER_OP_DIRECTORY_TREE_ORIGIN;
	    w_record = &browser->directory_tree_origin_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP       

	    op = EDV_BROWSER_OP_MIME_TYPES;
	    w_record = &browser->mime_types_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Vista"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vue"
#elif defined(PROG_LANGUAGE_GERMAN)
"Blick"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Veduta"
#elif defined(PROG_LANGUAGE_DUTCH)
"Overzicht"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Vista"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sikt"
#else
"View"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);


	/* Create device menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_BROWSER_OP_MOUNT;
	    w_record = &browser->mount_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_EJECT;
	    w_record = &browser->eject_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_BROWSER_OP_DEVICE_CHECK;
	    w_record = &browser->device_check_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_DEVICE_TOOLS;
	    w_record = &browser->device_tools_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_DEVICE_FORMAT;
	    w_record = &browser->device_format_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_BROWSER_OP_DEVICES;
	    w_record = &browser->devices_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Dispositivo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Appareil"
#elif defined(PROG_LANGUAGE_GERMAN)
"Vorrichtung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Congegno"
#elif defined(PROG_LANGUAGE_DUTCH)
"Apparaat"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Artifcio"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Innretning"
#else
"Device"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);


	/* Create settings menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_BROWSER_OP_WRITE_PROTECT;
	    w_record = &browser->write_protect_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_BROWSER_OP_OPTIONS;
	    w_record = &browser->options_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_CUSTOMIZE;
	    w_record = &browser->customize_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Escenarios"
#elif defined(PROG_LANGUAGE_FRENCH)
"Montages"
#elif defined(PROG_LANGUAGE_GERMAN)
"Setzen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Montaggi"
#elif defined(PROG_LANGUAGE_DUTCH)
"Zetten"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Por"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Innstillinger"
#else
"Settings"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);


	/* Create windows menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_BROWSER_OP_NEW_BROWSER;
	    w_record = &browser->window_new_browser_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_NEW_IMBR;
	    w_record = &browser->window_new_imbr_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_NEW_ARCHIVER;
	    w_record = &browser->window_new_archiver_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_BROWSER_OP_RECYCLE_BIN;
	    w_record = &browser->window_recycle_bin_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Ventanas"
#elif defined(PROG_LANGUAGE_FRENCH)
"Windows"
#elif defined(PROG_LANGUAGE_GERMAN)
"Fenster"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Finestre"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ramen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Janelas"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Vinduer"
#else
"Windows"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);


	/* Create help menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_BROWSER_OP_HELP_CONTENTS;
	    w_record = &browser->help_contents_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_BROWSER_OP_HELP_FILE_BROWSER;
	    w_record = &browser->help_file_browser_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_HELP_KEYS_LIST;
	    w_record = &browser->help_keys_list_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_HELP_MIME_TYPES;
	    w_record = &browser->help_mime_types_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_HELP_DEVICES;
	    w_record = &browser->help_devices_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_HELP_COMMON_OPERATIONS;
	    w_record = &browser->help_common_operations_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_BROWSER_OP_HELP_ABOUT;
	    w_record = &browser->help_about_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Ayuda"
#elif defined(PROG_LANGUAGE_FRENCH)
"Aide"
#elif defined(PROG_LANGUAGE_GERMAN)
"Hilfe"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Aiuto"
#elif defined(PROG_LANGUAGE_DUTCH)
"Hulp"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Ajuda"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Hjelp"
#else
"Help"
#endif
	    , GUI_MENU_BAR_ALIGN_RIGHT
	);


	/* Create new objects submenu */
	EDVBrowserNewObjectMenuRegenerate(browser);


#undef DO_ADD_MENU_ITEM_LABEL
#undef DO_ADD_MENU_ITEM_CHECK
#undef DO_ADD_MENU_SEP
}


/*
 *	Recreates the FIle Browser's list styles.
 */
void EDVBrowserListStylesRegenerate(edv_browser_struct *browser)
{
	gint i;
	edv_browser_cell_style n;
	GdkColormap *colormap;
	GtkStyle *style, *src_style;
	GtkWidget *w;

	if(browser == NULL)
	    return;

	w = browser->contents_clist;
	if(w == NULL)
	    return;

	/* Unref existing cell styles */
	for(i = 0; i < EDV_BROWSER_TOTAL_CELL_STYLES; i++)
	{
	    GTK_STYLE_UNREF(browser->cell_style[i]);
	    browser->cell_style[i] = NULL;
	}

	/* Get source style from contents clist as a template */
	colormap = gtk_widget_get_colormap(w);
	src_style = gtk_widget_get_style(w);
	if(src_style == NULL)
	    return;


	/* Begin creating cell styles */

#define REALLOC_COLOR(_ct_,_cs_)		{		\
 GDK_COLORMAP_FREE_COLOR(colormap, (_ct_));			\
 memcpy((_ct_), (_cs_), sizeof(GdkColor));			\
 GDK_COLORMAP_ALLOC_COLOR(colormap, (_ct_));			\
}

	/* No Access */
	n = EDV_BROWSER_CELL_STYLE_NO_ACCESS;
	browser->cell_style[n] = style = gtk_style_copy(src_style);
	if(style != NULL)
	{
	    const GdkColor	cs = EDV_GDKCOLOR_NO_ACCESS_FG,
				cs_sel = EDV_GDKCOLOR_NO_ACCESS_FG_SELECTED,
				cs_insen = EDV_GDKCOLOR_NO_ACCESS_FG_INSENSITIVE;

	    GtkStateType state = GTK_STATE_NORMAL;
	    REALLOC_COLOR(&style->fg[state], &cs)

	    state = GTK_STATE_ACTIVE;
	    REALLOC_COLOR(&style->fg[state], &cs)

	    state = GTK_STATE_PRELIGHT;
	    REALLOC_COLOR(&style->fg[state], &cs)

	    state = GTK_STATE_SELECTED;
	    REALLOC_COLOR(&style->fg[state], &cs_sel)

	    state = GTK_STATE_INSENSITIVE;
	    REALLOC_COLOR(&style->fg[state], &cs_insen)
	}

	/* Dangling Link */
	n = EDV_BROWSER_CELL_STYLE_DANGLING_LINK;
	browser->cell_style[n] = style = gtk_style_copy(src_style);
	if(style != NULL)
	{
	    const GdkColor	cs = EDV_GDKCOLOR_DANGLING_LINK_FG,
				cs_sel = EDV_GDKCOLOR_DANGLING_LINK_FG_SELECTED,
				cs_insen = EDV_GDKCOLOR_DANGLING_LINK_FG_INSENSITIVE;

	    GtkStateType state = GTK_STATE_NORMAL;
	    REALLOC_COLOR(&style->fg[state], &cs)

	    state = GTK_STATE_ACTIVE;
	    REALLOC_COLOR(&style->fg[state], &cs)

	    state = GTK_STATE_PRELIGHT;
	    REALLOC_COLOR(&style->fg[state], &cs)

	    state = GTK_STATE_SELECTED;
	    REALLOC_COLOR(&style->fg[state], &cs_sel)

	    state = GTK_STATE_INSENSITIVE;
	    REALLOC_COLOR(&style->fg[state], &cs_insen)
	}

	/* Hidden Object */
	n = EDV_BROWSER_CELL_STYLE_HIDDEN;
	browser->cell_style[n] = style = gtk_style_copy(src_style);
	if(style != NULL)
	{
	    const GdkColor	cs = EDV_GDKCOLOR_HIDDEN_OBJECT_FG,
				cs_sel = EDV_GDKCOLOR_HIDDEN_OBJECT_FG_SELECTED,
				cs_insen = EDV_GDKCOLOR_HIDDEN_OBJECT_FG_INSENSITIVE;

	    GtkStateType state = GTK_STATE_NORMAL;
	    REALLOC_COLOR(&style->fg[state], &cs)

	    state = GTK_STATE_ACTIVE;
	    REALLOC_COLOR(&style->fg[state], &cs)

	    state = GTK_STATE_PRELIGHT;
	    REALLOC_COLOR(&style->fg[state], &cs)

	    state = GTK_STATE_SELECTED;
	    REALLOC_COLOR(&style->fg[state], &cs_sel)

	    state = GTK_STATE_INSENSITIVE;
	    REALLOC_COLOR(&style->fg[state], &cs_insen)
	}

	/* Executable */
	n = EDV_BROWSER_CELL_STYLE_EXECUTABLE;
	browser->cell_style[n] = style = gtk_style_copy(src_style);
	if(style != NULL)
	{
	    const GdkColor	cs = EDV_GDKCOLOR_EXECUTABLE_FG,
				cs_sel = EDV_GDKCOLOR_EXECUTABLE_FG_SELECTED,
				cs_insen = EDV_GDKCOLOR_EXECUTABLE_FG_INSENSITIVE;

	    GtkStateType state = GTK_STATE_NORMAL;
	    REALLOC_COLOR(&style->fg[state], &cs)

	    state = GTK_STATE_ACTIVE;
	    REALLOC_COLOR(&style->fg[state], &cs)

	    state = GTK_STATE_PRELIGHT;
	    REALLOC_COLOR(&style->fg[state], &cs)

	    state = GTK_STATE_SELECTED;
	    REALLOC_COLOR(&style->fg[state], &cs_sel)

	    state = GTK_STATE_INSENSITIVE;
	    REALLOC_COLOR(&style->fg[state], &cs_insen)
	}

#undef REALLOC_COLOR
}


/*
 *	Creates a new File Browser.
 */
edv_browser_struct *EDVBrowserNew(gpointer core_ptr)
{
	const gchar *location_history_file = NULL;
	gint	toplevel_x = 0,
		toplevel_y = 0,
		toplevel_width = EDV_DEF_BROWSER_WIDTH,
		toplevel_height = EDV_DEF_BROWSER_HEIGHT,
		paned_position = EDV_DEF_BROWSER_PANED_POSITION;
	gboolean	tool_bar_map_state = TRUE,
			location_bar_map_state = TRUE,
			mount_bar_map_state = TRUE,
			find_bar_map_state = TRUE,
			status_bar_map_state = TRUE;
	const gchar	*directory_ctree_origin_path = NULL;
	gint i;
	edv_status_bar_struct *status_bar;
	const gchar	*wm_name = NULL,
			*wm_class = NULL;
	const cfg_item_struct *cfg_list = (core_ptr != NULL) ?
	    EDV_CORE(core_ptr)->cfg_list : NULL;
	GdkCursor *cursor;
	GList *glist;
	GtkRcStyle	*standard_rcstyle = NULL,
			*lists_rcstyle = NULL;
	GtkStyle *style;
	GtkWidget *w, *parent, *parent2, *parent3, *parent4;
	gpointer combo_rtn;
	GtkCombo *combo;
	GtkCList *clist;
	GtkCTree *ctree;
	GdkWindow *window;
	GtkAccelGroup *accelgrp;
	const GtkTargetEntry dnd_tar_types[] = {
{"text/plain",				0,	EDV_DND_TYPE_INFO_TEXT_PLAIN},
{"text/uri-list",			0,	EDV_DND_TYPE_INFO_TEXT_URI_LIST},
{"STRING",				0,	EDV_DND_TYPE_INFO_STRING},
{EDV_DND_TYPE_STRING_RECYCLED_OBJECT,	0,	EDV_DND_TYPE_INFO_RECYCLED_OBJECT},
{EDV_DND_TYPE_STRING_ARCHIVE_OBJECT,	0,	EDV_DND_TYPE_INFO_ARCHIVE_OBJECT}
	};
	const GtkTargetEntry dnd_src_types[] = {
{"text/plain",				0,      EDV_DND_TYPE_INFO_TEXT_PLAIN},
{"text/uri-list",			0,      EDV_DND_TYPE_INFO_TEXT_URI_LIST},
{"STRING",				0,      EDV_DND_TYPE_INFO_STRING}
	};
	edv_browser_struct *browser = EDV_BROWSER(
	    g_malloc0(sizeof(edv_browser_struct))
	);
	if(browser == NULL)
	    return(browser);


	/* Get configuration */
	if(cfg_list != NULL)
	{
	    edv_core_struct *c_ptr = EDV_CORE(core_ptr);

	    standard_rcstyle = c_ptr->standard_rcstyle;
	    lists_rcstyle = c_ptr->lists_rcstyle;

	    wm_name = c_ptr->wm_name;
	    wm_class = c_ptr->wm_class;

	    location_history_file = EDV_GET_S(
		EDV_CFG_PARM_FILE_BROWSER_LOCATION_HISTORY
	    );

	    if(c_ptr->geometry_set)
	    {
		GdkRectangle *rect = &c_ptr->geometry;
		toplevel_x = rect->x;
		toplevel_y = rect->y;
		toplevel_width = rect->width;
		toplevel_height = rect->height;
	    }
	    else
	    {
		toplevel_x = EDV_GET_I(EDV_CFG_PARM_BROWSER_X);
		toplevel_y = EDV_GET_I(EDV_CFG_PARM_BROWSER_Y);
		toplevel_width = EDV_GET_I(EDV_CFG_PARM_BROWSER_WIDTH);
		toplevel_height = EDV_GET_I(EDV_CFG_PARM_BROWSER_HEIGHT);
	    }

	    paned_position = EDV_GET_I(EDV_CFG_PARM_BROWSER_PANED_POSITION);

	    tool_bar_map_state = EDV_GET_B(EDV_CFG_PARM_BROWSER_SHOW_TOOL_BAR);
	    location_bar_map_state = EDV_GET_B(EDV_CFG_PARM_BROWSER_SHOW_LOCATION_BAR);
	    mount_bar_map_state = EDV_GET_B(EDV_CFG_PARM_BROWSER_SHOW_MOUNT_BAR);
	    find_bar_map_state = EDV_GET_B(EDV_CFG_PARM_BROWSER_SHOW_FIND_BAR);
	    status_bar_map_state = EDV_GET_B(EDV_CFG_PARM_BROWSER_SHOW_STATUS_BAR);

	    directory_ctree_origin_path = EDV_GET_S(
		EDV_CFG_PARM_BROWSER_DIR_TREE_ORIGIN
	    );
	}

	browser->accelgrp = accelgrp = gtk_accel_group_new();
	browser->processing = FALSE;
	browser->busy_count = 0;
	browser->freeze_count = 0;
	browser->core_ptr = core_ptr;

	browser->opid = EDVBrowserOPIDListNew(
	    browser, &browser->total_opids
	);

	browser->tool_bar_map_state = tool_bar_map_state;
	browser->location_bar_map_state = location_bar_map_state;
	browser->mount_bar_map_state = mount_bar_map_state;
	browser->find_bar_map_state = find_bar_map_state;
	browser->status_bar_map_state = status_bar_map_state;
	browser->directory_ctree_expand_optimize_idleid = 0;
	browser->directory_ctree_selected_node = NULL;
	browser->contents_clist_selected_row = -1;
	browser->selected_dev_num = -1;
	browser->directory_ctree_origin_path = STRDUP(directory_ctree_origin_path);
	browser->last_recbin_items = -1;
	browser->last_write_protect_state = -1;
	browser->status_bar = NULL;
	browser->fopdlg = NULL;

	/* Begin creating widgets */
	/* Toplevel */
	browser->toplevel = w = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_uposition(
	    w, toplevel_x, toplevel_y
	);
	gtk_widget_set_usize(
	    w, toplevel_width, toplevel_height
	);
	if(!STRISEMPTY(wm_name) && !STRISEMPTY(wm_class))
	    gtk_window_set_wmclass(GTK_WINDOW(w), wm_name, wm_class);
	else
	    gtk_window_set_wmclass(
		GTK_WINDOW(w), "filebrowser", PROG_NAME
	    );
	gtk_window_set_policy(
	    GTK_WINDOW(w),
	    TRUE, TRUE, TRUE
	);
	gtk_widget_realize(w);
	style = gtk_widget_get_style(w);
	window = w->window;
	if(window != NULL)
	{
	    GdkGeometry geometry;

	    geometry.min_width = 100;
	    geometry.min_height = 70;

	    geometry.base_width = 0;
	    geometry.base_height = 0;

	    geometry.width_inc = 1;
	    geometry.height_inc = 1;

#if 0
	    geometry.min_aspect = 1.3f;
	    geometry.max_aspect = 1.3f;
#endif
	    gdk_window_set_geometry_hints(
		window, &geometry,
		GDK_HINT_MIN_SIZE |
		GDK_HINT_BASE_SIZE |
		/* GDK_HINT_ASPECT | */
		GDK_HINT_RESIZE_INC
	    );

	    GUISetWMIcon(window, (guint8 **)endeavour_48x48_xpm);
	}
	gtk_signal_connect(
	    GTK_OBJECT(w), "delete_event",
	    GTK_SIGNAL_FUNC(EDVBrowserDeleteEventCB), browser
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "destroy",
	    GTK_SIGNAL_FUNC(EDVBrowserDestroyCB), browser
	);
	gtk_window_add_accel_group(GTK_WINDOW(w), accelgrp);
	gtk_container_set_border_width(GTK_CONTAINER(w), 0);
	parent = w;


	/* Main vbox */
	browser->main_vbox = w = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(parent), w);
	gtk_widget_show(w);
	parent = w;


	/* Vbox for tool bars */
	browser->bars_vbox = w = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent2 = w;


	/* Handle for menu bar */
	browser->menu_bar_handle = w = gtk_handle_box_new();
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_attached",
	    GTK_SIGNAL_FUNC(EDVBrowserHandleChildAttachedCB), browser
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_detached",
	    GTK_SIGNAL_FUNC(EDVBrowserHandleChildDetachedCB), browser
	);
	gtk_widget_show(w);
	/* Create menu bar */
	EDVBrowserCreateMenuBar(browser, w);


	/* Handle for tool bar */
	browser->tool_bar_handle = w = gtk_handle_box_new();
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_attached",
	    GTK_SIGNAL_FUNC(EDVBrowserHandleChildAttachedCB), browser
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_detached",
	    GTK_SIGNAL_FUNC(EDVBrowserHandleChildDetachedCB), browser
	);
	if(browser->tool_bar_map_state)
	    gtk_widget_show(w);
	/* Build tool bar later */
	browser->toolbar = NULL;


	/* Location bar handle box */
	browser->location_bar_handle = w = gtk_handle_box_new();
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_attached",
	    GTK_SIGNAL_FUNC(EDVBrowserHandleChildAttachedCB), browser
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_detached",
	    GTK_SIGNAL_FUNC(EDVBrowserHandleChildDetachedCB), browser
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	if(browser->location_bar_map_state)
	    gtk_widget_show(w);
	parent2 = w;

	/* Location bar hbox for location bar */
	browser->location_bar_hbox = w = gtk_hbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_widget_show(w);
	parent2 = w;


	/* Hbox for location icon and combo */
	w = gtk_hbox_new(FALSE, 0);	/* Don't need spacing between icon
					 * and combo because combo has it
					 * already.
					 */
	gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Vbox to orient location icon fixed parent */
	w = gtk_vbox_new(TRUE, 0);
	gtk_widget_set_usize(w, 20, 20);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Location icon fixed parent */
	browser->location_icon_fixed = w = gtk_fixed_new();
	gtk_widget_add_events(
	    w,
	    GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK |
	    GDK_POINTER_MOTION_MASK |
	    GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, TRUE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "enter_notify_event",
	    GTK_SIGNAL_FUNC(EDVBrowserLocBarIconCrossingCB), browser
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "leave_notify_event",
	    GTK_SIGNAL_FUNC(EDVBrowserLocBarIconCrossingCB), browser
	);
	gtk_widget_realize(w);
	cursor = EDVGetCursor(
	    EDV_CORE(core_ptr), EDV_CURSOR_CODE_HAND
	);
	gdk_window_set_cursor(w->window, cursor);
	GUISetWidgetTip(
	    w,
#ifdef PROG_LANGUAGE_ENGLISH
"Drag this to create a link to this location"
#endif
#ifdef PROG_LANGUAGE_SPANISH
"Arrastre esto crear un eslabn a esta ubicacin"
#endif
#ifdef PROG_LANGUAGE_FRENCH
"Traner ceci pour crer un lien  cet emplacement"
#endif
	);
	gtk_widget_show(w);

	/* Reset location icon pixmap */
	browser->location_icon_pm = NULL;

	/* Location combo */
	glist = EDVOpenFileGList(location_history_file, 0);
	w = GUIComboCreate(
#ifdef PROG_LANGUAGE_ENGLISH
	    "Location:",
#endif
#ifdef PROG_LANGUAGE_SPANISH
	    "La Ubicacin:",
#endif
#ifdef PROG_LANGUAGE_FRENCH
	    "Emplacement:",
#endif
	    "/",
	    glist,
	    20,		/* Maximum items */
	    &combo_rtn,
	    browser,
	    EDVBrowserComboActivateCB,
	    NULL
	);
	if(glist != NULL)
	{
	    g_list_foreach(glist, (GFunc)g_free, NULL);
	    g_list_free(glist);
	    glist = NULL;
	}
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);

	browser->location_combo = w = (GtkWidget *)combo_rtn;
	combo = GTK_COMBO(w);
	gtk_combo_set_case_sensitive(combo, TRUE);
	GUIDNDSetSrc(
	    browser->location_icon_fixed,
	    dnd_src_types,
	    sizeof(dnd_src_types) / sizeof(GtkTargetEntry),
	    GDK_ACTION_COPY | GDK_ACTION_MOVE |
	    GDK_ACTION_LINK,			/* Actions */
	    GDK_BUTTON1_MASK | GDK_BUTTON2_MASK,/* Buttons */
	    NULL,
	    EDVLocBarIconDragDataGet,
	    NULL,
	    NULL,
	    combo
	);
	EDVEntrySetDND(EDV_CORE(core_ptr), combo->entry);
	EDVEntrySetCompletePath(EDV_CORE(core_ptr), combo->entry);


	/* Mount bar handle box */
	browser->mount_bar_handle = w = gtk_handle_box_new();
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_attached",
	    GTK_SIGNAL_FUNC(EDVBrowserHandleChildAttachedCB), browser
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_detached",
	    GTK_SIGNAL_FUNC(EDVBrowserHandleChildDetachedCB), browser
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	if(browser->mount_bar_map_state)
	    gtk_widget_show(w);
	parent2 = w;

	/* Create mount bar */
	browser->mountbar = EDVMountBarNew(
	    core_ptr, parent2,
	    EDVBrowserMountBarMountCB,
	    EDVBrowserMountBarEjectCB,
	    EDVBrowserMountBarGoToCB,
	    EDVBrowserBarStatusMessageCB,
	    browser
	);
	EDVMountBarMap(browser->mountbar);


	/* Find bar handle box */
	browser->find_bar_handle = w = gtk_handle_box_new();
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_attached",
	    GTK_SIGNAL_FUNC(EDVBrowserHandleChildAttachedCB), browser
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_detached",
	    GTK_SIGNAL_FUNC(EDVBrowserHandleChildDetachedCB), browser
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	if(browser->find_bar_map_state)
	    gtk_widget_show(w);
	parent2 = w;

	/* Create find bar */
	browser->findbar = EDVFindBarNew(
	    core_ptr, parent2,
	    EDV_FINDBAR_ROLE_DISK_OBJECT,
	    EDVBrowserBarStatusMessageCB,
	    EDVBrowserBarStatusProgressCB,
	    EDVBrowserFindBarLocationCB,
	    EDVBrowserFindBarStartCB,
	    EDVBrowserFindBarEndCB,
	    EDVBrowserFindBarMatchCB,
	    browser
	);
	EDVFindBarMap(browser->findbar);


	/* Main paned */
	browser->main_paned = w = gtk_hpaned_new();
	gtk_paned_set_position(GTK_PANED(w), paned_position);
	gtk_paned_set_handle_size(
	    GTK_PANED(w), EDV_DEF_PANED_HANDLE_SIZE
	);
	gtk_paned_set_gutter_size(
	    GTK_PANED(w), EDV_DEF_PANED_GUTTER_SIZE
	);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent2 = w;


	/* Scrolled window for directory ctree */
	w = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(
	    GTK_SCROLLED_WINDOW(w),
	    GTK_POLICY_AUTOMATIC,
	    GTK_POLICY_AUTOMATIC
	);
	gtk_paned_add1(GTK_PANED(parent2), w);
	gtk_widget_show(w);
	parent3 = w;

	/* Create directory ctree */
	browser->directory_ctree = w = gtk_ctree_new(1, 0);
	clist = GTK_CLIST(w);
	ctree = GTK_CTREE(w);
	gtk_widget_add_events(
	    w,
	    GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK |
	    GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK |
	    GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK |
	    GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_press_event",
	    GTK_SIGNAL_FUNC(EDVCListKeyEventCB), core_ptr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_release_event",
	    GTK_SIGNAL_FUNC(EDVCListKeyEventCB), core_ptr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_press_event",
	    GTK_SIGNAL_FUNC(EDVCListButtonEventCB), core_ptr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_release_event",
	    GTK_SIGNAL_FUNC(EDVCListButtonEventCB), core_ptr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "motion_notify_event",
	    GTK_SIGNAL_FUNC(EDVCListMotionEventCB), core_ptr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_press_event",
	    GTK_SIGNAL_FUNC(EDVBrowserKeyEventCB), browser
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_release_event",
	    GTK_SIGNAL_FUNC(EDVBrowserKeyEventCB), browser
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "button_press_event",
	    GTK_SIGNAL_FUNC(EDVBrowserButtonPressEventCB), browser
	);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_widget_realize(w);
	gtk_clist_set_selection_mode(clist, GTK_SELECTION_SINGLE);
	gtk_ctree_set_line_style(ctree, GTK_CTREE_LINES_DOTTED);
	gtk_clist_set_column_auto_resize(clist, 0, TRUE);
	gtk_clist_set_column_justification(
	    clist, 0, GTK_JUSTIFY_LEFT
	);
	gtk_clist_set_row_height(clist, EDV_LIST_ROW_SPACING);
	gtk_clist_set_shadow_type(clist, GTK_SHADOW_IN);
	gtk_signal_connect(
	    GTK_OBJECT(w), "tree_select_row",
	    GTK_SIGNAL_FUNC(EDVBrowserTreeSelectRowCB), browser
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "tree_unselect_row",
	    GTK_SIGNAL_FUNC(EDVBrowserTreeUnselectRowCB), browser
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "tree_expand",
	    GTK_SIGNAL_FUNC(EDVBrowserTreeExpandCB), browser
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "tree_collapse",
	    GTK_SIGNAL_FUNC(EDVBrowserTreeCollapseCB), browser
	);
	/* Set up DND for the directory ctree */
	GUIDNDSetSrc(
	    w,
	    dnd_src_types,
	    sizeof(dnd_src_types) / sizeof(GtkTargetEntry),
	    GDK_ACTION_COPY | GDK_ACTION_MOVE |
		GDK_ACTION_LINK,		/* Actions */
	    GDK_BUTTON1_MASK | GDK_BUTTON2_MASK,/* Buttons */
	    NULL,
	    EDVBrowserDirTreeDragDataGetCB,
	    EDVBrowserDirTreeDragDataDeleteCB,
	    NULL,
	    browser
	);
	GUIDNDSetTar(
	    w,
	    dnd_tar_types,
	    sizeof(dnd_tar_types) / sizeof(GtkTargetEntry),
	    GDK_ACTION_COPY | GDK_ACTION_MOVE |
		GDK_ACTION_LINK,		/* Actions */
	    GDK_ACTION_MOVE,			/* Default action if same */
	    GDK_ACTION_MOVE,			/* Default action */
	    EDVBrowserDirTreeDragDataReceivedCB,
	    browser
	);
	gtk_widget_show(w);


	/* Scrolled window for contents clist */
	w = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(
	    GTK_SCROLLED_WINDOW(w),
	    GTK_POLICY_AUTOMATIC,
	    GTK_POLICY_AUTOMATIC
	);
	gtk_paned_add2(GTK_PANED(parent2), w);
	gtk_widget_show(w);
	parent3 = w;

	/* Contents clist */
	browser->contents_clist = w = gtk_clist_new(EDV_BROWSER_CONTENTS_CLIST_COLUMNS_MAX);
	clist = GTK_CLIST(w);
	gtk_widget_add_events(
	    w,
	    GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK |
	    GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK |
	    GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK |
	    GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_press_event",
	    GTK_SIGNAL_FUNC(EDVCListKeyEventCB), core_ptr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_release_event",
	    GTK_SIGNAL_FUNC(EDVCListKeyEventCB), core_ptr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_press_event",
	    GTK_SIGNAL_FUNC(EDVCListButtonEventCB), core_ptr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_release_event",
	    GTK_SIGNAL_FUNC(EDVCListButtonEventCB), core_ptr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "motion_notify_event",
	    GTK_SIGNAL_FUNC(EDVCListMotionEventCB), core_ptr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_press_event",
	    GTK_SIGNAL_FUNC(EDVBrowserKeyEventCB), browser
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_release_event",
	    GTK_SIGNAL_FUNC(EDVBrowserKeyEventCB), browser
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "button_press_event",
	    GTK_SIGNAL_FUNC(EDVBrowserButtonPressEventCB), browser
	);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_widget_realize(w);
	gtk_clist_set_selection_mode(clist, GTK_SELECTION_EXTENDED);
	for(i = 0; i < clist->columns; i++)
	    gtk_clist_set_column_width(clist, i, 10);
	gtk_clist_set_row_height(clist, EDV_LIST_ROW_SPACING);
	gtk_clist_set_shadow_type(clist, GTK_SHADOW_IN);
	gtk_signal_connect(
	    GTK_OBJECT(w), "resize_column",
	    GTK_SIGNAL_FUNC(EDVBrowserResizeColumnCB), browser
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "click_column",
	    GTK_SIGNAL_FUNC(EDVBrowserClickColumnCB), browser
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "select_row",
	    GTK_SIGNAL_FUNC(EDVBrowserSelectRowCB), browser
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "unselect_row",
	    GTK_SIGNAL_FUNC(EDVBrowserUnselectRowCB), browser
	);
	/* Set up DND for the contents list */
	GUIDNDSetSrc(
	    w,
	    dnd_src_types,
	    sizeof(dnd_src_types) / sizeof(GtkTargetEntry),
	    GDK_ACTION_COPY | GDK_ACTION_MOVE |
		GDK_ACTION_LINK,		/* Actions */
	    GDK_BUTTON1_MASK | GDK_BUTTON2_MASK,/* Buttons */
	    NULL,
	    EDVBrowserContentsDragDataGetCB,
	    EDVBrowserContentsDragDataDeleteCB,
	    NULL,
	    browser
	);
	GUIDNDSetTar(
	    w,
	    dnd_tar_types,
	    sizeof(dnd_tar_types) / sizeof(GtkTargetEntry),
	    GDK_ACTION_COPY | GDK_ACTION_MOVE |
		GDK_ACTION_LINK,		/* Actions */
	    GDK_ACTION_MOVE,			/* Default action if same */
	    GDK_ACTION_MOVE,			/* Default action */
	    EDVBrowserContentsDragDataReceivedCB,
	    browser
	);
	gtk_widget_show(w);


	/* Create Tool Bar */
	EDVBrowserToolBarRegenerate(browser);

	/* Create Directory Tree Menu */
	EDVBrowserDirectoryMenuRegenerate(browser);

	/* Create Contents List Menu */
	EDVBrowserContentsMenuRegenerate(browser);


	/* Create Status Bar */
	browser->status_bar = status_bar = EDVStatusBarNew(
	    core_ptr, browser->main_vbox
	);
	if(status_bar != NULL)
	{
	    if(browser->status_bar_map_state)
		EDVStatusBarMap(status_bar);
	    else
		EDVStatusBarUnmap(status_bar);
	}


	/* Set initial RC styles */
	if(standard_rcstyle != NULL)
	    gtk_widget_modify_style_recursive(
		browser->toplevel, standard_rcstyle
	    );
	if(lists_rcstyle != NULL)
	    gtk_widget_modify_style_recursive(
		browser->directory_ctree, lists_rcstyle
	    );
	if(lists_rcstyle != NULL)
	    gtk_widget_modify_style_recursive(
		browser->contents_clist, lists_rcstyle
	    );
	if(standard_rcstyle != NULL)
	    gtk_widget_modify_style_recursive(
		browser->directory_ctree_menu, standard_rcstyle
	    );
	if(standard_rcstyle != NULL)
	    gtk_widget_modify_style_recursive(
		browser->contents_clist_menu, standard_rcstyle
	    );
	EDVBrowserListStylesRegenerate(browser);

	/* Load special icons */
	EDVLoadPixmap(          
	    core_ptr,
	    (guint8 **)icon_folder_home_20x20_xpm,
	    "icon_folder_home_20x20_xpm",
	    &browser->folder_home_pixmap,
	    &browser->folder_home_mask
	);
	EDVLoadPixmap(
	    core_ptr,
	    (guint8 **)icon_folder_parent_20x20_xpm,
	    "icon_folder_parent_20x20_xpm",
	    &browser->folder_parent_pixmap,
	    &browser->folder_parent_mask
	);
	EDVLoadPixmap(
	    core_ptr,
	    (guint8 **)icon_folder_noaccess_20x20_xpm,
	    "icon_folder_noaccess_20x20_xpm",
	    &browser->folder_noaccess_pixmap,
	    &browser->folder_noaccess_mask
	);


	/* Reset all values */
	EDVBrowserReset(browser, FALSE);

	/* Update menus */
	EDVBrowserUpdateMenus(browser);

	return(browser);
}

/*
 *	Resets all values on the File Browser.
 */
void EDVBrowserReset(edv_browser_struct *browser, gboolean need_unmap)
{
	if(browser == NULL)
	    return;

	EDVBrowserSetTitle(browser, NULL);



	if(need_unmap)
	    EDVBrowserUnmap(browser);
}

/*
 *	Syncronizes the File Browser's widget values with other values.
 */
void EDVBrowserSyncData(edv_browser_struct *browser)
{
	if(browser == NULL)
	    return;

/* This function may be removed in the future, since there really is
 * no floating data from widgets to be synced to disk on the browser
 */

}


/*
 *	Updates the File Browser's widgets to reflect current values.
 */
void EDVBrowserUpdateMenus(edv_browser_struct *browser)
{
	gboolean	write_protect,
			write_protect_changed = FALSE;
	gboolean	sensitive,
			state;
	gint selected_dev_num;
	edv_device_struct *selected_dev_ptr;
	guint8 **icon_data, **recbin_icon_data;
	GtkWidget *w;
	gboolean	selected_dir_node_expanded = FALSE,
			selected_dir_node_has_child = FALSE;
	GtkCTreeNode *selected_dir_node;
	gint selected_obj_row;
	const cfg_item_struct *cfg_list;
	toolbar_struct *tb;
	edv_core_struct *core_ptr;


	if(browser == NULL)
	    return;

	core_ptr = EDV_CORE(browser->core_ptr);
	if(core_ptr == NULL)
	    return;

	cfg_list = core_ptr->cfg_list;

	tb = browser->toolbar;

#define DO_SHOW		\
{ if(w != NULL) gtk_widget_show(w); }
#define DO_HIDE		\
{ if(w != NULL) gtk_widget_hide(w); }
#define DO_SET_CHECK_STATE	{			\
 if((w != NULL) ? GTK_IS_CHECK_MENU_ITEM(w) : FALSE)	\
  GTK_CHECK_MENU_ITEM(w)->active = state;		\
}

	/* Get global write protect state */
	write_protect = EDV_GET_B(EDV_CFG_PARM_WRITE_PROTECT);
	if(browser->last_write_protect_state < 0)
	{
	    write_protect_changed = TRUE;
	}
	else
	{
	    if((write_protect && !browser->last_write_protect_state) ||
	       (!write_protect && browser->last_write_protect_state)
	    )
		write_protect_changed = TRUE;
	}
	browser->last_write_protect_state = write_protect ? 1 : 0;

	/* Get last selected directory node and contents row, note
	 * that even not NULL or positive does not mean they are
	 * valid. Check if they actually exist on the list before
	 * referencing them
	 */
	selected_dir_node = browser->directory_ctree_selected_node;
	selected_obj_row = browser->contents_clist_selected_row;

	/* Get last selected device (if any) */
	selected_dev_num = browser->selected_dev_num;
	if((selected_dev_num >= 0) && (selected_dev_num < core_ptr->total_devices))
	    selected_dev_ptr = core_ptr->device[selected_dev_num];
	else
	    selected_dev_ptr = NULL;

	/* Update recycle bin icon data, setting it to not NULL if it
	 * needs to be changed and update the browser's last_recbin_items
	 * to match the value on the core structure.
	 */
	icon_data = NULL;
	if(browser->last_recbin_items < 0)
	{
	    if(core_ptr->last_recbin_items > 0)
		icon_data = (guint8 **)icon_trash_20x20_xpm;
	    else
		icon_data = (guint8 **)icon_trash_empty_20x20_xpm;
	}
	else
	{
	    if(!browser->last_recbin_items &&
	       core_ptr->last_recbin_items
	    )
		icon_data = (guint8 **)icon_trash_20x20_xpm;
	    else if(browser->last_recbin_items &&
		    !core_ptr->last_recbin_items
	    )
		icon_data = (guint8 **)icon_trash_empty_20x20_xpm;
	}
	browser->last_recbin_items = core_ptr->last_recbin_items;
	recbin_icon_data = icon_data;


	/* Get selected directory node expand state (if any) */
	if(browser->directory_ctree != NULL)
	{
	    GtkCTreeNode *node;
	    GtkCTreeRow *row_ptr;
	    GtkCTree *ctree = GTK_CTREE(browser->directory_ctree);

	    node = EDVCTreeGetSelectedLast(ctree, &row_ptr);
	    if(row_ptr != NULL)
	    {
		selected_dir_node_expanded = row_ptr->expanded;
		selected_dir_node_has_child = (row_ptr->children != NULL) ?
		    TRUE : FALSE;
	    }
	}


	/* Update mount bar */
	EDVMountBarUpdateMenus(browser->mountbar);

	/* Update find bar */
	EDVFindBarUpdateMenus(browser->findbar);



	/* Begin updating menu items and tool bar items */

	/* File */
	/* Open and open with */
	sensitive = ((selected_dir_node != NULL) ||
	    (selected_obj_row > -1)) ? TRUE : FALSE;
	/* Open */
	GTK_WIDGET_SET_SENSITIVE(browser->open_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_OPEN, sensitive
	);
	/* Open with */
	GTK_WIDGET_SET_SENSITIVE(browser->openwith_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_OPEN_WITH, sensitive
	);

	/* New object sub menu item */
	sensitive = ((selected_dir_node != NULL) ||
	    (selected_obj_row > -1)) ? TRUE : FALSE;
	GTK_WIDGET_SET_SENSITIVE(browser->new_object_submi, sensitive)
	/* New file */
	GTK_WIDGET_SET_SENSITIVE(browser->new_file_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_NEW_FILE, sensitive
	);
	/* New directory */
	GTK_WIDGET_SET_SENSITIVE(browser->new_directory_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_NEW_DIRECTORY, sensitive
	);
	/* New link */
	GTK_WIDGET_SET_SENSITIVE(browser->new_link_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_NEW_LINK, sensitive
	);
	/* New fifo */
	GTK_WIDGET_SET_SENSITIVE(browser->new_fifo_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_NEW_FIFO, sensitive
	);
	/* New block device */
	GTK_WIDGET_SET_SENSITIVE(browser->new_device_block_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_NEW_DEVICE_BLOCK, sensitive
	);
	/* New character device */
	GTK_WIDGET_SET_SENSITIVE(browser->new_device_character_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_NEW_DEVICE_CHARACTER, sensitive
	);
	/* New socket */
	GTK_WIDGET_SET_SENSITIVE(browser->new_socket_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_NEW_SOCKET, sensitive
	);

	/* Go to parent */
	sensitive = (selected_dir_node != NULL) ? TRUE : FALSE;
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_GOTO_PARENT, sensitive
	);

	/* Edit */
	sensitive = ((selected_dir_node != NULL) ||
	    (selected_obj_row > -1)) ? TRUE : FALSE;
	/* Move */
	GTK_WIDGET_SET_SENSITIVE(browser->move_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_MOVE, sensitive
	);
	/* Copy */
	GTK_WIDGET_SET_SENSITIVE(browser->copy_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_COPY, sensitive
	);
	/* Link */
	GTK_WIDGET_SET_SENSITIVE(browser->link_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_LINK, sensitive
	);
	/* Rename */
	GTK_WIDGET_SET_SENSITIVE(browser->rename_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_RENAME, sensitive
	);
	/* Change mode */
	GTK_WIDGET_SET_SENSITIVE(browser->chmod_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_CHMOD, sensitive
	);
	/* Chown */
	GTK_WIDGET_SET_SENSITIVE(browser->chown_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_CHOWN, sensitive
	);
	/* Delete */
	GTK_WIDGET_SET_SENSITIVE(browser->delete_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_DELETE, sensitive
	);
	/* Properties */
	GTK_WIDGET_SET_SENSITIVE(browser->properties_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_PROPERTIES, sensitive
	);
	/* Copy path */
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_COPY_PATH, sensitive
	);
	/* Copy URL */
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_COPY_URL, sensitive
	);

	/* View */
	/* Show tool bar */
	w = browser->show_tool_bar_micheck;
	state = EDV_GET_B(EDV_CFG_PARM_BROWSER_SHOW_TOOL_BAR);
	DO_SET_CHECK_STATE
	ToolBarItemSetToggleID(
	    tb, EDV_BROWSER_OP_SHOW_TOOL_BAR, state
	);
	/* Show location bar */
	w = browser->show_location_bar_micheck;
	state = EDV_GET_B(EDV_CFG_PARM_BROWSER_SHOW_LOCATION_BAR);
	DO_SET_CHECK_STATE
	ToolBarItemSetToggleID(
	    tb, EDV_BROWSER_OP_SHOW_LOCATION_BAR, state
	);
	/* Show mount bar */
	w = browser->show_mount_bar_micheck;
	state = EDV_GET_B(EDV_CFG_PARM_BROWSER_SHOW_MOUNT_BAR);
	DO_SET_CHECK_STATE
	ToolBarItemSetToggleID(
	    tb, EDV_BROWSER_OP_SHOW_MOUNT_BAR, state
	);
	/* Show find bar */
	w = browser->show_find_bar_micheck;
	state = EDV_GET_B(EDV_CFG_PARM_BROWSER_SHOW_FIND_BAR);
	DO_SET_CHECK_STATE
	ToolBarItemSetToggleID(
	    tb, EDV_BROWSER_OP_SHOW_FIND_BAR, state
	);
	/* Show status bar */
	w = browser->show_status_bar_micheck;
	state = EDV_GET_B(EDV_CFG_PARM_BROWSER_SHOW_STATUS_BAR);
	DO_SET_CHECK_STATE
	ToolBarItemSetToggleID(
	    tb, EDV_BROWSER_OP_SHOW_STATUS_BAR, state
	);


	/* Device */
	sensitive = (selected_dev_ptr != NULL) ?
	    !selected_dev_ptr->no_unmount : FALSE;
	w = browser->mount_mi;
	GTK_WIDGET_SET_SENSITIVE(w, sensitive)
	if(w != NULL)
	{
	    const gchar *text;
	    guint8 **icon_data;
	    if(selected_dev_ptr != NULL)
	    {
		if(selected_dev_ptr->is_mounted)
		{
		    text = "Unmount";
		    icon_data = (guint8 **)icon_unmount_20x20_xpm;
		}
		else
		{
		    text = "Mount";
		    icon_data = (guint8 **)icon_mount_20x20_xpm;
		}
	    }
	    else
	    {
		text = "Mount/Unmount";
		icon_data = (guint8 **)icon_unmount_20x20_xpm;
	    }
	    GUIMenuItemSetPixmap(w, icon_data);
	    GUIMenuItemSetLabel(w, text);
	    ToolBarItemUpdateByID(
		tb, EDV_BROWSER_OP_MOUNT, text, icon_data, NULL
	    );
	}
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_MOUNT, sensitive
	);

	/* Eject */
	if(selected_dev_ptr != NULL)
	    sensitive = !STRISEMPTY(selected_dev_ptr->command_eject);
	else
	    sensitive = FALSE;
	GTK_WIDGET_SET_SENSITIVE(browser->eject_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_EJECT, sensitive
	);

	/* Device check, tools, and format commands */
	if(selected_dev_ptr != NULL)
	    sensitive = !STRISEMPTY(selected_dev_ptr->command_check);
	else
	    sensitive = FALSE;
	GTK_WIDGET_SET_SENSITIVE(browser->device_check_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_DEVICE_CHECK, sensitive
	);

	if(selected_dev_ptr != NULL)
	    sensitive = !STRISEMPTY(selected_dev_ptr->command_tools);
	else
	    sensitive = FALSE;
	GTK_WIDGET_SET_SENSITIVE(browser->device_tools_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_DEVICE_TOOLS, sensitive
	);

	if(selected_dev_ptr != NULL)
	    sensitive = !STRISEMPTY(selected_dev_ptr->command_format);
	else
	    sensitive = FALSE;
	GTK_WIDGET_SET_SENSITIVE(browser->device_format_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_BROWSER_OP_DEVICE_FORMAT, sensitive
	);


	/* Settings */
	if(write_protect_changed)
	{
	    w = browser->write_protect_mi;
	    if(w != NULL)
		GUIMenuItemSetPixmap(
		    w,
		    (guint8 **)(write_protect ?
			icon_secure_20x20_xpm : icon_insecure_20x20_xpm)
		);
	    ToolBarItemUpdateByID(
		tb, EDV_BROWSER_OP_WRITE_PROTECT,
		NULL,
		(guint8 **)(write_protect ?
		    icon_secure_20x20_xpm : icon_insecure_20x20_xpm),
		NULL
	    );
	}


	/* Windows */
	if(recbin_icon_data != NULL)
	{
	    GUIMenuItemSetPixmap(
		browser->window_recycle_bin_mi, recbin_icon_data
	    );
	    ToolBarItemUpdateByID(
		tb, EDV_BROWSER_OP_RECYCLE_BIN,
		NULL, recbin_icon_data, NULL
	    );
	}


	/* Update directory ctree menu */
	sensitive = (selected_dir_node != NULL) ? TRUE : FALSE;
	GTK_WIDGET_SET_SENSITIVE(
	    browser->directory_ctree_move_mi, sensitive
	)
	GTK_WIDGET_SET_SENSITIVE(
	    browser->directory_ctree_copy_mi, sensitive
	)
	GTK_WIDGET_SET_SENSITIVE(
	    browser->directory_ctree_link_mi, sensitive
	)
	GTK_WIDGET_SET_SENSITIVE(
	    browser->directory_ctree_rename_mi, sensitive
	)
	GTK_WIDGET_SET_SENSITIVE(
	    browser->directory_ctree_chmod_mi, sensitive
	)
	GTK_WIDGET_SET_SENSITIVE(
	    browser->directory_ctree_chown_mi, sensitive
	)
	GTK_WIDGET_SET_SENSITIVE(
	    browser->directory_ctree_delete_mi, sensitive
	)
	GTK_WIDGET_SET_SENSITIVE(
	    browser->directory_ctree_properties_mi, sensitive
	)

	w = browser->directory_ctree_expand_mi;
	if(selected_dir_node != NULL)
	    sensitive = selected_dir_node_has_child;
	else
	    sensitive = FALSE;
	GTK_WIDGET_SET_SENSITIVE(w, sensitive)
	if(w != NULL)
	{
	    const gchar *text;
	    if(sensitive)
		text = selected_dir_node_expanded ?
		    "Collapse" : "Expand";
	    else
		text = "Expand/Collapse";
	    GUIMenuItemSetLabel(w, text);
	}

	w = browser->directory_ctree_mount_mi;
	if(selected_dev_ptr == NULL)
	    DO_HIDE
	else
	    DO_SHOW
	sensitive = (selected_dev_ptr != NULL) ?
	    !selected_dev_ptr->no_unmount : FALSE;
	GTK_WIDGET_SET_SENSITIVE(w, sensitive)
	if(selected_dev_ptr != NULL)
	{
	    const gchar *text;
	    guint8 **icon_data;
	    if(selected_dev_ptr->is_mounted)
	    {
		text = "Unmount";  
		icon_data = (guint8 **)icon_unmount_20x20_xpm;
	    }
	    else
	    {   
		text = "Mount";
		icon_data = (guint8 **)icon_mount_20x20_xpm;
	    }
	    GUIMenuItemSetPixmap(w, icon_data);
	    GUIMenuItemSetLabel(w, text);
	}

	w = browser->directory_ctree_mount_misep;
	if(selected_dev_ptr == NULL)
	    DO_HIDE
	else
	    DO_SHOW

	/* Eject */
	w = browser->directory_ctree_eject_mi;
	if(selected_dev_ptr == NULL)
	    DO_HIDE
	else
	    DO_SHOW
	if(selected_dev_ptr != NULL)
	    sensitive = (selected_dev_ptr->command_eject != NULL) ?
		(*selected_dev_ptr->command_eject != '\0') : FALSE;
	else
	    sensitive = FALSE;
	GTK_WIDGET_SET_SENSITIVE(w, sensitive)


	/* Update contents clist menu */
	sensitive = (selected_obj_row > -1) ? TRUE : FALSE;
	GTK_WIDGET_SET_SENSITIVE(
	    browser->contents_clist_open_mi, sensitive
	)
	GTK_WIDGET_SET_SENSITIVE(
	    browser->contents_clist_openwith_mi, sensitive
	)
	GTK_WIDGET_SET_SENSITIVE(
	    browser->contents_clist_move_mi, sensitive
	)
	GTK_WIDGET_SET_SENSITIVE(
	    browser->contents_clist_copy_mi, sensitive
	)
	GTK_WIDGET_SET_SENSITIVE(
	    browser->contents_clist_link_mi, sensitive
	)
	GTK_WIDGET_SET_SENSITIVE(
	    browser->contents_clist_rename_mi, sensitive
	)
	GTK_WIDGET_SET_SENSITIVE(
	    browser->contents_clist_chmod_mi, sensitive
	)
	GTK_WIDGET_SET_SENSITIVE(
	    browser->contents_clist_chown_mi, sensitive
	)
	GTK_WIDGET_SET_SENSITIVE(
	    browser->contents_clist_delete_mi, sensitive
	)
	GTK_WIDGET_SET_SENSITIVE(
	    browser->contents_clist_properties_mi, sensitive
	)




	/* Update status bar */
	EDVStatusBarUpdate(browser->status_bar);

#undef DO_SHOW
#undef DO_HIDE
#undef DO_SET_CHECK_STATE
}

/*
 *	Sets the File Browser as busy or ready.
 */
void EDVBrowserSetBusy(edv_browser_struct *browser, gboolean is_busy)
{
	GdkCursor *cursor;
	GtkWidget *w;
	edv_core_struct *core_ptr;


	if(browser == NULL)
	    return;

	core_ptr = EDV_CORE(browser->core_ptr);
	if(core_ptr == NULL)
	    return;

	w = browser->toplevel;
	if(w != NULL)
	{
	    if(is_busy)
	    {
		/* Increase busy count */
		browser->busy_count++;

		/* If already busy then don't change anything */
		if(browser->busy_count > 1)
		    return;

		cursor = EDVGetCursor(core_ptr, EDV_CURSOR_CODE_BUSY);
	    }
	    else
	    {
		/* Reduce busy count */
		browser->busy_count--;
		if(browser->busy_count < 0)
		    browser->busy_count = 0;

		/* If still busy do not change anything */
		if(browser->busy_count > 0)
		    return;

		cursor = NULL;	/* Use default cursor */
	    }

	    /* Update toplevel window's cursor */
	    if(w->window != NULL)
	    {
		gdk_window_set_cursor(w->window, cursor);
		gdk_flush();
	    }
	}
}

/*
 *	Checks if the File Browser is mapped.
 */
gboolean EDVBrowserIsMapped(edv_browser_struct *browser)
{
	GtkWidget *w = (browser != NULL) ? browser->toplevel : NULL;
	return((w != NULL) ? GTK_WIDGET_MAPPED(w) : FALSE);
}

/*
 *	Maps the File Browser.
 */
void EDVBrowserMap(edv_browser_struct *browser)
{
	GtkWidget *w = (browser != NULL) ? browser->toplevel : NULL;
	if(w == NULL)
	    return;

	gtk_widget_show_raise(w);
}

/*
 *	Unmaps the File Browser.
 */
void EDVBrowserUnmap(edv_browser_struct *browser)
{
	GtkWidget *w = (browser != NULL) ? browser->toplevel : NULL;
	if(w == NULL)
	    return;

	gtk_widget_hide(w);
}

/*
 *	Deletes the File Browser.
 */
void EDVBrowserDelete(edv_browser_struct *browser)
{
	gint i;

	if(browser == NULL)
	    return;

	/* Remove Directory Tree expand optimize idle callback */
	GTK_IDLE_REMOVE(browser->directory_ctree_expand_optimize_idleid)
	browser->directory_ctree_expand_optimize_idleid = 0;

	/* Reset last selected item references */
	browser->directory_ctree_selected_node = NULL;
	browser->contents_clist_selected_row = -1;

	/* Delete file operation dialog */
	EDVFOPDlgDelete(browser->fopdlg);
	browser->fopdlg = NULL;

	/* Right click menus */
	browser->directory_ctree_expand_mi = NULL;
	browser->directory_ctree_mount_mi = NULL;
	browser->directory_ctree_eject_mi = NULL;
	browser->directory_ctree_mount_misep = NULL;
	browser->directory_ctree_move_mi = NULL;
	browser->directory_ctree_copy_mi = NULL;
	browser->directory_ctree_link_mi = NULL;
	browser->directory_ctree_rename_mi = NULL;
	browser->directory_ctree_chmod_mi = NULL;
	browser->directory_ctree_chown_mi = NULL;
	browser->directory_ctree_delete_mi = NULL;
	browser->directory_ctree_properties_mi = NULL;
	GTK_WIDGET_DESTROY(browser->directory_ctree_menu)
	browser->directory_ctree_menu = NULL;

	browser->contents_clist_open_mi = NULL;
	browser->contents_clist_openwith_mi = NULL;
	browser->contents_clist_move_mi = NULL;
	browser->contents_clist_copy_mi = NULL;
	browser->contents_clist_link_mi = NULL;
	browser->contents_clist_rename_mi = NULL;
	browser->contents_clist_chmod_mi = NULL;
	browser->contents_clist_chown_mi = NULL;
	browser->contents_clist_delete_mi = NULL;
	browser->contents_clist_properties_mi = NULL;
	GTK_WIDGET_DESTROY(browser->contents_clist_menu)
	browser->contents_clist_menu = NULL;

	/* Delete the Status Bar */
	EDVStatusBarDelete(browser->status_bar);
	browser->status_bar = NULL;

	/* Delete the Tool Bar */
	ToolBarDelete(browser->toolbar);
	browser->toolbar = NULL;

	/* Delete the Mount Bar */
	EDVMountBarDelete(browser->mountbar);
	browser->mountbar = NULL;

	/* Delete the Find Bar */
	EDVFindBarDelete(browser->findbar);
	browser->findbar = NULL;

	/* Delete the Location Bar */
	GTK_WIDGET_DESTROY(browser->location_icon_pm)
	browser->location_icon_pm = NULL;
	GTK_WIDGET_DESTROY(browser->location_icon_fixed)
	browser->location_icon_fixed = NULL;
	GTK_WIDGET_DESTROY(browser->location_combo)
	browser->location_combo = NULL;
	GTK_WIDGET_DESTROY(browser->location_bar_hbox)
	browser->location_bar_hbox = NULL;

	/* Delete the Menus and the Menu Bar */
	browser->new_file_mi = NULL;
	browser->new_directory_mi = NULL;
	browser->new_link_mi = NULL;
	browser->new_fifo_mi = NULL;
	browser->new_device_block_mi = NULL;
	browser->new_device_character_mi = NULL;
	browser->new_socket_mi = NULL;
/*	GUIMenuItemSetSubMenu(browser->new_object_submi, NULL); */
	GTK_WIDGET_DESTROY(browser->new_object_submenu)
	browser->new_object_submenu = NULL;

	browser->open_mi = NULL;
	browser->openwith_mi = NULL;
	browser->new_object_submi = NULL;
	browser->sync_disks_mi = NULL;
	browser->history_mi = NULL;
	browser->run_mi = NULL;
	browser->close_mi = NULL;

	browser->move_mi = NULL;
	browser->copy_mi = NULL;
	browser->link_mi = NULL;
	browser->rename_mi = NULL;
	browser->chmod_mi = NULL;
	browser->chown_mi = NULL;
	browser->delete_mi = NULL;
	browser->select_all_mi = NULL;
	browser->unselect_all_mi = NULL;
	browser->invert_selection_mi = NULL;
	browser->find_mi = NULL;
	browser->properties_mi = NULL;

	browser->mount_mi = NULL;
	browser->eject_mi = NULL;
	browser->device_check_mi = NULL;
	browser->device_tools_mi = NULL;
	browser->device_format_mi = NULL;
	browser->devices_mi = NULL;

	browser->refresh_mi = NULL;
	browser->refresh_all_mi = NULL;
	browser->show_tool_bar_micheck = NULL;
	browser->show_location_bar_micheck = NULL;
	browser->show_mount_bar_micheck = NULL;
	browser->show_find_bar_micheck = NULL;
	browser->show_status_bar_micheck = NULL;
	browser->directory_tree_origin_mi = NULL;
	browser->mime_types_mi = NULL;

	browser->write_protect_mi = NULL;
	browser->options_mi = NULL;
	browser->customize_mi = NULL;

	browser->window_new_browser_mi = NULL;
	browser->window_new_imbr_mi = NULL;
	browser->window_new_archiver_mi = NULL;
	browser->window_recycle_bin_mi = NULL;

	browser->help_contents_mi = NULL;
	browser->help_file_browser_mi = NULL;
	browser->help_keys_list_mi = NULL;
	browser->help_mime_types_mi = NULL;
	browser->help_devices_mi = NULL;
	browser->help_common_operations_mi = NULL;
	browser->help_about_mi = NULL;

	GTK_WIDGET_DESTROY(browser->menu_bar) 
	browser->menu_bar = NULL;


	/* Destroy all other widgets and the toplevel widget */
	GTK_WIDGET_DESTROY(browser->contents_clist)
	browser->contents_clist = NULL;
	GTK_WIDGET_DESTROY(browser->directory_ctree)
	browser->directory_ctree = NULL;
	GTK_WIDGET_DESTROY(browser->main_paned)
	browser->main_paned = NULL;
	GTK_WIDGET_DESTROY(browser->menu_bar_handle)
	browser->menu_bar_handle = NULL;
	GTK_WIDGET_DESTROY(browser->tool_bar_handle)
	browser->tool_bar_handle = NULL;
	GTK_WIDGET_DESTROY(browser->location_bar_handle)
	browser->location_bar_handle = NULL;
	GTK_WIDGET_DESTROY(browser->bars_vbox)
	browser->bars_vbox = NULL;
	GTK_WIDGET_DESTROY(browser->main_vbox)
	browser->main_vbox = NULL;
	GTK_WIDGET_DESTROY(browser->toplevel)
	browser->toplevel = NULL;

	/* Unref all cell styles */
	for(i = 0; i < EDV_BROWSER_TOTAL_CELL_STYLES; i++)
	{
	    GTK_STYLE_UNREF(browser->cell_style[i])
	    browser->cell_style[i] = NULL;
	}

	/* Unref special icons */
	GDK_PIXMAP_UNREF(browser->folder_home_pixmap)
	GDK_BITMAP_UNREF(browser->folder_home_mask)
	GDK_PIXMAP_UNREF(browser->folder_parent_pixmap)
	GDK_BITMAP_UNREF(browser->folder_parent_mask)
	GDK_PIXMAP_UNREF(browser->folder_noaccess_pixmap)
	GDK_BITMAP_UNREF(browser->folder_noaccess_mask)

	GTK_ACCEL_GROUP_UNREF(browser->accelgrp)

	/* Delete other resources */

	/* Operation IDs */
	EDVBrowserOPIDListDelete(
	    browser->opid, browser->total_opids
	);

	g_free(browser->directory_ctree_origin_path);

	g_free(browser);
}
