/*
		    Endeavour Archiver Callbacks
 */

#ifndef ARCHIVERCB_H
#define ARCHIVERCB_H

#include <gtk/gtk.h>
#include "edvtypes.h"
#include "edvmimetypes.h"
#include "edvarchobj.h"
#include "archiver.h"


extern void EDVArchiverContentsItemDestroyCB(gpointer data);

extern gint EDVArchiverDeleteEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
extern void EDVArchiverDestroyCB(GtkObject *object, gpointer data);

extern gint EDVArchiverMapCB(
	GtkWidget *widget, GdkEventAny *event, gpointer data
);
extern gint EDVArchiverUnmapCB(
	GtkWidget *widget, GdkEventAny *event, gpointer data
);

extern gint EDVArchiverKeyEventCB(
	 GtkWidget *widget, GdkEventKey *key, gpointer data
);
extern gint EDVArchiverEnterNotifyEventCB(
	 GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint EDVArchiverLeaveNotifyEventCB(
	 GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint EDVArchiverButtonPressEventCB(
	GtkWidget *widget, GdkEventButton *button, gpointer data
);

extern void EDVArchiverHandleChildAttachedCB(
	GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);
extern void EDVArchiverHandleChildDetachedCB(
	GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);

extern void EDVArchiverResizeColumnCB(
	GtkCList *clist, gint column, gint width, gpointer data
);
extern void EDVArchiverClickColumnCB(
	GtkCList *clist, gint column, gpointer data
);
extern void EDVArchiverSelectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);
extern void EDVArchiverUnselectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);

extern void EDVArchiverComboActivateCB(GtkWidget *widget, gpointer data);

extern void EDVArchiverWriteProtectChangedCB(
	edv_archiver_struct *archiver, gboolean state
);

extern void EDVArchiverObjectModifiedNotifyCB(
	edv_archiver_struct *archiver, const gchar *path,
	const gchar *new_path, const struct stat *lstat_buf
);
extern void EDVArchiverObjectRemovedNotifyCB(
	edv_archiver_struct *archiver, const gchar *path
);

extern void EDVArchiverArchiveObjectAddedNotifyCB(
	edv_archiver_struct *archiver, const gchar *arch_path,
	const gchar *path, edv_archive_object_struct *obj
);
extern void EDVArchiverArchiveObjectModifiedNotifyCB(
	edv_archiver_struct *archiver, const gchar *arch_path,
	const gchar *path, const gchar *new_path,
	edv_archive_object_struct *obj
);
extern void EDVArchiverArchiveObjectRemovedNotifyCB(
	edv_archiver_struct *archiver, const gchar *arch_path,
	const gchar *path
);

extern void EDVArchiverRecycledObjectAddedNotifyCB(
	edv_archiver_struct *archiver, guint index
);
extern void EDVArchiverRecycledObjectRemovedNotifyCB(
	edv_archiver_struct *archiver, guint index
);

extern void EDVArchiverReconfiguredNotifyCB(edv_archiver_struct *archiver);

extern void EDVArchiverMimeTypeAddedCB(
	edv_archiver_struct *archiver,
	gint mt_num, edv_mimetype_struct *mt_ptr
);
extern void EDVArchiverMimeTypeModifiedCB(
	edv_archiver_struct *archiver,
	gint mt_num, edv_mimetype_struct *mt_ptr
);
extern void EDVArchiverMimeTypeRemovedCB(
	edv_archiver_struct *archiver, gint mt_num
);


#endif	/* ARCHIVERCB_H */
