/* Install script for the FAT32.IFS driver                                */
/*                                                                        */
/* Place the following files in this directory from the OS2FAT32 package: */
/* FAT32.IFS, CACHEF32.EXE, F32STAT.EXE, MONITOR.EXE, UFAT32.DLL,         */
/* PARTFILT.FLT, fat32.txt, partfilt.txt, partfilt.doc and DISKINFO.EXE.  */
/*                                                                        */
/* Instead of PARTFILT.FLT you might place here DANIDASD.DMD too.         */
/* PARTFILT.FLT (or DANIDASD.DMD) will not be installed if LVM is         */
/* active!!! The LVM enabled version of OS2DASD.DMD is FAT32 aware, so    */
/* you will not need those files.                                         */
/*                                                                        */
/* 05.05.2001: FAT32.IFS will be added before the PROTSHELL line, and not */
/*             after HPFS.IFS. HPFS.IFS is not always in the config.sys.  */ 
/* 23.01.2002: added option 0B,0C,1B,1C to partfilt.flt                   */
/* 05.24.2002: added support for uninstallation                           */
/* 05.26.2002: copy diskinfo.exe to diskif32.exe (dani has the same tool) */
/* 01.09.2003: fixed danidasd.dmd uninstallation problem                  */

parse arg target source mode

/* get additional parameters from environment */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")

/* check if we are in uninstall mode */
if mode = 'UNINSTALL' then do
	call uninstall
	exit
end

/* exit if package does not exist */
if stream(inst_dir'\fat32.ifs', 'c', 'query exists') = '' then exit 9

/* copy files but do not overwrite them if they are already there */
if stream(target'\os2\FAT32.IFS', 'c', 'query exists') = '' then do
	'copy 'inst_dir'\FAT32.IFS 'target'\os2\. >> 'product_log
end
if stream(target'\os2\CACHEF32.EXE', 'c', 'query exists') = '' then do
	'copy 'inst_dir'\CACHEF32.EXE 'target'\os2\. >> 'product_log
end
if stream(target'\os2\F32STAT.EXE', 'c', 'query exists') = '' then do
	'copy 'inst_dir'\F32STAT.EXE 'target'\os2\. >> 'product_log
end
if stream(target'\os2\MONITOR.EXE', 'c', 'query exists') = '' then do
	'copy 'inst_dir'\MONITOR.EXE 'target'\os2\. >> 'product_log
end
if stream(target'\os2\DISKINFO.EXE', 'c', 'query exists') = '' then do
	'copy 'inst_dir'\DISKINFO.EXE 'target'\os2\diskif32.exe >> 'product_log
end
if stream(target'\os2\DLL\UFAT32.DLL', 'c', 'query exists') = '' then do
	'copy 'inst_dir'\UFAT32.DLL 'target'\os2\dll\. >> 'product_log
end
if stream(target'\os2\boot\PARTFILT.FLT', 'c', 'query exists') = '' then do
  if stream(inst_dir'\PARTFILT.FLT', 'c', 'query exists') <> '' then 'copy 'inst_dir'\PARTFILT.FLT 'target'\os2\boot\. >> 'product_log
end
if stream(target'\os2\boot\DANIDASD.DMD', 'c', 'query exists') = '' then do
	if stream(inst_dir'\DANIDASD.DMD', 'c', 'query exists') <> '' then 'copy 'inst_dir'\DANIDASD.DMD 'target'\os2\boot\. >> 'product_log
end
if stream(target'\os2\help\fat32.txt', 'c', 'query exists') = '' then do
	'copy 'inst_dir'\fat32.txt 'target'\os2\help\. >> 'product_log
end
if stream(target'\os2\help\partfilt.txt', 'c', 'query exists') = '' then do
	'copy 'inst_dir'\partfilt.txt 'target'\os2\help\. >> 'product_log
end
if stream(target'\os2\help\partfilt.doc', 'c', 'query exists') = '' then do
	'copy 'inst_dir'\partfilt.doc 'target'\os2\help\. >> 'product_log
end

/* change config.sys if needed */
cfgfile = target'\config.sys'
q = 1
lvm_active = 0
do while lines(cfgfile)
	l.q = linein(cfgfile)
	if pos('FAT32.IFS',  translate(l.q)) > 0 then exit /* the driver is already added, leave the config.sys alone */
	if pos('OS2LVM.DMD', translate(l.q)) > 0 then lvm_active = 1
	q = q+1
end
rc = lineout(cfgfile)
l.0 = q-1

/* backup config.sys */
'copy 'cfgfile target'\os2\install\config.f32' 
'del 'cfgfile
gevonden = 0
do q=1 to l.0
	if pos('PROTSHELL=', translate(l.q)) > 0 then do
		/* add FAT32 driver after PROTSHELL= */
		gevonden = 1
	end
	if (pos('OS2DASD.DMD', translate(l.q)) = 0 | stream(inst_dir'\DANIDASD.DMD', 'c', 'query exists') = '') then rc = lineout(cfgfile, l.q)
	if gevonden = 1 then do
		rc = lineout(cfgfile, ' ')
		rc = lineout(cfgfile, 'REM UpdCD')
		rc = lineout(cfgfile, 'IFS='target'\OS2\FAT32.IFS /CACHE:2048')
		rc = lineout(cfgfile, 'CALL='target'\OS2\CACHEF32.EXE')
		if lvm_active = 0 then do
			if stream(inst_dir'\DANIDASD.DMD', 'c', 'query exists') <> '' then rc = lineout(cfgfile, 'BASEDEV=DANIDASD.DMD') 
			else rc = lineout(cfgfile, 'BASEDEV=PARTFILT.FLT /P 0B,0C,1B,1C /W') 
		end
		else do
			if stream(inst_dir'\DANIDASD.DMD', 'c', 'query exists') <> '' then rc = lineout(cfgfile, 'BASEDEV=OS2DASD.DMD') 
		end
		gevonden = 0
	end
end
rc = lineout(cfgfile)

exit

uninstall:

	/* update config.sys */
	found. = 0
	cfgfile = target'\config.sys'
	q = 1
	do while lines(cfgfile)
		l.q = linein(cfgfile)
		q=q+1
	end
	call lineout cfgfile
	l.0=q-1
	'copy 'cfgfile target'\os2\install\config.f32 >> 'product_log 
	'del 'cfgfile' >> 'product_log 
	do q=1 to l.0
		if pos('\OS2\FAT32.IFS', translate(l.q)) > 0 then iterate
		if pos('\OS2\CACHEF32.EXE', translate(l.q)) > 0 then iterate
		if pos('DANIDASD.DMD', translate(l.q)) > 0 then do
			call lineout cfgfile, 'BASEDEV=OS2DASD.DMD'
			iterate
		end
		call lineout cfgfile, l.q
	end
	call lineout cfgfile

	/* delete files */
	'call 'source'\updcd\bin\unlock.exe 'target'\os2\cachef32.exe'
	'del 'target'\os2\fat32.ifs    >> 'product_log
	'del 'target'\os2\cachef32.exe >> 'product_log
	'del 'target'\os2\MONITOR.EXE  >> 'product_log
	'del 'target'\os2\DISKIF32.EXE >> 'product_log
	'del 'target'\os2\DLL\UFAT32.DLL >> 'product_log
	'del 'target'\os2\help\fat32.txt >> 'product_log
	if stream(target'\os2\boot\danidasd.dmd', 'c', 'query exists') <> '' then 'del 'target'\os2\boot\danidasd.dmd >> 'product_log

return
