/* Postprocessing script, runs after the installation of the add-on products */
/* Last modified on 03.25.2001                                               */
/* 10.11.2001: added move CDrecord/2 folder                                  */
/* 05.18.2002: added move pmview & sysbar folders                            */
/* 05.25.2002: added support for uninstallation                              */
/* 06.11.2002: removed unused path variable                                  */

parse arg target source mode

/* get additional parameters from environment */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")

/* check if we are in uninstall mode */
if mode = 'UNINSTALL' then do
	call uninstall
	exit
end

/* add installer icons */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

/* Move icons from Desktop to different folders */
instpath = 'warpsrv'
if stream(source'\'instpath'\coninst.exe', 'c', 'query exists') = '' then instpath = 'grpware'
if stream(source'\'instpath'\coninst.exe', 'c', 'query exists') = '' then instpath = 'ibminst'
if instpath = 'ibminst' then target_folder = '<WP_APPSFOLDER>'
else target_folder = '<WP_OS2SYS>'

rc = SysMoveObject('<WARPIN_FOLDER>',    target_folder) 
'echo Moving Warp-In folder to Applications folder rc = 'rc' >> 'product_log
rc = SysMoveObject('<Sym_NAV>',          target_folder) 
'echo Moving NAV/2 folder to Applications folder rc = 'rc'   >> 'product_log
rc = SysMoveObject('<ACROBAT>',          target_folder) 
'echo Moving Acrobat folder to Applications folder rc = 'rc' >> 'product_log
rc = SysMoveObject('<FC2_FOLDER>',       target_folder) 
'echo Moving FC/2 folder to Applications folder rc = 'rc'    >> 'product_log
rc = SysMoveObject('<SCITECH_DESKTOP>',  target_folder) 
'echo Moving SDD folder to Applications folder rc = 'rc'     >> 'product_log
rc = SysMoveObject('<NS46_FOLDER>',      target_folder) 
'echo Moving NS folder to Applications folder rc = 'rc'      >> 'product_log
rc = SysMoveObject('<FI_JAVA_UNINSTALL>',target_folder) 
'echo Java uninst prg to Applications folder rc = 'rc'       >> 'product_log
rc = SysMoveObject('<INNOTEK_FLASH>',    target_folder) 
'echo Flash Player to Applications folder rc = 'rc'          >> 'product_log
rc = SysMoveObject('<WC_WEBEX_FOLD>',    target_folder) 
'echo Web Explorer to Applications folder rc = 'rc'          >> 'product_log
rc = SysMoveObject('<OS/2-Commander>',   target_folder) 
'echo OS/2 Commander to Applications folder rc = 'rc'        >> 'product_log
rc = SysMoveObject('<XFREE86OS2>',       target_folder) 
'echo XFree86 to Applications folder rc = 'rc'               >> 'product_log
rc = SysMoveObject('<XWP_MAINFLDR>',     target_folder) 
'echo XWP to Applications folder rc = 'rc'                   >> 'product_log
rc = SysMoveObject('<NBMSFLDR>',         target_folder) 
'echo Amouse to Applications folder rc = 'rc'                   >> 'product_log
rc = SysMoveObject('<CDREC2>',         target_folder) 
'echo CDRecord/2 to Applications folder rc = 'rc'               >> 'product_log
rc = SysMoveObject('<PMVIEW20FOLDER>',  target_folder) 
'echo PMView to Applications folder rc = 'rc'                   >> 'product_log
rc = SysMoveObject('<SYSBAR2FOLDER>',  target_folder) 
'echo SysBar to Applications folder rc = 'rc'                   >> 'product_log
rc = SysMoveObject('<PMM2FOLDER>',  target_folder) 
'echo Pmmail to Applications folder rc = 'rc'                   >> 'product_log
rc = SysMoveObject('<EM_emx_0.9d_FOLDER>', target_folder) 
'echo EMX to Applications folder rc = 'rc'                   >> 'product_log
rc = SysDestroyObject('<URL_GETNETSCAPE>') 
'echo Destroy get Netscape URL rc = 'rc'                     >> 'product_log

/* remove junk from config.sys */
/* load config.sys */
cfgfile = target'\config.sys'
i = 1
do while lines(cfgfile)
	l.i = linein(cfgfile)
	i = i+1
end
rc = lineout(cfgfile)
l.0 = i-1
/* update config.sys */
'copy 'cfgfile target'\os2\install\config.psp >> 'product_log
'del 'cfgfile' >> 'product_log
do i = 1 to l.0
	if pos('SET ADDONINS_', l.i) = 0 then rc = lineout(cfgfile, l.i)
end
rc = lineout(cfgfile)

exit

/* uninstall mode */
uninstall:

	nop;

return
