/* Installation of FC/2                         */
/* Add the FC/2 files to this directory         */
/* 08.12.2001: added removal of RO attribs      */
/* 05.19.2002: added support for uninstallation */

parse arg target source mode

/* get additional parameters from environment */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
product_drv       = value("PRODUCT_DRV"      , ,"OS2ENVIRONMENT")
product_path      = value("PRODUCT_PATH"     , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")

/* check if we are in uninstall mode */
if mode = 'UNINSTALL' then do
	call uninstall
	exit
end

if stream(inst_dir'\fc.exe', 'c', 'query exists') = '' then exit 9

/* copy files */
dest_dir = product_drv'\'product_path
'xcopy 'inst_dir'\* 'dest_dir'\. >> 'product_log
'del 'dest_dir'\addonins.cmd >> 'product_log

/* remove RO attributes */
call RxFuncAdd SysFileTree, RexxUtil, SysFileTree
call SysFileTree dest_dir'\*', 'tmp.', 'SO',,'**---'

/* create objects */
cdir = directory()
rc   = directory(dest_dir)
dest_dir'\setup.exe >> 'product_log
rc   = directory(cdir)

exit

/* uninstall mode */
uninstall:

	/* destroy objects */
	call RxFuncAdd 'SysDestroyObject', 'RexxUtil', 'SysDestroyObject'
	call SysDestroyObject "<FC2_FOLDER>"

	/* delete files */
	dest_dir = translate(product_drv'\'product_path)
	call RxFuncAdd SysFileTree, RexxUtil, SysFileTree
	call SysFileTree dest_dir'\*', 'tmp.', 'FO',,'**---'
	do q=1 to tmp.0
		/* !!! TODO: unlock first */
		'del 'tmp.q
	end
	'rmdir 'dest_dir

return
