/* Acrobat Reader 3.0 installation script                                  */
/* Unzip acro2?30.exe in this directory                                    */
/* 08.11.2001: added copy of NPPDFOS2.DLL to Netscape\Program\Plugins      */
/* 05.25.2002: added support for uninstallation                            */

parse arg target source mode

/* get additional parameters from environment */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
product_drv       = value("PRODUCT_DRV"      , ,"OS2ENVIRONMENT")
product_path      = value("PRODUCT_PATH"     , ,"OS2ENVIRONMENT")
product_rsp       = value("PRODUCT_RSP"      , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")
NS_DIR            = value("NS_DIR"           , ,"OS2ENVIRONMENT")

/* check if we are in uninstall mode */
if mode = 'UNINSTALL' then do
	call uninstall
	exit
end

/* exit if package does not exist */
if stream(inst_dir'\install.exe', 'c', 'query exists') = '' then exit 9

/* create response file */
dest_dir = product_drv'\'product_path
'@echo FILE='dest_dir'               >  'product_rsp
'@echo CFGUPDATE=MANUAL              >> 'product_rsp
'@echo OVERWRITE=YES                 >> 'product_rsp
'@echo SAVEBACKUP=NO                 >> 'product_rsp
'@echo DELETEBACKUP=YES              >> 'product_rsp

/* CID install */
inst_dir'\INSTALL /L1:'product_log' /L2:'product_log' /X /R:'product_rsp

/* copy NPPDFOS2.DLL to netscape directory */
ns_plugin_dir = NS_DIR||'\program\plugins\.'
'@copy 'dest_dir'\browser\nppdfos2.dll 'ns_plugin_dir

exit

/* uninstall mode */
uninstall:

	dest_dir = product_drv'\'product_path
	cdir = directory()
	call directory dest_dir
	'uninst.exe'
	call directory cdir
	call deldir dest_dir
	'@del 'NS_DIR'\program\plugins\nppdfos2.dll'

return

DelDir: procedure

	parse upper arg Directory
	DirSpec = Directory'\*'

	/* delete subdirectories */
	rc = SysFileTree(DirSpec, Subdirs, 'DO', '*****', '-*---')
	do i = 1 to Subdirs.0
   		call DelDir Subdirs.i
	end

	/* delete files */
	rc = SysFileTree(DirSpec, Files, 'FO', '*****', '-*---')
	do i = 1 to Files.0
		'@del "'Files.i'"'
	end

	/* delete directory */
	'@rmdir "'Directory'"'

return

