/* InnoTek Flash 5 installation, registration and icon creation             */
/* Install Flash 5 on a machine and place the following files here:         */
/* npswf2.dll, license.txt, readme.txt, flash5.exe and flashdel.cmd         */
/* Do not forget to register at http://www.innotek.de                       */
/* Please not: Flash 4 is not supported any more by this script             */
/* 02.15.2002: changed to work with Flash 5                                 */
/* 05.24.2002: added support for uninstallation                             */
/* 06.08.2002: fixed hang when plugins dir were missing                     */

parse arg target source mode

/* get additional parameters from environment */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")
NS_DIR            = value("NS_DIR"           , ,"OS2ENVIRONMENT")

/* check if we are in uninstall mode */
if mode = 'UNINSTALL' then do
	call uninstall
	exit
end

/* exit if package does not exist */
if stream(inst_dir'\npswf2.dll', 'c', 'query exists') = '' then exit 9

/* Register with REXX API extensions. */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

/* copy files */
'xcopy 'inst_dir'\* 'NS_DIR'\Program\PlugIns\. /s/e >> 'product_log
if stream(ns_dir'\program\plugins\addonins.cmd', 'c', 'query exists') <> '' then
	'del 'ns_dir'\program\plugins\addonins.cmd >> 'product_log

/* create objects */
CreateCollision = 'Replace' 
rc = CreateObject( 'WPFolder',,
    'Macromedia Flash Player for OS/2^by www.innotek.de',,
    '<WP_DESKTOP>',,
    'NOTDEFAULTICON=YES;'||,
    'NOPRINT=YES;'||,
    'DEFAULTVIEW=CONTENTS;'||,
    'SELFCLOSE=1;'||,
    'ICONFONT=9.WarpSans;'||,
    'DETAILSFONT=9.WarpSans;'||,
    'TREEFONT=9.WarpSans;'||,
    'ICONVIEW=FLOWED,NORMAL;'||,
    'DETAILSVIEW=MINI;'||,
    'TREEVIEW=LINES,MINI;'||,
    'ALWAYSSORT=YES;'||,
    'OBJECTID=<INNOTEK_FLASH>',,
    CreateCollision )

rc = CreateObject( 'WPShadow',,
    'readme.txt',,
    '<INNOTEK_FLASH>',,
    'SHADOWID='NS_DIR'\PROGRAM\PLUGINS\readme.txt;'||,
    'OBJECTID=<INNOTEK_FLASH_README>',,
    CreateCollision )

rc = CreateObject( 'WPShadow',,
    'license.txt',,
    '<INNOTEK_FLASH>',,
    'SHADOWID='NS_DIR'\PROGRAM\PLUGINS\license.txt;'||,
    'OBJECTID=<INNOTEK_FLASH_LICENSE>',,
    CreateCollision )

rc = CreateObject( 'WPProgram',,
    'Macromedia Flash 5 Player',,
    '<INNOTEK_FLASH>',,
    'EXENAME='NS_DIR'\PROGRAM\PLUGINS\flash5.exe;'||,
		'STARTUPDIR='NS_DIR'\PROGRAM\PLUGINS;'||,
    'OBJECTID=<INNOTEK_FLASH_PLAYER>',,
    CreateCollision )

rc = CreateObject( 'WPProgram',,
    'Uninstall Flash 5 Player',,
    '<INNOTEK_FLASH>',,
    'EXENAME=CMD.EXE;'||,
		'PARAMETERS=/C start /f 'NS_DIR'\PROGRAM\PLUGINS\flashdel.cmd;'||,
		'STARTUPDIR='NS_DIR'\PROGRAM\PLUGINS;'||,
    'OBJECTID=<INNOTEK_FLASH_UNINSTALL>',,
    CreateCollision )

rc = CreateObject( 'WPUrl',,
    'OS2.org helpdesk',,
    '<INNOTEK_FLASH>',,
    'NOTDEFAULTICON=YES;'||,
    'DEFAULTVIEW=CONTENTS;'||,
    'URL=http://en.OS2.org/forum/helpdesk/;'||,
    'OBJECTID=<INNOTEK_FLASH_OS2ORGHELPDESK>',,
    CreateCollision )

rc = CreateObject( 'WPUrl',,
    'InnoTek Flash Support Forum',,
    '<INNOTEK_FLASH>',,
    'NOTDEFAULTICON=YES;'||,
    'DEFAULTVIEW=CONTENTS;'||,
    'URL=http://www.innotek.de/support/forums;'||,
    'OBJECTID=<INNOTEK_FLASH_WEB>',,
    CreateCollision )

rc = CreateObject( 'WPFolder',,
    'Flash Sample Pages',,
    '<INNOTEK_FLASH>',,
    'NOTDEFAULTICON=YES;'||,
    'NOPRINT=YES;'||,
    'DEFAULTVIEW=CONTENTS;'||,
    'SELFCLOSE=1;'||,
    'ICONFONT=9.WarpSans;'||,
    'DETAILSFONT=9.WarpSans;'||,
    'TREEFONT=9.WarpSans;'||,
    'ICONVIEW=FLOWED,NORMAL;'||,
    'DETAILSVIEW=MINI;'||,
    'TREEVIEW=LINES,MINI;'||,
    'ALWAYSSORT=YES;'||,
    'OBJECTID=<INNOTEK_FLASH_SAMPLES>',,
    CreateCollision )

rc = CreateObject( 'WPUrl',,
    'Any Given Sunday',,
    '<INNOTEK_FLASH_SAMPLES>',,
    'NOTDEFAULTICON=YES;'||,
    'DEFAULTVIEW=CONTENTS;'||,
    'URL=http://www.anygivensunday.net;'||,
    'OBJECTID=<INNOTEK_FLASH_SAMPLE_ANYGIVENSUNDAY>',,
    CreateCollision )

rc = CreateObject( 'WPUrl',,
    'Balthaser Studios',,
    '<INNOTEK_FLASH_SAMPLES>',,
    'NOTDEFAULTICON=YES;'||,
    'DEFAULTVIEW=CONTENTS;'||,
    'URL=http://www.balthaser.com;'||,
    'OBJECTID=<INNOTEK_FLASH_SAMPLE_BALTHASER>',,
    CreateCollision )

rc = CreateObject( 'WPUrl',,
    'EYE4U active media',,
    '<INNOTEK_FLASH_SAMPLES>',,
    'NOTDEFAULTICON=YES;'||,
    'DEFAULTVIEW=CONTENTS;'||,
    'URL=http://www.eye4u.com;'||,
    'OBJECTID=<INNOTEK_FLASH_SAMPLE_EYE4U>',,
    CreateCollision )

rc = CreateObject( 'WPUrl',,
    'KIMBLE Special Agent',,
    '<INNOTEK_FLASH_SAMPLES>',,
    'NOTDEFAULTICON=YES;'||,
    'DEFAULTVIEW=CONTENTS;'||,
    'URL=http://www.kimble.org/kimmovie/kimble_themovie.swf;'||,
    'OBJECTID=<INNOTEK_FLASH_SAMPLE_KIMBLE>',,
    CreateCollision )

rc = CreateObject( 'WPUrl',,
    'Lionhead Studios',,
    '<INNOTEK_FLASH_SAMPLES>',,
    'NOTDEFAULTICON=YES;'||,
    'DEFAULTVIEW=CONTENTS;'||,
    'URL=http://www.lionhead.co.uk;'||,
    'OBJECTID=<INNOTEK_FLASH_SAMPLE_LIONHEAD>',,
    CreateCollision )

rc = CreateObject( 'WPUrl',,
    'Macromedia',,
    '<INNOTEK_FLASH_SAMPLES>',,
    'NOTDEFAULTICON=YES;'||,
    'DEFAULTVIEW=CONTENTS;'||,
    'URL=http://www.macromedia.com;'||,
    'OBJECTID=<INNOTEK_FLASH_SAMPLE_MACROMEDIA>',,
    CreateCollision )

rc = CreateObject( 'WPUrl',,
    'The Void',,
    '<INNOTEK_FLASH_SAMPLES>',,
    'NOTDEFAULTICON=YES;'||,
    'DEFAULTVIEW=CONTENTS;'||,
    'URL=http://www.thevoid.co.uk;'||,
    'OBJECTID=<INNOTEK_FLASH_SAMPLE_THEVOID>',,
    CreateCollision )

rc = CreateObject( 'WPUrl',,
    'TimeTicker',,
    '<INNOTEK_FLASH_SAMPLES>',,
    'NOTDEFAULTICON=YES;'||,
    'DEFAULTVIEW=CONTENTS;'||,
    'URL=http://www.timeticker.com;'||,
    'OBJECTID=<INNOTEK_FLASH_SAMPLE_TIMETICKER>',,
    CreateCollision )

rc = CreateObject( 'WPUrl',,
    'Varazdin 2000',,
    '<INNOTEK_FLASH_SAMPLES>',,
    'NOTDEFAULTICON=YES;'||,
    'DEFAULTVIEW=CONTENTS;'||,
    'URL=http://www.2000.varazdin.com;'||,
    'OBJECTID=<INNOTEK_FLASH_SAMPLE_VARAZDIN2000>',,
    CreateCollision )

/* change ini */
rcode = ''
rc = SysIni( 'USER', 'InnoTek_Flash', 'Workaround15Bit', d2c(0) )
if rc <> '' then rcode = rc
rc = SysIni( 'USER', 'InnoTek_Flash', 'Quality', d2c(0) )
if rc <> '' then rcode = rc
rc = SysIni( 'USER', 'InnoTek_Flash', 'OverrideQuality', d2c(0) )
if rc <> '' then rcode = rc
rc = SysIni( 'USER', 'InnoTek_Flash', 'SoundEnabled', d2c(1) )
if rc <> '' then rcode = rc
rc = SysIni( 'USER', 'InnoTek_Flash', 'Volume', d2c(100) )
if rc <> '' then rcode = rc
rc = SysIni( 'USER', 'InnoTek_Flash', 'SoundDevice', d2c(0) )
if rc <> '' then rcode = rc

if rcode = '' then
  'echo InnoTek Flash has been added to the OS2.INI. >> 'product_log
else
  'echo InnoTek Flash has not been added to the OS2.INI. >> 'product_log

exit

/* create object */
CreateObject: procedure expose product_log
    Parse Arg Class, Title, Location, Setup, Collision
    'echo Registering Object ['Title'] >> 'product_log
    rc = SysCreateObject( Class, Title, Location, Setup, Collision )
    If rc <> 1 Then
        'echo Registering Object ['Title' ^| 'Class'] in ['Location'] did not work >> 'product_log
return rc

/* uninstall mode */
uninstall:

	/* destroy objects */
	call RxFuncAdd 'SysDestroyObject', 'RexxUtil', 'SysDestroyObject'
	call SysDestroyObject "<INNOTEK_FLASH>"

	/* delete from ini */
	call RxFuncAdd 'SysIni', 'RexxUtil', 'SysIni'
	rc = SysIni('USER', 'InnoTek_Flash', 'DELETE:')

	/* del files */
	'call 'source'\updcd\bin\unlock.exe 'NS_DIR'\Program\PlugIns\npswf2.dll'
	'call 'source'\updcd\bin\unlock.exe 'NS_DIR'\Program\PlugIns\flash5.exe'
	'del 'NS_DIR'\Program\PlugIns\npswf2.dll'
	'del 'NS_DIR'\Program\PlugIns\flash5.exe'
	'del 'NS_DIR'\Program\PlugIns\readme.txt'
	'del 'NS_DIR'\Program\PlugIns\license.txt'

return
