/* ODIN installation file                                          */
/* Place the ODIN package here under the name odin.wpi or odin.zip */
/* 01.11.2002: made variables local                                */
/* 02.16.2002: added support for zip distribution                  */
/* 05.25.2002: added support for uninstallation                    */

parse arg target source mode

/* get additional parameters from environment */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")
product_drv       = value("PRODUCT_DRV"      , ,"OS2ENVIRONMENT")
product_path      = value("PRODUCT_PATH"     , ,"OS2ENVIRONMENT")

/* check if we are in uninstall mode */
if mode = 'UNINSTALL' then do
	call uninstall
	exit
end

/* do nothing if package does not exist */
if stream(inst_dir'\odin.wpi', 'c', 'query exists') <> '' then 
	call install_wpi
else if stream(inst_dir'\odin.zip', 'c', 'query exists') <> '' then 
	call install_zip

exit

/* install wpi distribution */
install_wpi: 

	/* set installation environment */
	call setlocal
	rc = value("WARPIN_DISPLAYPAGES"     , "NO"       , "OS2ENVIRONMENT")
	rc = value("WARPIN_INSTALLACTION"    , "ADDREMOVE", "OS2ENVIRONMENT")
	rc = value("WARPIN_SELECTPACKAGE1"   , "INSTALL"  , "OS2ENVIRONMENT")
	rc = value("WARPIN_TARGETPATH1"      , product_drv"\"product_path,  "OS2ENVIRONMENT")
	rc = value("WARPIN_SELECTPACKAGE2"   , "INSTALL"  , "OS2ENVIRONMENT")
	rc = value("WARPIN_TARGETPATH2"      , product_drv"\"product_path"\SYSTEM32", "OS2ENVIRONMENT")
	rc = value("WARPIN_SELECTPACKAGE3"   , "IGNORE"   , "OS2ENVIRONMENT")
	rc = value("WARPIN_TARGETPATH3"      , product_drv"\"product_path"\SYSTEM32", "OS2ENVIRONMENT")
	rc = value("WARPIN_SELECTPACKAGE4"   , "IGNORE"   , "OS2ENVIRONMENT")
	rc = value("WARPIN_TARGETPATH4"      , product_drv"\"product_path"\SYSTEM32", "OS2ENVIRONMENT")
	rc = value("WARPIN_SELECTPACKAGE5"   , "IGNORE"   , "OS2ENVIRONMENT")
	rc = value("WARPIN_TARGETPATH5"      , product_drv"\"product_path"\SYSTEM32", "OS2ENVIRONMENT")
	rc = value("WARPIN_UPDATECONFIGSYS"  , "YES"      , "OS2ENVIRONMENT")
	rc = value("WARPIN_INSTALLWPSCLASSES", "NO"       , "OS2ENVIRONMENT")
	rc = value("WARPIN_CREATEWPSOBJECTS" , "NO"       , "OS2ENVIRONMENT")
	rc = value("WARPIN_IFSAMEDATE"       , "OVERWRITE", "OS2ENVIRONMENT")
	rc = value("WARPIN_IFEXISTINGOLDER"  , "OVERWRITE", "OS2ENVIRONMENT")
	rc = value("WARPIN_IFEXISTINGNEWER"  , "OVERWRITE", "OS2ENVIRONMENT")

	/* run warpin */
	cdir = directory()
	rc   = directory(get_ini_key(warpin path))
	'WarpIN.Exe 'inst_dir'\odin.wpi'
	rc = directory(cdir)
	call endlocal

	/* make uninstall flag */
	'@echo WPI BASE - DO NOT DELETE! > 'product_drv'\'product_path'\odininst.txt'

return

/* install zip distribution */
install_zip:

	'unzip -o 'inst_dir'\odin.zip -d 'product_drv'\'product_path' >> 'product_log' 2>>&1'
	cdir = directory()
	call directory product_drv'\'product_path'\system32'
	'odininst.exe >> 'product_log
	call directory cdir

	/* make uninstall flag */
	'@echo ZIP BASE - DO NOT DELETE! > 'product_drv'\'product_path'\odininst.txt'

return

/* get apps key value from OS2.INI */
get_ini_key: procedure

	parse upper arg apps key

	call rxfuncadd sysini, rexxutil, sysini
	call SysIni 'USER', 'All:', 'Apps.'
	do i = 1 to Apps.0	
		if translate(apps.i) = apps then do
			call SysIni 'USER', Apps.i, 'All:', 'Keys'
 	   	do j=1 to Keys.0
 	   		if translate(Keys.j) = key then do
					val = SysIni('USER', Apps.i, Keys.j)
					return val
				end
    	end
  	end
	end

return ''

uninstall:

	/* check */
	l = linein(product_drv'\'product_path'\odininst.txt')

	if l = 'WPI BASE - DO NOT DELETE!' then do
		/* run warpin to uninstall */
		cdir = directory()
		rc   = directory(get_ini_key(warpin path))
		'WarpIN.Exe'
		rc = directory(cdir)
		call deldir product_drv'\'product_path
	end
	else do
		call deldir product_drv'\'product_path
		/* todo: change config path? */
	end

return

DelDir: procedure

	parse upper arg Directory
	DirSpec = Directory'\*'

	/* delete subdirectories */
	rc = SysFileTree(DirSpec, Subdirs, 'DO', '*****', '-*---')
	do i = 1 to Subdirs.0
   		call DelDir Subdirs.i
	end

	/* delete files */
	rc = SysFileTree(DirSpec, Files, 'FO', '*****', '-*---')
	do i = 1 to Files.0
		'@del "'Files.i'"'
	end

	/* delete directory */
	'@rmdir "'Directory'"'

return

