/* rexx program to tune the os2.ini and os2sys.ini during phase2 */
/* created: 06.18.2002                                           */

parse arg target instdir

/* log file */
logFile = target||"\"instdir"\tuneini.log"
'@echo Starting tuneini.cmd 'date() time()' > 'logFile

/* ini files */
os2file = target'\os2\os2.ini'
sysfile = target'\os2\os2sys.ini'

/* macro file */
macroFile = target'\'instdir'\tuneini.cfg'

do while lines(macroFile)
	l = linein(macroFile)
	if substr(l, 1, 1) = ';' then iterate
	parse var l ini apps key value
	if ini <> 'USER' & ini <> 'SYSTEM' then iterate
	if ini = 'USER'   then call sysini os2file, apps, key, value
	if ini = 'SYSTEM' then call sysini sysfile, apps, key, value
end
call lineout macroFile

exit


