// Virtual Pascal, tam@gmx.de 16.09.2001
uses Os2Base,SysUtils;

var State : Boolean;
    DevHandle : LongInt;

Procedure OpenAPM;
var rc,ulAction : LongInt;
begin
  rc := DosOpen('APM$',DevHandle,ulAction,0,FILE_NORMAL,FILE_OPEN,
                 OPEN_ACCESS_READWRITE or OPEN_SHARE_DENYNONE,NIL);
  if rc <> NO_ERROR then begin
    WriteLn('DosOpen() APM$: ',SysErrorMessage(rc));
    if rc = 110 then
      WriteLn('APM.SYS must be installed.');
    Halt;
  end;
end;

Procedure CloseAPM;
var rc : LongInt;
begin
  rc := DosClose(DevHandle);
  if rc <> NO_ERROR then begin
    WriteLn('DosClose() APM$: ',SysErrorMessage(rc));
    Halt;
  end;
end;

Procedure SetAPM;
var PLen,DLen,rc : LongInt;
    Params : Array[1..2] of LongInt;
    Data : Word;
begin
  if State then
    Params[1] := 3  // enable APM
  else
    Params[1] := 4; // disable APM
  Params[2] := 0;
  OpenAPM;
  PLen := SizeOf(Params);
  DLen := SizeOf(Data);
  rc := DosDevIOCtl(DevHandle, IOCTL_POWER,POWER_SENDPOWEREVENT,
                    @Params, PLen, @PLen,@Data, DLen, @DLen);
  if rc <> NO_ERROR then begin
    WriteLn('DosDevIOCtl(): ',SysErrorMessage(rc));
    Halt;
  end;
  WriteLn('APM enabled: ',state);
  CloseAPM;
end;

Procedure GetParameter;
begin
  WriteLn('ApmSwitch, 16.09.2001, tam@gmx.de');
  if ParamCount <> 1 then begin
    WriteLn('usage: ApmSwitch 1 -> turn APM on');
    WriteLn('       ApmSwitch 0 (or any other value) -> turn APM off');
    Halt;
  end;
  State := ParamStr(1) = '1';
end;

begin
  GetParameter;
  SetAPM;
end.

