/* Installation script for WFT.                    */
/* Author: Peter Moylan, peter@ee.newcastle.edu.au */

CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
CALL SysLoadFuncs

srcdir = directory()
SAY 'Installation of Web Family Tree'
SAY 'Directory where the program should be installed?'
SAY '  (Leave this blank to use the current directory)'
PULL wftdir
wftdir = STRIP(wftdir, 'Trailing', '\')
wftdir = STRIP(wftdir, 'Trailing', '/')

IF wftdir = '' THEN wftdir = srcdir
SAY 'Installing to 'wftdir
IF wftdir \= srcdir THEN DO
    IF SysMkDir(wftdir) = 0 THEN
        SAY 'Created directory 'wftdir
    'copy wft.exe' wftdir
    'copy sampleheader' wftdir
    'copy samplefooter' wftdir
    'copy GedSort.exe' wftdir
    'copy Lint.exe' wftdir
    'copy wft.inf' wftdir
END
datadir = wftdir||'\data'
IF SysMkDir(datadir) = 0 THEN
    SAY 'Created directory 'datadir

SAY ''
SAY 'For this next step, you need to specify the directory that your'
SAY 'web server uses for holding CGI scripts.  It usually has a name'
SAY 'like cgi-bin.  If that directory does not yet exist, type CTRL/C'
SAY 'now, and re-run this installation script after setting up the'
SAY 'web server.'

SAY ''
SAY 'Directory where the CGI scripts live?'
PULL cgidir
DO WHILE cgidir = ''
    SAY 'You must specify a directory name.'
    PULL cgidir
END

CALL MakeCommandFile wftdir, cgidir

/* Create the 'remove' script. */

outfile = wftdir||'\Remove.cmd'
IF stream(outfile, 'C', 'query exists') \= '' THEN
    '@del 'outfile
CALL stream outfile, 'C', 'open write'

CALL LineOut outfile, '/* Run this script to uninstall WFT */'
CALL LineOut outfile, ''
CALL LineOut outfile, '"del '||cgidir||'\wft.cmd"'
CALL LineOut outfile, 'ourdir = directory()'
CALL LineOut outfile, 'CALL directory "'wftdir||'"'
CALL LineOut outfile, '"del wft.exe"'
CALL LineOut outfile, '"del wft.inf"'
CALL LineOut outfile, '"del sampleheader"'
CALL LineOut outfile, '"del samplefooter"'
CALL LineOut outfile, '"del gedsort.exe"'
CALL LineOut outfile, '"del lint.exe"'
CALL LineOut outfile, '"del README"'
CALL LineOut outfile, '"del links.doc"'
CALL LineOut outfile, '"del Remove.cmd"'
CALL LineOut outfile, 'CALL directory ourdir'
CALL stream outfile, 'C', 'close'

SAY ''
SAY 'A script Remove.cmd has been created in the installation directory,'
SAY 'and you can run this to uninstall WFT.  Note, however, that it will'
SAY 'not delete your data directory, since that probably contains files'
SAY 'you want to keep.'

EXIT

MakeCommandFile: PROCEDURE
    parse arg wftdir, cgidir
    infile = 'WFT.0'
    outfile = cgidir||'\wft.cmd'
    IF stream(outfile, 'C', 'query exists') \= '' THEN
        '@del 'outfile
    CALL stream infile, 'C', 'open read'
    CALL stream outfile, 'C', 'open write'
    DO WHILE LINES(infile) > 0
        rec = LINEIN(infile)
        IF POS('?', rec) = 0 THEN DO
                CALL LINEOUT outfile, rec
            END
        ELSE DO
                parse var rec part1'?'part2
                CALL LINEOUT outfile, part1||wftdir||part2
            END
    END
    CALL stream infile, 'C', 'close'
    CALL stream outfile, 'C', 'close'
    RETURN

