/*-------------------------------------------------------------------*/
/* RWSUTIL08.CMD                                                     */
/* REXX script to register/ deregister the "RWSxx" WPS class         */
/*                                                                   */
/* Remote Workplace Server                                           */
/* (C)Copyright 2004, 2005  R.L.Walsh - all rights reserved          */
/*                                                                   */
/*-------------------------------------------------------------------*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

say ''
say 'RwsUtil registers and/or deregisters the RWSxx WPS class'
say 'used by Remote Workplace Server.  Would you like to:'
say ''
say '   1 - deregister all versions of the RWSxx class'
say '   2 - register RWS08 (the current version)'
say '   3 - both 1 & 2'
say '   X - exit without any changes'
say ''

do FOREVER
    call charout ,'Enter 1, 2, 3, or X:  '
    pull answer

    if answer = '1' then
      do
        call Dereg
        leave
      end
    else
    if answer = '2' then
      do
        call Reg
        leave
      end
    else
    if answer = '3' then
      do
        call Dereg
        call Reg
        leave
      end
    else
    if answer = 'X' then
        leave
end
exit

/*-------------------------------------------------------------------*/

Dereg : procedure

    /* deregister all possible classes,               */
    /* regardless of whether they're actually present */

    Call SysDeregisterObjectClass("RWS")        /* v0.50 */
    Call SysDeregisterObjectClass("RWS06")      /* v0.60 */
    Call SysDeregisterObjectClass("RWS07")      /* v0.70 */
    Call SysDeregisterObjectClass("RWS08")      /* v0.80 */
    return

/*-------------------------------------------------------------------*/

Reg : procedure

    say ''
    Call SysDeregisterObjectClass 'RWS08'
    rc = 0

    /* look for the dll in the current directory */
    newpath = Stream('rwssrv08.dll', 'c', 'query exists')
    if newpath <> '' then
        rc = SysRegisterObjectClass('RWS08',newpath)

    /* if that failed, look on the LIBPATH */
    if rc = 0 then
        rc = SysRegisterObjectClass('RWS08',rwssrv08)

    /* if registration failed, the class list  */
    /* contains an invalid entry, so remove it */
    if rc = 0 then
      do
        Call SysDeregisterObjectClass 'RWS08'
        say 'Unable to register class RWS08 because rwssrv08.dll'
        say 'could not be found in the current directory or LIBPATH.'
      end

    /* if registration succeeded, create & destroy an RWS08   */
    /* object to cause the class to be unloaded, then display */
    /* the fully-qualified name of the dll that was used      */
    else
      do
        call SysQueryClassList "list."
        do ndx = list.0 to 1 by -1
            parse var list.ndx class newpath
            if class = 'RWS08' then
                leave
        end

        if SysCreateObject("RWS08","RWSUtilObject","<WP_NOWHERE>","OBJECTID=<RWSUtilObject>", "r") then
          do
            call SysSleep 1
            call SysDestroyObject "<RWSUtilObject>"
          end

        say 'Successfully registered class RWS08 using' newpath
      end

    /* give the user a chance to read the message */
    say ''
    say 'press Enter to continue...'
    pull
    return

/*-------------------------------------------------------------------*/

