/*-------------------------------------------------------------------*/
/* RWSUTIL07.CMD                                                     */
/* REXX script to register/ deregister the "RWSxx" WPS class         */
/*                                                                   */
/* Remote Workplace Server                                           */
/* (C)Copyright 2004, 2005  R.L.Walsh - all rights reserved          */
/*                                                                   */
/*-------------------------------------------------------------------*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

say ''
say 'RwsUtil registers and/or deregisters the RWSxx WPS class'
say 'used by Remote Workplace Server.  Would you like to:'
say ''
say '   1 - deregister all versions of the RWSxx class'
say '   2 - register RWS07 (the current version)'
say '   3 - both 1 & 2'
say '   X - exit without any changes'
say ''

do FOREVER
    call charout ,'Enter 1, 2, 3, or X:  '
    pull answer

    if answer = '1' then
      do
        call Dereg
        leave
      end
    else
    if answer = '2' then
      do
        call Reg
        leave
      end
    else
    if answer = '3' then
      do
        call Dereg
        call Reg
        leave
      end
    else
    if answer = 'X' then
        leave
end
exit

/*-------------------------------------------------------------------*/

Dereg : procedure

    /* deregister all possible classes,               */
    /* regardless of whether they're actually present */

    Call SysDeregisterObjectClass("RWS")        /* v0.50 */
    Call SysDeregisterObjectClass("RWS06")      /* v0.60 */
    Call SysDeregisterObjectClass("RWS07")      /* v0.70 */
    return

/*-------------------------------------------------------------------*/

Reg : procedure

    say ''
    Call SysDeregisterObjectClass 'RWS07'
    rc = 0

    /* look for the dll in the current directory */
    newpath = Stream('rwssrv07.dll', 'c', 'query exists')
    if newpath <> '' then
        rc = SysRegisterObjectClass('RWS07',newpath)

    /* if that failed, look on the LIBPATH */
    if rc = 0 then
        rc = SysRegisterObjectClass('RWS07',rwssrv07)

    /* if registration failed, the class list  */
    /* contains an invalid entry, so remove it */
    if rc = 0 then
      do
        Call SysDeregisterObjectClass 'RWS07'
        say 'Unable to register class RWS07 because rwssrv07.dll'
        say 'could not be found in the current directory or LIBPATH.'
      end

    /* if registration succeeded, display the        */
    /* fully-qualified name of the dll that was used */
    else
      do
        call SysQueryClassList "list."
        do ndx = list.0 to 1 by -1
            parse var list.ndx class newpath
            if class = 'RWS07' then
                leave
        end
        say 'Successfully registered class RWS07 using' newpath
      end

    /* give the user a chance to read the message */
    say ''
    say 'press Enter to continue...'
    pull
    return

/*-------------------------------------------------------------------*/

