/****************************************************************/
/*        Adds a new member to a Major Major mailing list       */
/*                                                              */
/*      Author:       Peter Moylan (peter@ee.newcastle.edu.au)  */
/*      Started:      6 May 2001                                */
/*      Last revised: 6 May 2001                                */
/*                                                              */
/*  Usage:                                                      */
/*         subscribe listname emailaddress                      */
/*                                                              */
/*  Installation:                                               */
/*         Put this file in the directory containing MAJOR.INI  */
/*                                                              */
/****************************************************************/

CALL RxFuncAdd SysLoadFuncs, rexxutil, sysloadfuncs
CALL SysLoadFuncs

PARSE ARG listname newmember
IF (listname = '') | (newmember = '') THEN
    DO
        SAY "Usage: subscribe listname newmember"
        EXIT 0
    END

/* Switch our working directory to the program directory */

PARSE SOURCE rubbish rubbish SrcDir
j = LASTPOS('\', SrcDir)
IF j > 0 THEN SrcDir = LEFT(SrcDir, j-1)
WrkDir = DIRECTORY()
CALL DIRECTORY SrcDir

/* Check that the list exists. */

IF SysIni( 'MAJOR.INI', listname, 'ALL:', 'dummy.' ) = 'ERROR:' THEN
    DO
         SAY 'List 'listname' does not exist'
         EXIT
    END

/* Fetch the list of current members. */

names = SysIni( 'MAJOR.INI', listname, 'names' )
IF names = 'ERROR:' THEN names = '0'X

/* Add the new member.  We don't bother sorting the list,         */
/* because this will be done the next time that Admin.exe is run. */
/* (And, anyway, it's not vital that the list be sorted.)         */

CALL SysINI 'MAJOR.INI', listname, 'names', newmember||'0'X||names
SAY 'New member 'newmember' added'
CALL DIRECTORY WrkDir
EXIT 0
