/****************************************************************/
/*        Lists all members of a Major Major mailing list       */
/*                                                              */
/*      Author:       Peter Moylan (peter@ee.newcastle.edu.au)  */
/*      Started:      3 May 2001                                */
/*      Last revised: 3 May 2001                                */
/*                                                              */
/*  Usage:                                                      */
/*         listmembers listname                                 */
/*                                                              */
/*  Installation:                                               */
/*         Put this file in the directory containing MAJOR.INI  */
/*                                                              */
/****************************************************************/

CALL RxFuncAdd SysLoadFuncs, rexxutil, sysloadfuncs
CALL SysLoadFuncs

PARSE ARG listname
IF listname = '' THEN
    DO
        SAY "Usage: listmembers listname"
        EXIT 0
    END

/* Switch our working directory to the program directory */

PARSE SOURCE rubbish rubbish SrcDir
j = LASTPOS('\', SrcDir)
IF j > 0 THEN SrcDir = LEFT(SrcDir, j-1)
WrkDir = DIRECTORY()
CALL DIRECTORY SrcDir

/* Fetch the list of list members. */

names = SysIni( 'MAJOR.INI', listname, 'names' )
IF names = 'ERROR:' then
    DO
         SAY 'List 'listname' does not exist, or has no members'
         EXIT
    END

/* Strip out the individual names and write them. */

SAY 'Members of list 'listname
SAY '===================='

DO WHILE (names \= '') & (names \= '0'X)
     PARSE VALUE names WITH name1 '0'X names
     SAY '    'name1
END /* DO */

CALL DIRECTORY WrkDir
EXIT 0
