:userdoc.
:title.Major Major documentation
:docprof toc=123.

.***********************************
.*   INTRODUCTION
.***********************************

:h1.Introduction

:p.
Major Major is a mailing list manager.  It allows you to set up
one or more mailing lists, and it allows people to subscribe to those
lists.  When mail comes in for the list, Major Major sends a copy
to everyone on the list.
:p.
It is distributed as :link reftype=hd refid=register.optional shareware:elink..
:p.This documentation is for version 1.5.

:p.
:hp2.Disclaimer of Warranty:ehp2.

:sl compact.
:li.
:hp1.
This Product is provided "as-is", without warranty of any
kind, either expressed or implied, including, but not limited to,
the implied warranties of merchantability and fitness for a
particular purpose.  The entire risk as to the quality and
performance of the Product is with you.  Should the Product prove
defective, the full cost of repair, servicing, or correction lies
with you.
:ehp1.
:esl.

:p.
The author of Major Major is Peter Moylan, peter@ee.newcastle.edu.au.

:p.
The latest version of Major Major is normally kept at ftp&colon.&slash.&slash.eepjm.newcastle.edu.au/software.
Information about other software on this site may be found at
http&colon.&slash.&slash.eepjm.newcastle.edu.au/os2.

:p.
:hp2.Getting information about new versions:ehp2.

:p.
You can, if you wish, join a mailing list for announcements about
new releases of my software.  There are two lists: software-announce,
which is purely for such announcements, and majormajor-list, which is a
general forum for discussions and questions about Major Major.  To join
one or both of these, send an
e-mail to majormajor@eepjm.newcastle.edu.au.  The subject line is not
important and may be anything.  In the body of the message, put the
lines
:xmp.       subscribe software-announce
       subscribe majormajor-list
       end
:exmp.

:p.(To join only one of the two lists, use only one "subscribe"
command.)  To have yourself removed from a list, send a similar e-mail but
using the command "unsubscribe" instead of "subscribe".

.***********************************
.*   REGISTRATION
.***********************************

:h1 id=register.Registration

:hp2.Registration:ehp2.

:p.This software is "optional shareware".  What this means is that you
decide whether you want to register as a paid owner of the software.
The software is not crippled in any way, and I will continue to provide
support and free releases of new versions to all users, whether or
not they are registered, for at least the short-term future.

:p.If you decide that this software is worth supporting, you have the
following payment options.
:p.
:hp2.Payment through BMT Micro:ehp2.

:p.This is likely to be the most convenient method for most people,
because BMT Micro has a number of different payment methods, including
credit cards.  It also has agents in several countries.  For full
details, see the file register.bmt included in the Major Major distribution.
The price is $20 (US dollars).

:p.
:hp2.From Europe:ehp2.

:p.This works best for people living in the European Union.  (Warning:
check first whether your bank is going to charge you transfer fees.)
You have two options:
:ul.
:li.Transfer 20, or the equivalent in Belgian francs, to the following bank account
:sl.
:li.Marion Gevers
.br
Account number 220-0586389-60
.br
G&ea.n&ea.rale de Banque (Belgium)
.br
Mention: Major Major
:esl.
:p.and send an e-mail to peter@ee.newcastle.edu.au to confirm that you've done it.

:li.Send a Eurocheque for 20, or the equivalent in Belgian francs, to
:sl.
:li.Marion Gevers
.br
91 Harriet Street
.br
Waratah, NSW 2298
.br
Australia
:esl.
:eul.

:p.
:hp2.Payment directly to me in Australia:ehp2.

:p.This is a more attractive option for people in Australia.  From
other countries, it's not a good idea because of the bank charges on
international transfers.  (Please don't send non-Australian currency
to an Australian bank, because then I get hit with exorbitant bank fees.)
You can do it in either of two ways.

:ul.
:li.Send a cheque, or equivalent, for $25 (Australian dollars) to
:sl.
:li.Peter Moylan
.br
91 Harriet Street
.br
Waratah, NSW 2298
.br
Australia
:esl.

:li.Transfer the amount of $25 (Australian dollars) to the following bank
account.
:sl.
:li.Marion Gevers
.br
Account number (06 2831) 00626468
.br
Commonwealth Bank
.br
University of Newcastle, Australia
:esl.
:eul.

.***********************************
.*   HOW IT WORKS
.***********************************

:h1.How it works

:hp2.What is a mailing list?:ehp2.

:p.
A mailing list is similar to a newsgroup, except that it uses e-mail
rather than Usenet to transport the messages.  People join the list
by mailing a "subscribe" command to the mailing list manager.  If
they later want to leave the list, they send in an "unsubscribe"
command.
:p.
The name of the list is an e-mail address.  That is, it has the form
"listname@domain", where "domain" is the mail domain for the mail
server that receives mail for the list.  You send a message to the
list by mailing it to that address.  When it is received, the list
manager sees it and sends copies to everyone who is subscribed to
the list.  In other words, when you send an e-mail to the list you
are actually sending it to multiple people.

:p.:hp2.Major Major and its interaction with the mail server:ehp2.

:p.
A mail server consists of two parts.  (These might be two separate
pieces of software, or they might be integrated in a single package.)
One part is the SMTP software, which is the software that looks after
transferring mail between the source and destination machines.  The
other part is the "Post Office" server, through which users pick up
their mail after it has arrived.  Major Major assumes that the
Post Office server is a POP3 server, which at least for now is the
most common kind of Post Office server.

:p.
One way to implement a mailing list manager would be to make it an
integral part of the mail server software.  I haven't done it this
way, however, because I dislike large integrated software packages.
Rather than have one giant program that does everything, I prefer
to have many small programs, each of which does one thing and
does it well.  That gives a cleaner design, with less chance of
undetected software errors.  It also means that the users can
"mix and match" their software, according to their own preferences,
without having to get it all from the same supplier.

:p.
As a result of this, Major Major is :hp1.not:ehp1. itself a mail
server.  It assumes that a mail server is already installed, and
it interacts with that mail server.  When mailing list mail arrives
at the Post Office machine, Major Major gets it from the POP3
server.  Then Major Major decides who it should be forwarded to,
and it sends it back to the SMTP server to be delivered.

:p.
When you set up a mailing list, you specify to Major Major how
often it should check for mail.  Most mailing lists don't need a
rapid response, so it would be sufficient to check them once an
hour or even once a day.  In the case of a discussion list that
has lively back-and-forth discussions, you might want to cut the
sampling interval down to a few minutes.  In an extreme case
you might even reduce it to a few seconds; but that is not
recommended, because it puts an extra load on your processor.

:p.
Major Major can handle multiple mailing lists, and you can set
different sampling intervals for different lists.

:p.:hp2.Special case: the interaction with Weasel:ehp2.

:p.
If you are using the Weasel mail server, and it is running on the
same machine as Major Major, a shortcut is possible.  In this
case, Major Major doesn't need to use the POP3 and SMTP protocols
to send and receive mail.  Instead, it looks directly into the
disk directories where Weasel stores the mail.  This removes
some overhead from the operation, because you don't have as much
network traffic.


.***********************************
.*   INSTALLATION
.***********************************

:h1.Installation
:hp2.Installation:ehp2.
:p.
See also :link reftype=hd refid=deinstall.De-installation:elink.

:p.You should have received this package in the form of a zip file.
The first step is to unzip the file into a directory of your choice.
(Presumably you've already done this.)  You will find that you
have executable files Major.exe and Admin.exe, and a few other
files.

:p.Admin.exe sets up the configurable parameters, so you should
run it first.  The required settings should be obvious.  If they're
not, you can refer to the :link reftype=hd refid=Configuration.configuration:elink.
section of this manual.

:p.Major.exe is the actual mailing list manager, and you leave
it running all the time.  Ultimately you will probably want to
run it minimized or detached, but initially it's a good idea
to run it directly on your desktop, so that you can verify that
it's doing what you expect.

:p.If you need to stop Major.exe, type CTRL/C. Alternatively,
perform a signal on the global event semaphore \SEM32\MAJOR\SHUTDOWN.
A process killer, e.g. the second button in the WarpCenter, will also work, but
the CTRL/C or event semaphore methods are preferred because they make
Major Major tidy up and exit cleanly.

:p.The command file MakeFolder.cmd is optional.  If you run it,
it will create a desktop folder to let you work with Major Major
without having to open the directory in which it's installed.

:p.Of course, Major Major is not going to do anything interesting
until you've created one or more mailing lists, and this includes
creating the e-mail accounts for those lists.  Those details
are covered in the following sections.

.***********************************
.*   DEINSTALLATION
.***********************************

:h1 id=deinstall.De-installation
:hp2.De-installation:ehp2.
:p.
Major Major does not tamper with CONFIG.SYS or with other system files.
If you decide that you don't want to keep Major Major, simply delete
the directory into which you installed it.

:p.You should probably also go to your mail server and close down
the e-mail accounts that you were using for Major Major, unless
of course you still need those accounts.

.***********************************
.*   SETTING UP THE E-MAIL ACCOUNTS
.***********************************

:h1.Setting up the e-mail accounts
:hp2.Setting up the e-mail accounts:ehp2.

:p.Major Major needs one e-mail account for itself, plus one account
for each mailing list it is managing.  The account that Major Major
reserves for itself is the one that receives the administrative
commands such as "subscribe" and "unsubscribe".  The other accounts
are the ones that receive the mailing list traffic.

:p.To provide these accounts, you have basically two choices.
:ul.
:li.You can use an existing e-mail server, and ask the manager of
that server to create the accounts for you.  You might have to pay
for these accounts, depending on your service provider's rules.
:li.Alternatively, you can become your own postmaster by installing
a mail server on your own computer.  To do this, you must of course
have enough network connectivity to send and receive mail.
:eul.

:p.Major Major does not have to be physically on the same machine
where the mail server is running.

.***********************************
.*   CONFIGURATION
.***********************************

:h1 id=configuration.Configuration

:p.The program called Admin.exe is what you use to configure Major Major.
The configuration parameters are stored in a file called Major.INI.
In effect, Admin.exe is an editor for that configuration file.

:p.When you run Admin, you will get a small screen window with Local/Remote
radio buttons and three pushbuttons. The Remote option is for remote
configuration, which is described in a
:link reftype=hd refid=remoteconfig.separate section:elink.. Normally you
should choose the Local option, which will edit the Major.INI file that
resides in the same directory as ADMIN.EXE. Click on the "GO" button to
start the editing.

:p.If you start Admin with the command
:xmp.            admin -G

:exmp.
then you don't get the small opening screen, and the Local/Remote option
has whatever value it had the last time you ran Admin.

:p.After passing the small opening screen, you get a notebook with the
following pages.

:ul.
:li.:link reftype=hd refid=Basic.Basic:elink. - some overall program settings.
:li.:link reftype=hd refid=Admin.Admin:elink. - settings for the Major Major administrator.
:li.:link reftype=hd refid=Messages.Messages:elink. - the file names for some standard messages
:li.:link reftype=hd refid=Lists.Lists:elink. - creation and deletion of mailing lists.
:li.:link reftype=hd refid=About.About:elink. - identifies the program version.
:eul.

.***********************************
.*   BASIC
.***********************************

:h2 id=Basic.Basic settings
:hp2.Basic settings:ehp2.

:p.Changes made on this page will not have any effect until you restart
Major Major.

:p.:hp2.Server and domain:ehp2.

:p.The first thing you have to specify on this page is whether you are using
the Weasel mail server, running on the same machine as Major Major, as your
mail server.  You do this by selecting one of two radio buttons.  If you choose
"Weasel on this machine", Major Major will send and receive mail by direct
manipulation of the Weasel mail directories.  If you choose "Other mail server",
Major Major will use the SMTP and POP3 protocols to send and receive mail.

:p.The mail domain name is what comes after the '@' sign in the e-mail address
used by Major Major.  Commonly this is just the hostname of the machine on which
the mail server is running, but it is also possible for a single mail domain to
have multiple mail servers; in this case the mail domain name is, in effect, an
identifier for the group.

:p.The main use for this field within Major Major is in constructing the
"Reply-To" header line that is part of every e-mail sent out.

:p.Note. Some POP servers require users to log in with a login name of the
form user@domain. Since Major Major uses the name of a mailing list as the
POP account name for that list, you will have to include the '@domain' part
in the name of every mailing list if you are using that kind of POP server.
If so, you should leave the 'domain' field blank on this page, to avoid
getting it twice.

:p.:hp2.Root directory for mail:ehp2.

:p.This is needed only if you have selected the "Weasel on this machine" option.  It
should specify the full path name of the disk directory that Weasel uses for
storing mail.

:p.:hp2.SMTP and POP3 servers:ehp2.

:p.These must be specified if you have selected the "Other mail server" option.
The SMTP server is used for sending mail out, and the POP3 server is for incoming
mail.  Often these are on the same machine, but this is not compulsory.

:p.For each server you have to specify a hostname and a port number.  The
standard port number for an SMTP server is 25, and the standard port number for
a POP3 server is 110.  Do not use different port numbers unless the postmaster
tells you to.

:p.For the SMTP server, you also have the option of using
:link reftype=hd refid=POPbeforeSMTP.POP-before-SMTP authentication:elink..
To enable this, select the checkbox under the SMTP hostname field.

:p.:hp2.Logging:ehp2.

:p.If you want to keep a log of the Major Major operations, select one or both
of the checkboxes in this section.  You can choose to have the log written to
the screen, or to a disk file called MAJOR.LOG, or to both.

.***********************************
.*   POP-BEFORE-SMTP AUTHENTICATION
.***********************************

:h3 id=POPbeforeSMTP.POP-before-SMTP authentication
:hp2.POP-before-SMTP authentication:ehp2.

:p.As a protection against system abuse, the operators of most mail servers
put restrictions on who may send out mail via their servers.  The usual
arrangement is that an ISP will accept mail for forward delivery only
from its own customers.  That means that it must apply some sort of
"legitimacy" check on the sender of mail to be forwarded.  Obviously
this will include a check on mail sent to it from Major Major.

:p.The most common form of legitimacy check is a check on the IP address
of the sender.  If this is what is being done in your case, and Major
Major is running on a machine that the server considers to be legitimate,
you can ignore this section.  The mail from Major Major should be
going out without problem.

:p.An alternative approach, used by some mail servers, is to require the client
to do a POP login before sending out mail.  This is because a POP
login requires a correct password, whereas the SMTP protocol does not
use passwords.  Normally this is not an inconvenience to the clients,
who would most likely be checking for incoming mail anyway at the
time when they're sending mail out.  It does, however, require you
to be aware that the POP login is necessary.

:p.When you enable the "POP before SMTP" checkbox, a new dialogue
is shown where you have to enter four details: the hostname of the
machine on which the mail server is running; the POP port (normally
110) and the username and password for one of your POP accounts on
that server.  Major Major will then log into that account, and
then log out without fetching any mail, before sending any outbound
mail.

:p.If you later want to change these details, click on the "POP
before SMTP" checkbox twice: once to disable it, and once more to
enable it again.

.***********************************
.*   ADMIN
.***********************************

:h2 id=Admin.Admin
:hp2.Admin&colon. settings for the Major Major administrator:ehp2.

:p.The administrator is the part of Major Major that receives and processes commands
such as "subscribe".  Changes made on this page will not have any effect until you restart
Major Major.

:p.:hp2.E-mail account for the administrator:ehp2.

:p.Here you specify the username and POP3 password for the e-mail account that
receives mail for the administrator.  (Note: this refers to the "administrator"
component of the Major Major software, not to a human administrator.)
Enter the details here as specified by
your postmaster.  These fields might or might not be case-sensitive, depending
on the mail server.

:p.The default assumption is that the username is "MajorMajor", but you can
choose some different name if you prefer and/or if your postmaster requires it.

:ul.
:li.Special case 1&colon. If you have selected "Weasel on this machine" as your mail
server, the password is not needed.
:li.Special case 2&colon. Some multi-domain POP servers require you to log in with
a string of the form "username@domain" as the username.  If so, you should
include this complete string in the username field here, and you should leave
the mail domain field on the Basic page blank.
:eul.

:p.:hp2.Time between checks:ehp2.

:p.This specifies how often the Major Major administrator will check for new
mail for itself.  (This has nothing to do with the times for checking the
mailing lists.  The time is set independently for each list.)  Typically
this is not urgent mail, so you don't need frequent checks.

.***********************************
.*   MESSAGES
.***********************************

:h2 id=Messages.Messages
:hp2.Messages&colon. names of files containing some standard messages:ehp2.

:p.Each entry on this page contains the name of a file.  The file contains
a message that will be e-mailed as a reply to certain operations.  You
can choose to use the default messages in the "Canned" subdirectory, or
you can write your own versions.  If you write your own, give them file
names or directories that are different from the default file names;
otherwise, you risk having your modifications overwritten when you install
a new version of Major Major.

:p.:hp2.Message when non-subscriber attempts to post:ehp2.

:p.This file should contain the reply that will be sent to someone who
attempts to send a message to a list that they're not allowed to
write to.  The first line is normally a "Subject:" line.  After this
you can add more header lines if you wish.  After the header lines there
should be a blank line, and then the body of the message.

:p.:hp2.Response to HELP command:ehp2.

:p.This file should contain the text that will be sent back to a user
in response to a HELP command.  There are no header lines.

:p.See also the section on
:link reftype=hd refid=ListMessages.macros:elink..

.***********************************
.*   LISTS
.***********************************

:h2 id=Lists.Lists
:hp2.Lists&colon. creation and deletion of mailing lists:ehp2.

:p.The listbox on this page lists all the mailing lists that are currently
defined.  Changes made on this page will take effect immediately; it will
not be necessary to restart Major Major.

:p.:hp2.Adding a new mailing list:ehp2.

:p.To create a new list, click on the "Add" button.  You will be asked
to enter a name for the list.  Type in the name, finishing with the
<Enter> key.  You may then proceed to
:link reftype=hd refid=EditList.edit the list properties:elink..

:p.:hp2.Editing the properties of an existing mailing list:ehp2.

:p.To edit a list, first select that list (e.g. by clicking on its
name with the left mouse button), and then click on the "Edit" button.
Then proceed as described in the section on
:link reftype=hd refid=EditList.editing the list properties:elink..

:p.Instead of selecting the "Edit" button, you may also double-click
on the list name.

:p.:hp2.Changing the name of an existing mailing list:ehp2.

:p.To rename a list, first select that list (e.g. by clicking on its
name with the left mouse button), and then click on the "Rename" button.
You will then see a small entry box where you can edit the name.
Type the <Enter> key when you have finished.  This operation changes
only the name of the list, and therefore its e-mail address.  All other
properties of the list are kept unchanged.

:p.:hp2.Deleting an existing mailing list:ehp2.

:p.To delete a list, first select that list (e.g. by clicking on its
name with the left mouse button), and then click on the "Delete" button.

:p.Warning: there is no way to undo this operation.  As a safety measure,
it is a good idea to use the
:link reftype=hd refid=DumpINILoadINI.DumpINI:elink. utility to create a
backup copy of your data.

.***********************************
.*   ABOUT
.***********************************

:h2 id=About.About
:hp2.About:ehp2.

:p.The function of the "About" notebook page is to identify the author, and to tell you
what version of the program you have.

.***********************************
.*   REMOTE CONFIGURATION
.***********************************

:h1 id=remoteconfig.Remote configuration

:p.Admin also offers the option of remote mailing list administration.  That
is, you can run Admin on one computer and use it to configure a copy
of Major Major that is installed on a different computer.  To do this, you have
to have the freeware utility INIServe running on the same computer as
Major Major.  You can find INIServe at http&colon.&slash.&slash.eepjm.newcastle.edu.au&slash.os2.

:p.If you select the "Remote" radio button after starting Admin, a "Setup"
pushbutton is enabled.  Clicking on this gives you four fields to fill in&colon.

:dl break=all.
:dt.     Hostname
:dd.The name (or IP address) of the machine on which Major Major is running.
:dt.     INIServe port
:dd.The TCP port that INIServe has been configured to listen on.  The default
value is 8000.
:dt.     INIServe password
:dd.The password needed to log in to your copy of INIServe.
:dt.     Major Major directory
:dd.The full path name of the directory, on the remote machine, where Major Major
is installed.
:edl.

:p.When you close the Setup window, you can click on the "GO" button to connect
to the remote machine.  If this gives a "failed to connect" or similar error
message, it probably means that you don't have INIServe running on the
remote machine, or that you've done something like specifying an incorrect
port number.

:p.Once the connection is made, the operation is the same as for the
case of local configuration.

.***************************************
.*   EDITING THE MAILING LIST PROPERTIES
.***************************************

:h1 id=EditList.Defining the properties of a mailing list
:hp2.Defining the properties of a mailing list:ehp2.

:p.You reach this point by going to the "Lists" page in the Admin
notebook and choosing the "Add" or "Edit" option.  This opens up a
new notebook with the list properties.

:p.The book has the following pages.

:ul.
:li.:link reftype=hd refid=ListBasic.Basic settings:elink.
:li.:link reftype=hd refid=ListOptions.Options:elink.
:li.:link reftype=hd refid=ListMessages.Messages:elink.
:li.:link reftype=hd refid=ListMembers.Members:elink.
:li.:link reftype=hd refid=ListOwners.Owners:elink.
:eul.

:p.Any changes you make will come into effect once you close the list notebook.
It is not necessary to restart Major Major.

.***************************************
.*   LIST NOTEBOOK: BASIC PAGE
.***************************************

:h2 id=ListBasic.Basic settings
:hp2.Basic properties of the list:ehp2.

:p.The settings on this page define some basic properties of the list.

:dl break=all.
:dt.POP3 password
:dd.This is the password that is needed to log in to the POP3 server and
fetch mail.  It will have been assigned to you by the person in charge
of the mail server.  In the special case where you have specified
"Weasel on this machine" as your mail server, a POP3 password is not
needed.
:dt.Abbreviated list name
:dd.Here you can specify an abbreviation for the list name, up to
eight characters long. This will appear in brackets at the beginning
of the "Subject:" line when mailings are distributed to the list
subscribers.
:dt.Check for new mail
:dd.Specify here how often the POP3 server is to be checked for new
mail to this list.  Making this time too short can put an unreasonable
load on your processor.  A time in the range 1 to 10 minutes is a
reasonable compromise.  If list messages are not particularly urgent
you could even reduce this to once per day.
:dt.Mail from non-subscribers
:dd.Here you have to decide whether people not subscribed to the list
should be able to post messages to the list.  Choose "Accept" if you
want to permit this.  Choose "Reject" if you want to refuse the message
and send an error message back to the sender.  Most commonly you will
want to choose "Ignore", which is like "Reject" except that no error
message is sent back.  This is because a lot of junk mail software
takes a reply as a confirmation that this e-mail account is active
and able to receive more junk mail.
:dt.Error messages
:dd.Error messages will be produced by the receiving SMTP servers when,
for example, somebody subscribes to the list with an invalid address.
You can specify "discard" to say that these messages should be ignored,
or you can specify an e-mail address to receive such messages.  The
address will typically be the same as the one of the list owner
addresses on the "Owners" page, but does not need to be.
:dt.Filter
:dd.The entry in the "Filter" field, if present, should be the name
of an executable program or of a Rexx script that will filter the
incoming messages.  The filter takes one parameter, which is the
name of a file that contains the incoming message.  The filter may
modify the message, but it should not change the file name.  If the
reply code from the filter is zero, the (possibly modified) message
will be delivered to all subscribers to the list.  If the reply
code is nonzero, the message will be deleted and not delivered.

:edl.

.***************************************
.*   LIST NOTEBOOK: OPTIONS
.***************************************

:h2 id=ListOptions.Options
:hp2.Option settings for this list:ehp2.

:p.:hp2.Remove attachments:ehp2.

:p.
If this option is checked, all attachments are stripped from messages
sent to the mailing list, leaving only the text part.  This is a
desirable option because mail attachments are a common way of
distributing viruses.  In addition, even non-virus attachments are
considered by many people to be a nuisance, because they add to the
size of the message and the time taken to receive it.

:p.:hp2.Moderated list:ehp2.

:p.
If you tick the "List is moderated" box, this list becomes a moderated
list.  In a moderated list only the list owners may
post messages to the list.  (You should make sure that the "Owners" page
for this list contains at least one entry.)
If anyone else sends mail to a moderated list, that mail will be sent
to the list owners rather than to the whole list.  It is then up to
the owners to decide whether to re-post the message to the list.

:p.:hp2.Controlled commands:ehp2.

:p.Certain commands that may be sent to Major Major are
"controlled" in the sense that you decide, by checking the
appropriate options on this page, whether the commands will be
considered legal.  The list owners are always allowed to send
controlled commands, regardless of the settings on this page.
Other people can use a controlled command only if it has been
enabled by a check-mark on this page for that command.

:p.In the present version of Major Major, the following commands
are controlled&colon.

:dl break=all.
:dt.    subscribe
:dd.This is the basic "please subscribe me to this list" command.
If you do not enable this command, nobody except the list owners
may subscribe by sending an e-mail to Major Major.  Everyone
else has to be subscribed manually.
:dt.    subscribe, long form
:dd.This refers to subscription requests of the form
:xmp.     subscribe listname emailaddress:exmp.
:p.where the person being subscribed is not necessarily the person
who has sent the command.  If you disable this command then the
list owners can subscribe other people, but nobody else can.
:dt.    unsubscribe, long form
:dd.This is similar to the previous case, but for unsubscribing.
:dt.    who
:dd.The "who" command allows anyone to find out who is already
subscribed to the list.  You might or might not want to enable
this, depending on whether you consider the list of subscribers
to be confidential.
:edl.

:p.Note that the short form of "unsubscribe" cannot be
disabled.  Major Major is not intended to be used for sending
junk mail, therefore it is always possible for recipients to
remove themselves from the mailing lists.

.***************************************
.*   LIST NOTEBOOK: MESSAGES
.***************************************

:h2 id=ListMessages.Messages
:hp2.Messages for this list:ehp2.

:p.This page is for specifying the file names of message files for
use with this list.  All of these are optional.  Leave the name
blank if you do not want to use the option.

:dl break=all.
:dt.Welcome message
:dd.This is the name of a file that contains a message that will be
sent to all new subscribers to this list.  (That is, it will be sent
whenever a 'subscribe' command is successful.)  The message should
start with a "Subject:" line, plus any other optional header lines
you want to add.  Then there should be a blank line, followed by the
text of the welcome message.
:dt.Leader file
:dd.This file contains a message that will be inserted in front of
the body of all list
messages as they are sent out.  Most mailing list managers won't
need to use this feature, but it can be used if you want all list
messages to start in a distinctive way.
:dt.Footer file
:dd.This file contains a message that will be appended to all list
messages as they are sent out.  It would normally contain a signature
line, or a message saying how to unsubscribe from the list, or
something similar.
:edl.

:p.:hp2.Macros:ehp2.

:p.In these messages the '%' character has a special function.
This plus the following character forms a two-character macro that
causes special values to be inserted into your text. The macros
currently available are&colon.

:dl break=none.
:dt.    %D
:dd.the domain name of our server.
:dt.    %L
:dd.the name of this mailing list.
:dt.    %S
:dd.the e-mail address of the sender of this message.
:dt.    %%
:dd.the '%' character itself.
:edl.

:p.

.***************************************
.*   LIST NOTEBOOK: MEMBERS PAGE
.***************************************

:h2 id=ListMembers.Members
:hp2.Subscribers to this list:ehp2.

:p.Normally the subscribe/unsubscribe operations are handled by the
list members themselves.  They send an e-mail to put themselves on
the mailing list or to remove themselves from the list.  There might,
however, be times when you want to make changes manually.

:p.:hp2.Adding a new member:ehp2.

:p.Click on the "Add" button, and type in an e-mail address.  Finish with
the Enter key to confirm your entry, or with the Esc key to cancel the
operation.

:p.:hp2.Changing an existing entry:ehp2.

:p.Click on the entry to be changed, click on the "Revise" button, and edit the
e-mail address.  Finish with
the Enter key to confirm your entry, or with the Esc key to leave the
original entry unchanged.

:p.:hp2.Deleting an existing member:ehp2.

:p.Click on the entry to be deleted, then click on the "Delete" button.

:p.Double-clicking on a list entry has the same effect as selecting the
"Revise" button.

.***************************************
.*   LIST NOTEBOOK: OWNERS PAGE
.***************************************

:h2 id=ListOwners.Owners
:hp2.The owners of the list:ehp2.

:p.The owners of the list, who might or might not also be members
of the list, have two special functions.

:ol.
:li.They are allowed to use the :link reftype=hd refid=ListOptions.controlled commands:elink.,
even those that are disabled for ordinary users.
:li.If the list is a moderated list, the list owners are the
moderators.  They receive the mail submitted to the list, and decide
whether it should be sent out again.
:eol.

:p.If you don't need either of these features, then you can leave the
"Owners" list empty.  For a moderated list, it is of course essential
to have at least one owner.  In most cases a single owner (moderator)
is sufficient, but we allow for multiple owners to handle lists where
the job of moderating must be shared among several people.

:p.:hp2.Adding another owner:ehp2.

:p.Click on the "Add" button, and type in an e-mail address.  Finish with
the Enter key to confirm your entry, or with the Esc key to cancel the
operation.

:p.:hp2.Changing an existing entry:ehp2.

:p.Click on the entry to be changed, click on the "Revise" button, and edit the
e-mail address.  Finish with
the Enter key to confirm your entry, or with the Esc key to leave the
original entry unchanged.

:p.:hp2.Deleting an existing owner:ehp2.

:p.Click on the entry to be deleted, then click on the "Delete" button.

:p.Double-clicking on a list entry has the same effect as selecting the
"Revise" button.

.***************************************
.*   LIST NOTEBOOK: ARCHIVE PAGE
.***************************************

:h2 id=Archive.Archive
:hp2.Creating an archive of the list:ehp2.

:p.If you want to keep copies of messages sent to this list, check
the "Create archive for this list" checkbox on the Archive page of
the list notebook. You also have to specify how many days must pass
before the current archive file is closed and a new archive file is
started. If, for example, you specify 28 days then each archive file
for this list will contain a four-week collection of messages.

:p.The archive files are stored in the
:link reftype=hd refid=Repository.file repository:elink.
for this list. The file names are constructed from the date, to
make it easier to keep them in order.

:p.An archive file is just a concatenation of messages that have
been sent to that list, except that some of the "uninteresting"
header lines have been deleted. The file archives\separator
contains some text (usually just a dotted line, or something
similar) to go in between the messages. You may edit that
separator file if you want a different separator.

.***************************************
.*   THE FILE REPOSITORY
.***************************************

:h1 id=Repository.The file repository
:hp2.The file repository:ehp2.

:p.Optionally, a list may have a file repository associated with it.
If such a repository exists, list subscribers may use the 'index'
command to find out what files are in the repository, and the 'get'
command to fetch files from the repository.  In the present
implementation, these must be text files.

:p.Physically, the repository is simply a disk directory.  To create
a repository, you can create a subdirectory under the directory
'archives' in the Major Major directory.  (If the 'archives'
directory does not exist, you should create it as a subdirectory of
the directory that contains Major.exe.)  The subdirectory name
should be the same as the list name.

.***************************************
.*   COMMANDS TO THE LIST ADMINISTRATOR
.***************************************

:h1 id=AdminCommands.Commands to the list administrator
:hp2.Commands to the list administrator:ehp2.

:p.List subscribers and potential subscribers interact with Major Major
by sending it an e-mail message.  The "Subject:" header of the message
is not important, because Major Major ignores everything in the header
except the "Return-Path:" and "From:" addresses.  The body of the message contains one
or more commands, which are explained on this page.  Whitespace (empty
lines or space characters before the commands) is ignored.

:p.Note that some of these commands can be disabled, by removing the
appropriate checkmarks on the :link reftype=hd refid=ListOptions.Options:elink.
page for a list.

:dl break=all.
:dt.:xmp.subscribe listname emailaddress
:exmp.
:dd.This is how you subscribe someone to a list.  The first parameter is
the name of the list, and the second parameter is the e-mail address of
the person to be subscribed.
:dt.:xmp.subscribe listname
:exmp.
:dd.This is the same as the above, except that the e-mail address of the
new subscriber is taken from the "Return-Path:" line of the request. If
the "Return-Path:" line is missing then the address is instead taken
from the "From:" line of the request.
:dt.:xmp.unsubscribe listname emailaddress
:exmp.
:dd.This is how you remove someone from a list.  The first parameter is
the name of the list, and the second parameter is the e-mail address to
be removed from the subscriptions.
:dt.:xmp.unsubscribe listname
:exmp.
:dd.This is the same as the above, except that the e-mail address to be
removed is taken from the "Return-Path:" (if present) or the "From:" line of the request.
:dt.:xmp.help
:exmp.
:dd.This command causes a help message to be sent back to the person
sending the mail.
:dt.:xmp.lists
:exmp.
:dd.This returns a list of all mailing lists on this server.
:dt.:xmp.index listname
:exmp.
:dd.This returns a listing of the files held in the file repository
for this list.  If the list has no file repository, an empty
listing is returned.
:dt.:xmp.get listname filename
:exmp.
:dd.Returns a copy of the text file 'filename' from the file
repository for this list.
:dt.:xmp.which
:exmp.
:dd.This returns a list of all mailing lists to which the person
sending the request is subscribed.
:dt.:xmp.who listname
:exmp.
:dd.The result of executing this command is that a list of list members
is sent back to the person sending the mail.
:dt.:xmp.end
:exmp.
:dd.Specifies that there are no more commands.  This ensures that Major
Major does not try to process things like signature blocks.  If the
'end' command is missing, processing stops either at the end of the
e-mail or at a line starting with a '-' character, whichever comes first.
:edl.

.***************************************
.*   DUMPINI AND LOADINI
.***************************************

:h1 id=DumpINILoadINI.The DumpINI and LoadINI utilities

:p.All of the configuration data for Major Major, including details such
as the list of all e-mail addresses for a mailing list, are kept in a
binary file called MAJOR.INI.  The two programs described on this page
allow you to save this data in "plain text" form for backup purposes.
This also gives you the possibility of manually editing the data, for
example when trying to create a mailing list from an address book in
your e-mail software.

:p.:hp2.DumpINI:ehp2.

:p.The DumpINI program reads MAJOR.INI and creates a new file called
MAJOR.TNI.  This new file contains the same data, but in human-readable
form.

:p.:hp2.LoadINI:ehp2.

:p.The LoadINI program reads MAJOR.TNI and loads the information back
into the main INI file called MAJOR.INI.  It is possible to use this
when MAJOR.TNI contains only a subset of the data, because existing
entries in MAJOR.INI are not deleted except when they are superseded
by new information in MAJOR.TNI.

:h1.Who was Major Major?

:hp2.Who was Major Major?:ehp2.

:p.Major Major's full name was Major Major Major.  He was given
that name by his father.  Here is a quote from the novel
:hp1.Catch-22:ehp1., by Joseph Heller.

:lm margin=6.
:rm margin=10.
:font facename='Helv' size=14x8.

:p.A lesser man might have wavered that day in the hospital
corridor, a weaker man might have compromised on such excellent
substitutes as Drum Major, Minor Major, Sergeant Major, or
C. Sharp Major, but Major Major's father had waited fourteen
years for just such an opportunity, and he was not a person
to waste it.
:rm margin=1.
:lm margin=1.
:font facename=default.

:p.When Major Major grew up, he joined the Army.  Four days
later, he was promoted to the rank of Major by a computer error.

:p.:hp1.Catch-22:ehp1. is one of the great books of 20th
century English literature.  If you haven't yet read it,
try to find a copy.

:euserdoc.

