#ifndef _USERTYPE_H_
#define _USERTYPE_H_

#define MAXUSERNAMELEN    80
#define MAXPASSLEN        80
#define MAXSECTIONNAMELEN 80
#define MAXGROUPNAMELEN   80
#define MAXHOMELEN        CCHMAXPATH
#define MAXSHELLLEN       (2 * CCHMAXPATH)

#ifndef ACT_READ
#define ACT_READ   0x00000001
#define ACT_WRITE  0x00000002
#define ACT_CREATE 0x00000004
#define ACT_DELETE 0x00000008
#define ACT_EXEC   0x00000010
#define ACT_SESS   0x00000020
#endif

#ifndef TYPE_ALL
#define TYPE_ALL	0
#define TYPE_FIRST	1
#define TYPE_LAST	2
#define TYPE_USER	3
#define TYPE_GROUP	4
#endif

#pragma pack(1)

/*
 * ACLs container result
 */
typedef struct
{
    ULONG ulRight;                 /* The set of allowed actions */
    CHAR szMask[CCHMAXPATH + 1];   /* The mask for which this actions allowed */
}
USERACL;

typedef USERACL* PUSERACL;

/*
 * DosUserList result
 */
typedef struct
{
    LONG lUid;                       /* User UID, UID = 0 is reserved for root user */
    CHAR szUser[MAXUSERNAMELEN + 1]; /* User name */
}
USERLIST;

typedef USERLIST* PUSERLIST;

/*
 * DosUserAclList result
 */
typedef struct
{
    ULONG ulType;                          /* Type of structure, dependant on user base manager */
    CHAR szSection[MAXSECTIONNAMELEN + 1]; /* Section name */
}
USERACLLIST;

typedef USERACLLIST* PUSERACLLIST;

/*
 * user_check request packet
 */

typedef struct
{
    ULONG cbSize;       /* Size of structure */
    PSZ   pszUser;      /* User name with length <= MAXUSERNAMELEN */
    PSZ   pszPass;      /* Password with length <= MAXPASSLEN */
    PLONG plUid;        /* Destination buffer to hold user UID */
    PSZ   pszGroup;     /* Destination buffer to hold user group */
    ULONG cbGroup;      /* Length of user group buffer */
    PSZ   pszShell;     /* Destination buffer to hold user shell */
    ULONG cbShell;      /* Length of user shell buffer */
    PSZ   pszHome;      /* Destination buffer to hold user home dir */
    ULONG cbHome;       /* Length of user home dir buffer */
    PULONG pulMaxProc;  /* Destination buffer to max number of processes allowed to user */
}
USERCHECK;

typedef USERCHECK* PUSERCHECK;

/*
 * DosUserAdd && user_add request packet
 */

typedef struct
{
    ULONG cbSize;       /* Size of structure */
    PSZ   pszUser;      /* User name with length <= MAXUSERNAMELEN */
    PSZ   pszPass;      /* Password with length <= MAXPASSLEN */
    PSZ   pszGroup;     /* User group with length <= MAXGROUPNAMELEN */
    PSZ   pszShell;     /* User shell with length <= MAXSHELLLEN */
    PSZ   pszHome;      /* User home dir length <= MAXHOMELEN */
    ULONG ulMaxProc;    /* Max number of processes allowed to user */
}
USERADD;

typedef USERADD* PUSERADD;

/*
 * DosUserChange && user_change request packet
 */

typedef struct
{
    ULONG cbSize;       /* Size of structure */
    LONG  lUid;         /* User uid */
    PSZ   pszUser;      /* User name with length <= MAXUSERNAMELEN */
    PSZ   pszPass;      /* Password with length <= MAXPASSLEN */
    PSZ   pszGroup;     /* User group with length <= MAXGROUPNAMELEN */
    PSZ   pszShell;     /* User shell with length <= MAXSHELLLEN */
    PSZ   pszHome;      /* User home dir length <= MAXHOMELEN */
    ULONG ulMaxProc;    /* Max number of processes allowed to user */
}
USERCHANGE;

typedef USERCHANGE* PUSERCHANGE;

/*
 * DosUserQuery && user_query request packet
 */

typedef struct
{
    ULONG cbSize;       /* Size of structure */
    PSZ   pszUser;      /* Destination buffer to hold user name */
    ULONG cbUser;       /* Length of user name buffer */
    PLONG plUid;        /* Destination buffer to hold user UID */
    PSZ   pszGroup;     /* Destination buffer to hold user group */
    ULONG cbGroup;      /* Length of user group buffer */
    PSZ   pszShell;     /* Destination buffer to hold user shell */
    ULONG cbShell;      /* Length of user shell buffer */
    PSZ   pszHome;      /* Destination buffer to hold user home dir */
    ULONG cbHome;       /* Length of user home dir buffer */
    PULONG pulMaxProc;  /* Destination buffer to max number of processes allowed to user */
}
USERQUERY;

typedef USERQUERY* PUSERQUERY;

/*
 * DosUserRegister request packet
 */

typedef struct
{
    ULONG cbSize;       /* Size of structure */
    PID   pid;          /* The PID of user root process (i.e. user shell) */
    PSZ   pszUser;      /* User name with length <= MAXUSERNAMELEN */
    PSZ   pszPass;      /* Password with length <= MAXPASSLEN */
    PLONG plUid;        /* Destination buffer to hold user UID */
    PSZ   pszShell;     /* Destination buffer to hold user shell */
    ULONG cbShell;      /* Length of user shell buffer */
    PSZ   pszHome;      /* Destination buffer to hold user home dir */
    ULONG cbHome;       /* Length of user home dir buffer */
}
USERREGISTER;

typedef USERREGISTER* PUSERREGISTER;


/*
 * user_aclquery request packet
 */

typedef struct
{
    ULONG cbSize;       /* Size of structure */
    PSZ   pszUser;      /* User name with length <= MAXUSERNAMELEN */
    PVOID * pAcls;      /* Pointer to buffer containing user acls (USERACL) */
    PULONG pcbAcls;     /* Length of returned acls buffer in bytes */
    APIRET (APIENTRY * memAlloc)(PVOID pAddr, ULONG cbSize); /* The callback to allocate memory for acls buffer */
    PSZ   pszGroup;     /* User group with length <= MAXGROUPNAMELEN */
}
USERACLQUERY;

typedef USERACLQUERY* PUSERACLQUERY;

/*
 * user_updatecallback request packet
 */

typedef struct
{
    ULONG cbSize;       /* Size of structure */
    PSZ   pszUser;      /* User name with length <= MAXUSERNAMELEN */
    LONG  lUid;         /* User uid */
    ULONG ulMaxProc;    /* Max number of processes allowed to user */
    PVOID pAcls;	/* buffer containing user acls (USERACL) */
    ULONG cbAcls;       /* size of acls buffer in bytes */
}
USERUPDATE;

typedef USERUPDATE* PUSERUPDATE;

#pragma pack()

#endif /* _USERTYPE_H_ */