#ifndef _USERCTL_H_
#define _USERCTL_H_

#include <usertype.h>

/*-----------------------------------------*
 * API's                                   *
 *-----------------------------------------*/

/*
 * Add new user
 */
APIRET APIENTRY DosUserAdd(PUSERADD);

/*
 * Update existing user info
 * User is identified by uid (PUSERADD->lUid), if lUid >= 0,
 * or by username (PUSERADD->pszUser), if lUid < 0.
 * Only !NULL fields willbe updated.
 */
APIRET APIENTRY DosUserChange(PUSERCHANGE);

/*
 * Remove user from database
 * User is identified by uid (lUid), if lUid >= 0, or by username (pszUser),
 * if lUid < 0.
 */
APIRET APIENTRY DosUserDel(PSZ pszUser, LONG lUid);

/*
 * Query info about user
 * User is identified by uid (*PUSERADD->plUid), if *plUid >= 0,
 * or by username (PUSERADD->pszUser), if lUid < 0.
 * The *PUSERADD->plUid and PUSERADD->pszUser will be updated from
 * the current values from userbase.
 */
APIRET APIENTRY DosUserQuery(PUSERQUERY);

/*
 * Login (Register) user
 */
APIRET APIENTRY DosUserRegister(PUSERREGISTER);

/*
 * List all users in userbase. On output the bBuffer will contain array
 * of USERLIST structure.
 */
APIRET APIENTRY DosUserList(PVOID pBuffer, PULONG pcbBuffer);

/*
 * Query user assigned to current process
 * Returns both username to pszUser and user uid to *plUid.
 */
APIRET APIENTRY DosUserQueryCurrent(PSZ pszUser, ULONG cbUser, PLONG plUid);

/*
 * Check if requested action can be performed
 * pid - the pid of caller, ppid - parent pid of caller,
 * ulAction - one or more predefined actions.
 */
APIRET APIENTRY DosUserCheckAction(PID pid, PID ppid, ULONG ulAction, PSZ pszObjectName);

/*
 * Check if process can be killed (i.e, there is enough rights)
 */
APIRET APIENTRY DosUserCheckKill(PID pid, PID ppid, PID pidtokill);

/*
 * Set ACL's.
 * ulSectionType is the type of section to be set, pszSectionName is its name
 * pBuffer should contain the cbBuffer bytes array of USERACL elements
 * If section of given type and name exists, it will be replaced, if pBuffer
 * is NULL, it will be deleted.
 */
APIRET APIENTRY DosUserAclSet(ULONG ulSectionType, PSZ pszSectionName, PVOID pBuffer, ULONG cbBuffer);

/*
 * Add ACL's.
 * If section of given type and name exists, it will be replenished by given
 * ACL's, if this section does not exist, error will be returned.
 */
APIRET APIENTRY DosUserAclAdd(ULONG ulSectionType, PSZ pszSectionName, PVOID pBuffer, ULONG cbBuffer);

/*
 * Get ACL's
 * If pBuffer length is not enouph to hold the data, ERROR_MORE_DATA will
 * be returned and pcbBuffer will contain the required buffer size
 */
APIRET APIENTRY DosUserAclQuery(ULONG ulSectionType, PSZ pszSectionName, PVOID pBuffer, PULONG pcbBuffer);

/*
 * List ACL's sections
 * On exit pBuffer will contain the array of USERACLLIST elements.
 * If pBuffer length is not enough to hold the data, ERROR_MORE_DATA will
 * be returned and pcbBuffer will contain the required buffer size
 */
APIRET APIENTRY DosUserAclList(ULONG ulSectionType, PVOID pBuffer, PULONG pcbBuffer);

#endif /* _USERCTL_H_ */
