#ifndef _USERBASE_H_
#define _USERBASE_H_

#include <usertype.h>

/*
 * Called on DosUserAdd request.
 */ 
APIRET APIENTRY user_add(PSZ pszSource, PUSERADD);

/*
 * Called on DosUserCheck request.
 */ 
APIRET APIENTRY user_check(PSZ pszSource, PUSERCHECK);

/*
 * Called on DosUserChange request.
 */ 
APIRET APIENTRY user_change(PSZ pszSource, PUSERCHANGE);

/*
 * Called on DosUserDel request.
 */ 
APIRET APIENTRY user_del(PSZ pszSource, PSZ pszUser, LONG lUid);

/*
 * Called on DosUserQuery request.
 */ 
APIRET APIENTRY user_query(PSZ pszSource, PUSERQUERY);

/*
 * Called on DosUserList request.
 */ 
APIRET APIENTRY user_list(PSZ pszSource, PVOID pBuffer, PULONG pcbBuffer);

/*
 * Called on register a callback for updating user acls for registered users
 * on updates of user acls in userbase
 */ 
APIRET APIENTRY user_registercallback(APIRET (APIENTRY * updatecallback)(PUSERUPDATE));

/*
 * Called for querying the complete list of given user acls.
 * To allocate memory for acls list buffer it MUST call a memAlloc callback.
 */ 
APIRET APIENTRY user_aclquery(PSZ pszSource, PUSERACLQUERY);

/*
 * Called on DosUserAclQuery request.
 */ 
APIRET APIENTRY ACL_query(PSZ pszSource, ULONG ulSectionType, PSZ pszSectionName, PVOID pBuffer, PULONG pcbBuffer);

/*
 * Called on DosUserAclSet request.
 */ 
APIRET APIENTRY ACL_set(PSZ pszSource, ULONG ulSectionType, PSZ pszSectionName, PVOID pBuffer, ULONG cbBuffer);

/*
 * Called on DosUserAclAdd request.
 */ 
APIRET APIENTRY ACL_add(PSZ pszSource, ULONG ulSectionType, PSZ pszSectionName, PVOID pBuffer, ULONG cbBuffer);

/*
 * Called on DosUserAclList request.
 */ 
APIRET APIENTRY ACL_sectionlist(PSZ pszSource, ULONG ulSectionType, PVOID pBuffer, PULONG pcbBuffer);

#endif /* _USERBASE_H_ */