/***************************************************************************
 * CONFIGL.FNC f. ISDNPM 3.03
 *
 * Den deutschen Text finden Sie weiter unten !
 *
 * 22.02.2002, K. Schmidthaus
 *
 * ----- translation by Joerg Falkenstein ----------------------------------
 *
 * LANx configuration with the interface LANx already set with default route
 * in use with that. The connection configured with IP Masquerading.
 *
 * It looks like the following paragraph in SETUP.CMD with TCP/IP 4.1 and above, 
 * here with an example of lan1 is the ISDN interface and lan0 is an already
 * existing network setup:
 *
 * ifconfig lan0 192.168.5.103 netmask 255.255.255.0 mtu 1500
 * ifconfig lan1 192.168.210.1 netmask 255.255.255.0 metric 1 mtu 1500 -icmpred
 * route add default 192.168.210.1 -hopcount 1
 * ipgate on
 *
 * Important: when connecting via PPPoE (DSL) please use different
 *            MTU size (1492)
 * 
 * Many thanks to Christian Langanke for coding the routines scanning
 * the TCP/IP stack.
 *
 * -------------------------------------------------------------------------
 *
 * LANx-Konfiguration bei der die LANx-Schnittstelle bereits in der 
 * TCP/IP-Konfiguration konfiguriert und auf Default gesetzt wurde 
 * und die Verbindungen mit IP-Masquerading konfiguriert sind.
 *
 * In der SETUP.CMD unter TCP/IP 4.1 u. hoeher sieht es dann so aus, 
 * wobei in diesem Beispiel lan1 das ISDN-Interface ist und lan0 ein lokales
 * Netzwerk konfiguriert:
 *
 * ifconfig lan0 192.168.5.103 netmask 255.255.255.0 mtu 1500
 * ifconfig lan1 192.168.210.1 netmask 255.255.255.0 metric 1 mtu 1500 -icmpred
 * route add default 192.168.210.1 -hopcount 1
 * ipgate on
 *
 * WICHTIG: Abweichende MTU-Size (1492) bei PPPoE (DSL) setzen!!!
 *
 * Vielen Dank an Christian Langanke fuer die Routinen zur Abfrage des 
 * Tcp/IP-Stacks.
 *
****************************************************************************/
call RxFuncAdd 'SysSleep','RexxUtil','SysSleep'
call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs

PARSE ARG  action ifname ifnumber txt1 local txt2 remote txt3 dns1 txt4 dns2 txt5 nbdns1 txt6 nbdns2 txt7 netmask txt8 name txt9 default txt10 mmode txt11 doresolve txt12 lineoutname .
say action ifname ifnumber txt1 local txt2 remote txt3 dns1 txt4 dns2 txt5 nbdns1 txt6 nbdns2 txt7 netmask txt8 name txt9 default txt10 mmode txt11 doresolve txt12 lineoutname .

Fix_DNS = '0.0.0.0'    /* wenn gesetzt, wird dieser DNS fix eingetragen */
                       /* if used, the DNS has this fix address */

lnSetDNS = 1           /* 1 = resolv soll erstellt werden */
                       /* 1 = Create the resolv-file fuer DNS lookup */

/* ********************************************************************* */
/* ********************************************************************* */

 resolv =Value('ETC',,'OS2ENVIRONMENT')'\resolv'
 resolv2=Value('ETC',,'OS2ENVIRONMENT')'\resolv2'
 resolv_neu=resolv||'.tmp'
 resolv_sik=resolv||'.sik'

 mptn_bin=LEFT(Value('ETC',,'OS2ENVIRONMENT'),2)'\MPTN\BIN'

 /* ermittle drive von TCP/IP */
 BootDrive  = GetInstDrive( '\OS2');
 TcpIpDrive = GetInstDrive( '\TCPIP\BIN');
 MptsDrive  = GetInstDrive( '\MPTN\BIN');
 LapsDrive  = GetInstDrive( '\IBMCOM');

 SystemSyslevelFile = BootDrive'\os2\install\syslevel.os2';
 FixpakSyslevelFile = BootDrive'\os2\install\syslevel.fpk';
 TcpIpSyslevelFile  = TcpIpDrive'\tcpip\bin\syslevel.tcp';
 MptsSyslevelFile   = MptsDrive'\mptn\syslevel.mpt'

 /* hier werden alle Informationen geholt */
 /* all info is collected here */

/*
 SAY ReadSyslevelFile( SystemSyslevelFile);
 SAY ReadSyslevelFile( FixpakSyslevelFile);
 SAY ReadSyslevelFile( TcpIpSyslevelFile);
 SAY ReadSyslevelFile( MptsSyslevelFile);
*/

 /* Ermittlung der TCP/IP-Version */
 /* detect the TCP/IP version in OS/2 */

 TcpIpVersion = ReadSyslevelFile( TcpIpSyslevelFile,, 'VERSION');
 MptsVersion  = ReadSyslevelFile( MptsSyslevelFile,, 'VERSION');


 /* ISDNPM-Verzeichnis ermitteln */
 CallDir      = GetCallDir();
 lcCfgFile    = CallDir||'\isdn.cfg'

 /* MasquerMode ermitteln */
 IF LENGTH(mmode) > 0 THEN 
 DO 
    lnMasquerMode = mMode
    SAY 'MasquerMode ' lnMasquerMode
 END
 ELSE DO
    lcUserPath   = GetParamValue( lcCfgFile,'GLOBAL','UserPath' )
    IF LENGTH(name) > 0 THEN 
    DO
       lcUserFile   = GetUserFile(lcUserPath);
       SAY 'UserFile: ' lcUserFile
       lcMasquerMode = GetParamValue( lcUserFile,'OUTGOING','MasquerMode')
       IF LENGTH(lcMasquerMode) > 0 THEN 
       DO
          lnMasquerMode = lcMasquerMode
          SAY 'MasquerMode: ' lnMasquerMode
       END
    END
 END


/****************************************************************/
/* CALLED WHEN ISDN-ROUTER IS STARTED FOR A SPECIFIC INTERFRACE */
/****************************************************************/

if ACTION = 'START'  then 
do

   say 'START FOR INTERFACE ' ifname  ' NUMBER ' ifnumber
   SAY 'MPTS-Version:' MptsVersion
   SAY 'TCP/IP-Version:' TcpIPVersion

end

/****************************************************************/
/* CALLED WHEN ISDN-ROUTER IS STOPPED FOR A SPECIFIC INTERFRACE */
/****************************************************************/

if ACTION = 'STOP' then 
do

   say 'STOP FOR INTERFACE ' ifname   ' NUMBER ' ifnumber

   SAY 'MPTS-Version:' MptsVersion
   SAY 'TCP/IP-Version:' TcpIPVersion

end

/****************************************************************/
/* CALLED WHEN ISDN-ROUTER OPENS A 'PPP-LINK' FOR A INTERFACE   */
/****************************************************************/

if ACTION = 'OPEN' then 
do

   say 'CONFIG FOR INTERFACE ' ifname   ' NUMBER ' ifnumber
   say 'CONFIG ' txt1 local
   say 'CONFIG ' txt2 remote
   say 'CONFIG ' txt3 dns1
   say 'CONFIG ' txt4 dns2
   say 'CONFIG ' txt5 nbdns1
   say 'CONFIG ' txt6 nbdns2
   say 'CONFIG ' txt7 netmask
   say 'CONFIG ' txt8 name
   say 'CONFIG ' txt9 default

   if lnSetDNS = 1 then 
   do

      if stream(resolv_neu,'c','query exists')<>'' then 
      do
         'cmd /c del' resolv_neu
      end

      if stream(resolv_neu,'c','query exists') = '' then 
      do
         if Fix_DNS \= "0.0.0.0" then 
         do
            call lineout resolv_neu,'nameserver' Fix_DNS
            call lineout resolv_neu
         end
         if dns1 \= "0.0.0.0" then 
         do
            say "Nameserver1="||dns1
            call lineout resolv_neu,'nameserver' dns1
            call lineout resolv_neu
         end
         if dns2 \= "0.0.0.0" then 
         do
            say "Nameserver2="||dns2
            call lineout resolv_neu,'nameserver' dns2
            call lineout resolv_neu
         end
      end

      if stream(resolv_neu,'c','query exists')<>'' then 
      do

         if stream(resolv,'c','query exists')<>'' then 
         do
            say "save existing resolv file" resolv
            if stream(resolv_sik,'c','query exists')<>'' then 
            do
               'cmd /c del' resolv_sik
            end
            'cmd /c ren' resolv FileSpec("name",resolv_sik)
         end

         if stream(resolv,'c','query exists')='' then 
         do
            say "create resolv file" resolv "with requested DNS information"
            'cmd /c ren' resolv_neu FileSpec("name",resolv)
         end
      end

                           /* CREATE RESOLV2 from RESOLV if not exist */ 
      if stream(resolv2,'c','query exists')='' then 
      do
         if stream(resolv,'c','query exists')<>'' then 
         do
            do while lines( resolv )
               zeile = linein( resolv )
               call lineout resolv2,zeile
               call lineout resolv2
            end
            call Stream resolv, 'C', 'CLOSE'
         end
      end

   END  /* lnSetDNS */

end

/****************************************************************/
/* CALLED WHEN ISDN-ROUTER CLOSE A 'PPP-LINK' FOR A INTERFACE   */
/****************************************************************/

if ACTION = 'CLOSE' then 
do

   say 'RESET FOR INTERFACE ' ifname   ' NUMBER ' ifnumber
   say 'RESET ' txt1 local
   say 'RESET ' txt2 remote
   say 'RESET ' txt3 dns1
   say 'RESET ' txt4 dns2
   say 'RESET ' txt5 nbdns1
   say 'RESET ' txt6 nbdns2
   say 'RESET ' txt7 netmask
   say 'RESET ' txt8 name
   say 'RESET ' txt9 default

   if lnSetDNS = 1 then 
   do
      if stream(resolv,'c','query exists')<>'' then 
      do
         if stream(resolv_sik,'c','query exists')<>'' then 
         do
            'cmd /c del' resolv_sik
         end
         'cmd /c ren' resolv FileSpec("name",resolv_sik)
      end
      if stream(resolv,'c','query exists')<>'' then 
      do
         'cmd /c del' resolv
      end
   end
end

exit 0

/* ------------------------------------------------------------------------- */
/*  read syslevel information                                                */
/*  Syslevel-Informationen auslesen                                          */
/*  Christian Langanke, 2000                                                 */
/* ------------------------------------------------------------------------- */
ReadSyslevelFile: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG File, ForceCompId, Request

 /* default values */
 result = '';
 Request = TRANSLATE(Request);

 /* valid tags */
 Tag.0      = 8;
 /* ------------------------------ */
 Tag.1      = 'SYSID';
 Tag.1.Exec = 'result = sysid';
 /* ------------------------------ */
 Tag.2      = 'EDITION';
 Tag.2.Exec = 'result = edition';
 /* ------------------------------ */
 Tag.3      = 'VERSION';
 Tag.3.Exec = 'result = version||modify';
 /* ------------------------------ */
 Tag.4      = 'MODIFY';
 Tag.4.Exec = 'result = modify';
 /* ------------------------------ */
 Tag.5      = 'CURRCSD';
 Tag.5.Exec = 'result = currCsd';
 /* ------------------------------ */
 Tag.6      = 'PREVCSD';
 Tag.6.Exec = 'result = prevCsd';
 /* ------------------------------ */
 Tag.7      = 'ID';
 Tag.7.Exec = 'result = compId';
 /* ------------------------------ */
 Tag.8      = 'NAME';
 Tag.8.Exec = 'result = sysname';

 /* read header */
 header        = C2D(CHARIN(File,,2));
 sig           =     CHARIN(File,,8);
 DateJulian    = C2D(CHARIN(File,,5));
 Version       = C2D(CHARIN(File,,2));
 reserved      =     CHARIN(File,,16);
 offset        = C2D(REVERSE(CHARIN(File,,4))) + 1;

 /* is signature valid */
 IF (sig \= 'SYSLEVEL') THEN
    RETURN('');

 /* read table */
 sysid          = C2D(REVERSE(CHARIN(File,offset, 2)));
 edition        = C2D(CHARIN(File,,1));
 version        = D2X(C2D(CHARIN(File,,1)));
 modify         = C2D(CHARIN(File,,1));
 DateValue      = CHARIN(File,,2);

 currCsd        = CHARIN(File,,8);
 prevCsd        = CHARIN(File,,8);
 sysName        = CHARIN(File,,80);
 compId         = CHARIN(File,,9); /* ignore the rest */

 /* check comp id, if given */
 IF (ForceCompId \= '') THEN
    IF (ForceCompId  \= compId) THEN
       RETURN('');

 /* transform version */
 version = LEFT(version,1)'.'SUBSTR(version,2)

 /* cut off zero bytes from title */
 sysName = STRIP( sysName,,"0"x);

 /* get result */
 IF (Request \= '') THEN
 DO i = 1 TO Tag.0
    IF (POS(Request, Tag.i) = 1) THEN
    DO
       INTERPRET(Tag.i.Exec);
    END;
 END;

 IF (Result = '') THEN
    result = sysid edition version modify currCsd prevCsd compId sysname;

 /* close file */
 rc = STREAM(File, 'C', 'CLOSE');

 RETURN(result);

/* ------------------------------------------------------------------------- */
/* read system drive                                                         */
/*  Systemlaufwerk feststellen                                               */
/*  Christian Langanke, 2000                                                 */
/* ------------------------------------------------------------------------- */
GetInstDrive: PROCEDURE
 ARG DirName, EnvVarName

 /* Default: OS2-Verzeichnis -> ermittelt BootDrive */
 /* default: OS/2 directory -> detect BootDrive */
 IF (DirName = '') THEN DirName = '\OS2';

 /* Default: PATH  */
 IF (EnvVarName = '') THEN EnvVarName = 'PATH';

 /* Wert holen */
 /* get value */
 PathValue = TRANSLATE(VALUE(EnvVarName,,'OS2ENVIRONMENT'));

 /* Eintrag suchen und Laufwerk zurueckgeben */
 /* search entry and give drve letter */
 DirName = TRANSLATE(':'DirName';');
 EntryPos = POS(DirName, PathValue) - 1;
 IF (EntryPos = -1) THEN
    RETURN('');
 InstDrive = SUBSTR(PathValue, EntryPos, 2);
 RETURN(InstDrive);

/* ------------------------------------------------------------------------- */
/* Ermittelt den Namen der OUT-Datei                                         */
/* ------------------------------------------------------------------------- */
GetUserFile:
 parse arg UserPath

 call SysFileTree UserPath'\*.out', 'uf', 'FO'
 userFile = ''
 do i = 1 to uf.0
    userx = GetParamValue( uf.i,'OUTGOING','Name' )
    if translate( userx ) \= 'DEFAULT' then
    do
       if translate( userx ) = translate(name) then 
       do
          userfile = uf.i
          leave
       end
    end
 end
 return userfile

/* ------------------------------------------------------------------------- */
/* Holt einen ParameterWert fr pn aus der angebenen Datei fn                */
/* ------------------------------------------------------------------------- */
GetParamValue:
 parse arg fn, sec, pn
 pv = ''

 pn  = translate(pn)
 sec   = '['||translate(sec)||']'

 SecOK = 0

 if fn <> "" then
 if stream(fn,'c','query exists')<>'' then 
 do
    do while lines( fn )
       pl = strip( linein( fn ) )
       if left( pl, 2 ) == '//' | left( pl, 1 ) == '#' then
                        iterate

       pl = translate(pl)

       if left( pl, 1 ) = '[' then
       do
          SecOK = 0

          if word(pl,1) = sec then 
             SecOK = 1
          iterate
       end

       if SecOK \= 1 then
          iterate

       parse var pl . (pn) pv
       pv = strip( strip( pv ), 'B', ':' )
       pv = word(pv,1)
       if pv \= '' then
          leave
    end
    call Stream fn, 'C', 'CLOSE'
 end
 return pv

/* ------------------------------------------------------------------------- */
/* ------------------------------------------------------------------------- */
GetCalldir: PROCEDURE
PARSE SOURCE . . CallName
 CallDir = FILESPEC('Drive', CallName)||FILESPEC('Path', CallName);
 RETURN(LEFT(CallDir, LENGTH(CallDir) - 1));

/* ------------------------------------------------------------------------- */
