/***************************************************************************
 * CONFIG0.FNC for ISDNPM 3.03
 *
 * Den deutschen Text finden Sie weiter unten !
 *
 * 06.10.2001, K. Schmidthaus
 * 10.06.2002, C.Langanke
 * 13.06.2002, K. Schmidthaus
 *
 * Many thanks to Christian Langanke for
 * - the following procedures:
 *    ReadSyslevelFile, GetInstDrive, GetUserFile,
 *    GetCalldir, FileExist, ExecuteCommand, CommandIncluded
 *    new implementation of GetParamValue
 * - implementing configuration for all scenarios in this one script
 *
 * -------------------------------------------------------------------------
 *
 * This script configures the TCP/IP interface used by ISDNPM when starting
 * the program and/or a connection and cleans up after termination of a
 * connection and/or the program. Doing this the setting for using IP
 * masquerading is taken into account.
 * For serial line interfaces (sl0 or ppp0) the default route is set to the
 * interface created by ISDNPM when requested within the connection definition
 * by the flag DEFAULTROUTE.
 * For lan interfaces you can choose to let this script perform the
 * configuration for you or do that yourselfeither within the TCP/IP
 * configuration notebook or edit it manually in ?:\MPTN\BIN\SETUP.CMD.
 *
 * Note:
 * - set the variable LocalDNS to the TCP/IP adress of your local DNS within
 *   your LAN, if you have one. Make sure though that the configuration of
 *   your DNS server contains a forwarder entry to any DNS Server within the
 *   internet !!!
 * - if the flag DNSREQUEST (V3.02) / DORESOLV (V3.03) is set and
 *   - a connection has been established:
 *     - an existing file %ETC%\resolv will be backed up
 *     - the file %ETC%\resolv will be created with the current DNS values
 *     - if it does not exist, the file %ETC%\resolv2 will be created as a
 *       copy of the new file %ETC%\resolv
 *   - a connection has been closed:
 *      - the file %ETC%\resolv will be deleted
 *      - an existing backup copy of %ETC%\resolv will be restored.
 *      - a file %ETC%\resolv2 will not be deleted
 * - connections not making use of IP masquerading (MasquerMode =zero)
 *   are configured to the IP address provided by the dial-in server
 *   and reset after termination of the connection.
 * - if your isdn.cfg contains the definition of a PPPoE interface, a MTU
 *   size of 1492 bytes is being used instead of 1500. This compensates for
 *   the additional overhead of the PPPoE protocol header being 8 bytes
 *   larger as usual, causing packet fragmentation and thus performance
 *   degradation with the usual MTU size of 1500.
 *
 * -------------------------------------------------------------------------
 *
 * Dieses Script konfiguriert die von ISDNPM genutzte IP-Schnittstelle beim
 * Programmstart bzw. bei Start einer Verbindung und rumt bei Beendigung
 * der Verbindung bzw. des Programms entsprechend auf. Hierbei wird die
 * Einstellung fr die Verwendung von IP Masquerading bercksichtigt.
 * Die Default-Route wird jeweils auf das von ISDNPM erstellte Interface
 * gesetzt, wenn dies in der Verbindungsdefinition mit dem Flag DEFAULTROUTE
 * eingestellt wird.
 * Fr lan Schnittstellen knnen Sie wahlweise dieses Script die
 * Konfiguration vornehmen lassen oder diese selbst im TCP/IP Konfigurations-
 * notizbuch vornehmen bzw. manuell in ?:\MPTN\BIN\SETUP.CMD eintragen.
 *
 * Hinweise:
 * - Setzen Sie den Wert der Variablen LocalDNS auf die TCP/IP Addresse
 *   Ihres lokalen DNS Servers in Ihrem LAN (Netzwerk), wenn Sie einen haben.
 *   Stellen Sie aber sicher, dass die Konfiguration Ihres DNS Servers einen
 *   Weiterleitungseintrag auf einen anderen  DNS Server im Internet hat !!!
 * - Wenn das Flag DNSREQUEST (V3.02) / DORESOLV (V3.03) gesetzt wird und
 *   - eine Verbindung aufgebaut wurde:
 *     - wird eine existierende Datei %ETC%\resolv gesichert
 *     - die Datei %ETC%\resolv wird erstellt mit den aktuellen DNS Werten
 *     - wenn sie nicht existiert, wird die Datei %ETC%\resolv2 als Kopie
 *       der neuen Datei %ETC%\resolv erstellt
 *   - eine Verbindung geschlossen wurde:
 *      - wird die Datei %ETC%\resolv gelscht
 *      - eine ggfs. existierende Sicherheitskopie von %ETC%\resolv
 *        zurckgesicehrt
 *      - eine Datei %ETC%\resolv2 wird gelscht, wenn sie zuvor von
 *        ISDNPM (!) geschrieben wurde.
 * - bei Verbindungen, die ohne Masquerading (MasquerMode = 0) konfiguriert
 *   sind, wird das Interface beim Verbindungsaufbau auf die vom Dial-In
 *   Server zugewiesene IP-Adresse konfiguriert und mit dem Verbindungsende
 *   wieder zurueckgesetzt.
 * - Falls in der isdn.cfg eine PPPoE-Schnittstelle konfiguriert wurde,
 *   wird eine MTU-Grsse von 1492 Bytes anstelle von 1500 verwendet. Dies
 *   kompensiert den um den 8 Byte grsseren Header des PPPoE-Protokolls,
 *   was bei einer Verwendung der blichen MTU Gre von 1500 Bytes zu
 *   Paketfragmentierung und Performanceverlusten fhren wrde.
 *
****************************************************************************/

 call RxFuncAdd 'SysSleep','RexxUtil','SysSleep'
 call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
 call SysLoadFuncs

 /* read parameter */
 PARSE ARG  action ifname ifnumber txt1 local txt2 remote txt3 dns1 txt4 dns2 txt5 nbdns1 txt6 nbdns2 txt7 netmask txt8 name txt9 default txt10 mmode txt11 doresolve txt12 lineoutname .

 /* display parameters in more readable form */
 PARSE SOURCE . . CallName
 PARSE ARG . . . MoreParms;
 CALL LOGSAY CallName 'started for' action 'of interface' ifname'/'ifnumber;
 DO WHILE (MoreParms \= '')
    PARSE VAR MoreParms ThisName ThisValue MoreParms;
    CALL LOGSAY  ' ' ThisName ThisValue;
 END;

 /* To the maintainer of this script:                                     */
 /* When upgrading this script for release with ISDNPM V3.03              */
 /* - please remove this comment and the line defining fIsVersion302      */
 /* - "optimize" the code below currently using fIsVersion302             */
 /* - update the head comment of this script covering the flag DNSREQUEST */
 fIsVersion302 = 0;

 /* ********************************************************************* */
 /*                         configuration section                         */
 /* --------------------------------------------------------------------- */
 /*                 These values normally need no change                  */
 /* ********************************************************************* */

 /* values for connections using IP masquerading */
 lcLocalIP     = '192.168.200.1'
 lcNetmask     = '255.255.255.0'

 /* Change the following value to the address of a DNS server within your */
 /* LAN, if you have one. See the comment at the top of this script !!!   */
 LocalDNS = '0.0.0.0'

/****************************************************************/
/* COMMON SECTION                                               */
/****************************************************************/


 /* detect drive letter of diverse system components */
 BootDrive  = GetInstDrive( '\OS2');
 TcpIpDrive = GetInstDrive( '\TCPIP\BIN');
 MptsDrive  = GetInstDrive( '\MPTN\BIN');
 LapsDrive  = GetInstDrive( '\IBMCOM');

 MptsSetupFile = MptsDrive'\mptn\bin\setup.cmd';

 /* ---------------------------------------- */

 /* read the version of selected components  from their respective syslevel file */
 TcpIpVersion = ReadSyslevelFile( TcpIpDrive'\tcpip\bin\syslevel.tcp',, 'VERSION');
 MptsVersion  = ReadSyslevelFile( MptsDrive'\mptn\syslevel.mpt',,       'VERSION');

 /* ---------------------------------------- */

 /* determine ISDNPM program directory and some filenames */
 CallDir      = GetCallDir();
 lcCfgFile    = CallDir||'\isdn.cfg';
 lcUserPath   = GetParamValue( lcCfgFile, 'GLOBAL', 'UserPath');
 If (lcUserPath = '') THEN
    lcUserPath = CallDir;

 /* ---------------------------------------- */

 /* is it a lan interface to configure ? */
 IsLanInterface   = 0;
 LanInterfaceType = 'WAN';
 CfgIfCount = GetParamValue( lcCfgFile, 'GLOBAL', 'LanInterfaces');
 IF (CfgIfCount = '') THEN
    CfgIfCount = 0;

 DO i = 0 TO CfgIfCount - 1;
    CfgIfName = GetParamValue( lcCfgFile, 'LAN'i, 'IF_NAME');
    IF (TRANSLATE( CfgIfName) = TRANSLATE( IfName)) THEN
    DO
       IsLanInterface = 1;
       LanInterfaceType = 'LAN';
       LEAVE;
    END;
 END;

 CALL LOGSAY 'IP Interface Type:' LanInterfaceType;

 /* ---------------------------------------- */

 /* default behaviour */
 MptsConfigureInterface = 1;   /* configure interface                         */
 MptsConfigureDefRoute  = 1;   /* configure default route                     */
                               /* may be modified below ! See SetDefaultRoute */
 MptsConfigureIpGate    = 1;   /* activate IP routing                         */

 /* modified behaviour for LAN interfaces, if (parts of) */
 /* required configuration is already included in MPTS   */
 IF (IsLanInterface) THEN
 DO
    MptsConfigureInterface = (\CommandIncluded( MptsSetupFile, 'ifconfig' IfName));
    MptsConfigureDefRoute  = (\CommandIncluded( MptsSetupFile, 'route add default'));
    MptsConfigureIpGate    = (\CommandIncluded( MptsSetupFile, 'ipgate on'));
 END;

 IF (MptsConfigureInterface) THEN
    CALL LOGSAY 'MPTS configuration for interface' ifname 'required';
 IF (MptsConfigureIpGate) THEN
    CALL LOGSAY 'MPTS IP gateway configuration for interface' ifname 'required';
 IF (MptsConfigureDefRoute) THEN
    CALL LOGSAY 'MPTS default route configuration required';

 IF ((\MptsConfigureInterface) &,
     (\MptsConfigureIpGate)    &,
     (\MptsConfigureDefRoute)) THEN
    CALL LOGSAY 'MPTS configuration for' ifname 'already complete';

 /* ---------------------------------------- */

 /* get some variables in case of START or CLOSE when using ISDNPM V3.02 */
 IF (WORDPOS( ACTION, 'OPEN CLOSE') > 0) THEN
 DO
    /* is default route to be set ?               */
    /* if not, overide behaviour determined above */
    SetDefaultRoute = (default \= "0.0.0.0");
    IF ((\SetDefaultRoute) & (MptsConfigureDefRoute)) THEN
       MptsConfigureDefRoute = 0;

    /* get user file */
    lcUserFile = GetUserFile( lcUserPath, name);
    IF (lcUserFile = '') THEN
    DO
       SAY '#### Error cannot determine .out definition file!';
       EXIT(2);
    END;

    CALL LOGSAY 'UserFile: ' lcUserFile

    /* determine by which version of ISDNPM V3.x is called */
    IF (fIsVersion302 = '1') THEN
    DO
       /*  - get some values from user file */

       lcMasquerMode = GetParamValue( lcUserFile, 'OUTGOING', 'MasquerMode');

       /* check for flag DNSREQUEST              */
       /* this code assumes that flag DNSREQUEST */
       /* is set in default.out as default !     */
       lcDoResolv = TRUE;
                           /* specify 1 as 4th parm to read more than one line ! */
       Flags = GetParamValue( lcUserFile, 'OUTGOING', 'Flags', 1);
       Flags = TRANSLATE( TRANSLATE( Flags, ' ', ','));
       DO w = 1 TO WORDS( Flags)
          IF (WORD( Flags, w) = 'DNSREQUEST') THEN
             lcDoResolv = 1;
          IF (WORD( Flags, w) = '~DNSREQUEST') THEN
             lcDoResolv = 0;
       END;
    END;
    ELSE
    DO
       /*  - get some values from call parameters */
       lcMasquerMode = mmode;
       lcDoResolv    = doresolve
    END;

    IF (lcMasquerMode \= '') THEN
       CALL LOGSAY 'MasquerMode: ' lcMasquerMode;
 END;

 /* ---------------------------------------- */

 /* Determine otpimum size of MTU for IP masqueraded interface */
 /* If a DSL interface is configured, use 1492 instead of 1500 */
 /* to compensate for 8 extra bytes overhead of the PPPoE      */
 /* protocol, otherwise causing packet fragmentation.          */
 PPPOELines    = GetParamValue( lcCfgFile, 'GLOBAL', 'PPPOELines');
 IF ((PPPoELines = '') | (PPPoELines = '0')) THEN
    lcMtusize = 1500;
 ELSE
    lcMtusize = 1492;
 CALL LOGSAY 'MTU size: ' lcMtusize;

 CALL LOGSAY 'MPTS-Version:' MptsVersion;
 CALL LOGSAY 'TCP/IP-Version:' TcpIPVersion;
 IF (MptsVersion < 5.3) THEN
    CALL LOGSAY 'Route Syntax: using old Version';

/****************************************************************/
/* CALLED WHEN ISDN-ROUTER IS STARTED FOR A SPECIFIC INTERFRACE */
/****************************************************************/

 IF (ACTION = 'START') THEN
 DO
    IF (MptsVersion < 5.3) THEN
    DO
       CmdDeleteRoute = 'route delete net default 1';
       CmdConfigIf    = 'ifconfig' ifname lcLocalIP 'netmask' lcNetmask 'mtu' lcMtusize;
       CmdAddRoute    = 'route add default' lcLocalIP '1';
       CmdActIpGate   = 'ipgate on';
    END;
    ELSE
    DO
       CmdDeleteRoute = 'route delete default';
       CmdConfigIf    = 'ifconfig' ifname lclocalIP 'netmask' lcNetmask 'metric 1 mtu' lcMtusize;
       CmdAddRoute    = 'route add default' lcLocalIP '-hopcount 1';
       CmdActIpGate   = 'ipgate on';
    END;

    IF (MptsConfigureDefRoute)  THEN ExecuteCommand( CmdDeleteRoute);
    IF (MptsConfigureInterface) THEN ExecuteCommand( CmdConfigIf);
    IF (MptsConfigureDefRoute)  THEN ExecuteCommand( CmdAddRoute);
    IF (MptsConfigureIpGate)    THEN ExecuteCommand( CmdActIpGate);
 END;

/****************************************************************/
/* CALLED WHEN ISDN-ROUTER IS STOPPED FOR A SPECIFIC INTERFRACE */
/****************************************************************/

 IF (ACTION = 'STOP') THEN
 DO

    IF (MptsVersion < 5.3) THEN
    DO
       CmdDeleteRoute = 'route delete net default ' lcLocalIP  '1';
       CmdDeactIpGate = 'ipgate off';
    END;
    ELSE
    DO
       CmdDeleteRoute = 'route delete default';
       CmdDeactIpGate = 'ipgate off';
    END;

    IF (MptsConfigureDefRoute)  THEN ExecuteCommand( CmdDeleteRoute);
    IF (MptsConfigureIpGate)    THEN ExecuteCommand( CmdDeactIpGate);

 END;

/****************************************************************/
/* CALLED WHEN ISDN-ROUTER OPENS A 'PPP-LINK' FOR A INTERFACE   */
/****************************************************************/

 IF (ACTION = 'OPEN') THEN
 DO
    IF (lcMasquerMode <> 2) THEN
    DO

       IF (MptsVersion < 5.3) THEN
       DO
          CmdDeleteRoute = 'route delete net default ' lcLocalIP  '1';
          CmdConfigIf    = 'ifconfig' ifname local remote 'netmask' netmask 'mtu' lcMtusize;
          CmdAddRoute    = 'route add default' default '1';
       END;
       ELSE
       DO
          CmdDeleteRoute = 'route delete default';
          CmdConfigIf    = 'ifconfig' ifname local remote 'netmask' netmask 'metric 1 mtu' lcMtusize;
          CmdAddRoute    = 'route add default' default '-hopcount 1';
       END;

       IF (MptsConfigureDefRoute)  THEN ExecuteCommand( CmdDeleteRoute);
       IF (MptsConfigureInterface) THEN ExecuteCommand( CmdConfigIf);
       IF (MptsConfigureDefRoute)  THEN ExecuteCommand( CmdAddRoute);

    END;

    /* write resolver configuration */
    IF (lcDoResolv = 1) THEN
       WriteResolv( LocalDNS, DNS1, DNS2); 

 END;

/****************************************************************/
/* CALLED WHEN ISDN-ROUTER CLOSE A 'PPP-LINK' FOR A INTERFACE   */
/****************************************************************/

 IF (ACTION = 'CLOSE') THEN
 DO
    IF (lcMasquerMode <> 2) THEN
    DO

       IF (MptsVersion < 5.3) THEN
       DO
          CmdDeleteRoute = 'route delete net default' local;
          CmdConfigIf    = 'ifconfig' ifname lcLocalIP 'netmask' lcNetmask 'mtu' lcMtusize;
          CmdAddRoute    = 'route add default' lcLocalIP '1';
       END;
       ELSE
       DO
          CmdDeleteRoute = 'route delete default';
          CmdConfigIf    = 'ifconfig' ifname lclocalIP 'netmask' lcNetmask 'metric 1 mtu' lcMtusize;
          CmdAddRoute    = 'route add default' lcLocalIP '-hopcount 1';
       END;

       IF (MptsConfigureDefRoute)  THEN ExecuteCommand( CmdDeleteRoute);
       IF (MptsConfigureInterface) THEN ExecuteCommand( CmdConfigIf);
       IF (MptsConfigureDefRoute)  THEN ExecuteCommand( CmdAddRoute);

    END;

    /* cleanup  resolver configuration */
    IF (lcDoResolv = 1) THEN
       WriteResolv( );

 END;


/****************************************************************/
/* END OF SCRIPT                                                */
/****************************************************************/

CALL LOGSAY CallName 'ended'
SAY;
exit 0

/* ------------------------------------------------------------------------- */
/*  write resolv config, when called with parameter                          */
/*  cleanup resolv config, when called with no parameter                     */
/* ------------------------------------------------------------------------- */
WriteResolv: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG LocalDNS, DNS1, DNS2; 

 /* default values */
 Redirection = '>NUL 2>&1';
 resolv     = VALUE( 'ETC',, 'OS2ENVIRONMENT')'\resolv'
 resolv2    = VALUE( 'ETC',, 'OS2ENVIRONMENT')'\resolv2'
 resolv_tmp = resolv||'.tmp'
 resolv_bak = resolv||'.sik'

 IF (DNS1 \= '') THEN
 DO
    /* ---- write resolv configuration ---- */

    /* write temporary resolv file */
    rc = SysFileDelete( resolv_tmp);
    IF (LocalDNS \= "0.0.0.0") THEN CALL LINEOUT resolv_tmp, 'nameserver' LocalDNS;
    IF (dns1     \= "0.0.0.0") THEN CALL LINEOUT resolv_tmp, 'nameserver' dns1;
    IF (dns2     \= "0.0.0.0") THEN CALL LINEOUT resolv_tmp, 'nameserver' dns2;
    CALL LINEOUT resolv_tmp

    /* create backup copy */
    IF (FileExist( resolv)) THEN
    DO
       CALL LOGSAY 'create backup copy of existing file' resolv;
       rc = SysFileDelete( resolv_bak);
       'ren' resolv FileSpec( 'N', resolv_bak) Redirection;
    END;

    /* now let temporary file become the real resolv file */
    CALL LOGSAY 'create file' resolv 'with requested DNS information'
    rc = SysFileDelete( resolv);
    'ren' resolv_tmp FileSpec( 'N', resolv) Redirection;

    /* create resolv2 from resolv if not exist or empty */
    IF (\FileExist( resolv2)) | (STREAM(Filename, 'C', 'QUERY SIZE') = 0) THEN
    DO
       CALL LOGSAY 'create file' resolv2 'as copy';
       'COPY' resolv resolv2 Redirection;
    END;
 END;
 ELSE
 DO
    /* ---- cleaup resolv configuration ---- */

    /* delete current resolv file */
    CALL LOGSAY 'removing file' resolv;
    rc = SysFileDelete( resolv);

    /* rename back a backup copy */
    IF (FileExist( resolv_bak)) THEN
    DO
       CALL LOGSAY 'reactivating existing backup copy of' resolv;
       'ren' resolv_bak FileSpec( 'N', resolv) Redirection;
    END;

    /* do not delete resolv2 !   */
    /* better for autodial users */

 END;

 RETURN( '');

/* ------------------------------------------------------------------------- */
/*  read syslevel-Informationen                                              */
/*  Christian Langanke, 2000                                                 */
/* ------------------------------------------------------------------------- */
ReadSyslevelFile: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG File, ForceCompId, Request

 /* default values */
 result = '';
 Request = TRANSLATE(Request);

 /* valid tags */
 Tag.0      = 8;
 /* ------------------------------ */
 Tag.1      = 'SYSID';
 Tag.1.Exec = 'result = sysid';
 /* ------------------------------ */
 Tag.2      = 'EDITION';
 Tag.2.Exec = 'result = edition';
 /* ------------------------------ */
 Tag.3      = 'VERSION';
 Tag.3.Exec = 'result = version||modify';
 /* ------------------------------ */
 Tag.4      = 'MODIFY';
 Tag.4.Exec = 'result = modify';
 /* ------------------------------ */
 Tag.5      = 'CURRCSD';
 Tag.5.Exec = 'result = currCsd';
 /* ------------------------------ */
 Tag.6      = 'PREVCSD';
 Tag.6.Exec = 'result = prevCsd';
 /* ------------------------------ */
 Tag.7      = 'ID';
 Tag.7.Exec = 'result = compId';
 /* ------------------------------ */
 Tag.8      = 'NAME';
 Tag.8.Exec = 'result = sysname';

 /* read header */
 header        = C2D(CHARIN(File,,2));
 sig           =     CHARIN(File,,8);
 DateJulian    = C2D(CHARIN(File,,5));
 Version       = C2D(CHARIN(File,,2));
 reserved      =     CHARIN(File,,16);
 offset        = C2D(REVERSE(CHARIN(File,,4))) + 1;

 /* is signature valid */
 IF (sig \= 'SYSLEVEL') THEN
    RETURN('');

 /* read table */
 sysid          = C2D(REVERSE(CHARIN(File,offset, 2)));
 edition        = C2D(CHARIN(File,,1));
 version        = D2X(C2D(CHARIN(File,,1)));
 modify         = C2D(CHARIN(File,,1));
 DateValue      = CHARIN(File,,2);

 currCsd        = CHARIN(File,,8);
 prevCsd        = CHARIN(File,,8);
 sysName        = CHARIN(File,,80);
 compId         = CHARIN(File,,9); /* ignore the rest */

 /* check comp id, if given */
 IF (ForceCompId \= '') THEN
    IF (ForceCompId  \= compId) THEN
       RETURN('');

 /* transform version */
 version = LEFT(version,1)'.'SUBSTR(version,2)

 /* cut off zero bytes from title */
 sysName = STRIP( sysName,,"0"x);

 /* get result */
 IF (Request \= '') THEN
 DO i = 1 TO Tag.0
    IF (POS(Request, Tag.i) = 1) THEN
    DO
       INTERPRET(Tag.i.Exec);
    END;
 END;

 IF (Result = '') THEN
    result = sysid edition version modify currCsd prevCsd compId sysname;

 /* close file */
 rc = STREAM(File, 'C', 'CLOSE');

 RETURN(result);

/* ------------------------------------------------------------------------- */
/*  readout the system drive letter or of installed components               */
/*  Christian Langanke, 2000                                                 */
/* ------------------------------------------------------------------------- */
GetInstDrive: PROCEDURE
 ARG DirName, EnvVarName

 /* Default: search OS2 directory to return OS/2 boot drive */
 IF (DirName = '') THEN DirName = '\OS2';

 /* Default: search in path variable  */
 IF (EnvVarName = '') THEN EnvVarName = 'PATH';

 /* catch value */
 PathValue = TRANSLATE(VALUE(EnvVarName,,'OS2ENVIRONMENT'));

 /* search entry and give drive letter */
 DirName = TRANSLATE(':'DirName';');
 EntryPos = POS(DirName, PathValue) - 1;
 IF (EntryPos = -1) THEN
    RETURN('');
 InstDrive = SUBSTR(PathValue, EntryPos, 2);
 RETURN(InstDrive);

/* ------------------------------------------------------------------------- */
/* determines the file containing the connection definition                  */
/* ------------------------------------------------------------------------- */
GetUserFile: PROCEDURE
 PARSE ARG UserPath, Name

 UserFile = '';

 rc = SysFileTree( UserPath'\*.out', 'File.', 'FO');
 IF (rc \= 0) THEN
 DO
    CALL LOGSAY 'Error in SysFileTree, cannot determine user file. Aborting ...';
    EXIT(rc);
 END;

 CheckName = TRANSLATE( Name);
 DO i = 1 TO File.0
    UserName = GetParamValue( File.i,'OUTGOING','Name' );
    IF (TRANSLATE( UserName) \= 'DEFAULT') THEN
    DO
       IF (TRANSLATE( UserName) = CheckName) THEN
       DO
          UserFile = File.i;
          LEAVE;
       END;
    END;
 END;
 RETURN UserFile;

/* ------------------------------------------------------------------------- */
/* gets the value of keyword pn of section sec in the file fn                */
/* if AppendAllowed is set to 1, the value of several lines are concatenated */
/* ------------------------------------------------------------------------- */
GetParamValue: PROCEDURE
 PARSE ARG File, Section, ParamName, AppendAllowed;

 /* default values */
 ParamValue      = '';
 fSectionFound   = 0;
 ValidDelimiters = ':=';

 IF (AppendAllowed \= '1') THEN
    AppendAllowed = '0';

 /* prepare for seek */
 ParamName  = TRANSLATE( STRIP( ParamName));
 Section    = '['TRANSLATE( STRIP( Section))']';

 DO UNTIL (1)
    /* does file exist ? */
    IF (\FileExist( File)) THEN
       LEAVE;

    /* open file for read only */
    rc = STREAM( File, 'C', 'OPEN READ');
    IF (rc \= 'READY:') THEN
       LEAVE;

    /* read all lines */
    DO WHILE (LINES( File))

       /* read line and skip comments and empty lines */
       ThisLine = STRIP( LINEIN( File));
       IF (ThisLine = '')             THEN ITERATE;
       IF (LEFT( ThisLine, 2) = '//') THEN ITERATE;
       IF (LEFT( ThisLine, 1) = '#')  THEN ITERATE;

       /* is it a section */
       IF (LEFT( ThisLine, 1) = '[') THEN
       DO
          fSectionFound = (ThisLine = Section);
          ITERATE;
       END;

       /* cut off comments */
       CommentPos = POS( '//', ThisLine);
       IF (CommentPos > 0) THEN
          ThisLine = LEFT( ThisLine, CommentPos - 1);

       /* check lines of searched section only */
       IF (\fSectionFound) THEN ITERATE;

       /* does line contain a valid delimiter ? */
       CheckDelimiters = ValidDelimiters;
       DO WHILE (CheckDelimiters \= '')
          PARSE VAR CheckDelimiters ThisDelimiter +1 CheckDelimiters;
          IF (POS( ThisDelimiter, ThisLine) > 0) THEN
             LEAVE;
          ELSE
             ThisDelimter = '';
       END;
       IF (ThisDelimiter = '') THEN
          ITERATE;

       /* check varname */
       PARSE VAR ThisLine ThisParamName (ThisDelimiter) ThisParamValue;
       ThisParamName = TRANSLATE( STRIP( ThisParamName));
       IF (ThisParamName = ParamName) THEN
       DO
          /* append value if allowed and already found*/
          IF ((AppendAllowed) & (ParamValue \= '')) THEN
             ParamValue = ParamValue','STRIP( ThisParamValue);
          ELSE
             ParamValue = STRIP( ThisParamValue);

          IF (\AppendAllowed) THEN
             LEAVE;
       END;

    END;
    rc = STREAM( File, 'C', 'CLOSE');
 END;

 RETURN( ParamValue);

/* ------------------------------------------------------------------------- */
/* checks commands within a batch file                                       */
/*  - specified commands must start at the beginnin of a line                */
/*  - whitespace on a line is ignored                                        */
/*  - search is case insensitive                                             */
/* ------------------------------------------------------------------------- */
CommandIncluded: PROCEDURE
 PARSE ARG File, Command

 IsIncluded = 0;
 Command = TRANSLATE( SPACE( STRIP( Command)));

 DO UNTIL (1)
    /* check parm */
    IF (Command = '') THEN
       LEAVE;

    /* search first word of command in file */
    rc = SysFileSearch( WORD( Command, 1), File, 'Line.');
    if (rc \= 0) THEN
       LEAVE;

    /* go through lines found */
    DO i = 1 TO Line.0
       ThisLine = TRANSLATE( Line.i, D2C(32), D2C( 9));
       ThisLine = TRANSLATE( SPACE( STRIP( ThisLine)));

       IF (POS( Command, ThisLine) = 1) THEN
       DO
          IsIncluded = 1;
          LEAVE;
       END;
    END;

 END;

 RETURN( IsIncluded);

/* ------------------------------------------------------------------------- */
/* check if a command is included in a batch file                            */
/* ------------------------------------------------------------------------- */
CommandIncluded: PROCEDURE
 PARSE ARG File, Command;
 RETURN( 0);

/* ------------------------------------------------------------------------- */
/* determines the directory where this procedure has been called from        */
/* ------------------------------------------------------------------------- */
GetCalldir: PROCEDURE
PARSE SOURCE . . CallName
 CallDir = FILESPEC('Drive', CallName)||FILESPEC('Path', CallName);
 RETURN(LEFT(CallDir, LENGTH(CallDir) - 1));

/* ------------------------------------------------------------------------- */
/* determines if a given file exists                                         */
/* ------------------------------------------------------------------------- */
FileExist: PROCEDURE
 PARSE ARG FileName
 RETURN(STREAM(Filename, 'C', 'QUERY EXISTS') > '');

/* ------------------------------------------------------------------------- */
/* displays a command and then executes it. The output is catched in order   */
/* to display it together with LogId and indentation                         */
/* ------------------------------------------------------------------------- */
ExecuteCommand: PROCEDURE EXPOSE LogId
 PARSE ARG Command;

 QueueName = RXQUEUE('CREATE');
 rc        = RXQUEUE('SET', QueueName);

 '' Command ' 2>&1 | rxqueue' QueueName;

 CALL LOGSAY 'Executing command: "' Command'", rc='rc;
 IF (QUEUED() > 0) THEN
 DO
    DO WHILE (QUEUED() > 0)
       PARSE PULL Line;
       CALL LOGSAY '>>   ' Line;
    END;
 END;

 rc = RXQUEUE('DELETE', QueueName);
 rc = RXQUEUE('SET', 'SESSION');

 RETURN('');

/* ------------------------------------------------------------------------- */
/* write a line to console and logfile                                       */
/* name and place of the logfile is the same as of the script, but with      */
/* extension .log, The file must exist in order to be written.               */
/* ------------------------------------------------------------------------- */
LOGSAY: PROCEDURE

 LogId       = '[#]';
 TimeStamp   = TRANSLATE( 'abcd/ef/gh', DATE('S'), 'abcdefgh') TIME()':';

 PARSE ARG Line;
 PARSE SOURCE . . CallName;
 LogFile = OVERLAY( '.log', CallName, LASTPOS( '.', CallName));
 IF (FileExist( LogFile)) THEN
 DO
    rc = LINEOUT( LogFile, TimeStamp Line);
    rc = LINEOUT( LogFile);
 END;

 SAY LogId Line;
 RETURN( 0);

