/* REXX ================================================================ */
/*                                                                       */
/* ProgrammName     : Mx_Conf.Cmd                                        */
/* ErstellungsDatum : 11.11.1996                                         */
/*                                                                       */
/* Autor            : Gert Massheimer                                    */
/* eMail            : GertMassheimer@swol.de     2:2476/62@fidonet       */
/*                                                                       */
/* Funktion         : Aktualisiert aus einer Maximus-3.x-kompatiblen     */
/*                    FileArea.CTL eine MxUtil.Cfg fr den MxBuck-       */
/*                    Requestprozessor. Als RequestLevel wird A fr ALL  */
/*                    eingestellt. (CD-Areas werden bercksichtigt!)     */
/*                                                                       */
/*                    Es knnen Pfade vorgegeben werden, welche          */
/*                      a) nicht bercksichtigt werden.                  */
/*                      b) Passwortgeschtzt sind.                       */
/*                                                                       */
/*                    Die MxUtil.Cfg kann wahlweise automatisch aktuali- */
/*                    siert werden oder eine temporre geschrieben wer-  */
/*                    den.                                               */
/*                                                                       */
/* Syntax           : OS/2-Rexx                                          */
/* Letzte nderung  : 01.09.1997                                         */
/*                                                                       */
/* ===================================================================== */

/* Rexx initialisieren */

 If RxFuncQuery('SysLoadFuncs') then do
   Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   Call SysLoadFuncs
 End

/* Fehlerauswertung */

 Signal on Halt                            /*  Abbruch bei Fehler        */
 Signal on NoValue                         /*  Leere Variable            */
 Signal on Syntax                          /*  Falsche Befehls-Syntax    */


/* --------------------------------------------------------------------- */
/* Einstellungen bitte vorher genau prfen und ggf. anpassen!            */
/* --------------------------------------------------------------------- */

 /* Verzeichnisse excluden (vom Request ausnehmen) ===================== */
 /* (Diese Verzeichnisse werden in der FileArea.CTL miachtet!) ======== */

 ExcludeDir.0  = 10                /* Anzahle der auszuschlieenden DIRs */
 ExcludeDir.1  = 'D:\Binkley\Inbound1'
 ExcludeDir.2  = 'D:\Binkley\Inbound2'
 ExcludeDir.3  = 'D:\Binkley\Inbound3'
 ExcludeDir.4  = 'D:\Binkley\Inbound4'
 ExcludeDir.5  = 'D:\Binkley\Inbound5'
 ExcludeDir.6  = 'D:\Binkley\In-Prot1'
 ExcludeDir.7  = 'D:\Binkley\In-Prot2'
 ExcludeDir.8  = 'D:\Binkley\In-Prot3'
 ExcludeDir.9  = 'D:\Binkley\In-Prot4'
 ExcludeDir.10 = 'D:\Binkley\In-Prot5'

 /* Pawortgeschtzte Verzeichnisse ==================================== */

 ProtDir.0 = 2                            /* Anzahl der geschtzten DIRs */
 ProtDir.1 = 'D:\File\Uncheck'            /* Verzeichnis                 */
 PWD.1     = '!Point'                     /* !Pawort                    */
 ProtDir.2 = 'E:\BBS\File\X-Rated'
 PWD.2     = '!X-Rate'

 /* FLSearch.CTL festlegen ============================================= */

 FileCTL = 'D:\Max\FileArea.CTL'     /* Max-3.x-kompatible FileArea.CTL. */


 /* MxUtil.Cfg festlegen =============================================== */

 MxU_Cfg = 'D:\Binkley\MxBuck\MxUtil.Cfg'   /* Alle Eintrge auer den   */
                                            /* Kommentaren und FileArea- */
                                            /* Angaben werden bernommen */

 /* QFUtil.Cfg automatisch berschreiben =============================== */

 Refresh = 1          /* MxUtil.Cfg wird bei 1 automatisch ersetzt.      */
                      /* Bei 0 wird stattdessen nur eine temporre Datei */
                      /* angelegt, welche dann umbenannt werden mu.     */

 AutoUpdate = 1      /* Bei 1 wird das evt. vorhandene Area.Tmp ersetzt. */
                     /* Mu = 1 sein wenn Refresh = 1 ist!               */

Main:
/* --------------------------------------------------------------------- */
/* Hauptprogramm                                                         */
/* --------------------------------------------------------------------- */

 If Stream(FileCTL, 'C', 'Query Exist') = '' then do
   Say '1B'x'[1;31;40m' " Couldn't find" FileCTL
   Say '1B'x'[1;31;40m' ' Please check FileCTL configuration...'
   Exit
 End

 If Stream(MxU_Cfg, 'C', 'Query Exist') = '' then do
   Say '1B'x'[1;31;40m' " Couldn't find" MxU_Cfg
   Say '1B'x'[1;31;40m' ' Please check QFUtil.Cfg configuration...'
   Exit
 End

 CurDir = Directory()
 TmpFile = CurDir || '\Area.Tmp'

 Say '';
 Say ' Mx_Conf.CMD (c) by Gert Massheimer [2:2476/62]'
 Say '';

 If AutoUpdate \= 1 then do
   Say ' Die Datei "Area.Tmp" wird im aktuellen Verzeichnis erstellt!'
   Say '';
 End
 Else Say ' Erstelle' MxU_Cfg

 If AutoUpdate \= 1 then do
   If Exist(TmpFile) then do
     Say ' Achtung! Im akt. Verzeichnis existiert bereits eine Datei mit dem'
     Say ' Namen "Area.Tmp"!'
     Say ''; Say '';
     Call CharOut, ' berschreiben oder abbrechen (/a)? '
     Key = SysGetKey()
     If Translate(Key) = 'A' then Exit
      Else Call SysFileDelete TmpFile
   End
 End
 Else Call SysFileDelete TmpFile

 If Refresh \= 1 then do
   Say ' Area.Tmp in MxUtil.Cfg umbennen und ggf. ins MxBuck-Verzeichnis kopieren.'
   Say ' Bitte FileArea-Eintrge prfen und ggf. ungewollte Zeilen lschen!'
   Say '';
   Call CharOut, ' Bitte eine Taste drcken um fortzufahren...'
   Call SysGetKey
 End

 Call Stream FileCTL, 'C', 'Open Read'
 Call Stream TmpFile, 'C', 'Open Write'
 IF Refresh \= 1 then do
   Call Lineout TmpFile, '; Area.Tmp erstellt von Mx_Conf.CMD (c) by Gert Massheimer [2:2476/62]'
   Call Lineout TmpFile, '; Area.Tmp in MxUtil.Cfg umbennen und ggf. ins MxBuck-Verzeichnis kopieren.'
 End
 Else
   Call Lineout TmpFile, '; MxUtil.Cfg erstellt von Mx_Conf.CMD (c) by Gert Massheimer [2:2476/62]'
 Call Lineout TmpFile, '; Datum:' Date() '    Uhrzeit:' Time()
 Call Lineout TmpFile, ';'
 Call Stream MxU_Cfg, 'C', 'Open Read'
 Do while Lines(MxU_Cfg)
   MxULine = LineIn(MxU_Cfg)
   If (Substr(Subword(MxULine,1,1),1,1) = ";") |,
      (Subword(MxULine,1,1) = "HD") |,
      (Subword(MxULine,1,1) = "CD") then Iterate
   Call Lineout TmpFile, MxULine
 End
 Call Lineout TmpFile, ';'
 Call Lineout TmpFile, '; Definition der Fileareas HD bzw. CD'
 Call Lineout TmpFile, '; HD (CD) <A=Alle P=Protect K=Known> <Pfad> <Files.BBS> <{!}PASSWORT>'
 Call Lineout TmpFile, ';'
 Call Stream MxU_Cfg, 'C', 'Close'
 FinishedArea = 1; DlPath = ''; FList = ''; ReadType = 0; LW = ''; S = '';
 Area = ''; StartLW = '';
 Do while Lines(FileCTL)
   CTLLine = LineIn(FileCTL)
   If Length(CTLLine) = 0 then Iterate
   Keyword = Strip(Translate(Word(CTLLine, 1)))
   Select
     When Keyword = 'FILEAREA' then Area   = Strip(Word(CTLLine,2))
     When Keyword = 'DOWNLOAD' then DlPath = Strip(Strip(Word(CTLLine,2)), 'T', '\')
     When Keyword = 'FILELIST' then FList  = Strip(Word(CTLLine,2))
     When Keyword = 'TYPE'     then do
       ReadType = 1
       CTLLine = Translate(CTLLine)
       Do I = 1 to Words(CTLLine)
         If Word(CTLLIne, I) = 'CD' then LW = 'CD'
       End I
      End
     When Keyword = 'END'      then do
       Excluded = 0
       Do E = 1 to ExcludeDir.0
         ExcludeDir.E = Translate(ExcludeDir.E)
         If Translate(DLPath) = ExcludeDir.E then Excluded = 1
       End E
       Protected = 0
       Do P = 1 to ProtDir.0
         ProtDir.P = Translate(ProtDir.P)
         If Translate(DLPath) = ProtDir.P then do
           Protected = 1; PWD = PWD.P
           Leave
         End
       End P
       If Excluded = 0 then do
         If Protected = 0 then PWD = ''
         If LW \= 'CD' then StartLW = 'HD A'
         Else StartLW = 'CD A'
         If FList = '' then OutLine = StartLW DlPath || '\  ' DlPath || '\Files.Bbs' PWD
         Else OutLine = StartLW DlPath || '\  ' FList PWD
         S = Spinny(S, 'Schreibe Area:' Area)
         Call LineOut TmpFile, OutLine
         DlPath = ''; FList = ''; ReadType = 0; LW = ''; Area = ''; StartLW = '';
       End
      End
     Otherwise Iterate
   End
 End
 Call Stream TmpFile, 'C', 'Close'
 Call Stream FileCTL, 'C', 'Close'

 If Refresh = 1 then do
   '@Copy' TmpFile MxU_Cfg '>nul 2>nul'
   Call SysFileDelete TmpFile
 End

Exit


/* --------------------------------------------------------------------- */
/* Unterprogramme und Funktionen                                         */
/* --------------------------------------------------------------------- */

Exist:
  Parse Arg SearchFile
  Call SysFileTree SearchFile, 'SSFile', 'F'
  If SSFile.0 = 0 then ExistFile = 0
  Else ExistFile = 1
Return ExistFile

Spinny: Procedure
 Parse Arg S, Text
 If \(Datatype(S, 'W')) then S = 4
 S = (S // 8) + 1
 If S = 1 then Spin = '-'
   Else if S = 2 then Spin = '\'
     Else if S = 3 then Spin = '|'
       Else if S = 4 then Spin = '/'
         Else if S = 5 then Spin = '-'
           Else if S = 6 then Spin = '\'
             Else if S = 7 then Spin = '|'
               Else Spin = '/'
 Call CharOut , ' 'Spin Text '0D'x
Return S
/* --------------------------------------------------------------------- */
/* Fehlerauswertung                                                      */
/* --------------------------------------------------------------------- */

Halt:
  Say '1B'x'[1;31;40m'               /* Setze Farbe hell Rot auf Schwarz */
  Say 'Programm angehalten in Zeile:' sigl'.'
  Bad_Code = sigl
  Signal Bad_Running

NoValue:
  Say '1B'x'[1;31;40m'               /* Setze Farbe hell Rot auf Schwarz */
  Say 'Fehlender Wert in Zeile:' sigl'.'
  Say 'Die fehlerhafte Variable ist:' Condition('Description')
  Bad_Code = sigl
  Signal Bad_Running

Syntax:
  Say '1B'x'[1;31;40m'               /* Setze Farbe hell Rot auf Schwarz */
  Say 'Program Syntax Fehler in Zeile:' sigl'.'
  Say 'Die Fehlernummer ist' RC', was bedeutet "'Errortext(RC)'"'
  Bad_Code = sigl
  Signal Bad_Running

Bad_Running:
  Say '1B'x'[1;31;40m'               /* Setze Farbe hell Rot auf Schwarz */
  Say 'Der Fehler ist: "'Sourceline(Bad_Code)'"'
  Say '1B'x'[0;36;40m'                   /* Setze Farbe Cyan auf Schwarz */
  Say 'Du kannst nun debuggen wenn Du willst.'
  Trace ?R
  Signal Main

