//----------------------------------------//
//                                        //
//  PDE Desktop Environment (OS/2)        //
//  http://os2progg.by.ru/pde             //
//                                        //
//  PDE English to Russian dictionary     //
//  Copyleft [PDE Team] 2004              //
//                                        //
//----------------------------------------//

Unit Unit2;

Interface

Uses
  Classes, Forms, Graphics, ExtCtrls, StdCtrls, Buttons, PMWin, XplorBtn
  , Unit5;

Type
  TShortForm = Class (TForm)
    MenuItem7: TMenuItem;
    mExit1: TMenuItem;
    edRu: TEdit;
    Shape1: TShape;
    Shape2: TShape;
    bClose: TExplorerButton;
    bMenu: TExplorerButton;
    bFullSize: TExplorerButton;
    Shape3: TShape;
    Shape4: TShape;
    Shape5: TShape;
    Bevel5: TBevel;
    mOpenIn: TMenuItem;
    MenuItem2: TMenuItem;
    Label1: TLabel;
    edEng: TEdit;
    mOnTop: TMenuItem;
    MenuItem4: TMenuItem;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    Bevel4: TBevel;
    bGo: TButton;
    LabHint: TLabel;
    PopupMenu1: TPopupMenu;
    mPaste1: TMenuItem;
    PopupMenu2: TPopupMenu;
    mCopy1: TMenuItem;
    mAbout: TMenuItem;
    MenuItem5: TMenuItem;
    mFullMode: TMenuItem;
    MenuItem3: TMenuItem;
    mAddWord: TMenuItem;
    MenuItem1: TMenuItem;
    mAutoSearch: TMenuItem;
    pMenu: TPopupMenu;
    Procedure mOpenInOnClick (Sender: TObject);
    Procedure mOnTopOnClick (Sender: TObject);
    Procedure Label1OnClick (Sender: TObject);
    Procedure mCopy1OnClick (Sender: TObject);
    Procedure mPaste1OnClick (Sender: TObject);
    Procedure ShortFormOnCloseQuery (Sender: TObject; Var CanClose: Boolean);
    Procedure bGoOnClick (Sender: TObject);
    Procedure edEngOnEnter (Sender: TObject);
    Procedure edEngOnScan (Sender: TObject; Var KeyCode: TKeyCode);
    Procedure edEngOnChange (Sender: TObject);
    Procedure ShortFormOnMouseMove (Sender: TObject; Shift: TShiftState;
      X: LongInt; Y: LongInt);
    Procedure ShortFormOnMouseDown (Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X: LongInt; Y: LongInt);
    Procedure bMenuOnClick (Sender: TObject);
    Procedure mAutoSearchOnClick (Sender: TObject);
    Procedure mAddWordOnClick (Sender: TObject);
    Procedure mFullModeOnClick (Sender: TObject);
    Procedure mAboutOnClick (Sender: TObject);
    Procedure mExitOnClick (Sender: TObject);
    Procedure ShortFormOnShow (Sender: TObject);
    Procedure ShortFormOnCreate (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
  End;

Var
  ShortForm: TShortForm;
  X1, Y1: Integer;

Implementation

uses
  Unit1, Unit3, Unit4;

Procedure TShortForm.mOpenInOnClick (Sender: TObject);
var
  t: String;
Begin

  {open new window with translation}
  if edEng.Text = '' then exit;

  Application.CreateForm (TViewForm, ViewForm);
  ViewForm.Caption := 'ᬮ: '+LabHint.Caption;
  ViewForm.LabWord.Caption := LabHint.Caption;
  ViewForm.mWord.Clear;
  t := edRu.Text;
  while pos('  ', t) <> 0 do
    begin
    ViewForm.mWord.Lines.Add(copy(t, 1, pos('  ', t)));
    delete(t, 1, pos('  ', t)+1);
    end;
  ViewForm.mWord.Lines.Add(t);
  ViewForm.Show;

End;

Procedure TShortForm.mOnTopOnClick (Sender: TObject);
Begin

  mOnTop.Checked := not(mOnTop.Checked);
  FullForm.mOnTop1.Checked := mOnTop.Checked;

  if mOnTop.Checked then
    begin
    WinSetWindowULong(Frame.Handle, QWL_STYLE
      , WinQueryWindowULong(Frame.Handle, QWL_STYLE) or $200000);
    WinSetWindowULong(FullForm.Frame.Handle, QWL_STYLE
      , WinQueryWindowULong(FullForm.Frame.Handle, QWL_STYLE) or $200000);
    end
  else
    begin
    WinSetWindowULong(Frame.Handle, QWL_STYLE
      , WinQueryWindowULong(Frame.Handle, QWL_STYLE) - $200000);
    WinSetWindowULong(FullForm.Frame.Handle, QWL_STYLE
      , WinQueryWindowULong(FullForm.Frame.Handle, QWL_STYLE) - $200000);
    end;

End;

Procedure TShortForm.Label1OnClick (Sender: TObject);
Begin

  if edEng.Text <> '' then
    begin
    edRu.Text := FindTranslation(edEng.Text);
    edRu.Hint := edRu.Text;
    LabHint.Show;
    end;

End;

Procedure TShortForm.mCopy1OnClick (Sender: TObject);
Begin

  edRu.CopyToClipboard;

End;

Procedure TShortForm.mPaste1OnClick (Sender: TObject);
Begin

  edEng.PasteFromClipboard;

End;

Procedure TShortForm.ShortFormOnCloseQuery (Sender: TObject;
  Var CanClose: Boolean);
Begin

  //save settings and exit
  if not Visible then exit;

  SaveSettings;
  FreeResources;
  Application.Terminate;
  CanClose := True;

End;

Procedure TShortForm.bGoOnClick (Sender: TObject);
Begin

  if edEng.Text <> '' then
    begin

    edRu.Text := FindTranslation(edEng.Text);
    edRu.Hint := edRu.Text;
    LabHint.Show;

    end;

End;

Procedure TShortForm.edEngOnEnter (Sender: TObject);
Begin

  bGo.Default := True;

End;

Procedure TShortForm.edEngOnScan (Sender: TObject; Var KeyCode: TKeyCode);
Begin

//  if KeyCode = kbEnter then


End;

Procedure TShortForm.edEngOnChange (Sender: TObject);
Begin

  if (edEng.Text <> '') and (mAutoSearch.Checked) then
    begin

    edRu.Text := FindTranslation(edEng.Text);
    LabHint.Show;

    end
  else
    LabHint.Hide;

End;

Procedure TShortForm.ShortFormOnMouseMove (Sender: TObject; Shift: TShiftState;
  X: LongInt; Y: LongInt);
Begin

  if ssLeft in Shift then
  begin
    Left := Left - X1 + X;
    Bottom := Bottom - Y1 + Y;
    //Application.ProcessMessages;
  end;

End;

Procedure TShortForm.ShortFormOnMouseDown (Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X: LongInt; Y: LongInt);
Begin

  X1 := X;
  Y1 := Y;

End;

Procedure TShortForm.bMenuOnClick (Sender: TObject);
Begin

  { show menu}
  pMenu.Popup(Screen.MousePos.X, Screen.MousePos.Y);

End;

Procedure TShortForm.mAutoSearchOnClick (Sender: TObject);
Begin

  {"auto search"}
  mAutoSearch.Checked := not(mAutoSearch.Checked);
  FullForm.mAutoSearch1.Checked := mAutoSearch.Checked;

End;

Procedure TShortForm.mAddWordOnClick (Sender: TObject);
Begin

  //show "add word dialog"
  AddWordForm.edEng1.Text := '';
  AddWordForm.edRu1.Text := '';

  if AddWordForm.ShowModal = cmOk then
    begin //add word to user's dictionary
    AddNewWord(AddWordForm.edEng1.Text, AddWordForm.edRu1.Text);
    end;

End;

Procedure TShortForm.mFullModeOnClick (Sender: TObject);
Begin

  //goto to full mode (FullForm)
  Hide;
  FullForm.Right := Right;
  FullForm.Bottom := Bottom;
  FullForm.Show;

End;

Procedure TShortForm.mAboutOnClick (Sender: TObject);
Begin

  {about ...}
  AboutForm.ShowModal;

End;

Procedure TShortForm.mExitOnClick (Sender: TObject);
Begin

  //save settings and exit
  SaveSettings;
  FreeResources;
  Application.Terminate;

End;

Procedure TShortForm.ShortFormOnShow (Sender: TObject);
Begin

  mAutoSearch.Checked := FullForm.mAutoSearch1.Checked;
  Height := 75;
  ActiveControl := edEng;

End;

Procedure TShortForm.ShortFormOnCreate (Sender: TObject);
Begin

  BorderStyle := bsStealth;

End;

Initialization
  RegisterClasses ([TShortForm, TEdit, TLabel, TButton, TPopupMenu,
    TMenuItem, TBevel, TShape, TExplorerButton]);
End.
