//----------------------------------------//
//                                        //
//  PDE Desktop Environment (OS/2)        //
//  http://os2progg.by.ru/pde             //
//                                        //
//  PDE common dialogs DLL                //
//  Copyleft [PDE Team] 2004              //
//                                        //
//----------------------------------------//

Unit Unit7;

Interface

Uses
  Classes, Forms, Graphics, os2def, pmwin, //pmgpi,
  ExtCtrls, StdCtrls, Buttons, TabCtrls, SysUtils, pdeNLS;

Type
  TAboutDlg = Class (TForm)
    pBox: TPaintBox;
    LName: TLabel;
    bClose: TButton;
    tsTabs: TTabSet;
    pPanel: TPanel;
    mInfo: TMemo;

    imgLogo: HPointer; {pointer to ICON, BITMAP, METAFILE}

    about: String; {file names}
    authors: String;
    thanks: String;
    licensefile: String;

    Procedure PaintBox1OnPaint (Sender: TObject; Const rec: TRect);
    Procedure AboutDlgOnCreate (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
    Procedure TabsChange(Sender: TObject; NewTab: LongInt;
      Var AllowChange: Boolean);
  End;

Var
  AboutDlg: TAboutDlg;

//about, authors, thanks, license <- are file names
function pdeAboutDialogS(about, authors, thanks, cptn, text, license: String; logo: HPointer): Integer;

//about <- array of String; authors, thanks, license <- are file names
//function pdeAboutDialogA(about: array of String; authors, thanks, cptn, text, license: String; logo: HPointer): Integer;

Implementation

function pdeAboutDialogS(cptn, text, about, authors, thanks, license: String; logo: HPointer): Integer;
begin

  {about dialog: about, authors, thanks, license <- file names}
  //Application.Create;

  AboutDlg := TAboutDlg.Create(Application.MainForm);
  AboutDlg.Caption := cptn;
  AboutDlg.lName.Caption := text;
  AboutDlg.ImgLogo := Logo;

  AboutDlg.licensefile := license;
  AboutDlg.about := about;
  AboutDlg.authors := authors;
  AboutDlg.thanks := thanks;

  AboutDlg.mInfo.BeginUpdate;
  if FileExists(about) then
    AboutDlg.mInfo.Lines.LoadFromFile(about);
  AboutDlg.mInfo.EndUpdate;

  Result := 0;

  if AboutDlg.ShowModal = cmClose then
    Result := 0;

  if AboutDlg<>nil then
    AboutDlg.Free;

  //Application.Destroy;

end;

Procedure TAboutDlg.PaintBox1OnPaint (Sender: TObject; Const rec: TRect);
var
  ps: hPS;
//  si: HPOINTER;
Begin

  {render image in "ImgLogo" pointer}
  pBox.canvas.fillrect(pBox.Canvas.ClipRect, color);
  ps := WinGetPS(pBox.Handle);

  WinDrawPointer( ps, 0, 0, ImgLogo, 0);

  //si := WinGetSysBitmap(HWND_DESKTOP, SBMP_DRIVE);
  //WinDrawPointer( ps, 0, 0, si, 0);
  //GPIDeleteBitmap(si);

  WinReleasePS(ps);

End;

Procedure TAboutDlg.AboutDlgOnCreate (Sender: TObject);
Begin

  BorderStyle := bsDialog;

  Caption := pdeLoadNLS('dlgAboutProgram', ' ணࠬ');

  bClose.Caption := pdeLoadNLS('dlgCloseButton', '');

  tsTabs.tabs.add(pdeLoadNLS('dlgAboutProgram', ' ணࠬ'));
  tsTabs.tabs.add(pdeLoadNLS('dlgAboutAuthors', ''));
  tsTabs.tabs.add(pdeLoadNLS('dlgAboutThanks', '୮'));
  tsTabs.tabs.add(pdeLoadNLS('dlgAboutLicense', '業'));
  tsTabs.UnselectedColor := clDlgWindow;
  tsTabs.SelectedColor := clWindow;
  tsTabs.OnChange := TabsChange;

End;

Procedure TAboutDlg.TabsChange(Sender: TObject; NewTab: LongInt;
  Var AllowChange: Boolean);
Begin

mInfo.Lines.Clear;

  case newtab of
  0:
    begin
    mInfo.BorderStyle := bsNone;
    if about <> '' then
      begin
      mInfo.BeginUpdate;
      if FileExists(about) then
        mInfo.Lines.LoadFromFile(about);
      mInfo.EndUpdate;
      end;
    end;
  1:
    begin
    mInfo.BorderStyle := bsSingle;
    if thanks <> '' then
      begin
      mInfo.BeginUpdate;
      if FileExists(authors) then
        mInfo.Lines.LoadFromFile(authors);
      mInfo.EndUpdate;
      end;
    end;
  2:
    begin
    mInfo.BorderStyle := bsSingle;
    if thanks <> '' then
      begin
      mInfo.BeginUpdate;
      if FileExists(thanks) then
        mInfo.Lines.LoadFromFile(thanks);
      mInfo.EndUpdate;
      end;
    end;
  3:
    begin
    mInfo.BorderStyle := bsSingle;
    if licensefile <> '' then
      begin
      mInfo.BeginUpdate;
      if FileExists(licensefile) then
        mInfo.Lines.LoadFromFile(licensefile);
      mInfo.EndUpdate;
      end;
    end;
  end;

End;

Initialization
  RegisterClasses ([TAboutDlg, TPaintBox, TLabel, TButton, TTabSet, TPanel,
    TMemo]);
End.
