//----------------------------------------//
//                                        //
//  PDE Desktop Environment (OS/2)        //
//  http://os2progg.by.ru/pde             //
//                                        //
//  PDE common dialogs DLL                //
//  Copyleft [PDE Team] 2004              //
//                                        //
//----------------------------------------//

Unit Unit1;

Interface

Const
  DLL_VERSION = 1;

Uses
  Classes, Forms, Graphics, pdenls, Buttons, StdCtrls, ExtCtrls
  , os2def, pmwin;

Type
  TMsgForm = Class (TForm)
    bCancel: TButton;
    MsgLab: TLabel;
    pBox: TPaintBox;
    bOK: TButton;
    Procedure pBoxOnPaint (Sender: TObject; Const rec: TRect);
    Procedure MsgFormOnCreate (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
    bmp: hpointer;
  End;

Var
  MsgForm: TMsgForm;

function DllVer: Integer;
function pdeMessageBoxOK(text, cptn: String; bmp: hpointer): Integer;
function pdeMessageBox(text, cptn: String; bmp: hpointer): Integer;

Implementation

function DllVer: Integer;
begin
  {return DLL version}
  Result := DLL_VERSION;
end;

function pdeMessageBoxOK(text, cptn: String; bmp: hpointer): Integer;
begin

  {show dialog window with caption, text, bitmap and [OK] button}
//  Application.Create;
  MsgForm := TMsgForm.Create(nil);
  MsgForm.Caption := cptn;
  MsgForm.MsgLab.Caption := text;
  MsgForm.bCancel.Caption := pdeLoadNLS('dlgOkButton', 'OK');
  MsgForm.bmp := bmp;
  MsgForm.ShowModal;
  MsgForm.Free;
  Result := 0;
//  Application.Destroy;

end;

function pdeMessageBox(text, cptn: String; bmp: hpointer): Integer;
begin

  {show dialog window with caption, text, bitmap and [OK, CANCEL] buttons}
//  Application.Create;
  MsgForm := TMsgForm.Create(nil);
  MsgForm.Caption := cptn;
  MsgForm.MsgLab.Caption := text;
  MsgForm.bOK.Visible := True;
  MsgForm.bOK.Caption := pdeLoadNLS('dlgOkButton', 'OK');
  MsgForm.bCancel.Caption := pdeLoadNLS('dlgCancelButton', '⬥');
  MsgForm.bmp := bmp;
  Result := 1;
  if msgForm.ShowModal = cmOk then
    Result := 0;

  MsgForm.Free;
//  Application.Destroy;

end;

Procedure TMsgForm.pBoxOnPaint (Sender: TObject; Const rec: TRect);
var
  ps: hPS;
Begin
  {render image in "bmp" pointer}
  pBox.canvas.fillrect(pBox.Canvas.ClipRect, color);
  ps := WinGetPS(pBox.Handle);
  WinDrawPointer( ps, 0, 0, bmp, 0);
  WinReleasePS(ps);

End;

Procedure TMsgForm.MsgFormOnCreate (Sender: TObject);
Begin
  BorderStyle := bsStealthDlg;
End;

Initialization
  RegisterClasses ([TMsgForm, TButton, TLabel, TPaintBox]);
End.
