/*
 * JMFontDialog.java
 *
 * Created on March 7, 2009, 9:40 PM
 * JMFontDialog is a font chooser for Java
 * Copyright (C) 2009 Jeff Robinson
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
package anecho.gui;

import java.awt.Color;
import java.awt.Font;

/**
 * @version $Id: JMFontDialog.java,v 1.1 2009/03/17 02:25:24 jeffnik Exp $
 * @author  jeffnik
 */
public class JMFontDialog extends javax.swing.JDialog {

    /** Creates new form JMFontDialog
     * @param parent The parent frame for this dialog
     * @param foreGround The original foreground (font) colour to display
     * @param backGround The original background colour to display
     * @param mainFontFace The current font to use
     */
    public JMFontDialog(java.awt.Frame parent, java.awt.Color foreGround, java.awt.Color backGround, java.awt.Font mainFontFace) {
        super(parent, true);
        fgColour = foreGround;
        bgColour = backGround;
        currentFont = mainFontFace;

        initComponents();

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        final javax.swing.JLabel nameL = new javax.swing.JLabel();
        final javax.swing.JLabel styleL = new javax.swing.JLabel();
        final javax.swing.JLabel sizeL = new javax.swing.JLabel();
        final javax.swing.JButton fontColourB = new javax.swing.JButton();
        final javax.swing.JButton backgroundColourB = new javax.swing.JButton();
        final javax.swing.JScrollPane jScrollPane1 = new javax.swing.JScrollPane();
        final javax.swing.JButton okayB = new javax.swing.JButton();
        final javax.swing.JButton cancelB = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("anecho/gui/guiBundle"); // NOI18N
        setTitle(bundle.getString("JMFontDialog.title")); // NOI18N
        getContentPane().setLayout(new java.awt.GridBagLayout());

        nameL.setText(bundle.getString("JMFontDialog.nameL.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(nameL, gridBagConstraints);

        styleL.setText(bundle.getString("JMFontDialog.styleL.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(styleL, gridBagConstraints);

        sizeL.setText(bundle.getString("JMFontDialog.sizeL.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(sizeL, gridBagConstraints);

        java.awt.GraphicsEnvironment ge = java.awt.GraphicsEnvironment.getLocalGraphicsEnvironment();
        final String[] names = ge.getAvailableFontFamilyNames();
        for (int i = 0; i < names.length; i++) {
            fontNameCB.addItem(names[i]);
        }

        // Select current font
        fontNameCB.setSelectedItem(currentFont.getName());
        fontNameCB.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                fontNameCBItemStateChanged(evt);
            }
        });
        fontNameCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fontNameCBActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(fontNameCB, gridBagConstraints);

        fontStyleCB.addItem("Plain");
        fontStyleCB.addItem("Bold");
        fontStyleCB.addItem("Italic");
        fontStyleCB.addItem("Bold & Italic");

        fontStyleCB.setSelectedIndex(currentFont.getStyle());
        fontStyleCB.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                fontStyleCBItemStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(fontStyleCB, gridBagConstraints);

        for (int fs = 6; fs < 41; fs++) {
            fontSizeCB.addItem(Integer.toString(fs));
        }

        fontSizeCB.setSelectedIndex(currentFont.getSize() - 6);
        fontSizeCB.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                fontSizeCBItemStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(fontSizeCB, gridBagConstraints);

        fontColourB.setText(bundle.getString("JMFontDialog.fontColourB.text")); // NOI18N
        fontColourB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fontColourBActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(fontColourB, gridBagConstraints);

        backgroundColourB.setText(bundle.getString("JMFontDialog.backgroundColourB.text")); // NOI18N
        backgroundColourB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                backgroundColourBActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(backgroundColourB, gridBagConstraints);

        jScrollPane1.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);

        sampleTA.setColumns(20);
        sampleTA.setRows(5);
        sampleTA.setText(bundle.getString("JMFontDialog.sampleTA.text")); // NOI18N
        setSampleText();
        jScrollPane1.setViewportView(sampleTA);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(jScrollPane1, gridBagConstraints);

        okayB.setText(bundle.getString("JMFontDialog.okayB.text")); // NOI18N
        okayB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okayBActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(okayB, gridBagConstraints);

        cancelB.setText(bundle.getString("JMFontDialog.cancelB.text")); // NOI18N
        cancelB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelBActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(cancelB, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents
    private void fontColourBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fontColourBActionPerformed
        final Color tempColour = callColourChooser("Font Colour", fgColour);
        if (tempColour != null) {
            fgColour = tempColour;
            setSampleText();
        }
    }//GEN-LAST:event_fontColourBActionPerformed

    private void backgroundColourBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_backgroundColourBActionPerformed
        final Color tempColour = callColourChooser("Background Colour", bgColour);

        if (tempColour != null) {
            bgColour = tempColour;
            setSampleText();
        }

    }//GEN-LAST:event_backgroundColourBActionPerformed

    private void okayBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okayBActionPerformed
        setNewColour();
        setVisible(false);
        dispose();
    }//GEN-LAST:event_okayBActionPerformed

    private void cancelBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelBActionPerformed
        setCancelledColour();
        setVisible(false);
        dispose();
    }//GEN-LAST:event_cancelBActionPerformed

    private void fontNameCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fontNameCBActionPerformed
        setSampleText();
    }//GEN-LAST:event_fontNameCBActionPerformed

    private void fontNameCBItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_fontNameCBItemStateChanged
        setSampleText();
    }//GEN-LAST:event_fontNameCBItemStateChanged

    private void fontStyleCBItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_fontStyleCBItemStateChanged
        setSampleText();
    }//GEN-LAST:event_fontStyleCBItemStateChanged

    private void fontSizeCBItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_fontSizeCBItemStateChanged
        setSampleText();
    }//GEN-LAST:event_fontSizeCBItemStateChanged

    /**
     * Apply the new colour and face as chosen by the user
     */
    private void setNewColour() {
        // Get information from fontBody and fontStyle, and apply them

        final String body = fontNameCB.getSelectedItem().toString();
        final int style = fontStyleCB.getSelectedIndex();
        final int fSize = Integer.parseInt(fontSizeCB.getSelectedItem().toString());
        currentFont = new Font(body, style, fSize);
    }

    /** Set our currentFont to null, so we know the user
     * cancelled any changes that were made */
    private void setCancelledColour() {
        currentFont = (Font) null;
    }

    /**
     * Return our font
     * @return 
     */
    public Font getFontStyle() {
        return currentFont;
    }

    /**
     * Return the foreground (text) colour.
     * @return The colour of our text
     */
    public Color getForegroundColour() {
        return fgColour;
    }

    /**
     * Returns the background colour (negative space around the text).
     * @return Returns the background colour.
     */
    public Color getBackgroundColour() {
        return bgColour;
    }

    /** Show the JColorChooser and return the selected colour */
    private Color callColourChooser(final String title, final Color initialColour) {
        Color retColour = new Color(0, 0, 0);

        retColour = javax.swing.JColorChooser.showDialog(this, title, initialColour);

        return retColour;
    }

    /**
     * Update the sample text to show the currently selected font style and colour
     */
    private void setSampleText() {
        // final int body = fontBody.getSelectedIndex();
        final String body = fontNameCB.getSelectedItem().toString();
        final int style = fontStyleCB.getSelectedIndex();
        final int fSize = Integer.parseInt(fontSizeCB.getSelectedItem().toString());
        final Font tempFont = new Font(body, style, fSize);
        sampleTA.setBackground(bgColour);
        sampleTA.setForeground(fgColour);
        sampleTA.setFont(tempFont);
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private final transient javax.swing.JComboBox fontNameCB = new javax.swing.JComboBox();
    private final transient javax.swing.JComboBox fontSizeCB = new javax.swing.JComboBox();
    private final transient javax.swing.JComboBox fontStyleCB = new javax.swing.JComboBox();
    private final transient javax.swing.JTextArea sampleTA = new javax.swing.JTextArea();
    // End of variables declaration//GEN-END:variables
    /**
     * The background colour used with the selected font
     */
    private transient Color bgColour;
    /**
     * The colour to be applied to the selected font
     */
    private transient Color fgColour;
    /**
     * The font face to use for our currently selected font
     */
    private transient Font currentFont;
}
