package anecho.extranet.event;

import java.util.EventObject;

/**
 * TelnetEvent is an event passed along to any class registered as a 
 * TelnetEventListener
 */
public class TelnetEvent extends EventObject {

    private transient String _IACMessage;
    private static final boolean DEBUG = false;

    /**
     * 
     * @param source 
     * @param IACMessage 
     */
    public TelnetEvent( Object source, String IACMessage ) {
        super( source );
        _IACMessage = IACMessage;
    }

    /**
     * Returns a String of the current telnet event.
     * @return A String representing the current Telnet event.
     */
    public String getMessage() {
        if (DEBUG) {
            System.err.println("TelnetEvent.getMessage() " + _IACMessage);
        }
        return _IACMessage;
    }

    /**
     * 
     * @param message 
     */
    public void sendMessage(final String message) {
        _IACMessage = message;
        if (DEBUG) {
            System.err.println("TelnetEvent.sendMessage() " + _IACMessage);
        }
    }
    
}
