/*
 * TimeStampGUI.java
 *
 * Created on December 7, 2007, 5:51 PM
 */

package anecho.JamochaMUD.plugins.TimeStampDir;

/**
 * This is the GUI that allows users to define their own time-stamp
 * format.  Formats are based on the Java's SimpleDateFormat.
 * @author Jeff Robinson
 */
public class TimeStampGUI extends javax.swing.JDialog {
    
    /**
     * Creates new form TimeStampGUI
     * @param parent This is the parent frame for this dialogue.
     * @param modal Indicates whether this dialog is modal (yes, it is) or not.
     */
    public TimeStampGUI(java.awt.Frame parent, boolean modal) {
    
        super(parent, modal);
        initComponents();
    }
    
    /**
     * This returns the existing instance of this GUI.
     * @param parentClass This is the class that calls the GUI.  This may now
     * be redundant.  Fix Me XXX
     * @return Returns the instance of the TimeStampGUI, ensuring that
     * we cannot have more than one TimeStampGUI at a time.
     */
    public static synchronized TimeStampGUI getInstance(final anecho.JamochaMUD.plugins.TimeStamp parentClass) {
        if (_instance==null) {
            final anecho.JamochaMUD.JMConfig config = anecho.JamochaMUD.JMConfig.getInstance();
            final java.awt.Frame mainFrame = config.getJMFrame(anecho.JamochaMUD.JMConfig.MAINWINDOWVARIABLE);
            
            _instance = new TimeStampGUI(mainFrame, true);
        }
        
        return _instance;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        final javax.swing.JButton okayButton = new javax.swing.JButton();
        final javax.swing.JButton cancelButton = new javax.swing.JButton();
        final javax.swing.JLabel formatLabel = new javax.swing.JLabel();
        formatText = new javax.swing.JTextField();
        final javax.swing.JButton sampleButton = new javax.swing.JButton();
        sampleDisplay = new javax.swing.JLabel();
        final javax.swing.JScrollPane timePane = new javax.swing.JScrollPane();
        final javax.swing.JTable timeTable = new javax.swing.JTable();
        final javax.swing.JLabel exampleLabel = new javax.swing.JLabel();
        final javax.swing.JLabel example1 = new javax.swing.JLabel();
        final javax.swing.JLabel example2 = new javax.swing.JLabel();
        final javax.swing.JLabel example3 = new javax.swing.JLabel();
        final javax.swing.JLabel example4 = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/TimeStampDir/Bundle"); // NOI18N
        setTitle(bundle.getString("Time_Stamp_options")); // NOI18N
        getContentPane().setLayout(new java.awt.GridBagLayout());

        okayButton.setText(bundle.getString("Okay")); // NOI18N
        okayButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okayButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.insets = new java.awt.Insets(15, 0, 10, 0);
        getContentPane().add(okayButton, gridBagConstraints);

        cancelButton.setText(bundle.getString("Cancel")); // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new java.awt.Insets(15, 0, 10, 0);
        getContentPane().add(cancelButton, gridBagConstraints);

        formatLabel.setText(bundle.getString("Date_format:")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 2, 0);
        getContentPane().add(formatLabel, gridBagConstraints);

        formatText.setColumns(20);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 2, 2, 0);
        getContentPane().add(formatText, gridBagConstraints);

        sampleButton.setText(bundle.getString("Show_sample")); // NOI18N
        sampleButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sampleButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(sampleButton, gridBagConstraints);

        sampleDisplay.setText(bundle.getString("Click_Show_Sample_to_see_a_sample_here.")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 0);
        getContentPane().add(sampleDisplay, gridBagConstraints);

        timeTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {"H", "Hour in Day (0-23)", "y", "Year"},
                {"k", "Hour in Day (1-24)", "M", "Month in Year"},
                {"K", "Hour in Day (0 - 11)", "d", "Day in Month"},
                {"h", "Hour in Day (1 - 12)", "E", "Day in Week"},
                {"m", "Minute in hour", null, null},
                {"s", "Second in minute", null, null},
                {"a", "am/pm marker", null, null}
            },
            new String [] {
                "Time Variable", "Value", "Date Variable", "Value"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, false, false, false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        timePane.setViewportView(timeTable);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 10, 0);
        getContentPane().add(timePane, gridBagConstraints);

        exampleLabel.setText(bundle.getString("Examples:")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(exampleLabel, gridBagConstraints);

        example1.setText(bundle.getString("(HH:mm:ss)_displays:_(23:12:34)")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(example1, gridBagConstraints);

        example2.setText(bundle.getString("->hh:mm:ss_a<-_displays:_->11:12:34_pm<-")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(example2, gridBagConstraints);

        example3.setText(bundle.getString("HH:mm:ss_YY-MM-DD_displays:_23:12:34_2007-12-08")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(example3, gridBagConstraints);

        example4.setText(bundle.getString("EEEE,_MMMM_DD,_YY_hh:mm:ss_a_displays:_Saturday,_December_9,_2007_11:12:34_pm")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(example4, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void okayButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okayButtonActionPerformed
        this.setVisible(false);
        
    }//GEN-LAST:event_okayButtonActionPerformed
    
    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        // The user has cancelled any changes
        formatText.setText("");
        this.setVisible(false);
        this.dispose();
    }//GEN-LAST:event_cancelButtonActionPerformed
    
    private void sampleButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sampleButtonActionPerformed
        displaySample();
    }//GEN-LAST:event_sampleButtonActionPerformed
    
    /**
     * This method returns the time format that is currently displayed
     * in the GUI.
     * @return A String containing the time format to be used by TimeStamp.
     */
//    public static void main(String args[]) {
//        java.awt.EventQueue.invokeLater(new Runnable() {
//            public void run() {
//                new TimeStampGUI(new javax.swing.JFrame(), true).setVisible(true);
//            }
//        });
//    }
    
    public String getTimeStamp() {
        String timeFormat = formatText.getText();
        
        if (timeFormat == null || timeFormat.equals("")) {
            // There is no time format present.  Return a default
            
            timeFormat = "";
            
        }
        
        return timeFormat;
    }

    /**
     * Sets the time format shown in the GUI.
     * @param inStamp A String representing the time format to display.
     */
    public void setTimeStamp(final String inStamp) {
        String stamp;
        
        if (inStamp == null || inStamp.equals("")) {
            stamp = "(HH:mm:ss)";
        } else {
            stamp = inStamp;
        }
        
        formatText.setText(stamp);
    }
    
    /**
     * Displays the sample format of the time
     */
    private void displaySample() {
        final String timeFormat = formatText.getText();
        
        if (timeFormat == null || timeFormat.equals("")) {
            // There is no time format present.
            // We may want to give the user a message to this nature
            // Fix Me XXX
            return;
        }
        
        final java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(timeFormat);
        final java.util.Calendar cal = java.util.Calendar.getInstance();
        final String timeStr = sdf.format(cal.getTime());
        
        sampleDisplay.setText(timeStr);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private transient javax.swing.JTextField formatText;
    private transient javax.swing.JLabel sampleDisplay;
    // End of variables declaration//GEN-END:variables
    
    /** The instance of this class */
    private static TimeStampGUI _instance;
}
