/*
 * MusicBoxGUI.java
 *
 * Created on November 11, 2004, 10:40 PM
 */

package anecho.JamochaMUD.plugins.MusicBoxDir;

/**
 *
 * @author  Jeff Robinson
 */
public class MusicBoxAWTGUI extends java.awt.Dialog {
    
    /**
     * Creates new form MusicBoxGUI
     * @param parent 
     * @param modal 
     */
    public MusicBoxAWTGUI(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        playingLabel = new java.awt.Label();
        playingTF = new java.awt.TextField();
        browseButton = new java.awt.Button();
        displayLabel = new java.awt.Label();
        displayTF = new java.awt.TextField();
        ctrlLabel = new java.awt.Label();
        ctrlCB = new java.awt.Checkbox();
        shiftCB = new java.awt.Checkbox();
        altCB = new java.awt.Checkbox();
        ctrlTF = new java.awt.TextField();
        fileContents = new java.awt.TextArea(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/MusicBoxDir/MusicBoxBundle").getString(""), 50, 6, java.awt.TextArea.SCROLLBARS_VERTICAL_ONLY);
        okayButton = new java.awt.Button();
        cancelButton = new java.awt.Button();

        setLayout(new java.awt.GridBagLayout());

        setTitle(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/MusicBoxDir/MusicBoxBundle").getString("MusicBox_Properties"));
        playingLabel.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/MusicBoxDir/MusicBoxBundle").getString("Playing_file"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(7, 7, 3, 3);
        add(playingLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(7, 3, 3, 3);
        add(playingTF, gridBagConstraints);

        browseButton.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/MusicBoxDir/MusicBoxBundle").getString("Browse..."));
        browseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(7, 3, 3, 7);
        add(browseButton, gridBagConstraints);

        displayLabel.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/MusicBoxDir/MusicBoxBundle").getString("Display"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 7, 3, 3);
        add(displayLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 7);
        add(displayTF, gridBagConstraints);

        ctrlLabel.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/MusicBoxDir/MusicBoxBundle").getString("Control_Key:"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 7, 3, 3);
        add(ctrlLabel, gridBagConstraints);

        ctrlCB.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/MusicBoxDir/MusicBoxBundle").getString("CTRL_+"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(ctrlCB, gridBagConstraints);

        shiftCB.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/MusicBoxDir/MusicBoxBundle").getString("Shift_+"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(shiftCB, gridBagConstraints);

        altCB.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/MusicBoxDir/MusicBoxBundle").getString("Alt_+"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(altCB, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 7);
        add(ctrlTF, gridBagConstraints);

        fileContents.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/MusicBoxDir/MusicBoxBundle").getString("MusicBoxInstructions"));
        fileContents.setEditable(false);
        fileContents.setRows(7);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 7, 3, 7);
        add(fileContents, gridBagConstraints);

        okayButton.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/MusicBoxDir/MusicBoxBundle").getString("Okay"));
        okayButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okayButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(7, 7, 7, 7);
        add(okayButton, gridBagConstraints);

        cancelButton.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/MusicBoxDir/MusicBoxBundle").getString("Cancel"));
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(7, 7, 7, 7);
        add(cancelButton, gridBagConstraints);

        pack();
    }//GEN-END:initComponents

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        this.setVisible(false);
        this.dispose();
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void okayButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okayButtonActionPerformed
        this.setVisible(false);
        this.dispose();
        okayStatus = true;
    }//GEN-LAST:event_okayButtonActionPerformed

    private void browseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseButtonActionPerformed
        // java.awt.Frame pFrame = settings.getJMFrame(JMConfig.MUCKMAINFRAME);
        final java.awt.Window tempWin = (java.awt.Window)this;
        final java.awt.Frame pFrame = (java.awt.Frame)tempWin;
        // java.awt.Frame pFrame = new java.awt.Frame();
        final java.awt.FileDialog jfc = new java.awt.FileDialog(pFrame, java.util.ResourceBundle.getBundle("anecho/JamochaMUD/plugins/MusicBoxDir/MusicBoxBundle").getString("Playing_file_to_open"));
        
        final String tempPlay = playingTF.getText();
        
        if (!tempPlay.equals("")) {
            // java.io.File sFile = new java.io.File(tempPlay);
            // jfc.setSelectedFile(sFile);
            jfc.setFile(tempPlay);
        }
        
        // int retVal = jfc.showOpenDialog(this);
        jfc.setVisible(true);
        
        // if (retVal == javax.swing.JFileChooser.APPROVE_OPTION) {
        if (jfc.getFile() != null) {
            playingTF.setText(jfc.getFile());
        }

    }//GEN-LAST:event_browseButtonActionPerformed
    
    /**
     * 
     * @return 
     */
    public String getPlayFile() {
        return playingTF.getText();
    }
   
    /**
     * 
     * @param playFile 
     */
    public void setPlayFile(final String playFile) {
        if (playFile != null) {
            playingTF.setText(playFile);
        }
    }
    
    /**
     * 
     * @return 
     */
    public String getDispLine() {
        return displayTF.getText();
    }
    
    /**
     * 
     * @param dispLine 
     */
    public void setDispLine(final String dispLine) {
        if (dispLine != null) {
            displayTF.setText(dispLine);
        }
    }
    
    /**
     * 
     * @return 
     */
    public boolean isOkay() {
        return okayStatus;
    }

    /**
     * 
     * @param ctrlKey 
     */
    public void setCTRLKey(final char ctrlKey) {
        ctrlTF.setText(ctrlKey + "");
    }

    /**
     * 
     * @return 
     */
    public char getCTRLKey() {
        final String ctrl = ctrlTF.getText().trim();
        char retVal;

        if (ctrl.length() > 0) {
            retVal = ctrl.charAt(0);
        } else {
            retVal = '\u0000';
        }

        return retVal;
    }

    /**
     * 
     * @param useCTRL 
     */
    public void setUseCTRL(final boolean useCTRL) {
        ctrlCB.setState(useCTRL);
    }

    /**
     * 
     * @return 
     */
    public boolean useCTRL() {
        return ctrlCB.getState();
    }

    /**
     * 
     * @param useSHIFT 
     */
    public void setUseSHIFT(final boolean useSHIFT) {
        shiftCB.setState(useSHIFT);
    }

    /**
     * 
     * @return 
     */
    public boolean useSHIFT() {
        return shiftCB.getState();
    }

    /**
     * 
     * @param useALT 
     */
    public void setUseALT(final boolean useALT) {
        altCB.setState(useALT);
    }

    /**
     * 
     * @return 
     */
    public boolean useALT() {
        return altCB.getState();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private java.awt.Checkbox altCB;
    private java.awt.Button browseButton;
    private java.awt.Button cancelButton;
    private java.awt.Checkbox ctrlCB;
    private java.awt.Label ctrlLabel;
    private java.awt.TextField ctrlTF;
    private java.awt.Label displayLabel;
    private java.awt.TextField displayTF;
    private java.awt.TextArea fileContents;
    private java.awt.Button okayButton;
    private java.awt.Label playingLabel;
    private java.awt.TextField playingTF;
    private java.awt.Checkbox shiftCB;
    // End of variables declaration//GEN-END:variables
    private boolean okayStatus = false;
}
