/*
 * MuckConn.java
 *
 * Created on April 30, 2005, 9:32 PM
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2005  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package anecho.JamochaMUD.legacy;

import anecho.JamochaMUD.*;

/**
 *
 * @author  jeffnik
 */
public class MuckConnAWT extends java.awt.Dialog {
    
    /**
     * Creates new form MuckConn
     * @param settings 
     */
    public MuckConnAWT(JMConfig settings) {
        super(settings.getJMFrame(JMConfig.MUCKMAINFRAME), true);
        this.settings = settings;
//        editName = settings.getJMVector(JMConfig.MUCKNAME);
//        editAddy = settings.getJMVector(JMConfig.MUCKADDY);
//        editPort = settings.getJMVector(JMConfig.MUCKPORT);
        
                // This vector contains all our MuckInfo classes
        muckList = settings.getJMVector(JMConfig.MUCKLIST);

        initComponents();
        
        java.awt.Point tPoint = anecho.gui.PosTools.findCenter();
        java.awt.Dimension tSize= this.size();
        this.setLocation(tPoint.x - (int)(tSize.width/2) , tPoint.y - (int)(tSize.height/2));
        
        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jmMUNames = new java.awt.Choice();
        compileNames();
        topRowPanel = new java.awt.Panel();
        connButton = new java.awt.Button();
        addButton = new java.awt.Button();
        removeButton = new java.awt.Button();
        buttomRowPanel = new java.awt.Panel();
        editButton = new java.awt.Button();
        dontButton = new java.awt.Button();

        setLayout(new java.awt.GridBagLayout());

        setTitle(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("JamochaMUDConnector"));
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jmMUNames, gridBagConstraints);

        connButton.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("connect"));
        connButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                connButtonActionPerformed(evt);
            }
        });

        topRowPanel.add(connButton);

        addButton.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("addMU"));
        addButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addButtonActionPerformed(evt);
            }
        });

        topRowPanel.add(addButton);

        removeButton.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("removeMU"));
        removeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeButtonActionPerformed(evt);
            }
        });

        topRowPanel.add(removeButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(topRowPanel, gridBagConstraints);

        editButton.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("editMU"));
        editButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editButtonActionPerformed(evt);
            }
        });

        buttomRowPanel.add(editButton);

        dontButton.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("dontConnect"));
        dontButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dontButtonActionPerformed(evt);
            }
        });

        buttomRowPanel.add(dontButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(buttomRowPanel, gridBagConstraints);

        pack();
    }
    // </editor-fold>//GEN-END:initComponents
    
    private void dontButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dontButtonActionPerformed
        dontConnect();
    }//GEN-LAST:event_dontButtonActionPerformed
    
    private void addButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addButtonActionPerformed
        addMU();
    }//GEN-LAST:event_addButtonActionPerformed
    
    private void removeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeButtonActionPerformed
        removeMU();
    }//GEN-LAST:event_removeButtonActionPerformed
    
    private void editButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editButtonActionPerformed
        editMU();
    }//GEN-LAST:event_editButtonActionPerformed
    
    private void connButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_connButtonActionPerformed
        connectToMU();
    }//GEN-LAST:event_connButtonActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        dispose();
        
        // If the main window is not visible then we'll terminate the program.
        if (!(settings.getJMFrame(settings.MUCKMAINFRAME)).isVisible()) {
            System.exit(0);
        }
    }//GEN-LAST:event_closeDialog
    
    /**
     * Call the methods necessary for the user to add
     * a new MUD/MUCK to the list of worlds
     */
    private void addMU() {
        
        
        // Call the AddEdit box
//        final AddEdit addMU = new AddEdit(settings.getJMFrame(JMConfig.MUCKMAINFRAME), java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("addMU"));
//        addMU.setLocation(anecho.gui.PosTools.findCenter(this, addMU));
//        addMU.setVisible(true);
//        
//        if (addMU.isOkay()) {
//            final String jmEditName = addMU.getName();
//            final String jmEditAddy = addMU.getAddress();
//            // final String jmEditPort = addMU.getPort();
//            final int jmEditPort = addMU.getPort();
//            
//            jmEditName.trim();
//            jmEditAddy.trim();
//            // jmEditPort.trim();
//            
//            // if (!jmEditName.equals("") && !jmEditAddy.equals("") && !jmEditPort.equals("")) {
//            if (!jmEditName.equals("") && !jmEditAddy.equals("") && (jmEditPort > 0)) {
//                // Check to see if the first entry is a 'valid'
//                // MU*, or just a place-marker
//                if ((settings.getJMVector(JMConfig.MUCKNAME)).size() < 1) {
//                    jmMUNames.removeAll();
//                }
//                
//                // Add the new entry to the list of available MU*s
//                editName.addElement(jmEditName);
//                editAddy.addElement(jmEditAddy);
//                editPort.addElement(jmEditPort + "");
//                jmMUNames.addItem(jmEditName + " (" + jmEditAddy + " Port: " + jmEditPort + ")");
//                // Put new vector into the hashtable
//                settings.setJMValue(JMConfig.MUCKNAME, editName);
//                settings.setJMValue(JMConfig.MUCKADDY, editAddy);
//                settings.setJMValue(JMConfig.MUCKPORT, editPort);
//                
//                // Display new MU* in choice
//                jmMUNames.select(jmMUNames.getItemCount() - 1);
//                connButton.requestFocus();
//                
//            }
//        }

                boolean okaySelect = false;
            String jmEditName = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("");
            String jmEditAddy = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("");
            int jmEditPort;
            boolean jmEditSSL = false;
        
        // Call the AddEdit box
          final AddEdit addMU = new AddEdit(settings.getJMFrame(JMConfig.MUCKMAINFRAME), java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("addMU"));
        addMU.setLocation(anecho.gui.PosTools.findCenter(this, addMU));
        addMU.setVisible(true);

//        final AddEdit addMU = new AddEdit(settings.getJMFrame(JMConfig.MUCKMAINFRAME), java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("addMU"));
//        addMU.setLocation(anecho.gui.PosTools.findCenter(this, addMU));
//        addMU.setVisible(true);
        okaySelect = addMU.isOkay();
            jmEditName = addMU.getName();
            jmEditAddy = addMU.getAddress();
            jmEditPort = addMU.getPort();
            jmEditSSL = addMU.isSSL();
        
        if (okaySelect) {
            
            jmEditName.trim();
            jmEditAddy.trim();
            
            if (!jmEditName.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("")) && !jmEditAddy.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("")) && (jmEditPort > 0)) {
                // Check to see if the first entry is a 'valid'
                // MU*, or just a place-marker
                if (DEBUG) {
                    System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Doing_a_check_to_see_if_would_should_empty_the_'placeholder'_first."));
                    // System.err.println("Our MUCKNAME vector has " + (settings.getJMVector(JMConfig.MUCKNAME)).size() + " elements");
                    System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Our_MUCKLIST_vector_has_") + (settings.getJMVector(JMConfig.MUCKLIST)).size() + java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("_elements"));
                }
                
                // if ((settings.getJMVector(JMConfig.MUCKNAME)).size() < 1) {
                if ((settings.getJMVector(JMConfig.MUCKLIST)).size() < 1) {
                    if (DEBUG) {
                        System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Removing_our_placeholder_(and_all_other_elements)_from_our_list."));
                    }
                    // jmMUNames.removeAllItems();
                    jmMUNames.removeAll();
                }
                
                // Add the new entry to the list of available MU*s
                final MuckInfo tempMU = new MuckInfo();
                tempMU.setName(jmEditName);
                tempMU.setAddress(jmEditAddy);
                tempMU.setPort(jmEditPort);
                tempMU.setSSL(jmEditSSL);
                
                jmMUNames.addItem(jmEditName + java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("_(") + jmEditAddy + java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("_Port:_") + jmEditPort + java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString(")"));

                // Add the new MU* to our vector and then update that in our settings
                muckList.addElement(tempMU);
                settings.setJMValue(JMConfig.MUCKLIST, muckList);

                // Display new MU* in choice
                // jmMUNames.setSelectedIndex(jmMUNames.getItemCount() - 1);
                jmMUNames.select(jmMUNames.getItemCount() -1);
                connButton.requestFocus();
                
                
            }
        }

    }
    
    /**
     * Remove the currently selected MUD/MUCK from the list
     * of available worlds (and the .jamocha.rc file).
     */
    private void removeMU() {
        // Remove MU* from list
//        java.util.Vector muckName = new java.util.Vector(0, 1);
//        java.util.Vector muckAddy = new java.util.Vector(0, 1);
//        java.util.Vector muckPort = new java.util.Vector(0, 1);
//        
//        muckName = settings.getJMVector(JMConfig.MUCKNAME);
//        muckAddy = settings.getJMVector(JMConfig.MUCKADDY);
//        muckPort = settings.getJMVector(JMConfig.MUCKPORT);
//        
//        muckName.removeElementAt(jmMUNames.getSelectedIndex());
//        muckAddy.removeElementAt(jmMUNames.getSelectedIndex());
//        muckPort.removeElementAt(jmMUNames.getSelectedIndex());
//        
//        if (muckName.size() < 1) {
//            jmMUNames.removeAll();
//            muckName.addElement("None");
//            muckAddy.addElement(blank);
//            muckPort.addElement(blank);
//            jmMUNames.addItem("None (" + blank + " Port: " + blank + ")");
//        } else {
//            jmMUNames.remove(jmMUNames.getSelectedIndex());
//        }
//        
//        // Now place the vectors back in the Hashtable
//        settings.setJMValue(JMConfig.MUCKNAME, muckName);
//        settings.setJMValue(JMConfig.MUCKADDY, muckAddy);
//        settings.setJMValue(JMConfig.MUCKPORT, muckPort);
                // Remove MU* from list
        
        muckList.removeElementAt(jmMUNames.getSelectedIndex());
        
        if (muckList.size() < 1) {
            jmMUNames.removeAll();
            jmMUNames.addItem(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("None_(") + blank + java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("_Port:_") + blank + java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString(")"));
        } else {
            // jmMUNames.removeItemAt(jmMUNames.getSelectedIndex());
            jmMUNames.remove(jmMUNames.getSelectedIndex());
        }
        
        // Now place the vectors back in the Hashtable
        settings.setJMValue(JMConfig.MUCKLIST, muckList);

    }
    
    /**
     * The user has opted to connect to the currently selected
     * MUD/MUCK, so we honour their wishes here!
     */
    private void connectToMU() {
        
//        java.util.Vector tempAddy = new java.util.Vector(0, 1);
//        java.util.Vector tempPort = new java.util.Vector(0, 1);
//        
//        tempAddy = settings.getJMVector(JMConfig.MUCKADDY);
//        tempPort = settings.getJMVector(JMConfig.MUCKPORT);
//        
//        if (tempAddy.size() < 1) {
//            // We don't have any valid MU*'s listed
//            return;
//        }
//        
//        if (DEBUG) {
//            System.err.println("MuckConn.JMConnectToMU setVisible(false)");
//        }
//        
//        final java.awt.Frame mainFrame = settings.getJMFrame(JMConfig.MUCKMAINFRAME);
//        
//        if (!mainFrame.isVisible()) {
//            mainFrame.setVisible(true);
//        }
//        
//        final int selection = jmMUNames.getSelectedIndex();
//        
//        chosenName = editName.elementAt(selection).toString();
//        finalAddress = tempAddy.elementAt(selection).toString();
//        chosenPort = (Integer.parseInt(tempPort.elementAt(selection).toString()));
//        
//        settings.setJMValue(JMConfig.CONNMUCK, finalAddress);
//        settings.setJMValue(JMConfig.CONNPORT, chosenPort);
//        settings.setJMValue(JMConfig.LASTMU, jmMUNames.getSelectedItem());
//        
//        setVisible(false);
//        
//        // We only want to set the Main Layout once
//        if (!settings.getJMboolean(JMConfig.MAINLAYOUTVALID)) {
//            // (settings.getMainWindowVariable()).setMainLayout();
//            MuckMain.getInstance().setMainLayout();
//        }
//        
//        settings.setJMValue(JMConfig.MUCKCONNVISIBLE, false);
//        
//        if (DEBUG) {
//            System.err.println("MuckConn.JMConnectToMU returning focus to main frame.");
//        }
//        
//        mainFrame.requestFocus();
                if (muckList.size() < 1) {
            // We don't have any valid MU*'s listed
            return;
        }
        
        if (DEBUG) {
            System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("MuckConn.JMConnectToMU_setVisible(false)"));
        }
        
        final java.awt.Frame mainFrame = settings.getJMFrame(JMConfig.MUCKMAINFRAME);
        
        if (!mainFrame.isVisible()) {
            mainFrame.setVisible(true);
        }
        
        final int selection = jmMUNames.getSelectedIndex();

        if (DEBUG) {
            System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Our_selected_index_is_") + selection);
            // System.err.println("Our vector has " + editName.size());
            System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Our_vector_has_") + muckList.size() + java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("_entries"));
        }
        
        final MuckInfo tempMU = (MuckInfo)muckList.elementAt(selection);
//        chosenName = editName.elementAt(selection).toString();
//        finalAddress = tempAddy.elementAt(selection).toString();
//        chosenPort = (Integer.parseInt(tempPort.elementAt(selection).toString()));
        
        chosenName = tempMU.getName();
        finalAddress = tempMU.getAddress();
        chosenPort = tempMU.getPort();
        boolean chosenSSL = tempMU.getSSL();
        
        settings.setJMValue(JMConfig.CONNMUCK, finalAddress);
        settings.setJMValue(JMConfig.CONNPORT, chosenPort);
        settings.setJMValue(JMConfig.LASTMU, jmMUNames.getSelectedItem());
        settings.setJMValue(JMConfig.CONNSSL, chosenSSL);
        
        setVisible(false);
        
        // We only want to set the Main Layout once
        // Is this necessary?  Fix Me XXX
//        if (!settings.getJMboolean(JMConfig.MAINLAYOUTVALID)) {
//            (settings.getMainWindowVariable()).setMainLayout();
//        }
        
        settings.setJMValue(JMConfig.MUCKCONNVISIBLE, false);
        
        if (DEBUG) {
            System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("MuckConn.JMConnectToMU_returning_focus_to_main_frame."));
        }
        
        mainFrame.requestFocus();

    }
    
    /**
     * Call the methods to allow the user to edit the MUD/MUCK
     * Name/address/port of the currently selected world
     */
    private void editMU() {
        // edit current MU* entry
//        final AddEdit editBox = new AddEdit(settings.getJMFrame(JMConfig.MUCKMAINFRAME), java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("editMU"));
//        
//        final int index = jmMUNames.getSelectedIndex();
//        editBox.setName((String)editName.elementAt(index));
//        editBox.setAddress((String)editAddy.elementAt(index));
//        editBox.setPort((String)editPort.elementAt(index));
//        editBox.setLocation(anecho.gui.PosTools.findCenter(this, editBox));
//        editBox.setVisible(true);
//        
//        // Call the AddEdit box
//        
//        if (editBox.isOkay()) {
//            final String jmEditName = editBox.getName();
//            final String jmEditAddy = editBox.getAddress();
//            // final String jmEditPort = editBox.getPort();
//            final int jmEditPort = editBox.getPort();
//            
//            jmEditName.trim();
//            jmEditAddy.trim();
//            // jmEditPort.trim();
//            
//            // if (!jmEditName.equals("") && !jmEditAddy.equals("") && !jmEditPort.equals("")) {
//            if (!jmEditName.equals("") && !jmEditAddy.equals("") && (jmEditPort > 0)) {
//                // Replace the edited MU* info
//                editName.removeElementAt(index);
//                editAddy.removeElementAt(index);
//                editPort.removeElementAt(index);
//                
//                editName.insertElementAt(jmEditName, index);
//                editAddy.insertElementAt(jmEditAddy, index);
//                editPort.insertElementAt(jmEditPort + "", index);
//                
//                // Put new vector into the hashtable
//                settings.setJMValue(JMConfig.MUCKNAME, editName);
//                settings.setJMValue(JMConfig.MUCKADDY, editAddy);
//                settings.setJMValue(JMConfig.MUCKPORT, editPort);
//                
//                // Replace the choice entry
//                jmMUNames.remove(index);
//                jmMUNames.insert(jmEditName + " (" + jmEditAddy + " Port: " + jmEditPort + ")", index);
//                jmMUNames.select(index);
//                connButton.requestFocus();
//                
//            }
//        }
                // edit current MU* entry
        final AddEdit editBox = new AddEdit(settings.getJMFrame(JMConfig.MUCKMAINFRAME), java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("editMU"));
        
        final int index = jmMUNames.getSelectedIndex();
//        editBox.setName((String)editName.elementAt(index));
//        editBox.setAddress((String)editAddy.elementAt(index));
//        editBox.setPort((String)editPort.elementAt(index));
        final MuckInfo tempMU = (MuckInfo)muckList.elementAt(index);
        editBox.setName(tempMU.getName());
        editBox.setAddress(tempMU.getAddress());
        // editBox.setPort(tempMU.getPort() + "");
        editBox.setPort(Integer.toString(tempMU.getPort()));
        editBox.setSSL(tempMU.getSSL());
        
        editBox.setLocation(anecho.gui.PosTools.findCenter(this, editBox));
        editBox.setVisible(true);
        
        // Call the AddEdit box
        
        if (editBox.isOkay()) {
            final String jmEditName = editBox.getName();
            final String jmEditAddy = editBox.getAddress();
            // final String jmEditPort = editBox.getPort();
            final int jmEditPort = editBox.getPort();
            final boolean jmEditSSL = editBox.isSSL();
            
            jmEditName.trim();
            jmEditAddy.trim();
            // jmEditPort.trim();
            
            // if (!jmEditName.equals("") && !jmEditAddy.equals("") && !jmEditPort.equals("")) {
            if (!jmEditName.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("")) && !jmEditAddy.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("")) && (jmEditPort > 0)) {
                // Replace the edited MU* info
                muckList.removeElementAt(index);
                // Re-use our tempMU object to hold the new settings
                tempMU.setName(jmEditName);
                tempMU.setAddress(jmEditAddy);
                tempMU.setPort(jmEditPort);
                tempMU.setSSL(jmEditSSL);
                
                // Put our new tempMU into the muckList
                muckList.insertElementAt(tempMU, index);
                
                // Put new vector into the hashtable
//                settings.setJMValue(JMConfig.MUCKNAME, editName);
//                settings.setJMValue(JMConfig.MUCKADDY, editAddy);
//                settings.setJMValue(JMConfig.MUCKPORT, editPort);
                
                // Put the updated muckList into our configuration file
                settings.setJMValue(JMConfig.MUCKLIST, muckList);
                
                // Replace the choice entry
                jmMUNames.remove(index);
                // jmMUNames.insertItemAt(jmEditName + " (" + jmEditAddy + " Port: " + jmEditPort + ")", index);
                jmMUNames.insert(jmEditName + java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("_(") + jmEditAddy + java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("_Port:_") + jmEditPort + java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString(")"), index);
                // jmMUNames.setSelectedIndex(index);
                jmMUNames.select(index);
                connButton.requestFocus();
            }
        }
    }
    
    /**
     * Compile the MU* names
     * and then write them into the
     * choice of jmMCFrame
     */
    private void compileNames() {
        // First grab the vectors
//        java.util.Vector muckAddy = new java.util.Vector(0, 1);
//        java.util.Vector muckName = new java.util.Vector(0, 1);
//        java.util.Vector muckPort = new java.util.Vector(0, 1);
//        
//        muckName = settings.getJMVector(JMConfig.MUCKNAME);
//        muckAddy = settings.getJMVector(JMConfig.MUCKADDY);
//        muckPort = settings.getJMVector(JMConfig.MUCKPORT);
//        
//        /* We have no listed MU*'s, so we'll put in a default */
//        if (muckName.size() < 1) {
//            muckName.addElement("None");
//            muckAddy.addElement(blank);
//            muckPort.addElement(blank);
//        }
//        
//        for (int i=0; i < muckName.size(); i++) {
//            jmMUNames.addItem(muckName.elementAt(i) + " (" + muckAddy.elementAt(i) + " Port: " + muckPort.elementAt(i) + ")");
//        }
//        
//        
//        // Set the 'focus' on the last-selected MU*
//        if (settings.getJMString(JMConfig.LASTMU) != null) {
//            jmMUNames.select(settings.getJMString(JMConfig.LASTMU));
//        }
                // First grab the vectors
        
        muckList = new java.util.Vector(0, 1);
        muckList = settings.getJMVector(JMConfig.MUCKLIST);
        
        MuckInfo tempMU;
        
        // for (int i=0; i < muckName.size(); i++) {
        for (int i=0; i < muckList.size(); i++) {
            tempMU = (MuckInfo)muckList.elementAt(i);
            jmMUNames.addItem(tempMU.getName() + java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("_(") + tempMU.getAddress() + java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("_Port:_") + tempMU.getPort());
        }
        
        
        // Set the 'focus' on the last-selected MU*
        if (settings.getJMString(JMConfig.LASTMU) != null) {
            jmMUNames.select(settings.getJMString(JMConfig.LASTMU));
            // jmMUNames.setSelectedItem(settings.getJMString(JMConfig.LASTMU));
            
        }

    }
    
    /**
     *
     * @return
     */
    public String getName() {
        return chosenName;
    }
    
    /**
     *
     * @return
     */
    public String getAddress() {
        return finalAddress;
    }
    
    /**
     *
     * @return
     */
    public int getPort() {
        return chosenPort;
    }
    
    private void dontConnect() {
        setVisible(false);
        
        final java.awt.Frame mmFrame = settings.getJMFrame(JMConfig.MUCKMAINFRAME);
        if (!mmFrame.isVisible()) {
            mmFrame.setVisible(true);
        }
        
        settings.setJMValue(JMConfig.MUCKCONNVISIBLE, false);
        
        // Send the focus to out main program... just a nice thing to do
        mmFrame.requestFocus();
        
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private java.awt.Button addButton;
    private java.awt.Panel buttomRowPanel;
    private java.awt.Button connButton;
    private java.awt.Button dontButton;
    private java.awt.Button editButton;
    private java.awt.Choice jmMUNames;
    private java.awt.Button removeButton;
    private java.awt.Panel topRowPanel;
    // End of variables declaration//GEN-END:variables
    // private java.util.Vector editName = new java.util.Vector(0, 1);
    // private java.util.Vector editAddy = new java.util.Vector(0, 1);
    // private java.util.Vector editPort = new java.util.Vector(0, 1);
    final transient private JMConfig settings;
    private static final boolean DEBUG = false;
    private transient String chosenName = null;
    private transient String finalAddress = null;
    private transient int chosenPort;
    private transient final String blank = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("----");
        private transient java.util.Vector muckList = new java.util.Vector(0, 1);
        // private boolean chosenSSL = false;

}
