/**
 * FontFace (allows changing of colours and font faces)
 * New version created on August 22, 2004, 11:20 AM
 * $Id: FontFace.java,v 1.1 2009/03/17 02:41:16 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2004  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package anecho.JamochaMUD.legacy;

import anecho.JamochaMUD.*;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;

import anecho.gui.ColourPicker;

/**
 * This class supplies an interface to allow users to change font
 * face, style, size, and colour.
 * @author Jeff Robinson
 */

public class FontFace extends java.awt.Dialog {
    
    /** Creates new form FontFace */
    private FontFace(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
    }
    
    /**
     * 
     * @param parent 
     * @param foreGround 
     * @param backGround 
     * @param mainFontFace 
     */
//    public FontFace(anecho.JamochaMUD.JMConfig settings, java.awt.Frame parent, java.awt.Color foreGround, java.awt.Color backGround, java.awt.Font mainFontFace) {
    public FontFace(java.awt.Frame parent, java.awt.Color foreGround, java.awt.Color backGround, java.awt.Font mainFontFace) {
        super(parent, java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("JamochaMUD_Fonts_&_Colours"), true);
        this.parentFrame = parent;
        this.bgColour = backGround;
        this.fontColour = foreGround;
        this.currentFont = mainFontFace;
        // this.settings = settings;
        settings = JMConfig.getInstance();
        initComponents();
        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        label1 = new java.awt.Label();
        fontBody = new java.awt.Choice();
        fontStyle = new java.awt.Choice();
        label2 = new java.awt.Label();
        fontSize = new java.awt.Choice();
        label3 = new java.awt.Label();
        fontColourButton = new java.awt.Button();
        label4 = new java.awt.Label();
        bgColourButton = new java.awt.Button();
        okayButton = new java.awt.Button();
        cancelButton = new java.awt.Button();
        label5 = new java.awt.Label();
        label6 = new java.awt.Label();
        sampleText = new java.awt.TextField();

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        setLayout(new java.awt.GridBagLayout());

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle"); // NOI18N
        label1.setText(bundle.getString("Font_name")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 2, 2);
        add(label1, gridBagConstraints);

        if (settings.getJMboolean(settings.USESWING)) {
            // Swing support!
            java.awt.GraphicsEnvironment ge = java.awt.GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] names = ge.getAvailableFontFamilyNames();
            for (int i = 0; i < names.length; i++) {
                fontBody.add(names[i]);
            }
        } else {
            // No Swing support
            String[] names = java.awt.Toolkit.getDefaultToolkit().getFontList();
            for (int i = 0; i < names.length; i++) {
                fontBody.add(names[i]);
            }
        }

        // Select current font
        fontBody.select(currentFont.getName());
        fontBody.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                fontBodyItemStateChanged(evt);
            }
        });
        fontBody.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                fontBodyKeyPressed(evt);
            }
        });
        fontBody.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                fontBodyMouseClicked(evt);
            }
        });
        fontBody.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                fontBodyPropertyChange(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 2, 2, 5);
        add(fontBody, gridBagConstraints);

        fontStyle.add("Plain");
        fontStyle.add("Bold");
        fontStyle.add("Italic");
        fontStyle.add("Bold & Italic");

        fontStyle.select(currentFont.getStyle());
        fontStyle.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                fontStyleItemStateChanged(evt);
            }
        });
        fontStyle.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                fontStyleKeyPressed(evt);
            }
        });
        fontStyle.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                fontStyleMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 5);
        add(fontStyle, gridBagConstraints);

        label2.setText(bundle.getString("Font_size")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 5, 2, 2);
        add(label2, gridBagConstraints);

        for (int fs = 6; fs < 41; fs++) {
            fontSize.add(new Integer(fs).toString());
        }

        fontSize.select(currentFont.getSize() - 6);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 5);
        add(fontSize, gridBagConstraints);

        label3.setText(bundle.getString("Change")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 5, 2, 2);
        add(label3, gridBagConstraints);

        fontColourButton.setLabel(bundle.getString("Font_Colour")); // NOI18N
        fontColourButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fontColourButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 5);
        add(fontColourButton, gridBagConstraints);

        label4.setText(bundle.getString("Change")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 5, 2, 2);
        add(label4, gridBagConstraints);

        bgColourButton.setLabel(bundle.getString("Background_colour")); // NOI18N
        bgColourButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bgColourButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 5);
        add(bgColourButton, gridBagConstraints);

        okayButton.setLabel(bundle.getString("Okay")); // NOI18N
        okayButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okayButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 2, 2);
        add(okayButton, gridBagConstraints);

        cancelButton.setLabel(bundle.getString("Cancel")); // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 2, 2, 5);
        add(cancelButton, gridBagConstraints);

        label5.setText(bundle.getString("Sample_text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 2, 5);
        add(label5, gridBagConstraints);

        label6.setText(bundle.getString("Font_style")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 5, 2, 2);
        add(label6, gridBagConstraints);

        sampleText.setText(bundle.getString("The_pleasing_red_fox_sipped...")); // NOI18N
        setSampleText();
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 5, 5, 5);
        add(sampleText, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void fontStyleItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_fontStyleItemStateChanged
        setSampleText();
    }//GEN-LAST:event_fontStyleItemStateChanged

    private void fontStyleMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_fontStyleMouseClicked
        setSampleText();
    }//GEN-LAST:event_fontStyleMouseClicked

    private void fontStyleKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_fontStyleKeyPressed
        setSampleText();
    }//GEN-LAST:event_fontStyleKeyPressed

    private void fontBodyItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_fontBodyItemStateChanged
        setSampleText();
    }//GEN-LAST:event_fontBodyItemStateChanged

    private void bgColourButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bgColourButtonActionPerformed
        final Color tempColour = callColourChooser(java.util.ResourceBundle.getBundle(bundleStr).getString("Background_Colour"), bgColour);
        
        if (tempColour != null) {
            bgColour = tempColour;
            setSampleText();
        }
    }//GEN-LAST:event_bgColourButtonActionPerformed

    private void fontColourButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fontColourButtonActionPerformed
        final Color tempColour = callColourChooser(java.util.ResourceBundle.getBundle(bundleStr).getString("Font_Colour"), fontColour);

        if (tempColour != null) {
            fontColour = tempColour;
            setSampleText();
        }
    }//GEN-LAST:event_fontColourButtonActionPerformed

    private void fontBodyKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_fontBodyKeyPressed
        setSampleText();
    }//GEN-LAST:event_fontBodyKeyPressed

    private void fontBodyMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_fontBodyMouseClicked
        setSampleText();
    }//GEN-LAST:event_fontBodyMouseClicked

    private void fontBodyPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_fontBodyPropertyChange
        setSampleText();
    }//GEN-LAST:event_fontBodyPropertyChange

    private void okayButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okayButtonActionPerformed
        // TODO add your handling code here:
        jMSetNewColour();
        setVisible(false);
        dispose();
    }//GEN-LAST:event_okayButtonActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        // TODO add your handling code here:
        jMSetCancelledColour();
        setVisible(false);
        dispose();
    }//GEN-LAST:event_cancelButtonActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        jMSetCancelledColour();
        setVisible(false);
        dispose();
    }//GEN-LAST:event_closeDialog

    /**
     * Apply the new colour and face as chosen by the user
     */
    private void jMSetNewColour() {
        // Get information from fontBody and fontStyle, and apply them
        // int a = fontStyle.getSelectedIndex();
        final int body = fontBody.getSelectedIndex();
        final int style = fontStyle.getSelectedIndex();
        final int size = fontSize.getSelectedIndex() + 6;

        currentFont = new Font(fontBody.getItem(body), style, size);
    }

    /** Set our currentFont to null, so we know the user
     * cancelled any changes that were made */
    private void jMSetCancelledColour() {
        currentFont = (Font)null;
    }

    /**
     * Return our font
     * @return 
     */
    public Font getFontStyle() {
        return currentFont;
    }

    /**
     * Return the foreground (text) colour.
     * @return The colour of our text
     */
    public Color getForegroundColour() {
        return fontColour;
    }

    /**
     * Returns the background colour (negative space around the text).
     * @return Returns the background colour.
     */
    public Color getBackgroundColour() {
        return bgColour;
    }

    /** Choose the appropriate colour chooser depending on the API */
    private Color callColourChooser(final String title, final Color initialColour) {
        Color retColour = new Color(0, 0, 0);

        if (settings.getJMboolean(JMConfig.USESWING)) {
            retColour = javax.swing.JColorChooser.showDialog(parentFrame, title, initialColour);
        } else {
            final ColourPicker picker = new ColourPicker(parentFrame, title, initialColour);
            picker.setVisible(true);

            retColour = picker.getColour();
        }

        return retColour;
    }

    private void setSampleText() {
        final int body = fontBody.getSelectedIndex();
        final int style = fontStyle.getSelectedIndex();
        final Font tempFont = new Font(fontBody.getItem(body), style, 12);
        sampleText.setBackground(bgColour);
        sampleText.setForeground(fontColour);
        sampleText.setFont(tempFont);
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private java.awt.Button bgColourButton;
    private java.awt.Button cancelButton;
    private java.awt.Choice fontBody;
    private java.awt.Button fontColourButton;
    private java.awt.Choice fontSize;
    private java.awt.Choice fontStyle;
    private java.awt.Label label1;
    private java.awt.Label label2;
    private java.awt.Label label3;
    private java.awt.Label label4;
    private java.awt.Label label5;
    private java.awt.Label label6;
    private java.awt.Button okayButton;
    private java.awt.TextField sampleText;
    // End of variables declaration//GEN-END:variables
    private Font currentFont;
    private Color bgColour, fontColour;
    private anecho.JamochaMUD.JMConfig settings;
    private Frame parentFrame;
    private String bundleStr = "anecho/JamochaMUD/JamochaMUDBundle";
}
