/*
 * AddEdit.java
 *
 * Created on May 7, 2005, 4:44 PM
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2005  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package anecho.JamochaMUD.legacy;

/**
 * This class creates a dialogue box which allows users to add
 * and remove MU* listings for our MuckConnector.
 * @author jeffnik
 */
public class AddEditAWT extends java.awt.Dialog {
    
    /**
     * Creates new form AddEdit
     * @param frameParent The parent frame of this dialogue.
     * @param boxLabel The title for our dialogue box.  The same dialogue
     * is used for both adding new entries and editing
     * existing entries.  Having a specific title will give
     * the user some extra visibility as to what they are
     * doing.
     */
    public AddEditAWT(java.awt.Frame frameParent, String boxLabel) {
        super(frameParent, java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("JamochaMUD_-_") + boxLabel, true);
        
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        label1 = new java.awt.Label();
        editName = new java.awt.TextField();
        label2 = new java.awt.Label();
        editAddy = new java.awt.TextField();
        label3 = new java.awt.Label();
        editPort = new java.awt.TextField();
        panel1 = new java.awt.Panel();
        button1 = new java.awt.Button();
        button2 = new java.awt.Button();

        setLayout(new java.awt.GridBagLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        label1.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("MUname"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(7, 7, 3, 0);
        add(label1, gridBagConstraints);

        editName.setColumns(20);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(7, 0, 3, 7);
        add(editName, gridBagConstraints);

        label2.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("MUaddress"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 7, 3, 0);
        add(label2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 3, 7);
        add(editAddy, gridBagConstraints);

        label3.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("MUport"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 7, 5, 0);
        add(label3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 7);
        add(editPort, gridBagConstraints);

        panel1.setLayout(new java.awt.GridBagLayout());

        button1.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("okay"));
        button1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                button1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        panel1.add(button1, gridBagConstraints);

        button2.setLabel(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("cancel"));
        button2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                button2ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        panel1.add(button2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(7, 7, 7, 7);
        add(panel1, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    private void button2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_button2ActionPerformed
        setVisible(false);
        dispose();
    }//GEN-LAST:event_button2ActionPerformed
    
    private void button1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_button1ActionPerformed
        okayStatus = true;
        setVisible(false);
        dispose();
        
    }//GEN-LAST:event_button1ActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        dispose();
    }//GEN-LAST:event_closeDialog
    
    /**
     * Set all our variables at once *
     * @param name The name of the MU*.
     * @param address The address, either human-readable or numeric, for our MU*
     * @param port The port used to connect to our MU*.
     */
    public void setAll(final String name, final String address, final String port) {
        setName(name);
        setAddress(address);
        setPort(port);
    }
    
    /**
     * Set the name of the MU* to appear in the dialogue
     * @param name The name of the MU* to be displayed.
     */
    public void setName(final String name) {
        editName.setText(name);
    }
    
    /**
     * Set the name of the MU*'s address
     * @param address The address of the MU*, either numeric or human readable.
     */
    public void setAddress(final String address) {
        editAddy.setText(address);
    }
    
    /**
     * Set the port of the MU*
     * @param port The number of the port for the selected MU*
     */
    public void setPort(final String port) {
        editPort.setText(port);
    }
    
    /**
     * Retrieves the human-readable name of the currently displayed MU*.
     * @return A string containing the human-readable name of the MU*
     * currently being edited.
     */
    public String getName() {
        return editName.getText();
    }
    
    /**
     * This method retrieves the numeric or human-readable address of the MU*
     * that is currently being displayed.
     * @return A string representing the number or human-readable MU* address
     */
    public String getAddress() {
        return editAddy.getText();
    }
    
    /**
     * This method retrieves the port number of the currently displayed MU*.
     * @return A string representing the port number of the currently 
     * displayed MU*.
     */
    public String getPort() {
        return editPort.getText();
    }
    
    /**
     * Return a true is "Okay" was selected,
     * otherwise return a false
     * @return <CODE>true</CODE> - the user has confirmed the changes made
     * <CODE>false</CODE> - the user wishes to disregard the changes made
     */
    public boolean isOkay() {
        return okayStatus;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private java.awt.Button button1;
    private java.awt.Button button2;
    private java.awt.TextField editAddy;
    private java.awt.TextField editName;
    private java.awt.TextField editPort;
    private java.awt.Label label1;
    private java.awt.Label label2;
    private java.awt.Label label3;
    private java.awt.Panel panel1;
    // End of variables declaration//GEN-END:variables
    private boolean okayStatus = false;
}
