/*
 * World.java
 *
 * Created on September 24, 2006, 7:26 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package anecho.JamochaMUD;

import anecho.gui.EasyIconTreeNode;
import javax.swing.Icon;
import javax.swing.ImageIcon;

/**
 * This class is used to store information about Worlds in
 * JamochaMUD.  It is a extends a node so that it can easily
 * be added and manipulated in a JTree.
 * @author Jeff Robinson (jeffnik@anecho.mb.ca)
 * @version $Id: World.java,v 1.8 2009/06/16 02:38:12 jeffnik Exp $
 */
public class World extends EasyIconTreeNode {

    /**
     * The constructor for the World class.
     */
    public World() {
        super();
        // Generate a unique WorldID for this instance
        worldID = System.currentTimeMillis();
        if (DEBUG) {
            System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("World.World():_New_worldID_set_to_") + worldID);
        }

    // ImageIcon leafIcon = new ImageIcon(AddEditWorld.class.getResource("icons/22/import.png"));

    // setIcon(leafIcon);

    }

    /**
     * 
     * @param newName 
     */
    public void setWorldName(final String newName) {
        worldName = newName;
    }

    /**
     * 
     * @return 
     */
    public String getWorldName() {
        return worldName;
    }

    /**
     * 
     * @param addy 
     */
    public void setAddress(final String addy) {
        worldAddress = addy;
    }

    /**
     * 
     * @return 
     */
    public String getAddress() {
        return worldAddress;
    }

    /**
     * 
     * @param port 
     */
    public void setPort(final int port) {
        worldPort = port;
    }

    /**
     * 
     * @return 
     */
    public int getPort() {
        return worldPort;
    }

    /**
     * Returns an ID unique to this world.  The ID is generated by
     * this class upon creation of a new world, and cannot be altered.
     * This should help avoid "book-keeping" headaches.
     * @return 
     */
    public long getWorldID() {
        return worldID;
    }

    /**
     * This method should only be used if setting up a previously existing
     * world.  Otherwise a unique WorldID is set during the creation of a
     * World object.
     * @param newID 
     */
    public void setWorldID(final long newID) {
        if (DEBUG) {
            System.err.println("World.setWorldID: updating ID to " + newID);
        }

        worldID = newID;
    }

    /**
     * 
     * @param state 
     */
    public void setSSL(final boolean state) {
        worldSSL = state;
    }

    /**
     * 
     * @return 
     */
    public boolean isSSL() {
        return worldSSL;
    }

    /**
     * 
     * @param state 
     */
    public void useAutoLogin(final boolean state) {
        worldAutoLogin = state;
    }

    /**
     * 
     * @return 
     */
    public boolean isAutoLogin() {
        return worldAutoLogin;
    }

    /**
     * 
     * @param style 
     */
    public void setLoginStyle(final int style) {
        worldLoginStyle = style;
    }

    /**
     * 
     * @return 
     */
    public int getLoginStyle() {
        return worldLoginStyle;
    }

    /**
     * 
     * @param notes 
     */
    public void setNotes(final String notes) {
        worldNotes = notes;
    }

    /**
     * 
     * @return 
     */
    public String getNotes() {
        return worldNotes;
    }

    /**
     * 
     * @return 
     */
    public Icon getIcon() {
        final Icon retIcon = new ImageIcon(AddEditWorld.class.getResource("icons/22/browser.png"));

        return retIcon;
    }

    /**
     * Return a string listing the name, address, and port
     * @return 
     */
    public String toString() {
        final StringBuffer retBuff = new StringBuffer();
        retBuff.append(this.getWorldName());
        retBuff.append(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("_("));
        retBuff.append(this.getAddress());
        retBuff.append(':');
        retBuff.append(this.getPort());
        retBuff.append(')');

        return retBuff.toString();
    }

    /**
     * This method returns a code-page if the world over-rides the standard code-page
     * @return The code page to use.  If this world does not over-ride a code page, it will return null.
     */
    public String getCodePage() {
        return codePage;
    }

    /**
     * This method allows the code-page to be set, indicating that this world is to over-ride the
     * standard code-page.
     * @param codePage The codepage to set, in the format of "cp1452"
     */
    public void setCodePage(String codePage) {
        this.codePage = codePage;
    }

    /**
     * This method reports whether the standard code-page has been over-ridden
     * @return <code>true</code> The code-page over-ride has been enabled
     * <code>false</code> The code-page over-ride has not been enabled
     */
    public boolean isOverride() {
        return override;
    }

    /**
     * This method sets whether the code-page has been over-ridden or not.
     * @param override <code>true</code> The code-page should be over-ridden
     * <code>false</code> The code-page should not be over-ridden
     */
    public void setOverride(boolean override) {
        this.override = override;
    }
    /**
     * A String representing the human-readable name for this world
     */
    private String worldName = "";
    /**
     * The address, either IP or URL, that this world uses
     */
    private transient String worldAddress = "";
    /**
     * The server port that the world resides on
     */
    private transient int worldPort = 0;
    private long worldID;
    /**
     * This variable indicates whether the connection to the world should be encrypted via SSL
     */
    private transient boolean worldSSL;
    /**
     * This variable indicates whether the user wishes to automatically login to a world
     */
    private transient boolean worldAutoLogin;
    /**
     * The login style to use if auto-login is enabled
     */
    private transient int worldLoginStyle;
    /**
     * This string contains user supplied notes about the world
     */
    private transient String worldNotes = "";
    /**
     * This variable enables and disables debugging output
     */
    private static final boolean DEBUG = false;
    /**
     * If not null, this variable indicates the code-page for this world to use
     */
    private String codePage;
    /** Indicates whether the code page is over-ridden or not */
    private boolean override;
}
