/*
 * Socks.java
 *
 * Created on June 22, 2009, 8:10 PM
 * JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2009 Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package anecho.JamochaMUD.PrefPanels.Socks;

import anecho.JamochaMUD.JMConfig;
import javax.swing.JPanel;

/**
 *
 * @author  jeffnik
 */
public class Socks extends javax.swing.JPanel implements anecho.JamochaMUD.PrefPanels.PrefInterface {

    /** Creates new form Socks */
    public Socks() {
        super();
    // initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        final javax.swing.JLabel titleLabel = new javax.swing.JLabel();
        enableSocksCB = new javax.swing.JCheckBox();
        proxyAddress = new javax.swing.JTextField();
        proxyPort = new javax.swing.JTextField();
        final javax.swing.JLabel addressLabel = new javax.swing.JLabel();
        final javax.swing.JLabel portLabel = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        titleLabel.setBackground(javax.swing.UIManager.getDefaults().getColor("InternalFrame.activeTitleBackground"));
        titleLabel.setFont(new java.awt.Font("Dialog", 1, 18));
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/PrefPanels/Socks/Bundle"); // NOI18N
        titleLabel.setText(bundle.getString("Socks.titleLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 2, 5);
        add(titleLabel, gridBagConstraints);

        enableSocksCB.setText(bundle.getString("Socks.enableSocksCB.text")); // NOI18N
        enableSocksCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                enableSocksCBActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(enableSocksCB, gridBagConstraints);

        proxyAddress.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 5, 2, 5);
        add(proxyAddress, gridBagConstraints);

        proxyPort.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 5, 2, 5);
        add(proxyPort, gridBagConstraints);

        addressLabel.setText(bundle.getString("Socks.addressLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 5, 2, 5);
        add(addressLabel, gridBagConstraints);

        portLabel.setText(bundle.getString("Socks.portLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 5, 2, 5);
        add(portLabel, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void enableSocksCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_enableSocksCBActionPerformed
        setProxy(enableSocksCB.isSelected());
    }//GEN-LAST:event_enableSocksCBActionPerformed
    
    public String getModuleName() {
        return "Socks Proxy";
    }

    public JPanel loadPanel() {
        // If this panel has not be used before we'll need to init our components
        if (enableSocksCB == null) {
            // Initialise our components
            initComponents();

        // Set-up items
        // populateCB();

        }

        // Set existing preferences
        readPrefs();

        return this;

    }

    private void readPrefs() {
        final JMConfig settings = JMConfig.getInstance();
        final boolean proxyState = settings.getJMboolean(JMConfig.PROXY);

        setProxy(proxyState);
        enableSocksCB.setSelected(proxyState);

        // Regardless of if the proxy is enabled or not,
        // we want the name to show up
        proxyAddress.setText(settings.getJMString(JMConfig.PROXYHOST));
        proxyPort.setText(Integer.toString(settings.getJMint(JMConfig.PROXYPORT)));

    }

    /**
     * Enable or disable the text fields for entering proxy information
     * @param state
     */
    private void setProxy(final boolean state) {
        proxyAddress.setEnabled(state);
        proxyPort.setEnabled(state);
    }

    /**
     * Save the current settings
     */
    public void applySettings() {
        final JMConfig settings = JMConfig.getInstance();

        if (enableSocksCB != null) {

            if (DEBUG) {
                System.err.println("ProxyBox.setOkayProxy: " + enableSocksCB.isSelected());
                System.err.println("ProxyBox.setOkayProxy: " + proxyAddress.getText());
                System.err.println("ProxyBox.setOkayProxy: " + proxyPort.getName());
            }

            settings.setJMValue(JMConfig.PROXY, enableSocksCB.isSelected());
            settings.setJMValue(JMConfig.PROXYHOST, proxyAddress.getText().trim());
            settings.setJMValue(JMConfig.PROXYPORT, proxyPort.getText().trim());
        }

    }

    public boolean checkVersion() {
        return true;
    }

    public void versionWarning() {
    // This method is not used, as there are now prerequisites for this class
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private transient javax.swing.JCheckBox enableSocksCB;
    private transient javax.swing.JTextField proxyAddress;
    private transient javax.swing.JTextField proxyPort;
    // End of variables declaration//GEN-END:variables
    /**
     * Enables or disables debugging output
     */
    private static final boolean DEBUG = false;
}
