/*
 * Logging.java
 *
 * Created on July 23, 2008, 3:06PM
 * Version $Id: Logging.java,v 1.3 2009/03/17 02:41:17 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2009 Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package anecho.JamochaMUD.PrefPanels.Logging;

import anecho.JamochaMUD.JMConfig;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

/**
 *
 * @author  jeffnik
 */
public class Logging extends javax.swing.JPanel implements anecho.JamochaMUD.PrefPanels.PrefInterface {

    /** Creates new form for Logging */
    public Logging() {
        super();
        if (DEBUG) {
            System.err.println("Creating new Logging pref panel instance");
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        final javax.swing.ButtonGroup formatButtonGroup = new javax.swing.ButtonGroup();
        final javax.swing.JLabel titleLabel = new javax.swing.JLabel();
        standardLocCB = new javax.swing.JCheckBox();
        customPathTF = new javax.swing.JTextField();
        browseB = new javax.swing.JButton();
        customNameCB = new javax.swing.JCheckBox();
        final javax.swing.JLabel sampleLabel = new javax.swing.JLabel();
        customFormatRB = new javax.swing.JRadioButton();
        simpleFormatRB = new javax.swing.JRadioButton();
        customFormatTF = new javax.swing.JTextField();
        fieldCB1 = new anecho.gui.JMappedComboBox();
        fieldCB2 = new anecho.gui.JMappedComboBox();
        fieldCB3 = new anecho.gui.JMappedComboBox();
        final javax.swing.JButton resetB = new javax.swing.JButton();
        final javax.swing.JScrollPane jScrollPane1 = new javax.swing.JScrollPane();
        samplePath = new javax.swing.JTextArea();
        final javax.swing.JLabel saveNoteLabel = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        titleLabel.setBackground(javax.swing.UIManager.getDefaults().getColor("InternalFrame.activeTitleBackground"));
        titleLabel.setFont(new java.awt.Font("Dialog", 1, 18));
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/PrefPanels/CustomColours/ColourBundle"); // NOI18N
        titleLabel.setText(bundle.getString("Custom_output_colour")); // NOI18N
        titleLabel.setOpaque(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(titleLabel, gridBagConstraints);

        java.util.ResourceBundle bundle1 = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/PrefPanels/Logging/Bundle"); // NOI18N
        standardLocCB.setText(bundle1.getString("Use_custom_log_file_location")); // NOI18N
        standardLocCB.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                standardLocCBItemStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(standardLocCB, gridBagConstraints);

        customPathTF.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(customPathTF, gridBagConstraints);

        browseB.setText(bundle1.getString("Browse")); // NOI18N
        browseB.setEnabled(false);
        browseB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseBActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(browseB, gridBagConstraints);

        customNameCB.setText(bundle1.getString("Use_custom_log_file_naming_scheme")); // NOI18N
        customNameCB.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                customNameCBItemStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(customNameCB, gridBagConstraints);

        sampleLabel.setFont(new java.awt.Font("Dialog", 1, 11));
        sampleLabel.setText(bundle1.getString("Sample:")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(sampleLabel, gridBagConstraints);

        formatButtonGroup.add(customFormatRB);
        customFormatRB.setText(bundle1.getString("Enter_your_own_format")); // NOI18N
        customFormatRB.setToolTipText(bundle1.getString("Feature_in_progress..._currently_not_available.")); // NOI18N
        customFormatRB.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(customFormatRB, gridBagConstraints);

        formatButtonGroup.add(simpleFormatRB);
        simpleFormatRB.setSelected(true);
        simpleFormatRB.setText(bundle1.getString("Simple_format")); // NOI18N
        simpleFormatRB.setEnabled(false);
        simpleFormatRB.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                simpleFormatRBStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(simpleFormatRB, gridBagConstraints);

        customFormatTF.setEnabled(false);
        customFormatTF.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                customFormatTFKeyReleased(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(customFormatTF, gridBagConstraints);

        fieldCB1.setEnabled(false);
        fieldCB1.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                fieldCB1ItemStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(fieldCB1, gridBagConstraints);

        fieldCB2.setEnabled(false);
        fieldCB2.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                fieldCB2ItemStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(fieldCB2, gridBagConstraints);

        fieldCB3.setEnabled(false);
        fieldCB3.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                fieldCB3ItemStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(fieldCB3, gridBagConstraints);

        resetB.setText(bundle1.getString("Reset")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 2;
        add(resetB, gridBagConstraints);

        jScrollPane1.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);

        samplePath.setColumns(20);
        samplePath.setEditable(false);
        samplePath.setLineWrap(true);
        samplePath.setRows(5);
        samplePath.setWrapStyleWord(true);
        jScrollPane1.setViewportView(samplePath);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jScrollPane1, gridBagConstraints);

        saveNoteLabel.setText(bundle1.getString("<html>Log_settings_will_be_in_effect_for_any_new_connections.<br>Existing_connections_will_not_be_affected.</html>")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(saveNoteLabel, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents
    private void simpleFormatRBStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_simpleFormatRBStateChanged
        setComboBoxes(simpleFormatRB.isSelected());
    }//GEN-LAST:event_simpleFormatRBStateChanged

    private void browseBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseBActionPerformed
        browseDir();
    }//GEN-LAST:event_browseBActionPerformed

    private void fieldCB1ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_fieldCB1ItemStateChanged
        buildSample();
    }//GEN-LAST:event_fieldCB1ItemStateChanged

    private void fieldCB2ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_fieldCB2ItemStateChanged
        buildSample();
    }//GEN-LAST:event_fieldCB2ItemStateChanged

    private void fieldCB3ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_fieldCB3ItemStateChanged
        buildSample();
    }//GEN-LAST:event_fieldCB3ItemStateChanged

    private void customFormatTFKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_customFormatTFKeyReleased
        buildSample();
    }//GEN-LAST:event_customFormatTFKeyReleased

    private void standardLocCBItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_standardLocCBItemStateChanged
        standardLocChecked(standardLocCB.isSelected());
    }//GEN-LAST:event_standardLocCBItemStateChanged

    private void customNameCBItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_customNameCBItemStateChanged
        standardNameChecked(customNameCB.isSelected());
    }//GEN-LAST:event_customNameCBItemStateChanged

    /**
     * This method is required by our Interface to return a human-readable title for
     * our module.
     * @return A string representing the human-readable name of our module.
     */
    public String getModuleName() {
        // final String retStr = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/PrefPanels/Logging/Bundle").getString("Logging_Options");
        // return retStr;
        return java.util.ResourceBundle.getBundle("anecho/JamochaMUD/PrefPanels/Logging/Bundle").getString("Logging_Options");
    }

    public JPanel loadPanel() {

        // If this panel has not be used before we'll need to init our components
        if (fieldCB1 == null) {
            // Initialise our components
            initComponents();

            // Set-up items
            populateCB();

        }

        // Set existing preferences
        readPrefs();


        // Make certain the sample path is up-to-date
        buildSample();

        return this;
    }

    /**
     * "Save" the current choices into JMConfig.  These will not take affect
     * on current connections, only new connections.
     */
    public void applySettings() {
        final JMConfig settings = JMConfig.getInstance();

        String logPath;
        if (standardLocCB.isSelected()) {
            // settings.setJMValue(JMConfig.AUTOLOGPATH, customPathTF.getText());
            logPath = customPathTF.getText();
        } else {
            // settings.setJMValue(JMConfig.AUTOLOGPATH, "");
            logPath = "";
        }

        settings.setJMValue(JMConfig.AUTOLOGPATH, logPath);

        String logFileFormat;
        if (customNameCB.isSelected()) {
            if (simpleFormatRB.isSelected()) {
                final StringBuffer tmpStr = new StringBuffer();
                tmpStr.append(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/PrefPanels/Logging/Bundle").getString("SIMPLE:"));
                tmpStr.append(SPLIT);
                tmpStr.append(fieldCB1.getSelectedMap().toString());
                tmpStr.append(SPLIT);
                tmpStr.append(fieldCB2.getSelectedMap().toString());
                tmpStr.append(SPLIT);
                tmpStr.append(fieldCB3.getSelectedMap().toString());
                tmpStr.append(SPLIT);

                logFileFormat = tmpStr.toString();
            } else {
                logFileFormat = customFormatTF.getText();
            }
        } else {
            logFileFormat = "";
        }

        settings.setJMValue(JMConfig.LOGFILENAMEFORMAT, logFileFormat);

    }

    public boolean checkVersion() {
        // There are no special requirements to run this module
        return true;
    }

    public void versionWarning() {
    // There is no version warning as there are no special requirements for this module.
    }

    /**
     * Enable or disable the items associated with having the standard location
     * button checked
     * @param state
     */
    private void standardLocChecked(final boolean state) {
        customPathTF.setEnabled(state);
        browseB.setEnabled(state);

        buildSample();
    }

    /**
     * Enable or disable the items associated with having the standard file name
     * button checked
     * @param state
     */
    private void standardNameChecked(final boolean state) {
        // customFormatRB.setEnabled(state);
        customFormatRB.setEnabled(false);  // Fix Me XXX
        customFormatTF.setEnabled(state);
        customPathTF.setEnabled(state);
        simpleFormatRB.setEnabled(state);

        buildSample();
    }

    /**
     * This method enables or disables the comboboxes depending on the state
     * of the parent radio button
     * @param state
     */
    private void setComboBoxes(final boolean state) {
        fieldCB1.setEnabled(state);
        fieldCB2.setEnabled(state);
        fieldCB3.setEnabled(state);

        customFormatTF.setEnabled(!state);

        buildSample();
    }

    /**
     * Add items to the JMappedComboBoxes
     */
    private void populateCB() {
        final String items[][] = {
            {java.util.ResourceBundle.getBundle("anecho/JamochaMUD/PrefPanels/Logging/Bundle").getString("MU*_Name_($MN)"), "$MN"},
            {java.util.ResourceBundle.getBundle("anecho/JamochaMUD/PrefPanels/Logging/Bundle").getString("MU*_Character_($MC)"), "$MC"},
            {java.util.ResourceBundle.getBundle("anecho/JamochaMUD/PrefPanels/Logging/Bundle").getString("Date_&_Connection_Time_(yy-MM-dd_H-mm-ss)"), "yy-MM-dd_H-mm-ss"},
            {java.util.ResourceBundle.getBundle("anecho/JamochaMUD/PrefPanels/Logging/Bundle").getString("Date_(yy-MM-dd)"), "yy-MM-dd"},
            {java.util.ResourceBundle.getBundle("anecho/JamochaMUD/PrefPanels/Logging/Bundle").getString("Connection_Time_(H-mm-ss)"), "H-mm-ss"},
            {java.util.ResourceBundle.getBundle("anecho/JamochaMUD/PrefPanels/Logging/Bundle").getString("Not_used"), " "}};

        final int len = items.length;

        for (int i = 0; i < len; i++) {
            fieldCB1.addItem(items[i][0], items[i][1]);
            fieldCB2.addItem(items[i][0], items[i][1]);
            fieldCB3.addItem(items[i][0], items[i][1]);
        }

        fieldCB1.setSelectedMap("$MN");
        fieldCB2.setSelectedMap("yy-MM-dd_H-mm-ss");
        fieldCB3.setSelectedMap(" ");
    }

    /**
     * Allow the user to browse for a directory to save files
     */
    private void browseDir() {
        final String startDirStr = customPathTF.getText();
        File startDir;

        try {
            // Try to base the startDir on any existing information
            startDir = new File(startDirStr);
        } catch (Exception exc) {
            // Failing that, we'll use the user directory
            final String userDir = JMConfig.getInstance().getJMString(JMConfig.USERDIRECTORY);
            final String sep = File.separator;

            startDir = new File(userDir + sep + "anecho" + sep + "JamochaMUD" + sep + "logs");
        }

        final JFileChooser chooser = new JFileChooser(startDir);
        chooser.setDialogTitle(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/PrefPanels/Logging/Bundle").getString("Choose_a_location_to_save_your_logfiles."));
        chooser.setDialogType(JFileChooser.SAVE_DIALOG);
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);

        final int retVal = chooser.showSaveDialog(this);

        if (retVal == JFileChooser.APPROVE_OPTION) {
            // customPathTF.setText(chooser.getCurrentDirectory().toString());
            customPathTF.setText(chooser.getSelectedFile().toString());

            buildSample();
        }

    }

    /**
     * Build a sample of the new logfile path and name
     */
    private void buildSample() {
        String path;
        final String sep = File.separator;
        final String logName = buildLogName();

        if (standardLocCB.isSelected()) {
            path = customPathTF.getText();
        } else {
            // Fix Me XXX.  We should have a standard location to get the standard name from
            path = JMConfig.getInstance().getJMString(JMConfig.USERDIRECTORY) + java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("logs");
        }

        samplePath.setText(path + sep + logName);
    }

    /**
     * 
     * @return
     */
    private String buildLogName() {
        String retStr;

        if (customNameCB.isSelected()) {
            if (simpleFormatRB.isSelected()) {
                // The user has chosen the simple format
                final StringBuffer tempStr = new StringBuffer();
                String tmp[] = new String[3];

                tmp[0] = fieldCB1.getSelectedMap().toString();
                tmp[1] = fieldCB2.getSelectedMap().toString();
                tmp[2] = fieldCB3.getSelectedMap().toString();

                for (int i = 0; i < 3; i++) {
                    if (!tmp[i].equals("")) {
                        tempStr.append(tmp[i]);

                        if (i < 2) {
                            // Add a "spacer"
                            tempStr.append('_');
                        }
                    }

                }

                tempStr.append(".txt");
                retStr = tempStr.toString();
            } else {
                // The user has chosen to build their own format
                retStr = customFormatTF.getText();
                retStr.replace("$MN", "MuckName");
                retStr.replace("$MC", "CharacterName");

            // Can we filter this against an actual date?  Fix Me XXX
            }
        } else {
            // The user wishes to use the standard naming convention
            retStr = "MuckName_2008-07-23_19-52-59";
        }

        return retStr;
    }

    /**
     * Read any existing preferences in and set-up our corresponding widgets
     */
    private void readPrefs() {
        final JMConfig settings = JMConfig.getInstance();
        final String autoLogPath = settings.getJMString(JMConfig.AUTOLOGPATH);
        final String autoLogFormat = settings.getJMString(JMConfig.LOGFILENAMEFORMAT);

        // Set-up the autologging path
        if ("".equals(autoLogPath)) {
            standardLocCB.setSelected(false);
        } else {
            standardLocCB.setSelected(true);
            customPathTF.setText(autoLogPath);
        }

        if ("".equals(autoLogFormat)) {
            customNameCB.setSelected(false);
        } else {
            customNameCB.setSelected(true);

            if (autoLogFormat.startsWith(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/PrefPanels/Logging/Bundle").getString("SIMPLE:"))) {
                simpleFormatRB.setSelected(true);

                // Break our string into tokens and set our comboboxes
                final String parts[] = autoLogFormat.split(SPLIT);
                final int partsLen = parts.length;

                if (DEBUG) {
                    System.err.println("Logging.readPrefs: There are " + partsLen + " parts to " + autoLogFormat);
                    for (int i = 0; i < partsLen; i++) {
                        System.err.println("Part " + i + ": " + parts[i]);
                    }
                }

                if (partsLen > 0 && parts[1] != null) {
                    fieldCB1.setSelectedMap(parts[1]);
                    if (DEBUG) {
                        System.err.println("Logging.readPrefs set ComboBox 1");
                    }
                }

                if (partsLen > 1 && parts[2] != null) {
                    fieldCB2.setSelectedMap(parts[2]);
                    if (DEBUG) {
                        System.err.println("Logging.readPrefs set ComboBox 2");
                    }
                }

                if (partsLen > 2 && parts[3] != null) {
                    fieldCB3.setSelectedMap(parts[3]);
                    if (DEBUG) {
                        System.err.println("Logging.readPrefs set ComboBox 3");
                    }

                }
            } else {
                // customFormatRB.setSelected(true);
                customFormatRB.setSelected(false);  // Fix Me XXX
                customFormatTF.setText(autoLogFormat);
            }
        }
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private transient javax.swing.JButton browseB;
    private transient javax.swing.JRadioButton customFormatRB;
    private transient javax.swing.JTextField customFormatTF;
    private transient javax.swing.JCheckBox customNameCB;
    private transient javax.swing.JTextField customPathTF;
    private transient anecho.gui.JMappedComboBox fieldCB1;
    private transient anecho.gui.JMappedComboBox fieldCB2;
    private transient anecho.gui.JMappedComboBox fieldCB3;
    private transient javax.swing.JTextArea samplePath;
    private transient javax.swing.JRadioButton simpleFormatRB;
    private transient javax.swing.JCheckBox standardLocCB;
    // End of variables declaration//GEN-END:variables
    /** Enables or disables debugging output */
    private static final boolean DEBUG = false;
    /** The token used to separate parts of a simple configuration string */
    private static final String SPLIT = "_JMUD_";
}
