/*
 * CommandHistory.java
 *
 * Created on December 29, 2005, 12:50 PM
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2005 Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */


package anecho.JamochaMUD.PrefPanels.CommandHistory;

import anecho.JamochaMUD.JMConfig;
import javax.swing.JPanel;

/**
 *
 * @author  jeffnik
 */
public class CommandHistory extends javax.swing.JPanel implements anecho.JamochaMUD.PrefPanels.PrefInterface {
// public class CommandHistory extends anecho.JamochaMUD.PrefPanels.PrefInterface {
    
    /**
     * Creates new form CommandHistory
     */
    public CommandHistory() {
//    private CommandHistory() {
        if (DEBUG) {
            System.err.println("Creating new CustomColour instance");
        }
        //       initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        final javax.swing.JLabel titleLabel = new javax.swing.JLabel();
        final javax.swing.JButton resetAll = new javax.swing.JButton();
        final javax.swing.JLabel entryLabel = new javax.swing.JLabel();
        entryTF = new javax.swing.JTextField();

        setLayout(new java.awt.GridBagLayout());

        titleLabel.setBackground(javax.swing.UIManager.getDefaults().getColor("InternalFrame.activeTitleBackground"));
        titleLabel.setFont(new java.awt.Font("Dialog", 1, 18));
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/PrefPanels/CommandHistory/CommandHistory"); // NOI18N
        titleLabel.setText(bundle.getString("Command_history")); // NOI18N
        titleLabel.setOpaque(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(titleLabel, gridBagConstraints);

        resetAll.setIcon(new javax.swing.ImageIcon(getClass().getResource("/anecho/JamochaMUD/icons/22/reload.png"))); // NOI18N
        resetAll.setMnemonic(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/PrefPanels/CommandHistory/CommandHistory").getString("CommandHistory.resetButtonMnemonic").charAt(0));
        resetAll.setText("Reset"); // NOI18N
        resetAll.setToolTipText("Reset all colours to current palette"); // NOI18N
        resetAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                resetAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(resetAll, gridBagConstraints);

        entryLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/PrefPanels/CommandHistory/CommandHistory").getString("CommandHistory.entryLabelMnemonic").charAt(0));
        entryLabel.setLabelFor(entryTF);
        entryLabel.setText("Number of entries to keep:"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(entryLabel, gridBagConstraints);

        entryTF.setColumns(4);
        entryTF.setToolTipText(bundle.getString("CommandHistory.entryToolTip")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(entryTF, gridBagConstraints);
        entryTF.getAccessibleContext().setAccessibleName(bundle.getString("CommandHistory.entryAccessibleName")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents
    
    private void resetAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_resetAllActionPerformed
        // Reset the value to what we started with
        getHistoryLength();
    }//GEN-LAST:event_resetAllActionPerformed
    
    /**
     * This method is required by our Interface to return a human-readable title for
     * our module.
     * @return A string representing the human-readable name of our module.
     */
    public String getModuleName() {
        return "Command history";
    }
    
    /**
     *
     * @return
     */
    public JPanel loadPanel() {
        // Check to see if components have already been initialised
        if (entryTF == null) {
            if (DEBUG) {
                System.err.println("CommandHistory.Loading new panel");
            }
            // Initialise our components
            initComponents();
            
            // Setup the colours in our table
            getHistoryLength();
        } else {
            if (DEBUG) {
                System.err.println("CommandHistory.Panel already loaded");
            }
        }
        
        return this;
    }
    
    /**
     * Save the settings for this module
     */
    public void applySettings() {
        if (DEBUG) {
            System.err.println("CommandHistory.applySettings() has been called.");
        }
        
        int hLen;
        
        try {
            hLen = Integer.parseInt(entryTF.getText());
            final JMConfig settings = JMConfig.getInstance();
            settings.setJMValue(JMConfig.HISTORYLENGTH, hLen);
            
            // Update the DataIn information right away as well
            // DataIn tempIn = DataIn.getInstance();
            final anecho.JamochaMUD.DataIn tempIn = settings.getDataInVariable();
            tempIn.setLimit(hLen);
        } catch (Exception exc) {
            if (DEBUG) {
                System.err.println("CommandHistory error parsing number of entries " + exc);
            }
        }
    }
    
    private void getHistoryLength() {
        int hLen;
        final JMConfig settings = JMConfig.getInstance();

//        try {
            hLen = settings.getJMint(JMConfig.HISTORYLENGTH);
//        } catch (Exception exc) {
//            if (DEBUG) {
//                System.err.println("There was an error getting the history length.  Chances are this value is null / empty.  Use a default");
//            }
//            
//            // hLen = 10;
//            hLen = -1;
//            
//            // Apply the settings so this is written our configuration for future use
//            // applySettings();
//        }
        
        if (hLen < 0) {
            hLen = 10;
            // Write this out to our configuration as we're starting with "nothing"
            applySettings();
        }
        
        // entryTF.setText(hLen + "");
            entryTF.setText(String.valueOf(hLen));
        
        
    }

        /** This module has no special requirements */
    public boolean checkVersion() {
        return true;
    }

    /** There will be no warning as there are no special requirements */
    public void versionWarning() {
        
    }

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private transient javax.swing.JTextField entryTF;
    // End of variables declaration//GEN-END:variables
    /**
     * Enables or disables debugging information
     */
    private static final boolean DEBUG = false;

    // private CommandHistory cusCol;
}
