/*
 * MuckConn.java
 *
 * Created on April 30, 2005, 9:32 PM
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2005  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package anecho.JamochaMUD;

import anecho.JamochaMUD.legacy.AddEdit;


/**
 *
 * @author  jeffnik
 */
public class MuckConn extends javax.swing.JDialog {
    
    /**
     * Creates new form MuckConn
     * @param settings
     */
    public MuckConn(JMConfig settings) {
        super(settings.getJMFrame(JMConfig.MUCKMAINFRAME), true);
        this.settings = settings;
        
        // This vector contains all our MuckInfo classes
        muckList = settings.getJMVector(JMConfig.MUCKLIST);
        
        initComponents();
        
        java.awt.Point tPoint = anecho.gui.PosTools.findCenter();
        java.awt.Dimension tSize= this.size();
        this.setLocation(tPoint.x - (int)(tSize.width/2) , tPoint.y - (int)(tSize.height/2));
        
        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jmMUNames = new javax.swing.JComboBox();
        jPanel1 = new javax.swing.JPanel();
        connButton = new javax.swing.JButton();
        addB = new javax.swing.JButton();
        removeB = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        editB = new javax.swing.JButton();
        dontB = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setTitle(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("JamochaMUDConnector"));
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        compileNames();
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jmMUNames, gridBagConstraints);

        connButton.setIcon(new javax.swing.ImageIcon(getClass().getResource(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("/anecho/JamochaMUD/icons/22/connect_established.png"))));
        connButton.setMnemonic('C');
        connButton.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("connect"));
        connButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                connButtonActionPerformed(evt);
            }
        });

        jPanel1.add(connButton);

        addB.setIcon(new javax.swing.ImageIcon(getClass().getResource(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("/anecho/JamochaMUD/icons/22/add.png"))));
        addB.setMnemonic('A');
        addB.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("addMU"));
        addB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addBActionPerformed(evt);
            }
        });

        jPanel1.add(addB);

        removeB.setIcon(new javax.swing.ImageIcon(getClass().getResource(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("/anecho/JamochaMUD/icons/22/delete.png"))));
        removeB.setMnemonic('R');
        removeB.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("removeMU"));
        removeB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeBActionPerformed(evt);
            }
        });

        jPanel1.add(removeB);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jPanel1, gridBagConstraints);

        editB.setIcon(new javax.swing.ImageIcon(getClass().getResource(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("/anecho/JamochaMUD/icons/22/edit.png"))));
        editB.setMnemonic('E');
        editB.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("editMU"));
        editB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editBActionPerformed(evt);
            }
        });

        jPanel2.add(editB);

        dontB.setIcon(new javax.swing.ImageIcon(getClass().getResource(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("/anecho/JamochaMUD/icons/22/connect_no.png"))));
        dontB.setMnemonic('D');
        dontB.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("dontConnect"));
        dontB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dontBActionPerformed(evt);
            }
        });

        jPanel2.add(dontB);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jPanel2, gridBagConstraints);

        pack();
    }
    // </editor-fold>//GEN-END:initComponents
    
    private void dontBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dontBActionPerformed
        dontConnect();
    }//GEN-LAST:event_dontBActionPerformed
    
    private void editBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editBActionPerformed
        editMU();
    }//GEN-LAST:event_editBActionPerformed
    
    private void removeBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeBActionPerformed
        removeMU();
    }//GEN-LAST:event_removeBActionPerformed
    
    private void addBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addBActionPerformed
        addMU();
    }//GEN-LAST:event_addBActionPerformed
    
    private void connButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_connButtonActionPerformed
        connectToMU();
    }//GEN-LAST:event_connButtonActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        dispose();
        
        // If the main window is not visible then we'll terminate the program.
        if (!(settings.getJMFrame(settings.MUCKMAINFRAME)).isVisible()) {
            System.exit(0);
        }
    }//GEN-LAST:event_closeDialog
    
    /**
     * Call the methods necessary for the user to add
     * a new MUD/MUCK to the list of worlds
     */
    private void addMU() {
        
        boolean okaySelect = false;
        String jmEditName = "";
        String jmEditAddy = "";
        int jmEditPort;
        boolean jmEditSSL = false;
        
        // Call the AddEdit box
        final AddEdit addMU = new AddEdit(settings.getJMFrame(JMConfig.MUCKMAINFRAME), java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("addMU"));
        addMU.setLocation(anecho.gui.PosTools.findCenter(this, addMU));
        addMU.setVisible(true);
        okaySelect = addMU.isOkay();
        jmEditName = addMU.getName();
        jmEditAddy = addMU.getAddress();
        jmEditPort = addMU.getPort();
        jmEditSSL = addMU.isSSL();
        
        if (okaySelect) {
            
            jmEditName.trim();
            jmEditAddy.trim();
            
            if (!jmEditName.equals("") && !jmEditAddy.equals("") && (jmEditPort > 0)) {
                // Check to see if the first entry is a 'valid'
                // MU*, or just a place-marker
                if (DEBUG) {
                    System.err.println("Doing a check to see if would should empty the 'placeholder' first.");
                    System.err.println("Our MUCKLIST vector has " + (settings.getJMVector(JMConfig.MUCKLIST)).size() + " elements");
                }
                
                if ((settings.getJMVector(JMConfig.MUCKLIST)).size() < 1) {
                    if (DEBUG) {
                        System.err.println("Removing our placeholder (and all other elements) from our list.");
                    }
                    jmMUNames.removeAllItems();
                }
                
                // Add the new entry to the list of available MU*s
                final MuckInfo tempMU = new MuckInfo();
                tempMU.setName(jmEditName);
                tempMU.setAddress(jmEditAddy);
                tempMU.setPort(jmEditPort);
                tempMU.setSSL(jmEditSSL);
                
                jmMUNames.addItem(jmEditName + " (" + jmEditAddy + " Port: " + jmEditPort + ")");
                
                // Add the new MU* to our vector and then update that in our settings
                muckList.addElement(tempMU);
                settings.setJMValue(JMConfig.MUCKLIST, muckList);
                
                // Display new MU* in choice
                jmMUNames.setSelectedIndex(jmMUNames.getItemCount() - 1);
                connButton.requestFocus();
                
                
            }
        }
        
    }
    
    /**
     * Remove the currently selected MUD/MUCK from the list
     * of available worlds (and the .jamocha.rc file).
     */
    private void removeMU() {
        // Remove MU* from list
        if (muckList.size() < 1) {
            return;
        }
        
        muckList.removeElementAt(jmMUNames.getSelectedIndex());
        
        if (muckList.size() < 1) {
            jmMUNames.removeAllItems();
            jmMUNames.addItem("None (" + blank + " Port: " + blank + ")");
        } else {
            jmMUNames.removeItemAt(jmMUNames.getSelectedIndex());
        }
        
        // Now place the vectors back in the Hashtable
        settings.setJMValue(JMConfig.MUCKLIST, muckList);
    }
    
    /**
     * The user has opted to connect to the currently selected
     * MUD/MUCK, so we honour their wishes here!
     */
    private void connectToMU() {
        
        if (muckList.size() < 1) {
            // We don't have any valid MU*'s listed
            return;
        }
        
        if (DEBUG) {
            System.err.println("MuckConn.JMConnectToMU setVisible(false)");
        }
        
        final java.awt.Frame mainFrame = settings.getJMFrame(JMConfig.MUCKMAINFRAME);
        
        if (!mainFrame.isVisible()) {
            mainFrame.setVisible(true);
        }
        
        final int selection = jmMUNames.getSelectedIndex();
        
        if (DEBUG) {
            System.err.println("Our selected index is " + selection);
            // System.err.println("Our vector has " + editName.size());
            System.err.println("Our vector has " + muckList.size() + " entries");
        }
        
        final MuckInfo tempMU = (MuckInfo)muckList.elementAt(selection);
        
        chosenName = tempMU.getName();
        finalAddress = tempMU.getAddress();
        chosenPort = tempMU.getPort();
        chosenSSL = tempMU.getSSL();
        
        settings.setJMValue(JMConfig.CONNMUCK, finalAddress);
        settings.setJMValue(JMConfig.CONNPORT, chosenPort);
        settings.setJMValue(JMConfig.LASTMU, jmMUNames.getSelectedItem());
        settings.setJMValue(JMConfig.CONNSSL, chosenSSL);
        
        setVisible(false);
        
        settings.setJMValue(JMConfig.MUCKCONNVISIBLE, false);
        
        if (DEBUG) {
            System.err.println("MuckConn.JMConnectToMU returning focus to main frame.");
        }
        
        mainFrame.requestFocus();
        
    }
    
    /**
     * Call the methods to allow the user to edit the MUD/MUCK
     * Name/address/port of the currently selected world
     */
    private void editMU() {
        // edit current MU* entry
        final AddEdit editBox = new AddEdit(settings.getJMFrame(JMConfig.MUCKMAINFRAME), java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("editMU"));
        
        final int index = jmMUNames.getSelectedIndex();
        final MuckInfo tempMU = (MuckInfo)muckList.elementAt(index);
        editBox.setName(tempMU.getName());
        editBox.setAddress(tempMU.getAddress());
        editBox.setPort(tempMU.getPort() + "");
        editBox.setSSL(tempMU.getSSL());
        
        editBox.setLocation(anecho.gui.PosTools.findCenter(this, editBox));
        editBox.setVisible(true);
        
        // Call the AddEdit box
        
        if (editBox.isOkay()) {
            final String jmEditName = editBox.getName();
            final String jmEditAddy = editBox.getAddress();
            // final String jmEditPort = editBox.getPort();
            final int jmEditPort = editBox.getPort();
            final boolean jmEditSSL = editBox.isSSL();
            
            jmEditName.trim();
            jmEditAddy.trim();
            
            if (!jmEditName.equals("") && !jmEditAddy.equals("") && (jmEditPort > 0)) {
                // Replace the edited MU* info
                muckList.removeElementAt(index);
                // Re-use our tempMU object to hold the new settings
                tempMU.setName(jmEditName);
                tempMU.setAddress(jmEditAddy);
                tempMU.setPort(jmEditPort);
                tempMU.setSSL(jmEditSSL);
                
                // Put our new tempMU into the muckList
                muckList.insertElementAt(tempMU, index);
                
                // Put the updated muckList into our configuration file
                settings.setJMValue(JMConfig.MUCKLIST, muckList);
                
                // Replace the choice entry
                jmMUNames.removeItemAt(index);
                jmMUNames.insertItemAt(jmEditName + " (" + jmEditAddy + " Port: " + jmEditPort + ")", index);
                jmMUNames.setSelectedIndex(index);
                connButton.requestFocus();
                
            }
        }
    }
    
    /**
     * Compile the MU* names
     * and then write them into the
     * choice of jmMCFrame
     */
    private void compileNames() {
        // First grab the vectors
        
        muckList = new java.util.Vector(0, 1);
        muckList = settings.getJMVector(JMConfig.MUCKLIST);
        
        MuckInfo tempMU;
        
        for (int i=0; i < muckList.size(); i++) {
            tempMU = (MuckInfo)muckList.elementAt(i);
            jmMUNames.addItem(tempMU.getName() + " (" + tempMU.getAddress() + " Port: " + tempMU.getPort());
        }
        
        
        // Set the 'focus' on the last-selected MU*
        if (settings.getJMString(JMConfig.LASTMU) != null) {
            jmMUNames.setSelectedItem(settings.getJMString(JMConfig.LASTMU));
        }
        
    }
    
    /**
     *
     * @return
     */
    public String getName() {
        return chosenName;
    }
    
    /**
     *
     * @return
     */
    public String getAddress() {
        return finalAddress;
    }
    
    /**
     *
     * @return
     */
    public int getPort() {
        return chosenPort;
    }
    
    /**
     * 
     * @return 
     */
    public boolean getSSL() {
        return chosenSSL;
    }
    
    private void dontConnect() {
        setVisible(false);
        
        final java.awt.Frame mmFrame = settings.getJMFrame(JMConfig.MUCKMAINFRAME);
        if (!mmFrame.isVisible()) {
            mmFrame.setVisible(true);
        }
        
        settings.setJMValue(JMConfig.MUCKCONNVISIBLE, false);
        
        // Send the focus to out main program... just a nice thing to do
        mmFrame.requestFocus();
        
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addB;
    private javax.swing.JButton connButton;
    private javax.swing.JButton dontB;
    private javax.swing.JButton editB;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JComboBox jmMUNames;
    private javax.swing.JButton removeB;
    // End of variables declaration//GEN-END:variables
    private java.util.Vector muckList = new java.util.Vector(0, 1);
    private JMConfig settings;
    private static final boolean DEBUG = false;
    private String chosenName = null;
    private String finalAddress = null;
    private int chosenPort;
    private boolean chosenSSL = false;
    private String blank = "----";
}
